/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis;

import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisEditor;
import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisEditorInput;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.io.File;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;

public class SaveImageAction
extends Action {
    public static final String ID = SaveImageAction.class.toString();
    private IWorkbenchPage page;

    public SaveImageAction(IWorkbenchPage page) {
        this.page = page;
        this.setId(ID);
        this.setText(Messages.SaveImageAction_SaveImage);
        this.setToolTipText(Messages.SaveImageAction_SaveImage);
        this.setImageDescriptor(SaveImageAction.getEnabledImage());
        this.setDisabledImageDescriptor(SaveImageAction.getDisabledImage());
    }

    public static ImageDescriptor getEnabledImage() {
        return ImagePool.SAVE_FLOW_IMAGE;
    }

    public static ImageDescriptor getDisabledImage() {
        return null;
    }

    public void run() {
        IEditorPart activeEditor = this.page.getActiveEditor();
        if (activeEditor == null) {
            return;
        }
        if (!(activeEditor instanceof FlowVisEditor)) {
            return;
        }
        FlowVisEditor flowVisEditor = (FlowVisEditor)activeEditor;
        FlowVisEditorInput input = (FlowVisEditorInput)flowVisEditor.getEditorInput();
        File file = input.getFile();
        String path = null;
        String name = null;
        if (file != null) {
            name = file.getName();
            path = file.getParent();
            if (name.toLowerCase(Locale.ENGLISH).endsWith(".sfv")) {
                name = name.substring(0, name.length() - 4);
            }
        }
        FileDialog fileDialog = new FileDialog(activeEditor.getEditorSite().getShell(), 8192);
        if (name == null) {
            name = input.getName();
        }
        name = String.valueOf(name.replace('.', '_')) + ".png";
        fileDialog.setFileName(name);
        String[] filterExtensions = new String[]{"*.png; *.bmp; *.jpg; *.jpeg", "*.*"};
        String[] filterNames = new String[]{Messages.SaveImageAction_ImageFilterNames, Messages.SaveImageAction_AllFiles};
        fileDialog.setFilterExtensions(filterExtensions);
        fileDialog.setFilterNames(filterNames);
        path = fileDialog.open();
        if (path != null) {
            String lowercase = path.toLowerCase(Locale.ENGLISH);
            int format = 0;
            if (lowercase.endsWith(".jpeg") || lowercase.endsWith(".jpg")) {
                format = 4;
            } else if (lowercase.endsWith(".bmp")) {
                format = 0;
            } else if (lowercase.endsWith(".png")) {
                format = 5;
            } else if (lowercase.endsWith(".gif")) {
                format = 2;
            } else {
                format = 5;
                path = String.valueOf(path) + ".png";
            }
            try {
                SaveImageAction.saveEditorContentsAsImage((IEditorPart)flowVisEditor, flowVisEditor.getGraphicalViewer(), path, format);
            }
            catch (Exception e) {
                ErrorDialog.openError((Shell)flowVisEditor.getSite().getShell(), null, null, (IStatus)StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
            }
        }
    }

    private static void saveEditorContentsAsImage(IEditorPart editorPart, GraphicalViewer viewer, String saveFilePath, int format) {
        ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)viewer.getEditPartRegistry().get(LayerManager.ID);
        IFigure rootFigure = rootEditPart.getLayer((Object)"Printable Layers");
        Rectangle rootFigureBounds = rootFigure.getBounds();
        Control figureCanvas = viewer.getControl();
        GC figureCanvasGC = new GC((Drawable)figureCanvas);
        Image img = new Image(null, rootFigureBounds.width, rootFigureBounds.height);
        GC imageGC = new GC((Drawable)img);
        imageGC.setBackground(figureCanvasGC.getBackground());
        imageGC.setForeground(figureCanvasGC.getForeground());
        imageGC.setFont(figureCanvasGC.getFont());
        imageGC.setLineStyle(figureCanvasGC.getLineStyle());
        imageGC.setLineWidth(figureCanvasGC.getLineWidth());
        imageGC.setXORMode(figureCanvasGC.getXORMode());
        imageGC.setAntialias(0);
        SWTGraphics imgGraphics = new SWTGraphics(imageGC);
        rootFigure.paint((Graphics)imgGraphics);
        ImageData[] imgData = new ImageData[]{img.getImageData()};
        ImageLoader imgLoader = new ImageLoader();
        imgLoader.data = imgData;
        imgLoader.save(saveFilePath, format);
        figureCanvasGC.dispose();
        imageGC.dispose();
        img.dispose();
    }
}

