/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis;

import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Component;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisDiagram;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisModel;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class RepositoryActionsSelectionProvider
implements ISelectionProvider,
ISelectionChangedListener,
Observer {
    private ListenerList listeners = new ListenerList(1);
    private Map<FlowVisModel, AbstractWrapper> wrappersMap = new HashMap<FlowVisModel, AbstractWrapper>();
    private FlowVisDiagram diagram;
    private GraphicalViewer viewer;

    public RepositoryActionsSelectionProvider(FlowVisDiagram diagram, GraphicalViewer viewer) {
        this.diagram = diagram;
        this.viewer = viewer;
        diagram.addObserver(this);
    }

    public ISelection getSelection() {
        List selectedEditParts = this.viewer.getSelectedEditParts();
        ArrayList<Object> convertedSelection = new ArrayList<Object>();
        for (Object o : selectedEditParts) {
            if (!(o instanceof AbstractEditPart)) continue;
            AbstractEditPart part = (AbstractEditPart)o;
            Object model = part.getModel();
            AbstractWrapper wrapper = this.wrappersMap.get(model);
            if (wrapper == null) {
                if (model instanceof FlowNode) {
                    FlowNode flowNode = (FlowNode)model;
                    IWorkspaceConnection connection = flowNode.getWorkspaceConnection();
                    if (connection != null) {
                        wrapper = AbstractPlaceWrapper.newWrapper(connection.getResolvedWorkspace());
                        this.wrappersMap.put(flowNode, wrapper);
                    }
                } else if (model instanceof Component) {
                    Component component = (Component)model;
                    IComponent iComponent = component.getComponent();
                    IWorkspaceConnection connection = component.getFlowNode().getWorkspaceConnection();
                    if (iComponent != null && connection != null) {
                        wrapper = WorkspaceComponentWrapper.newWrapper(connection, iComponent);
                        this.wrappersMap.put(component, wrapper);
                    }
                }
            }
            if (wrapper != null) {
                convertedSelection.add((Object)wrapper);
                continue;
            }
            convertedSelection.add(model);
        }
        return new StructuredSelection(convertedSelection);
    }

    public void setSelection(ISelection selection) {
    }

    @Override
    public void update(Observable o, Object arg) {
        FlowVisDiagram.PropertyId id = FlowVisEditPart.getArg(FlowVisDiagram.PropertyId.class, arg);
        if (id != null) {
            switch (id) {
                case FLOW_NODES: {
                    HashSet<FlowVisModel> models = new HashSet<FlowVisModel>();
                    for (FlowNode flowNode : this.diagram.getFlowNodes()) {
                        models.add(flowNode);
                        models.addAll(flowNode.getComponents());
                    }
                    ArrayList<FlowVisModel> toRemove = new ArrayList<FlowVisModel>();
                    for (FlowVisModel model : this.wrappersMap.keySet()) {
                        if (models.contains(model)) continue;
                        toRemove.add(model);
                    }
                    for (FlowVisModel model : toRemove) {
                        this.wrappersMap.remove(model);
                    }
                    break;
                }
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        SelectionChangedEvent convertedEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISelectionChangedListener)listener).selectionChanged(convertedEvent);
            ++n2;
        }
    }
}

