/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis;

import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisEditor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSiteJobRunner;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FlowVisUtil {
    private FlowVisEditor editor;
    private ITeamRepository repository;
    private IOperationRunner operationRunner;

    public FlowVisUtil(FlowVisEditor editor, ITeamRepository repository) {
        this.editor = editor;
        this.repository = repository;
    }

    public IOperationRunner getOperationRunner() {
        if (this.operationRunner == null) {
            this.operationRunner = new PartSiteJobRunner(this.editor.getSite(), true);
        }
        return this.operationRunner;
    }

    public Display getDisplay() {
        return this.editor.getSite().getWorkbenchWindow().getWorkbench().getDisplay();
    }

    public ITeamRepository getRepository() {
        return this.repository;
    }

    public Shell getShell() {
        return this.editor.getSite().getShell();
    }

    public IWorkspaceManager getWorkspaceManager() {
        return SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository());
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.editor.getGraphicalViewer();
    }

    public CommandStack getCommandStack() {
        return (CommandStack)this.editor.getAdapter(CommandStack.class);
    }

    public ZoomManager getZoomManager() {
        return (ZoomManager)this.editor.getAdapter(ZoomManager.class);
    }

    public static <Type> List<Type> filterList(Class<Type> cls, List list) {
        ArrayList<Type> filtered = new ArrayList<Type>();
        for (Object o : list) {
            Type type = FlowVisUtil.filter(cls, o);
            if (type == null) continue;
            filtered.add(cls.cast(o));
        }
        return filtered;
    }

    public static <Type> Type filter(Class<Type> cls, Object o) {
        if (o == null) {
            return null;
        }
        if (cls.isInstance(o)) {
            return cls.cast(o);
        }
        return null;
    }

    public static Date[] getDateRange(List<Date[]> datesList) {
        Date absOldest = null;
        Date absLatest = null;
        for (Date[] dates : datesList) {
            if (dates.length <= 2) continue;
            Date oldest = dates[0];
            Date latest = dates[1];
            if (absOldest == null) {
                absOldest = oldest;
            } else if (oldest != null) {
                Date date = absOldest = absOldest.compareTo(oldest) < 0 ? absOldest : oldest;
            }
            if (absLatest == null) {
                absLatest = latest;
                continue;
            }
            if (latest == null) continue;
            Date date = absLatest = absLatest.compareTo(latest) < 0 ? latest : absLatest;
        }
        return new Date[]{absOldest, absLatest};
    }
}

