/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis;

import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisUtil;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowNodeEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisConnectionEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisDiagramEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.FlowNodeFigure;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisDiagram;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.gef.EditPart;

public abstract class FlowVisLayout {
    public static void layout(FlowVisDiagramEditPart flowVisDiagramEditPart) {
        DirectedGraph graph = new DirectedGraph();
        graph.setDirection(((FlowVisDiagram)flowVisDiagramEditPart.getModel2()).getLayoutDirection());
        HashMap<FlowNodeEditPart, Node> nodes = new HashMap<FlowNodeEditPart, Node>();
        HashMap<FlowVisConnectionEditPart, Edge> edges = new HashMap<FlowVisConnectionEditPart, Edge>();
        List<FlowNodeEditPart> flowNodeEditParts = FlowVisUtil.filterList(FlowNodeEditPart.class, flowVisDiagramEditPart.getChildren());
        FlowVisLayout.addNodes(graph, nodes, flowNodeEditParts);
        FlowVisLayout.addEdges(graph, nodes, edges, flowNodeEditParts);
        new DirectedGraphLayout().visit(graph);
        FlowVisLayout.layoutNodesAndEdges(nodes, edges, flowNodeEditParts, false);
    }

    private static void layoutNodesAndEdges(Map<FlowNodeEditPart, Node> nodes, Map<FlowVisConnectionEditPart, Edge> edges, List<FlowNodeEditPart> flowNodeEditParts, boolean layoutEdges) {
        for (FlowNodeEditPart flowNodeEditPart : flowNodeEditParts) {
            Node node = nodes.get(flowNodeEditPart);
            if (node == null) continue;
            FlowVisLayout.layoutNode(flowNodeEditPart, node);
            if (!layoutEdges) continue;
            FlowVisLayout.layoutEdges(edges, flowNodeEditPart);
        }
    }

    private static void layoutNode(FlowNodeEditPart flowNodeEditPart, Node node) {
        FlowNode flowNode = (FlowNode)flowNodeEditPart.getModel2();
        FlowNodeFigure flowNodeFigure = (FlowNodeFigure)flowNodeEditPart.getFigure2();
        Rectangle constraint = flowNode.getConstraint();
        int x = FlowVisLayout.weightedAlign(node, flowNodeFigure, true);
        int y = FlowVisLayout.weightedAlign(node, flowNodeFigure, false);
        constraint.setLocation(x, y);
        flowNode.setPropertyValue((Object)FlowNode.PropertyId.CONSTRAINT, constraint);
    }

    private static int weightedAlign(Node node, FlowNodeFigure flowNodeFigure, boolean horizontal) {
        int nodeSize;
        int nodePos;
        int pos = nodePos = FlowVisLayout.getPosition(node, horizontal);
        int figureSize = FlowVisLayout.getSize(flowNodeFigure, horizontal);
        if (figureSize < (nodeSize = FlowVisLayout.getSize(node, horizontal))) {
            int nodesAbove = 0;
            int nodesBelow = 0;
            int i = 0;
            while (i < node.outgoing.size()) {
                Node target = node.outgoing.getEdge((int)i).target;
                int targetPos = FlowVisLayout.getPosition(target, horizontal);
                if (targetPos < nodePos) {
                    ++nodesAbove;
                } else if (targetPos > nodePos) {
                    ++nodesBelow;
                }
                ++i;
            }
            i = 0;
            while (i < node.incoming.size()) {
                Node source = node.incoming.getEdge((int)i).source;
                int sourcePos = FlowVisLayout.getPosition(source, horizontal);
                if (sourcePos < nodePos) {
                    ++nodesAbove;
                } else if (sourcePos > nodePos) {
                    ++nodesBelow;
                }
                ++i;
            }
            if (nodesBelow > 0) {
                pos += (nodeSize - figureSize) * nodesBelow / (nodesAbove + nodesBelow);
            }
        }
        return pos;
    }

    private static int getSize(FlowNodeFigure flowNodeFigure, boolean horizontal) {
        Rectangle bounds = flowNodeFigure.getBounds();
        return horizontal ? bounds.width : bounds.height;
    }

    private static int getSize(Node node, boolean horizontal) {
        return horizontal ? node.width : node.height;
    }

    private static int getPosition(Node node, boolean horizontal) {
        return horizontal ? node.x : node.y;
    }

    private static void layoutEdges(Map<FlowVisConnectionEditPart, Edge> edges, FlowNodeEditPart flowNodeEditPart) {
        List<FlowVisConnectionEditPart> connectionEditParts = FlowVisUtil.filterList(FlowVisConnectionEditPart.class, flowNodeEditPart.getSourceConnections());
        for (FlowVisConnectionEditPart connectionEditPart : connectionEditParts) {
            Connection connectionFigure;
            Edge edge = edges.get(connectionEditPart);
            if (edge == null || !((connectionFigure = connectionEditPart.getConnectionFigure()) instanceof PolylineConnection)) continue;
            PolylineConnection polyConn = (PolylineConnection)connectionFigure;
            NodeList vNodes = edge.vNodes;
            if (vNodes != null) {
                ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
                int i = 0;
                while (i < vNodes.size()) {
                    Node vn = vNodes.getNode(i);
                    int x = vn.x;
                    int y = vn.y;
                    if (edge.isFeedback()) {
                        bends.add(new AbsoluteBendpoint(x, y + vn.height));
                        bends.add(new AbsoluteBendpoint(x, y));
                    } else {
                        bends.add(new AbsoluteBendpoint(x, y));
                        bends.add(new AbsoluteBendpoint(x, y + vn.height));
                    }
                    ++i;
                }
                polyConn.setRoutingConstraint(bends);
                continue;
            }
            polyConn.setRoutingConstraint((Object)Collections.EMPTY_LIST);
        }
    }

    private static void addEdges(DirectedGraph graph, Map<FlowNodeEditPart, Node> nodes, Map<FlowVisConnectionEditPart, Edge> edges, List<FlowNodeEditPart> flowNodeEditParts) {
        for (FlowNodeEditPart flowNodeEditPart : flowNodeEditParts) {
            Node source = nodes.get(flowNodeEditPart);
            FlowNode flowNode = (FlowNode)flowNodeEditPart.getModel2();
            if (source != null) {
                List<FlowVisConnectionEditPart> connectionEditParts = FlowVisUtil.filterList(FlowVisConnectionEditPart.class, flowNodeEditPart.getSourceConnections());
                for (FlowVisConnectionEditPart connectionEditPart : connectionEditParts) {
                    FlowNodeEditPart targetFlowNodeEditPart;
                    EditPart editPart;
                    if (!connectionEditPart.getFigure2().isVisible() || !((editPart = connectionEditPart.getTarget()) instanceof FlowNodeEditPart) || (targetFlowNodeEditPart = (FlowNodeEditPart)editPart).equals(flowNodeEditPart)) continue;
                    Node target = nodes.get(targetFlowNodeEditPart);
                    if (target != null) {
                        Edge edge = new Edge(target, source);
                        FlowNode targetFlowNode = (FlowNode)targetFlowNodeEditPart.getModel2();
                        if (targetFlowNode.equals(flowNode.getDefaultIncomingFlow())) {
                            edge.weight = 2;
                        }
                        if (targetFlowNode.equals(flowNode.getDefaultOutgoingFlow())) {
                            edge.weight = 2;
                        }
                        if (targetFlowNode.equals(flowNode.getCurrentIncomingFlow())) {
                            edge.weight = 3;
                        }
                        if (targetFlowNode.equals(flowNode.getCurrentOutgoingFlow())) {
                            edge.weight = 3;
                        }
                        graph.edges.add((Object)edge);
                        edges.put(connectionEditPart, edge);
                        continue;
                    }
                    StatusUtil.log((IStatus)StatusUtil.newStatus(FlowVisLayout.class, (Throwable)new IllegalStateException()));
                }
                continue;
            }
            StatusUtil.log((IStatus)StatusUtil.newStatus(FlowVisLayout.class, (Throwable)new IllegalStateException()));
        }
    }

    private static void addNodes(DirectedGraph graph, Map<FlowNodeEditPart, Node> nodes, List<FlowNodeEditPart> flowNodeEditParts) {
        for (FlowNodeEditPart flowNodeEditPart : flowNodeEditParts) {
            FlowNode flowNode = (FlowNode)flowNodeEditPart.getModel2();
            Node node = new Node((Object)flowNodeEditPart);
            Dimension size = flowNode.getConstraint().getSize();
            FlowNodeFigure flowNodeFigure = (FlowNodeFigure)flowNodeEditPart.getFigure2();
            Dimension preferredSize = flowNodeFigure.getSize();
            if (size.width < 0) {
                size.width = preferredSize.width;
            }
            if (size.height < 0) {
                size.height = preferredSize.height;
            }
            node.setSize(size);
            graph.nodes.add((Object)node);
            nodes.put(flowNodeEditPart, node);
        }
    }
}

