/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis;

import com.ibm.team.filesystem.ui.editor.RemoteFileEditorInput;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.repository.client.ITeamRepository;
import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class FlowVisEditorInput
implements IEditorInput {
    private IFileEditorInput fileEditorInput;
    private FileStoreEditorInput fileStoreEditorInput;
    private IStorageEditorInput storageEditorInput;
    private RemoteFileEditorInput remoteFileEditorInput;
    private ITeamRepository repo;

    public FlowVisEditorInput(ITeamRepository repo) {
        this.repo = repo;
    }

    public FlowVisEditorInput(IFileEditorInput fileEditorInput, ITeamRepository repo) {
        this.fileEditorInput = fileEditorInput;
        this.repo = repo;
    }

    public FlowVisEditorInput(FileStoreEditorInput fileStoreEditorInput, ITeamRepository repo) {
        this.fileStoreEditorInput = fileStoreEditorInput;
        this.repo = repo;
    }

    public FlowVisEditorInput(RemoteFileEditorInput remoteFileEditorInput, ITeamRepository repo) {
        this.remoteFileEditorInput = remoteFileEditorInput;
        this.repo = repo;
    }

    public FlowVisEditorInput(IStorageEditorInput storageEditorInput, ITeamRepository repo) {
        this.storageEditorInput = storageEditorInput;
        this.repo = repo;
    }

    public RemoteFileEditorInput getRemoteFileEditorInput() {
        return this.remoteFileEditorInput;
    }

    public IStorageEditorInput getStorageEditorInput() {
        return this.storageEditorInput;
    }

    public ITeamRepository getRepository() {
        return this.repo;
    }

    public boolean exists() {
        if (this.fileEditorInput != null) {
            return this.fileEditorInput.exists();
        }
        if (this.fileStoreEditorInput != null) {
            return this.fileStoreEditorInput.exists();
        }
        if (this.remoteFileEditorInput != null) {
            return this.remoteFileEditorInput.exists();
        }
        if (this.storageEditorInput != null) {
            return this.storageEditorInput.exists();
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        Object adapted = null;
        if (this.fileEditorInput != null) {
            adapted = this.fileEditorInput.getAdapter(adapter);
        } else {
            if (this.fileStoreEditorInput != null) {
                return this.fileStoreEditorInput.getAdapter(adapter);
            }
            if (this.remoteFileEditorInput != null) {
                return this.remoteFileEditorInput.getAdapter(adapter);
            }
            if (this.storageEditorInput != null) {
                return this.storageEditorInput.getAdapter(adapter);
            }
        }
        return adapted;
    }

    public void setFile(File file) {
        if (file == null) {
            this.fileEditorInput = null;
        } else {
            IFile[] workspaceFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(Path.fromOSString((String)file.getPath()));
            if (workspaceFiles.length > 0) {
                this.fileEditorInput = new FileEditorInput(workspaceFiles[0]);
                this.fileStoreEditorInput = null;
                this.storageEditorInput = null;
            } else {
                this.fileEditorInput = null;
                this.storageEditorInput = null;
                IFileStore fileStore = EFS.getLocalFileSystem().getStore(file.toURI());
                this.fileStoreEditorInput = new FileStoreEditorInput(fileStore);
            }
        }
    }

    public File getFile() {
        if (this.fileEditorInput != null) {
            IPath location;
            IFile iFile = this.fileEditorInput.getFile();
            if (iFile != null && (location = iFile.getLocation()) != null) {
                return location.toFile();
            }
        } else if (this.fileStoreEditorInput != null) {
            return new File(this.fileStoreEditorInput.getURI());
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.fileEditorInput != null) {
            return this.fileEditorInput.getImageDescriptor();
        }
        if (this.fileStoreEditorInput != null) {
            return this.fileStoreEditorInput.getImageDescriptor();
        }
        if (this.remoteFileEditorInput != null) {
            return this.remoteFileEditorInput.getImageDescriptor();
        }
        if (this.storageEditorInput != null) {
            return this.storageEditorInput.getImageDescriptor();
        }
        return ImagePool.CHOICE;
    }

    public String getName() {
        String name = null;
        if (this.fileEditorInput != null) {
            name = this.fileEditorInput.getName();
        } else if (this.fileStoreEditorInput != null) {
            name = this.fileStoreEditorInput.getName();
        } else if (this.remoteFileEditorInput != null) {
            name = this.remoteFileEditorInput.getName();
        } else if (this.storageEditorInput != null) {
            name = this.storageEditorInput.getName();
        }
        if (name == null || name.length() == 0) {
            name = RepositoryUtils.getLabel(this.repo);
        }
        return name == null ? "" : name;
    }

    public IPersistableElement getPersistable() {
        if (this.fileEditorInput != null) {
            return this.fileEditorInput.getPersistable();
        }
        if (this.fileStoreEditorInput != null) {
            return this.fileStoreEditorInput.getPersistable();
        }
        if (this.remoteFileEditorInput != null) {
            return this.remoteFileEditorInput.getPersistable();
        }
        if (this.storageEditorInput != null) {
            return this.storageEditorInput.getPersistable();
        }
        return null;
    }

    public String getToolTipText() {
        String tooltip = null;
        if (this.fileEditorInput != null) {
            tooltip = this.fileEditorInput.getToolTipText();
        } else if (this.fileStoreEditorInput != null) {
            tooltip = this.fileStoreEditorInput.getToolTipText();
        } else if (this.remoteFileEditorInput != null) {
            tooltip = this.remoteFileEditorInput.getToolTipText();
        } else if (this.storageEditorInput != null) {
            tooltip = this.storageEditorInput.getToolTipText();
        }
        if (tooltip == null || tooltip.length() == 0) {
            tooltip = RepositoryUtils.getLabel(this.repo);
        }
        return tooltip == null ? "" : tooltip;
    }

    public String toString() {
        if (this.fileEditorInput != null) {
            return this.fileEditorInput.toString();
        }
        if (this.fileStoreEditorInput != null) {
            return this.fileStoreEditorInput.toString();
        }
        if (this.remoteFileEditorInput != null) {
            return this.remoteFileEditorInput.toString();
        }
        if (this.storageEditorInput != null) {
            return this.storageEditorInput.toString();
        }
        return super.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileEditorInput == null ? 0 : this.fileEditorInput.hashCode());
        result = 31 * result + (this.fileStoreEditorInput == null ? 0 : this.fileStoreEditorInput.hashCode());
        result = 31 * result + (this.remoteFileEditorInput == null ? 0 : this.remoteFileEditorInput.hashCode());
        result = 31 * result + (this.storageEditorInput == null ? 0 : this.storageEditorInput.hashCode());
        result = 31 * result + (this.repo == null ? 0 : this.repo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlowVisEditorInput other = (FlowVisEditorInput)obj;
        if (this.fileEditorInput == null) {
            return false;
        }
        if (!this.fileEditorInput.equals(other.fileEditorInput)) {
            return false;
        }
        if (this.fileStoreEditorInput == null) {
            return false;
        }
        if (!this.fileStoreEditorInput.equals((Object)other.fileStoreEditorInput)) {
            return false;
        }
        if (this.remoteFileEditorInput == null) {
            return false;
        }
        if (!this.remoteFileEditorInput.equals(other.remoteFileEditorInput)) {
            return false;
        }
        if (this.storageEditorInput == null) {
            return false;
        }
        if (!this.storageEditorInput.equals(other.storageEditorInput)) {
            return false;
        }
        if (this.repo == null) {
            return false;
        }
        return this.repo.equals(other.repo);
    }
}

