/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis;

import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.ui.editor.RemoteFileEditorInput;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowTransferDropTargetListener;
import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisContextMenuProvider;
import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisEditPartFactory;
import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisEditorInput;
import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisOutlinePage;
import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisPaletteFactory;
import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisUtil;
import com.ibm.team.internal.filesystem.ui.views.flowvis.SaveImageAction;
import com.ibm.team.internal.filesystem.ui.views.flowvis.gradient.FlowVisScalableFreeformLayeredPane;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisDiagram;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventObject;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class FlowVisEditor
extends GraphicalEditorWithFlyoutPalette
implements ITabbedPropertySheetPageContributor {
    public static final String ID = "com.ibm.team.filesystem.ui.editors.flowvis";
    public static final String FILE_EXTENSION = "sfv";
    public static final String FILE_EXTENSION_WITH_DOT = ".sfv";
    private PaletteRoot paletteRoot;
    private FlowVisDiagram diagram;
    private ResourceManager resourceManager;
    private KeyHandler sharedKeyHandler;
    private FlowVisOutlinePage outline;

    public FlowVisEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = FlowVisPaletteFactory.createPalette();
        }
        return this.paletteRoot;
    }

    public void doSave(IProgressMonitor monitor) {
        File file = ((FlowVisEditorInput)this.getEditorInput()).getFile();
        if (file != null && file.exists()) {
            this.performSave(file);
        } else {
            this.performSaveAs();
        }
    }

    private void performSave(File file) {
        try {
            this.saveProperties();
            FileOutputStream out = new FileOutputStream(file);
            this.writeToOutputStream(out);
            this.getCommandStack().markSaveLocation();
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void doSaveAs() {
        this.performSaveAs();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean performSaveAs() {
        FileDialog dialog = new FileDialog(this.getSite().getWorkbenchWindow().getShell(), 8192);
        FlowVisEditorInput editorInput = (FlowVisEditorInput)this.getEditorInput();
        File originalFile = editorInput.getFile();
        if (originalFile == null) {
            dialog.setFileName(String.valueOf(editorInput.getName()) + FILE_EXTENSION_WITH_DOT);
        } else {
            dialog.setFileName(originalFile.getName());
        }
        dialog.setFilterExtensions(new String[]{"*.sfv"});
        String path = dialog.open();
        if (path == null) {
            return false;
        }
        File file = new File(path);
        this.performSave(file);
        editorInput.setFile(file);
        this.setPartName(editorInput.getName());
        return true;
    }

    protected void writeToOutputStream(OutputStream os) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(os);
        out.writeObject(this.getDiagram());
        out.close();
    }

    private void saveProperties() {
        ZoomManager manager = (ZoomManager)this.getAdapter(ZoomManager.class);
        if (manager != null) {
            this.getDiagram().setZoom(manager.getZoom());
        }
    }

    public FlowVisDiagram getDiagram() {
        return this.diagram;
    }

    protected void setInput(IEditorInput input) {
        FlowVisEditorInput flowVisEditorInput = null;
        if (input instanceof FlowVisEditorInput) {
            flowVisEditorInput = (FlowVisEditorInput)input;
            FlowVisUtil util = new FlowVisUtil(this, flowVisEditorInput.getRepository());
            this.diagram = new FlowVisDiagram(util);
        } else if (input instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)input;
            IFile file = fileEditorInput.getFile();
            InputStream is = null;
            try {
                is = file.getContents(true);
                this.diagram = this.readInputStream(is);
                if (this.diagram != null) {
                    flowVisEditorInput = new FlowVisEditorInput(fileEditorInput, this.diagram.getUtil().getRepository());
                    this.setPartName(flowVisEditorInput.getName());
                } else {
                    Shell shell;
                    IWorkbenchPartSite site = this.getSite();
                    if (site != null && (shell = site.getWorkbenchWindow().getShell()) != null) {
                        MessageDialog.openError((Shell)shell, (String)Messages.FlowVisEditor_2, (String)NLS.bind((String)Messages.FlowVisEditor_3, (Object)file.getFullPath().toOSString()));
                    }
                }
            }
            catch (CoreException e) {
                IStatus status = StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                StatusUtil.log((IStatus)status);
            }
        } else if (input instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)input;
            File file = new File(fileStoreEditorInput.getURI());
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                this.diagram = this.readInputStream(is);
                if (this.diagram != null) {
                    flowVisEditorInput = new FlowVisEditorInput(fileStoreEditorInput, this.diagram.getUtil().getRepository());
                    this.setPartName(flowVisEditorInput.getName());
                } else {
                    Shell shell;
                    IWorkbenchPartSite site = this.getSite();
                    if (site != null && (shell = site.getWorkbenchWindow().getShell()) != null) {
                        MessageDialog.openError((Shell)shell, (String)Messages.FlowVisEditor_2, (String)NLS.bind((String)Messages.FlowVisEditor_3, (Object)file.getAbsolutePath()));
                    }
                }
            }
            catch (FileNotFoundException e) {
                IStatus status = StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                StatusUtil.log((IStatus)status);
            }
        } else if (input instanceof RemoteFileEditorInput) {
            final RemoteFileEditorInput remoteFileEditorInput = (RemoteFileEditorInput)input;
            this.run(new IRunnableWithProgress(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.FlowVisEditor_1, (int)100);
                    InputStream inStream = null;
                    try {
                        try {
                            IInputStreamProvider inStreamProvider = remoteFileEditorInput.getInputStreamProvider();
                            if (inStreamProvider == null || (inStream = inStreamProvider.getInputStream((IProgressMonitor)progress.newChild(100))) == null) return;
                            FlowVisEditor.this.diagram = FlowVisEditor.this.readInputStream(inStream);
                            return;
                        }
                        catch (FileNotFoundException e) {
                            IStatus status = StatusUtil.newStatus((Object)this, (Throwable)e);
                            StatusUtil.log((IStatus)status);
                            if (inStream == null) return;
                            try {
                                inStream.close();
                                return;
                            }
                            catch (IOException e2) {
                                IStatus status2 = StatusUtil.newStatus((Object)this, (Throwable)e2);
                                StatusUtil.log((IStatus)status2);
                            }
                            return;
                        }
                        catch (IOException e) {
                            IStatus status = StatusUtil.newStatus((Object)this, (Throwable)e);
                            StatusUtil.log((IStatus)status);
                            if (inStream == null) return;
                            try {
                                inStream.close();
                                return;
                            }
                            catch (IOException e3) {
                                IStatus status3 = StatusUtil.newStatus((Object)this, (Throwable)e3);
                                StatusUtil.log((IStatus)status3);
                            }
                            return;
                        }
                    }
                    finally {
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException e) {
                                IStatus status = StatusUtil.newStatus((Object)this, (Throwable)e);
                                StatusUtil.log((IStatus)status);
                            }
                        }
                    }
                }
            });
            if (this.diagram != null) {
                flowVisEditorInput = new FlowVisEditorInput(remoteFileEditorInput, this.diagram.getUtil().getRepository());
                this.setPartName(flowVisEditorInput.getName());
            } else {
                Shell shell;
                IWorkbenchPartSite site = this.getSite();
                if (site != null && (shell = site.getWorkbenchWindow().getShell()) != null) {
                    MessageDialog.openError((Shell)shell, (String)Messages.FlowVisEditor_2, (String)NLS.bind((String)Messages.FlowVisEditor_3, (Object)remoteFileEditorInput.getName()));
                }
            }
        } else if (input instanceof IStorageEditorInput) {
            IStorageEditorInput storageEditorInput = (IStorageEditorInput)input;
            try {
                IStorage storage = storageEditorInput.getStorage();
                InputStream is = storage.getContents();
                this.diagram = this.readInputStream(is);
                if (this.diagram != null) {
                    flowVisEditorInput = new FlowVisEditorInput(storageEditorInput, this.diagram.getUtil().getRepository());
                    this.setPartName(flowVisEditorInput.getName());
                } else {
                    Shell shell;
                    IWorkbenchPartSite site = this.getSite();
                    if (site != null && (shell = site.getWorkbenchWindow().getShell()) != null) {
                        MessageDialog.openError((Shell)shell, (String)Messages.FlowVisEditor_2, (String)NLS.bind((String)Messages.FlowVisEditor_3, (Object)storage.getFullPath()));
                    }
                }
            }
            catch (CoreException e) {
                IStatus status = StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                StatusUtil.log((IStatus)status);
            }
        } else {
            throw new IllegalArgumentException(input.getClass().toString());
        }
        if (this.diagram != null) {
            super.setInput((IEditorInput)flowVisEditorInput);
        }
    }

    private boolean run(IRunnableWithProgress runnable) {
        Shell shell;
        IWorkbenchPartSite site = this.getSite();
        if (site != null && (shell = site.getWorkbenchWindow().getShell()) != null) {
            try {
                new ProgressMonitorDialog(shell).run(true, true, runnable);
                return true;
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (t instanceof CoreException) {
                    CoreException ce = (CoreException)t;
                    StatusUtil.log((Object)((Object)this), (Throwable)ce);
                    ErrorDialog.openError((Shell)shell, null, null, (IStatus)ce.getStatus());
                } else {
                    ErrorDialog.openError((Shell)shell, null, null, (IStatus)StatusUtil.newStatus((Object)((Object)this), (Throwable)t));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FlowVisDiagram readInputStream(InputStream is) {
        FlowVisDiagram diagram = null;
        ObjectInputStream ois = null;
        try {
            try {
                ois = new ObjectInputStream(is);
                diagram = (FlowVisDiagram)ois.readObject();
                String repoURI = diagram.getRepositoryURI();
                UUID repoUUID = diagram.getRepositoryUUID();
                if (repoUUID == null) {
                    repoUUID = this.getRepoUuidFromFlowNodes(diagram);
                }
                ITeamRepository repository = repoUUID == null ? RepositoryUtils.getTeamRepository((String)repoURI) : RepositoryUtils.getTeamRepository((String)repoURI, (UUID)repoUUID);
                FlowVisUtil util = new FlowVisUtil(this, repository);
                diagram.setUtil(util);
                return diagram;
            }
            catch (IOException e) {
                IStatus status = StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                StatusUtil.log((IStatus)status);
                if (ois == null) return diagram;
                try {
                    ois.close();
                    return diagram;
                }
                catch (IOException e2) {
                    IStatus status2 = StatusUtil.newStatus((Object)((Object)this), (Throwable)e2);
                    StatusUtil.log((IStatus)status2);
                }
                return diagram;
            }
            catch (ClassNotFoundException e) {
                IStatus status = StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                StatusUtil.log((IStatus)status);
                if (ois == null) return diagram;
                try {
                    ois.close();
                    return diagram;
                }
                catch (IOException e3) {
                    IStatus status3 = StatusUtil.newStatus((Object)((Object)this), (Throwable)e3);
                    StatusUtil.log((IStatus)status3);
                }
                return diagram;
            }
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    IStatus status = StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                    StatusUtil.log((IStatus)status);
                }
            }
        }
    }

    private UUID getRepoUuidFromFlowNodes(FlowVisDiagram diagram) {
        UUID repoUuid = null;
        String repoURI = diagram.getRepositoryURI();
        for (FlowNode flowNode : diagram.getFlowNodes()) {
            if (!repoURI.equals(flowNode.getRepositoryUrl())) continue;
            repoUuid = flowNode.getRepoUUID();
            break;
        }
        return repoUuid;
    }

    private void handleException(Throwable e) {
        Shell shell;
        IStatus status = StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
        StatusUtil.log((IStatus)status);
        IWorkbenchPartSite site = this.getSite();
        if (site != null && (shell = site.getWorkbenchWindow().getShell()) != null) {
            ErrorDialog.openError((Shell)shell, null, null, (IStatus)status);
        }
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        registry.registerAction((IAction)new SaveImageAction(this.getSite().getPage()));
        IAction saveAction = registry.getAction((Object)ActionFactory.SAVE.getId());
        saveAction.setImageDescriptor(SaveImageAction.getEnabledImage());
        saveAction.setDisabledImageDescriptor(SaveImageAction.getDisabledImage());
        DirectEditAction directEditAction = new DirectEditAction((IWorkbenchPart)this);
        registry.registerAction((IAction)directEditAction);
        this.getSelectionActions().add(directEditAction.getId());
        IActionBars bars = this.getEditorSite().getActionBars();
        String id = ActionFactory.UNDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.REDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.DELETE.getId();
        IAction deleteAction = registry.getAction((Object)id);
        deleteAction.setText(Messages.FlowVisEditor_0);
        deleteAction.setToolTipText(Messages.FlowVisEditor_0);
        bars.setGlobalActionHandler(id, deleteAction);
        bars.updateActionBars();
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        if (this.diagram == null) {
            return;
        }
        this.getGraphicalViewer().setEditPartFactory((EditPartFactory)new FlowVisEditPartFactory(this.getResourceManager()));
        ScalableFreeformRootEditPart root = FlowVisEditor.newScalableFreeformRootEditPart();
        this.getGraphicalViewer().setRootEditPart((RootEditPart)root);
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        ZoomManager zoomManager = root.getZoomManager();
        zoomManager.setZoomLevelContributions(zoomLevels);
        zoomManager.setZoom(this.diagram.getZoom());
        ZoomInAction zoomIn = new ZoomInAction(zoomManager);
        ZoomOutAction zoomOut = new ZoomOutAction(zoomManager);
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        IHandlerService handler = (IHandlerService)this.getSite().getService(IHandlerService.class);
        handler.activateHandler(zoomIn.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)zoomIn));
        handler.activateHandler(zoomOut.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)zoomOut));
        this.getGraphicalViewer().setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        this.getGraphicalViewer().setKeyHandler(new GraphicalViewerKeyHandler(this.getGraphicalViewer()).setParent(this.getCommonKeyHandler()));
        FlowVisContextMenuProvider provider = new FlowVisContextMenuProvider(this.getGraphicalViewer(), this.getSite(), this.getActionRegistry(), this.diagram);
        this.getGraphicalViewer().setContextMenu((MenuManager)provider);
    }

    private static ScalableFreeformRootEditPart newScalableFreeformRootEditPart() {
        ScalableFreeformRootEditPart root = new ScalableFreeformRootEditPart(){

            protected ScalableFreeformLayeredPane createScaledLayers() {
                FlowVisScalableFreeformLayeredPane layers = new FlowVisScalableFreeformLayeredPane();
                layers.add((IFigure)this.createGridLayer(), "Grid Layer");
                layers.add((IFigure)this.getPrintableLayers(), "Printable Layers");
                FreeformLayer freeformLayer = new FreeformLayer();
                freeformLayer.setEnabled(true);
                layers.add((IFigure)freeformLayer, "Scaled Feedback Layer");
                return layers;
            }
        };
        return root;
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.sharedKeyHandler;
    }

    private ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), this.getGraphicalViewer().getControl());
        }
        return this.resourceManager;
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        if (this.diagram == null) {
            return;
        }
        this.getGraphicalViewer().setContents((Object)this.getDiagram());
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new FlowTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer(), this.diagram.getUtil().getRepository()));
        FlowVisEditor.requestShowPropertiesView();
    }

    public static void requestShowPropertiesView() {
        String id = "org.eclipse.ui.views.PropertySheet";
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null) {
            try {
                activePage.showView(id, null, 2);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
    }

    public void dispose() {
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
        super.dispose();
    }

    public String getContributorId() {
        return ID;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        if (adapter == IContentOutlinePage.class) {
            if (this.outline == null) {
                this.outline = new FlowVisOutlinePage((EditPartViewer)this.getGraphicalViewer());
            }
            return this.outline;
        }
        if (adapter == ZoomManager.class) {
            return this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        return super.getAdapter(adapter);
    }
}

