/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ui.actions.TanActions;
import com.ibm.team.filesystem.ui.changes.ChangesViewUtil;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.RepositoryActionsSelectionProvider;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.AddRemoveCollaborationCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.CreateWorkspaceCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.LayoutCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.RefreshFlowNodesCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.CollaborationEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.ComponentEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowNodeEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisDiagramEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Collaboration;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Component;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisDiagram;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.tools.MarqueeSelectionTool;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;

public class FlowVisContextMenuProvider
extends ContextMenuProvider {
    private static final String GROUP = "flowvis";
    private FlowVisDiagram diagram;
    private IWorkbenchPartSite site;
    private ActionRegistry actionRegistry;
    private MenuManager repoActions;
    private RepositoryActionsSelectionProvider repositoryActionsSelectionProvider;

    public FlowVisContextMenuProvider(GraphicalViewer viewer, IWorkbenchPartSite site, ActionRegistry actionRegistry, FlowVisDiagram diagram) {
        super((EditPartViewer)viewer);
        this.diagram = diagram;
        this.site = site;
        this.actionRegistry = actionRegistry;
        this.repoActions = new MenuManager(Messages.FlowVisContextMenuProvider_1);
        this.repositoryActionsSelectionProvider = new RepositoryActionsSelectionProvider(diagram, viewer);
        site.registerContextMenu(this.repoActions, (ISelectionProvider)this.repositoryActionsSelectionProvider);
    }

    public void buildContextMenu(IMenuManager menuManager) {
        Tool tool = this.getViewer().getEditDomain().getActiveTool();
        if (!(tool instanceof SelectionTool) && !(tool instanceof MarqueeSelectionTool)) {
            this.getViewer().getEditDomain().loadDefaultTool();
            return;
        }
        GEFActionConstants.addStandardActionGroups((IMenuManager)menuManager);
        IAction action = this.getActionRegistry().getAction((Object)ActionFactory.UNDO.getId());
        menuManager.appendToGroup("org.eclipse.gef.group.undo", action);
        action = this.getActionRegistry().getAction((Object)ActionFactory.REDO.getId());
        menuManager.appendToGroup("org.eclipse.gef.group.undo", action);
        action = this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in");
        menuManager.appendToGroup("org.eclipse.gef.group.view", action);
        action = this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_out");
        menuManager.appendToGroup("org.eclipse.gef.group.view", action);
        menuManager.appendToGroup("org.eclipse.gef.group.view", (IAction)new Action(Messages.FlowVisContextMenuProvider_2){

            public void run() {
                ISelection viewerSelection = FlowVisContextMenuProvider.this.getViewer().getSelection();
                if (viewerSelection instanceof IStructuredSelection) {
                    IStructuredSelection sSelection = (IStructuredSelection)viewerSelection;
                    Object o = sSelection.getFirstElement();
                    while (o != null && o instanceof EditPart) {
                        EditPart editPart = (EditPart)o;
                        if (editPart instanceof FlowVisDiagramEditPart) {
                            FlowVisDiagramEditPart flowVisDiagramEditPart = (FlowVisDiagramEditPart)editPart;
                            FlowVisContextMenuProvider.this.diagram.getUtil().getCommandStack().execute((Command)new LayoutCommand(flowVisDiagramEditPart));
                            return;
                        }
                        o = editPart.getParent();
                    }
                }
            }
        });
        menuManager.insertBefore("org.eclipse.gef.group.edit", (IContributionItem)new Separator(GROUP));
        menuManager.add((IContributionItem)new Separator(Messages.FlowVisContextMenuProvider_3));
        menuManager.appendToGroup(Messages.FlowVisContextMenuProvider_4, (IContributionItem)this.repoActions);
        this.repoActions.removeAll();
        ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)this.repoActions);
        ContextMenuHelper.addNewSubmenu((IMenuManager)this.repoActions, (boolean)false);
        List selection = this.getViewer().getSelectedEditParts();
        boolean needsProgress = false;
        int numFlowNodes = 0;
        int numCollaborations = 0;
        int numComponents = 0;
        boolean addRemoveFromDiagramMenu = true;
        for (Object o : selection) {
            if (o instanceof FlowNodeEditPart) {
                ++numFlowNodes;
                FlowNodeEditPart flowNodeEditPart = (FlowNodeEditPart)o;
                if (((FlowNode)flowNodeEditPart.getModel2()).getWorkspaceConnection() != null) continue;
                needsProgress = true;
                continue;
            }
            if (o instanceof CollaborationEditPart) {
                ++numCollaborations;
                continue;
            }
            if (!(o instanceof ComponentEditPart)) continue;
            ++numComponents;
            ComponentEditPart componentEditPart = (ComponentEditPart)o;
            Component component = (Component)componentEditPart.getModel2();
            if (component.getComponent() != null && component.getFlowNode().getWorkspaceConnection() != null) continue;
            needsProgress = true;
        }
        if (needsProgress) {
            this.repoActions.appendToGroup("jazz.navigate.group", (IAction)new Action(Messages.FlowVisContextMenuProvider_5){

                public void run() {
                    FlowVisContextMenuProvider.this.diagram.getUtil().getOperationRunner().enqueue(Messages.FlowVisContextMenuProvider_6, (Operation)new RepositoryOperation(){

                        public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                            List selection = FlowVisContextMenuProvider.this.getViewer().getSelectedEditParts();
                            ArrayList<IWorkspaceHandle> connectionsToFetch = new ArrayList<IWorkspaceHandle>();
                            ArrayList<IComponentHandle> componentsToFetch = new ArrayList<IComponentHandle>();
                            HashMap<UUID, FlowNode> flowNodesMap = new HashMap<UUID, FlowNode>();
                            HashMap<UUID, Component> componentsMap = new HashMap<UUID, Component>();
                            for (Object o : selection) {
                                FlowNode flowNode;
                                if (o instanceof FlowNodeEditPart) {
                                    FlowNodeEditPart flowNodeEditPart = (FlowNodeEditPart)o;
                                    FlowNode flowNode2 = (FlowNode)flowNodeEditPart.getModel2();
                                    if (flowNode2.getWorkspaceConnection() != null) continue;
                                    IWorkspaceHandle wsHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(flowNode2.getUUID(), null);
                                    connectionsToFetch.add(wsHandle);
                                    flowNodesMap.put(flowNode2.getUUID(), flowNode2);
                                    continue;
                                }
                                if (!(o instanceof ComponentEditPart)) continue;
                                ComponentEditPart componentEditPart = (ComponentEditPart)o;
                                Component component = (Component)componentEditPart.getModel2();
                                if (component.getComponent() == null) {
                                    IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(component.getUUID(), null);
                                    componentsToFetch.add(componentHandle);
                                    componentsMap.put(component.getUUID(), component);
                                }
                                if ((flowNode = component.getFlowNode()).getWorkspaceConnection() != null) continue;
                                IWorkspaceHandle wsHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(flowNode.getUUID(), null);
                                connectionsToFetch.add(wsHandle);
                                flowNodesMap.put(flowNode.getUUID(), flowNode);
                            }
                            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(connectionsToFetch.size() + componentsToFetch.size()));
                            ITeamRepository repository = FlowVisContextMenuProvider.this.diagram.getUtil().getRepository();
                            if (connectionsToFetch.size() > 0) {
                                ArrayList connections = new ArrayList();
                                for (IWorkspaceConnection connection : connections) {
                                    FlowNode flowNode;
                                    if (connection == null || (flowNode = (FlowNode)flowNodesMap.get(connection.getResolvedWorkspace().getItemId())) == null) continue;
                                    flowNode.setWorkspaceConnection(connection);
                                }
                            }
                            if (componentsToFetch.size() > 0) {
                                List components = repository.itemManager().fetchCompleteItems(componentsToFetch, 0, (IProgressMonitor)sub.newChild(componentsToFetch.size()));
                                for (IComponent iComponent : components) {
                                    Component component;
                                    if (iComponent == null || (component = (Component)componentsMap.get(iComponent.getItemId())) == null) continue;
                                    component.setComponent(iComponent);
                                }
                            }
                        }
                    });
                }
            });
        } else {
            TanActions.addTanActions(null, (IMenuManager)this.repoActions, (IWorkbenchSite)this.site, this.repositoryActionsSelectionProvider, IMenuOperationTarget.ALL_TYPES);
            if (selection.size() == 1 && numFlowNodes == 1) {
                Action newWorkspace = new Action(Messages.FlowVisContextMenuProvider_7, ImagePool.CREATE_WORKSPACE){

                    public void run() {
                        Object o;
                        List selectedEditParts = FlowVisContextMenuProvider.this.getViewer().getSelectedEditParts();
                        if (selectedEditParts.size() > 0 && (o = selectedEditParts.get(0)) instanceof FlowNodeEditPart) {
                            FlowNodeEditPart flowNodeEditPart = (FlowNodeEditPart)o;
                            CreateWorkspaceCommand command = new CreateWorkspaceCommand(false, (FlowNode)flowNodeEditPart.getModel2());
                            command.setDiagram(FlowVisContextMenuProvider.this.diagram);
                            FlowVisContextMenuProvider.this.diagram.getUtil().getCommandStack().execute((Command)command);
                        }
                    }
                };
                Action newStream = new Action(Messages.FlowVisContextMenuProvider_8, ImagePool.CREATE_STREAM){

                    public void run() {
                        Object o;
                        List selectedEditParts = FlowVisContextMenuProvider.this.getViewer().getSelectedEditParts();
                        if (selectedEditParts.size() > 0 && (o = selectedEditParts.get(0)) instanceof FlowNodeEditPart) {
                            FlowNodeEditPart flowNodeEditPart = (FlowNodeEditPart)o;
                            CreateWorkspaceCommand command = new CreateWorkspaceCommand(true, (FlowNode)flowNodeEditPart.getModel2());
                            command.setDiagram(FlowVisContextMenuProvider.this.diagram);
                            FlowVisContextMenuProvider.this.diagram.getUtil().getCommandStack().execute((Command)command);
                        }
                    }
                };
                menuManager.appendToGroup(GROUP, (IAction)newWorkspace);
                menuManager.appendToGroup(GROUP, (IAction)newStream);
            }
        }
        if (selection.size() == numFlowNodes && numFlowNodes > 0) {
            Action refreshAction = new Action(Messages.FlowVisContextMenuProvider_9, ImagePool.REFRESH_ICON){

                public void run() {
                    List selectedEditParts = FlowVisContextMenuProvider.this.getViewer().getSelectedEditParts();
                    ArrayList<FlowNode> flowNodes = new ArrayList<FlowNode>(selectedEditParts.size());
                    for (Object o : selectedEditParts) {
                        if (!(o instanceof FlowNodeEditPart)) continue;
                        FlowNodeEditPart flowNodeEditPart = (FlowNodeEditPart)o;
                        flowNodes.add((FlowNode)flowNodeEditPart.getModel2());
                    }
                    if (flowNodes.size() > 0) {
                        RefreshFlowNodesCommand command = new RefreshFlowNodesCommand(flowNodes);
                        command.setDiagram(FlowVisContextMenuProvider.this.diagram);
                        FlowVisContextMenuProvider.this.diagram.getUtil().getCommandStack().execute((Command)command);
                    }
                }
            };
            menuManager.appendToGroup("org.eclipse.gef.group.edit", (IAction)refreshAction);
        }
        if (addRemoveFromDiagramMenu && selection.size() != numComponents && (action = this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId())).isEnabled()) {
            menuManager.appendToGroup("org.eclipse.gef.group.edit", action);
        }
        if (selection.size() == numCollaborations && numCollaborations == 1) {
            this.repoActions.appendToGroup("jazz.refactoring.group", (IAction)new Action(Messages.FlowVisContextMenuProvider_10, ImagePool.DELETE){

                public void run() {
                    Object o;
                    List selectedEditParts = FlowVisContextMenuProvider.this.getViewer().getSelectedEditParts();
                    if (selectedEditParts.size() > 0 && (o = selectedEditParts.get(0)) instanceof CollaborationEditPart) {
                        CollaborationEditPart collaborationEditPart = (CollaborationEditPart)o;
                        Collaboration collaboration = (Collaboration)collaborationEditPart.getModel2();
                        FlowVisContextMenuProvider.this.diagram.getUtil().getCommandStack().execute((Command)new AddRemoveCollaborationCommand(collaboration, false));
                    }
                }
            });
            this.repoActions.appendToGroup("jazz.compare.group", (IAction)new Action(Messages.FlowVisContextMenuProvider_11){

                public void run() {
                    Object o;
                    List selectedEditParts = FlowVisContextMenuProvider.this.getViewer().getSelectedEditParts();
                    if (selectedEditParts.size() > 0 && (o = selectedEditParts.get(0)) instanceof CollaborationEditPart) {
                        CollaborationEditPart collaborationEditPart = (CollaborationEditPart)o;
                        Collaboration collaboration = (Collaboration)collaborationEditPart.getModel2();
                        final FlowNode source = (FlowNode)collaboration.getSource();
                        final FlowNode target = (FlowNode)collaboration.getTarget();
                        IWorkspaceConnection sourceConnection = source.getWorkspaceConnection();
                        IWorkspaceConnection targetConnection = target.getWorkspaceConnection();
                        if (sourceConnection != null && targetConnection != null) {
                            ChangesViewUtil.compareWorkspaceWithWorkspace(FlowVisContextMenuProvider.this.site.getPage(), sourceConnection.teamRepository(), (IWorkspaceHandle)sourceConnection.getResolvedWorkspace(), targetConnection.teamRepository(), (IWorkspaceHandle)targetConnection.getResolvedWorkspace());
                        } else {
                            FlowVisContextMenuProvider.this.diagram.getUtil().getOperationRunner().enqueue(Messages.FlowVisContextMenuProvider_12, (Operation)new RepositoryOperation(){

                                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                                    SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                                    final IWorkspaceConnection sourceConnection = source.getWorkspaceConnection((IProgressMonitor)sub.newChild(1));
                                    final IWorkspaceConnection targetConnection = target.getWorkspaceConnection((IProgressMonitor)sub.newChild(1));
                                    SWTUtil.greedyExec((Display)FlowVisContextMenuProvider.this.diagram.getUtil().getDisplay(), (Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            ChangesViewUtil.compareWorkspaceWithWorkspace(FlowVisContextMenuProvider.this.site.getPage(), sourceConnection.teamRepository(), (IWorkspaceHandle)sourceConnection.getResolvedWorkspace(), targetConnection.teamRepository(), (IWorkspaceHandle)targetConnection.getResolvedWorkspace());
                                        }
                                    });
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    private ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }
}

