/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis;

import com.ibm.team.filesystem.rcp.core.internal.changes.util.WorkspaceSyncContext;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;

public class FlowTransferDropTargetListener
extends AbstractTransferDropTargetListener {
    ITeamRepository repo;

    public FlowTransferDropTargetListener(EditPartViewer viewer, ITeamRepository repo) {
        super(viewer, (Transfer)LocalSelectionTransfer.getTransfer());
        this.repo = repo;
    }

    protected Request createTargetRequest() {
        CreateRequest request = new CreateRequest();
        return request;
    }

    protected void updateTargetRequest() {
        ((CreateRequest)this.getTargetRequest()).setLocation(this.getDropLocation());
    }

    protected void handleDragOver() {
        if (!this.isFlowNode()) {
            return;
        }
        this.getCurrentEvent().detail = 4;
        super.handleDragOver();
    }

    protected void handleDrop() {
        if (!this.isFlowNode()) {
            return;
        }
        CreateRequest request = (CreateRequest)this.getTargetRequest();
        final List<Object> selection = this.getSelection();
        request.setFactory(new CreationFactory(){

            public Object getNewObject() {
                return null;
            }

            public Object getObjectType() {
                return selection;
            }
        });
        super.handleDrop();
    }

    public boolean isEnabled(DropTargetEvent event) {
        if (this.isFlowNode()) {
            return super.isEnabled(event);
        }
        return false;
    }

    private List<Object> getSelection() {
        LocalSelectionTransfer lsTransfer;
        ISelection selection;
        ArrayList<Object> list = new ArrayList<Object>();
        Transfer transfer = this.getTransfer();
        if (transfer instanceof LocalSelectionTransfer && (selection = (lsTransfer = (LocalSelectionTransfer)transfer).getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Object[] objectArray = sSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o != null) {
                    WorkspaceSyncContext context;
                    AbstractPlaceWrapper wrapper = (AbstractPlaceWrapper)((Object)Adapters.getAdapter((Object)o, AbstractPlaceWrapper.class));
                    if (wrapper != null) {
                        if (wrapper.getRepository().equals(this.repo)) {
                            list.add((Object)wrapper);
                        }
                    } else if (o instanceof WorkspaceSyncContext && (context = (WorkspaceSyncContext)o).teamRepository().equals(this.repo)) {
                        list.add(o);
                    }
                }
                ++n2;
            }
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFlowNode() {
        LocalSelectionTransfer lsTransfer;
        ISelection selection;
        Transfer transfer = this.getTransfer();
        if (!(transfer instanceof LocalSelectionTransfer) || !((selection = (lsTransfer = (LocalSelectionTransfer)transfer).getSelection()) instanceof IStructuredSelection)) return true;
        IStructuredSelection sSelection = (IStructuredSelection)selection;
        Object[] objectArray = sSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o == null) return false;
            AbstractPlaceWrapper wrapper = (AbstractPlaceWrapper)((Object)Adapters.getAdapter((Object)o, AbstractPlaceWrapper.class));
            if (wrapper != null) {
                if (!wrapper.getRepository().equals(this.repo)) {
                    return false;
                }
            } else {
                if (!(o instanceof WorkspaceSyncContext)) return false;
                WorkspaceSyncContext context = (WorkspaceSyncContext)o;
                if (!context.teamRepository().equals(this.repo)) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }
}

