/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.ce;

import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsItemReviewEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.MergeGraphEntry;
import com.ibm.team.internal.filesystem.ui.views.history.GraphPaintListener;
import com.ibm.team.internal.filesystem.ui.views.history.MergeInfo;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class MergeGraphColumn {
    private ResourceManager resources;
    private Map<CombinedChangeSetsItemReviewEntry, MergeInfo> mergeData = new HashMap<CombinedChangeSetsItemReviewEntry, MergeInfo>();
    private Runnable recomputeRunnable = new Runnable(){

        @Override
        public void run() {
            if (MergeGraphColumn.this.reviewEntries == null || MergeGraphColumn.this.viewer.getTable().isDisposed()) {
                return;
            }
            MergeGraphColumn.this.mergeData.clear();
            int linesOfDescent = 0;
            ArrayList<UUID> contents = new ArrayList<UUID>();
            MergeInfo currentInfo = null;
            int count = 0;
            CombinedChangeSetsItemReviewEntry[] combinedChangeSetsItemReviewEntryArray = MergeGraphColumn.this.reviewEntries;
            int n = combinedChangeSetsItemReviewEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                CombinedChangeSetsItemReviewEntry next = combinedChangeSetsItemReviewEntryArray[n2];
                currentInfo = currentInfo == null ? MergeInfo.computeFirstRow(contents, next) : currentInfo.computePredecessorRow(contents, contents, next, ++count == MergeGraphColumn.this.reviewEntries.length);
                if (contents.size() > linesOfDescent) {
                    linesOfDescent = contents.size();
                }
                MergeGraphColumn.this.mergeData.put(next, currentInfo);
                ++n2;
            }
            MergeGraphColumn.this.paintListener.setTotalLinesOfDescent(linesOfDescent);
        }
    };
    private TableViewer viewer;
    private CombinedChangeSetsItemReviewEntry[] reviewEntries;
    private GraphPaintListener paintListener;

    public MergeGraphColumn(TableViewer viewer) {
        this.viewer = viewer;
        this.resources = new LocalResourceManager(JFaceResources.getResources());
        this.paintListener = new GraphPaintListener((Control)viewer.getTable(), this.resources){

            @Override
            public void handleEvent(Event event) {
                if (event.index == 0) {
                    super.handleEvent(event);
                }
            }

            @Override
            protected MergeInfo getMergeInfo(Object data) {
                if (data instanceof MergeGraphEntry) {
                    CombinedChangeSetsItemReviewEntry entry = ((MergeGraphEntry)data).getReviewEntry();
                    return (MergeInfo)MergeGraphColumn.this.mergeData.get(entry);
                }
                return null;
            }
        };
        this.recomputeRunnable.run();
        viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MergeGraphColumn.this.dispose();
            }
        });
    }

    public Listener getPaintListener() {
        return this.paintListener;
    }

    public void setReviewEntries(CombinedChangeSetsItemReviewEntry[] reviewEntries) {
        this.reviewEntries = reviewEntries;
        this.recomputeRunnable.run();
    }

    void dispose() {
        this.resources.dispose();
    }
}

