/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.ce;

import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsComponentEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsItemEntry;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IFolderHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public class CombinedChangeSetsParentEntry {
    private static final Comparator<CombinedChangeSetsItemEntry> COMPARATOR = new Comparator<CombinedChangeSetsItemEntry>(){

        @Override
        public int compare(CombinedChangeSetsItemEntry object1, CombinedChangeSetsItemEntry object2) {
            if (object1.getVersionableHandle() instanceof IFolderHandle) {
                if (!(object2.getVersionableHandle() instanceof IFolderHandle)) {
                    return -1;
                }
            } else if (object2.getVersionableHandle() instanceof IFolderHandle) {
                return 1;
            }
            String name1 = object1.getName();
            String name2 = object2.getName();
            if (name1 == null) {
                name1 = object1.getFallbackName();
            }
            if (name2 == null) {
                name2 = object2.getFallbackName();
            }
            return name1.compareTo(name2);
        }
    };
    private final CombinedChangeSetsComponentEntry parent;
    private UUID folderItemId;
    private final String path;
    private final boolean pathInContext;
    private List<CombinedChangeSetsItemEntry> itemEntries = new ArrayList<CombinedChangeSetsItemEntry>();

    public CombinedChangeSetsParentEntry(CombinedChangeSetsComponentEntry parent, String path, boolean pathInContext) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)path);
        this.parent = parent;
        this.path = path;
        this.pathInContext = pathInContext;
    }

    public CombinedChangeSetsComponentEntry getParent() {
        return this.parent;
    }

    public UUID getFolderItemId() {
        return this.folderItemId;
    }

    public void setFolderItemId(UUID folderItemId) {
        this.folderItemId = folderItemId;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isPathInContext() {
        return this.pathInContext;
    }

    public void sort() {
        Collections.sort(this.itemEntries, COMPARATOR);
    }

    public void addItemEntry(CombinedChangeSetsItemEntry itemEntry) {
        this.itemEntries.add(itemEntry);
    }

    public CombinedChangeSetsItemEntry[] getItemEntries() {
        return this.itemEntries.toArray(new CombinedChangeSetsItemEntry[this.itemEntries.size()]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.folderItemId == null ? 0 : this.folderItemId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CombinedChangeSetsParentEntry other = (CombinedChangeSetsParentEntry)obj;
        return !(this.folderItemId == null ? other.folderItemId != null : !this.folderItemId.equals((Object)other.folderItemId));
    }
}

