/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.ce;

import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import com.ibm.team.scm.common.dto.IConsolidatedChangeInfo;
import com.ibm.team.scm.common.dto.IConsolidatedChangeSetInfo;
import com.ibm.team.scm.common.dto.IConsolidatedStateInfo;
import com.ibm.team.scm.common.dto.IVersionableIdentifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CombinedChangeSetsItemReviewEntry {
    private IChangeSetLinkSummary linkSummary;
    private String comment;
    private boolean active;
    private IContributorHandle author;
    private UUID changeSetItemId;
    private IVersionableHandle versionableHandle;
    private UUID before;
    private UUID after;
    private int kind;
    private List<IVersionableHandle> merges = new ArrayList<IVersionableHandle>();
    private Date timestamp;
    private IVersionableIdentifier versionIdentifier;

    private static UUID getStateUUID(IConsolidatedStateInfo state) {
        return state == null ? null : state.getStateId();
    }

    public CombinedChangeSetsItemReviewEntry(IVersionableHandle versionableHandle, IConsolidatedChangeInfo change, IConsolidatedChangeSetInfo info) {
        IConsolidatedStateInfo afterState = change.getAfterState();
        this.versionableHandle = versionableHandle;
        this.changeSetItemId = info.getItemId();
        this.timestamp = info.getLastChangeDate();
        this.comment = info.getComment();
        this.author = info.getAuthor();
        this.before = CombinedChangeSetsItemReviewEntry.getStateUUID(change.getBeforeState());
        this.after = CombinedChangeSetsItemReviewEntry.getStateUUID(afterState);
        this.kind = change.getKind();
        this.active = info.isActive();
        if (afterState != null) {
            this.versionIdentifier = afterState.getVersionableIdentifier();
        }
    }

    public IChangeSetLinkSummary getLinkSummary() {
        return this.linkSummary;
    }

    public void setLinkSummary(IChangeSetLinkSummary linkSummary) {
        this.linkSummary = linkSummary;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isActive() {
        return this.active;
    }

    public IContributorHandle getAuthor() {
        return this.author;
    }

    public UUID getChangeSetItemId() {
        return this.changeSetItemId;
    }

    public IVersionableHandle getVersionableHandle() {
        return this.versionableHandle;
    }

    public UUID getBefore() {
        return this.before;
    }

    public UUID getAfter() {
        return this.after;
    }

    public IVersionableIdentifier getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public int getKind() {
        return this.kind;
    }

    public void addMerge(IVersionableHandle merge) {
        this.merges.add(merge);
    }

    public IVersionableHandle[] getMerges() {
        return this.merges.toArray(new IVersionableHandle[this.merges.size()]);
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.changeSetItemId == null ? 0 : this.changeSetItemId.hashCode());
        result = 31 * result + (this.versionableHandle == null || this.versionableHandle.getItemId() == null ? 0 : this.versionableHandle.getItemId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CombinedChangeSetsItemReviewEntry other = (CombinedChangeSetsItemReviewEntry)obj;
        if (this.changeSetItemId == null ? other.changeSetItemId != null : !this.changeSetItemId.equals((Object)other.changeSetItemId)) {
            return false;
        }
        return !(this.versionableHandle == null ? other.versionableHandle != null : (this.versionableHandle.getItemId() == null ? other.versionableHandle.getItemId() != null : !this.versionableHandle.getItemId().equals((Object)other.versionableHandle.getItemId())));
    }
}

