/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.ce;

import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsItemReviewEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsParentEntry;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IConsolidatedItemChanges;
import com.ibm.team.scm.common.dto.IVersionableIdentifier;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;

public class CombinedChangeSetsItemEntry
implements IAdaptable {
    private CombinedChangeSetsParentEntry parent;
    private String name;
    private String sourceName;
    private String fallbackName;
    private String path;
    private UUID pathUUID;
    private String sourcePath;
    private UUID sourcePathUUID;
    private IVersionableHandle versionableHandle;
    private UUID itemId;
    private UUID estimatedInitialState;
    private UUID estimatedFinalState;
    private IVersionableIdentifier versionIdentifier;
    private boolean comparable;
    private boolean merge;
    private int mergeCount;
    private List<CombinedChangeSetsItemReviewEntry> reviewEntries = new ArrayList<CombinedChangeSetsItemReviewEntry>();

    public CombinedChangeSetsItemEntry(CombinedChangeSetsParentEntry parent, IConsolidatedItemChanges changesReport) {
        Assert.isNotNull((Object)parent);
        this.parent = parent;
        if (changesReport.isUniqueStartingState()) {
            this.estimatedInitialState = changesReport.getUniqueStartingStateId();
        } else if (!changesReport.getMergeStateIds().isEmpty()) {
            this.estimatedInitialState = (UUID)changesReport.getMergeStateIds().get(changesReport.getMergeStateIds().size() - 1);
            this.merge = true;
            this.mergeCount = changesReport.getMergeStateIds().size() - 1;
        } else {
            this.comparable = false;
        }
        if (changesReport.isUniqueEndingState()) {
            this.estimatedFinalState = changesReport.getUniqueEndingStateId();
        } else {
            this.comparable = false;
            this.merge = false;
        }
        this.versionableHandle = changesReport.getVersionableHandle();
        this.itemId = this.versionableHandle.getItemId();
        this.versionIdentifier = changesReport.getEndingVersionableIdentifier();
        this.comparable = changesReport.isSingleLineOfDescent() || changesReport.isUniqueEndingState() && !changesReport.getMergeStateIds().isEmpty();
    }

    public CombinedChangeSetsParentEntry getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getFallbackName() {
        return this.fallbackName;
    }

    public void setFallbackName(String fallbackName) {
        this.fallbackName = fallbackName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public UUID getPathUUID() {
        return this.pathUUID;
    }

    public void setPathUUID(UUID pathUUID) {
        this.pathUUID = pathUUID;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public UUID getSourcePathUUID() {
        return this.sourcePathUUID;
    }

    public void setSourcePathUUID(UUID sourcePathUUID) {
        this.sourcePathUUID = sourcePathUUID;
    }

    public IVersionableHandle getVersionableHandle() {
        return this.versionableHandle;
    }

    public UUID getItemId() {
        return this.itemId;
    }

    public IVersionableIdentifier getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public UUID getEstimatedInitialState() {
        return this.estimatedInitialState;
    }

    public UUID getEstimatedFinalState() {
        return this.estimatedFinalState;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public boolean isComparable() {
        return this.comparable;
    }

    public int getMergeCount() {
        return this.mergeCount;
    }

    public void addReviewEntry(CombinedChangeSetsItemReviewEntry reviewEntry) {
        this.reviewEntries.add(reviewEntry);
    }

    public CombinedChangeSetsItemReviewEntry getReviewEntry(int index) {
        return this.reviewEntries.get(index);
    }

    public CombinedChangeSetsItemReviewEntry[] getReviewEntries() {
        return this.reviewEntries.toArray(new CombinedChangeSetsItemReviewEntry[this.reviewEntries.size()]);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IVersionableHandle.class) {
            return this.versionableHandle;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.itemId == null ? 0 : this.itemId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CombinedChangeSetsItemEntry other = (CombinedChangeSetsItemEntry)obj;
        return !(this.itemId == null ? other.itemId != null : !this.itemId.equals((Object)other.itemId));
    }

    public boolean isIncomplete() {
        return !this.isComparable();
    }
}

