/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.ce;

import com.ibm.team.filesystem.client.internal.FileContentInputStreamProvider;
import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.BaselineId;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.client.internal.snapshot.HistoryReferenceId;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.NamespaceSetId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReport;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceId;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.FileItemHandle;
import com.ibm.team.filesystem.common.internal.FilesystemFactory;
import com.ibm.team.filesystem.common.internal.util.SubComponentUtil;
import com.ibm.team.filesystem.ide.ui.internal.util.ExternalCompareToolUtils;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.MenuUtil;
import com.ibm.team.internal.filesystem.ui.views.ce.AggregateChangesTree;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsComponentEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsItemEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsItemReviewEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsParentEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedSubcomponentChangeEntry;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeSetInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.GenerateChangeLogRepositoryOperation;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.StructuralChangesViewInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSiteJobRunner;
import com.ibm.team.repository.rcp.ui.internal.query.PopupLayout;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IConsolidatedChangeInfo;
import com.ibm.team.scm.common.dto.IConsolidatedChangeSetInfo;
import com.ibm.team.scm.common.dto.IConsolidatedChangeSetsPathReport;
import com.ibm.team.scm.common.dto.IConsolidatedChangesComponentReport;
import com.ibm.team.scm.common.dto.IConsolidatedChangesReport;
import com.ibm.team.scm.common.dto.IConsolidatedItemChanges;
import com.ibm.team.scm.common.dto.IConsolidatedParentPathInfo;
import com.ibm.team.scm.common.dto.IConsolidatedStateInfo;
import com.ibm.team.scm.common.dto.IPagedFetchDescriptor;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.statushandlers.StatusManager;

public class ChangeSummaryView
extends ViewPart {
    public static final String VIEW_ID = "com.ibm.team.filesystem.ce.ChangeSummaryView";
    private static final int HISTORY_SIZE = 10;
    private TreeViewer viewer;
    private AggregateChangesTree aggregateChangesTree;
    private Action changeLogAction;
    private Action detailsAction;
    private Input currentInput;
    private Operation changeContextOperation;
    private AtomicBoolean refreshBoolean = new AtomicBoolean(false);
    private AtomicReference<SnapshotId> atomicSnapshot = new AtomicReference();
    private List<Input> history = new ArrayList<Input>(10);
    private Action backAction;
    private Action forwardAction;
    private boolean pinned = false;
    private Composite parent;
    private Composite toasterComposite;
    private PopupLayout popupLayout;
    private Composite pagingWarningComposite;
    private Composite inaccessibleItemsComposite;
    private Label inaccessibleItemsLabel;
    private Composite inaccessibleComponentsComposite;
    private Label inaccessibleComponentsLabel;
    private Composite unresolvedPathsWarningComposite;
    private Image warningImage;
    private FormColors formColors;
    private IOperationRunner runner;
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("PREF_CHANGE_SUMMARY_SHOW_DETAILS_PANE".equals(event.getProperty())) {
                Object newValue = event.getNewValue();
                if (newValue instanceof Boolean) {
                    ChangeSummaryView.this.detailsAction.setChecked(((Boolean)newValue).booleanValue());
                } else if (newValue instanceof String) {
                    ChangeSummaryView.this.detailsAction.setChecked(Boolean.parseBoolean((String)newValue));
                }
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.popupLayout = new PopupLayout();
        parent.setLayout((Layout)this.popupLayout);
        this.runner = new PartSiteJobRunner(this.getSite(), false);
        this.aggregateChangesTree = new AggregateChangesTree(this.getSite().getPage(), this.runner);
        this.popupLayout.setMainControl(this.aggregateChangesTree.createControls(parent));
        this.viewer = this.aggregateChangesTree.getTreeViewer();
        this.createToaster(parent);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.createContextMenu();
        this.createToolBarActions();
        this.createMenuActions();
        this.updateEnablement();
        UiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.filesystem.ide.ui.view_changesummary");
    }

    public void dispose() {
        UiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        if (this.warningImage != null) {
            this.warningImage.dispose();
            this.warningImage = null;
        }
        if (this.formColors != null) {
            this.formColors.dispose();
            this.formColors = null;
        }
        super.dispose();
    }

    private void createToaster(Composite parent) {
        this.formColors = new FormColors(parent.getDisplay());
        this.warningImage = com.ibm.team.jface.internal.ImagePool.WARN_ICON.createImage();
        this.toasterComposite = new Composite(parent, 2);
        this.toasterComposite.setVisible(false);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.toasterComposite.setLayout((Layout)layout);
        Label separator = new Label(this.toasterComposite, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createPagingWarning();
        this.createInaccessibleItemsWarning();
        this.createInaccessibleComponentsWarning();
        this.createUnresolvedPathsWarning();
        this.setToasterBackground();
    }

    private void setToasterBackground() {
        Color background = this.formColors.getBackground();
        this.toasterComposite.setBackground(background);
        this.setBackground(this.toasterComposite.getChildren(), background);
    }

    private void setBackground(Control[] controls, Color background) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                this.setBackground(((Composite)control).getChildren(), background);
            }
            control.setBackground(background);
            ++n2;
        }
    }

    private GridLayout createToasterItemLayout() {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = LayoutConstants.getSpacing().y;
        return layout;
    }

    private void createPagingWarning() {
        this.pagingWarningComposite = new Composite(this.toasterComposite, 0);
        this.pagingWarningComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.pagingWarningComposite.setLayout((Layout)this.createToasterItemLayout());
        Label warningLabel = new Label(this.pagingWarningComposite, 256);
        warningLabel.setImage(this.warningImage);
        GridData data = new GridData(1, 1, false, false);
        data.horizontalIndent = 5;
        warningLabel.setLayoutData((Object)data);
        Link hyperlink = new Link(this.pagingWarningComposite, 0);
        hyperlink.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        hyperlink.setText(Messages.ChangeSummaryView_pagingWarningText);
        hyperlink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ChangesViewConverter.openChangeExplorer(ChangeSummaryView.this.getSite().getPage(), new ChangeSetInput(ChangeSummaryView.this.currentInput.snapshotId, ChangeSummaryView.this.currentInput.changeSetHandles));
            }
        });
    }

    private void createInaccessibleItemsWarning() {
        this.inaccessibleItemsComposite = new Composite(this.toasterComposite, 0);
        this.inaccessibleItemsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.inaccessibleItemsComposite.setLayout((Layout)this.createToasterItemLayout());
        Label warningLabel = new Label(this.inaccessibleItemsComposite, 256);
        warningLabel.setImage(this.warningImage);
        GridData data = new GridData(1, 1, false, false);
        data.horizontalIndent = 5;
        warningLabel.setLayoutData((Object)data);
        this.inaccessibleItemsLabel = new Label(this.inaccessibleItemsComposite, 16448);
        this.inaccessibleItemsLabel.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
    }

    private void createInaccessibleComponentsWarning() {
        this.inaccessibleComponentsComposite = new Composite(this.toasterComposite, 0);
        this.inaccessibleComponentsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.inaccessibleComponentsComposite.setLayout((Layout)this.createToasterItemLayout());
        Label warningLabel = new Label(this.inaccessibleComponentsComposite, 256);
        warningLabel.setImage(this.warningImage);
        GridData data = new GridData(1, 1, false, false);
        data.horizontalIndent = 5;
        warningLabel.setLayoutData((Object)data);
        this.inaccessibleComponentsLabel = new Label(this.inaccessibleComponentsComposite, 16448);
        this.inaccessibleComponentsLabel.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
    }

    private void createUnresolvedPathsWarning() {
        this.unresolvedPathsWarningComposite = new Composite(this.toasterComposite, 0);
        this.unresolvedPathsWarningComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.unresolvedPathsWarningComposite.setLayout((Layout)this.createToasterItemLayout());
        Label warningLabel = new Label(this.unresolvedPathsWarningComposite, 256);
        warningLabel.setImage(this.warningImage);
        GridData data = new GridData(1, 1, false, false);
        data.horizontalIndent = 5;
        warningLabel.setLayoutData((Object)data);
        Link hyperlink = new Link(this.unresolvedPathsWarningComposite, 0);
        hyperlink.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        hyperlink.setText(Messages.ChangeSummaryView_unableToResolveLinkText);
        hyperlink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ChangeSummaryView.this.changeContext();
            }
        });
    }

    private void changeContext() {
        if (this.currentInput != null) {
            Input input = this.currentInput;
            ITeamRepository repository = input.snapshotId.getRepository();
            AbstractPlaceWrapper workspaceOrStream = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(this.getSite().getShell(), repository, null, null, WORKSPACES_OR_STREAMS.STREAMS, true, null, null);
            if (workspaceOrStream != null) {
                this.recomputePaths(input, (SnapshotId)WorkspaceId.create((ITeamRepository)repository, (IWorkspaceHandle)workspaceOrStream.getWorkspace()));
            }
        }
    }

    private void recomputePaths(final Input input, SnapshotId snapshotId) {
        if (this.changeContextOperation != null) {
            this.runner.dequeue(this.changeContextOperation);
        }
        this.changeContextOperation = new RepositoryOperation(input.snapshotId.getRepository()){

            private SnapshotId getSnapshot() {
                return (SnapshotId)ChangeSummaryView.this.atomicSnapshot.get();
            }

            private void checkInput() {
                if (input != ChangeSummaryView.this.currentInput) {
                    throw new OperationCanceledException();
                }
            }

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                this.checkInput();
                SnapshotId currentSnapshot = this.getSnapshot();
                ITeamRepository repo = currentSnapshot.getRepository();
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)11);
                ISnapshot snapshot = currentSnapshot.getSnapshot((IProgressMonitor)subMonitor.newChild(1));
                IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                Collection reports = input.report.getReports();
                IContextHandle workspace = ChangeSummaryView.getWorkspace(currentSnapshot);
                List<IConsolidatedChangeSetsPathReport> pathReports = null;
                if (workspace != null && (pathReports = ChangeSummaryView.calculateParentPaths(workspaceManager, workspace, reports, (IProgressMonitor)subMonitor.newChild(8))) == null) {
                    workspace = null;
                }
                this.checkInput();
                input.componentNamespaces = ChangeSummaryView.createComponentNamespaces(snapshot, reports, (IProgressMonitor)subMonitor.newChild(1));
                input.snapshotId = currentSnapshot;
                input.context = workspace;
                input.output = ChangeSummaryView.parse(repo, reports, pathReports, (IProgressMonitor)subMonitor.newChild(1));
                input.label = ChangeSummaryView.computeContentDescription(input.changeSetHandles.size(), input.context == null ? null : snapshot.getName());
                int i = 0;
                while (i < ChangeSummaryView.this.history.size()) {
                    Input storedInput = (Input)ChangeSummaryView.this.history.get(i);
                    if (storedInput.equals(input) && storedInput != input) {
                        ChangeSummaryView.this.history.remove(i);
                        --i;
                    }
                    ++i;
                }
                WorkbenchJob job = new WorkbenchJob(PlatformUI.getWorkbench().getDisplay(), Messages.ChangeSummaryView_pathCalculationOperationTitle){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (input == ChangeSummaryView.this.currentInput) {
                            ChangeSummaryView.this.open(input);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        };
        this.atomicSnapshot.set(snapshotId);
        this.runner.enqueue(Messages.ChangeSummaryView_pathCalculationOperationTitle, this.changeContextOperation);
    }

    private void showPagingWarning(Collection<IConsolidatedChangesComponentReport> reports) {
        IPagedFetchDescriptor descriptor = null;
        for (IConsolidatedChangesComponentReport report : reports) {
            descriptor = report.getNextPageDescriptor();
            if (descriptor != null) break;
        }
        boolean show = descriptor != null;
        GridData data = (GridData)this.pagingWarningComposite.getLayoutData();
        data.exclude = !show;
        this.pagingWarningComposite.setVisible(show);
        this.toasterComposite.setVisible(this.pagingWarningComposite.getVisible() || this.inaccessibleItemsComposite.getVisible() || this.inaccessibleComponentsComposite.getVisible() || this.unresolvedPathsWarningComposite.getVisible());
    }

    private void showInaccessibleItemsWarning(boolean visible) {
        GridData data = (GridData)this.inaccessibleItemsComposite.getLayoutData();
        data.exclude = !visible;
        this.inaccessibleItemsComposite.setVisible(visible);
    }

    private void showInaccessibleItemsWarning(long inaccessibleCount) {
        if (inaccessibleCount == 0L) {
            this.showInaccessibleItemsWarning(false);
        } else if (inaccessibleCount == 1L) {
            this.showInaccessibleItemsWarning(true);
            this.inaccessibleItemsLabel.setText(Messages.ChangeSummaryView_inaccessibleItemsWarningTextSingular);
        } else {
            this.showInaccessibleItemsWarning(true);
            this.inaccessibleItemsLabel.setText(NLS.bind((String)Messages.ChangeSummaryView_inaccessibleItemsWarningTextPlural, (Object)Long.toString(inaccessibleCount)));
        }
        this.toasterComposite.setVisible(this.pagingWarningComposite.getVisible() || this.inaccessibleItemsComposite.getVisible() || this.inaccessibleComponentsComposite.getVisible() || this.unresolvedPathsWarningComposite.getVisible());
    }

    private void showInaccessibleComponentsWarning(boolean visible) {
        GridData data = (GridData)this.inaccessibleComponentsComposite.getLayoutData();
        data.exclude = !visible;
        this.inaccessibleComponentsComposite.setVisible(visible);
    }

    private void showInaccessibleComponentsWarning(int inaccessibleCount) {
        if (inaccessibleCount == 0) {
            this.showInaccessibleComponentsWarning(false);
        } else if (inaccessibleCount == 1) {
            this.showInaccessibleComponentsWarning(true);
            this.inaccessibleComponentsLabel.setText(Messages.ChangeSummaryView_inaccessibleComponentsWarningTextSingular);
        } else {
            this.showInaccessibleComponentsWarning(true);
            this.inaccessibleComponentsLabel.setText(NLS.bind((String)Messages.ChangeSummaryView_inaccessibleComponentsWarningTextPlural, (Object)Long.toString(inaccessibleCount)));
        }
        this.toasterComposite.setVisible(this.pagingWarningComposite.getVisible() || this.inaccessibleItemsComposite.getVisible() || this.inaccessibleComponentsComposite.getVisible() || this.unresolvedPathsWarningComposite.getVisible());
    }

    private void showUnresolvedPathsWarning(boolean show) {
        GridData data = (GridData)this.unresolvedPathsWarningComposite.getLayoutData();
        data.exclude = !show;
        this.unresolvedPathsWarningComposite.setVisible(show);
        this.toasterComposite.setVisible(this.pagingWarningComposite.getVisible() || this.inaccessibleItemsComposite.getVisible() || this.inaccessibleComponentsComposite.getVisible() || this.unresolvedPathsWarningComposite.getVisible());
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        manager.add((IContributionItem)new Separator("additions"));
        final Menu menu = manager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                ISelection selection = ChangeSummaryView.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    MenuItem menuItem = ChangeSummaryView.this.getDefaultMenuItem(menu, (IStructuredSelection)selection);
                    if (menuItem != null && !menuItem.isEnabled()) {
                        menuItem = null;
                    }
                    menu.setDefaultItem(menuItem);
                }
            }
        });
        this.getViewSite().registerContextMenu(manager, (ISelectionProvider)this.viewer);
    }

    private MenuItem getDefaultMenuItem(Menu menu, IStructuredSelection selection) {
        if (selection == null || selection.size() != 1) {
            return null;
        }
        Object o = selection.getFirstElement();
        if (o instanceof CombinedChangeSetsItemEntry) {
            if (ExternalCompareToolUtils.shouldUseExternalCompareTool(selection)) {
                return MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.ui.changes.actions.OpenConflictInExternalCompareAction");
            }
            return MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.ide.ui.command.openCompareEditor");
        }
        return null;
    }

    private void createToolBarActions() {
        Action refreshAction = new Action(null, com.ibm.team.jface.internal.ImagePool.REFRESH){

            public void run() {
                ChangeSummaryView.this.refresh();
            }
        };
        refreshAction.setToolTipText(Messages.ChangeSummaryView_refresh);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)refreshAction);
        this.getViewSite().getActionBars().getToolBarManager().add((IContributionItem)new Separator());
        Action selectContextAction = new Action(null, ImagePool.SUMMARY_CHANGE_CONTEXT){

            public void run() {
                ChangeSummaryView.this.changeContext();
            }
        };
        selectContextAction.setToolTipText(Messages.ChangeSummaryView_selectContextAction);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)selectContextAction);
        Action collapseAllAction = new Action(null, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_COLLAPSEALL")){

            public void run() {
                ChangeSummaryView.this.viewer.collapseAll();
            }
        };
        collapseAllAction.setToolTipText(Messages.ChangeSummaryView_collapseAll);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)collapseAllAction);
        Action expandAllAction = new Action(null, com.ibm.team.jface.internal.ImagePool.EXPAND_ALL){

            public void run() {
                ChangeSummaryView.this.viewer.expandAll();
            }
        };
        expandAllAction.setToolTipText(Messages.ChangeSummaryView_expandAll);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)expandAllAction);
        this.getViewSite().getActionBars().getToolBarManager().add((IContributionItem)new Separator());
        this.backAction = new Action(null, com.ibm.team.repository.rcp.ui.internal.ImagePool.BACK){

            public void run() {
                ChangeSummaryView.this.open((Input)ChangeSummaryView.this.history.get(ChangeSummaryView.this.history.indexOf(ChangeSummaryView.this.currentInput) + 1));
            }
        };
        this.backAction.setMenuCreator(new IMenuCreator(){
            private Menu menu;

            public Menu getMenu(Menu parent) {
                return null;
            }

            public Menu getMenu(Control parent) {
                if (this.menu == null) {
                    this.menu = new Menu(parent);
                }
                MenuItem[] menuItemArray = this.menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.dispose();
                    ++n2;
                }
                int index = ChangeSummaryView.this.history.indexOf(ChangeSummaryView.this.currentInput);
                int i = index + 1;
                while (i < ChangeSummaryView.this.history.size()) {
                    ChangeSummaryView.this.createNavigationMenuItem(this.menu, (Input)ChangeSummaryView.this.history.get(i));
                    ++i;
                }
                return this.menu;
            }

            public void dispose() {
                if (this.menu != null) {
                    this.menu.dispose();
                    this.menu = null;
                }
            }
        });
        this.backAction.setToolTipText(Messages.ChangeSummaryView_back);
        this.backAction.setEnabled(false);
        this.forwardAction = new Action(null, com.ibm.team.repository.rcp.ui.internal.ImagePool.FORWARD){

            public void run() {
                ChangeSummaryView.this.open((Input)ChangeSummaryView.this.history.get(ChangeSummaryView.this.history.indexOf(ChangeSummaryView.this.currentInput) - 1));
            }
        };
        this.forwardAction.setMenuCreator(new IMenuCreator(){
            private Menu menu;

            public Menu getMenu(Menu parent) {
                return null;
            }

            public Menu getMenu(Control parent) {
                if (this.menu == null) {
                    this.menu = new Menu(parent);
                }
                MenuItem[] menuItemArray = this.menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.dispose();
                    ++n2;
                }
                int index = ChangeSummaryView.this.history.indexOf(ChangeSummaryView.this.currentInput);
                int i = index - 1;
                while (i >= 0) {
                    ChangeSummaryView.this.createNavigationMenuItem(this.menu, (Input)ChangeSummaryView.this.history.get(i));
                    --i;
                }
                return this.menu;
            }

            public void dispose() {
                if (this.menu != null) {
                    this.menu.dispose();
                    this.menu = null;
                }
            }
        });
        this.forwardAction.setToolTipText(Messages.ChangeSummaryView_forward);
        this.forwardAction.setEnabled(false);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.backAction);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.forwardAction);
        Action pinAction = new Action(null, 2){

            public void run() {
                ChangeSummaryView.this.pinned = !ChangeSummaryView.this.pinned;
            }
        };
        pinAction.setImageDescriptor(com.ibm.team.repository.rcp.ui.internal.ImagePool.PIN_VIEW);
        pinAction.setToolTipText(com.ibm.team.repository.rcp.ui.internal.Messages.AbstractViewWithInput_3);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)pinAction);
    }

    private void createMenuActions() {
        this.changeLogAction = new Action(Messages.StructuralChangesView_saveChangeLog, ImagePool.CREATE_CHANGELOG){

            public void run() {
                if (ChangeSummaryView.this.currentInput != null) {
                    ChangeSummaryView.this.runner.enqueue(Messages.StructuralChangesView_computingInputJobName, (Operation)new RepositoryOperation(ChangeSummaryView.this.currentInput.snapshotId.getRepository()){

                        public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                            ChangeSetInput input = new ChangeSetInput(ChangeSummaryView.this.currentInput.snapshotId, ChangeSummaryView.this.currentInput.changeSetHandles);
                            SnapshotSyncReport syncReport = ((StructuralChangesViewInput)input).computeSyncReport(true, null);
                            ChangeSummaryView.this.createChangeLog(input, syncReport);
                        }
                    });
                }
            }
        };
        this.detailsAction = new Action(Messages.ChangeSummaryView_showDetailsPaneAction, 2){

            public void run() {
                UiPlugin.getDefault().getPreferenceStore().setValue("PREF_CHANGE_SUMMARY_SHOW_DETAILS_PANE", ChangeSummaryView.this.detailsAction.isChecked());
            }
        };
        this.detailsAction.setChecked(UiPlugin.getDefault().getPreferenceStore().getBoolean("PREF_CHANGE_SUMMARY_SHOW_DETAILS_PANE"));
        this.getViewSite().getActionBars().getMenuManager().add((IAction)this.changeLogAction);
        this.getViewSite().getActionBars().getMenuManager().add((IAction)this.detailsAction);
    }

    private void createChangeLog(StructuralChangesViewInput input, SnapshotSyncReport syncReport) {
        Shell shell = this.getSite().getShell();
        final GenerateChangeLogRepositoryOperation operation = new GenerateChangeLogRepositoryOperation(input, this.currentInput.snapshotId, syncReport, FlowType.Outgoing, shell);
        shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ChangeSummaryView.this.parent.isDisposed() && operation.prompt()) {
                    ChangeSummaryView.this.runner.enqueue(Messages.CopyChangeLogDialog_SAVE_CHANGELOG_JOB_NAME, (Operation)operation);
                }
            }
        });
    }

    private void createNavigationMenuItem(Menu menu, final Input input) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText(input.label);
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ChangeSummaryView.this.open(input);
            }
        });
    }

    private void refresh() {
        if (this.currentInput != null && !this.refreshBoolean.get()) {
            this.refreshBoolean.set(true);
            final Input inputToRefresh = this.currentInput;
            RepositoryOperation refreshOperation = new RepositoryOperation(this.currentInput.snapshotId.getRepository()){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                    try {
                        Input input = ChangeSummaryView.consolidateChanges(ChangeSummaryView.this.currentInput.snapshotId.getRepository(), ChangeSummaryView.this.currentInput.snapshotId, ChangeSummaryView.this.currentInput.changeSetHandles, monitor, 2048);
                        inputToRefresh.snapshotId = input.snapshotId;
                        inputToRefresh.context = input.context;
                        inputToRefresh.changeSetHandles = input.changeSetHandles;
                        inputToRefresh.report = input.report;
                        inputToRefresh.output = input.output;
                        inputToRefresh.componentNamespaces = input.componentNamespaces;
                        inputToRefresh.inaccessibleItems = input.inaccessibleItems;
                        inputToRefresh.label = input.label;
                        ChangeSummaryView.openView(ChangeSummaryView.this, inputToRefresh, false);
                    }
                    finally {
                        ChangeSummaryView.this.refreshBoolean.set(false);
                    }
                }
            };
            this.runner.enqueue(Messages.ChangeSummaryView_aggregateOperationTitle, (Operation)refreshOperation);
        }
        this.updateEnablement();
    }

    public void openSelection(IStructuredSelection selection, boolean external) {
        this.aggregateChangesTree.openSelection(selection, external);
    }

    public StructuralChangesViewInput getStructuralChangesInput() {
        return new ChangeSetInput(this.currentInput.snapshotId, this.currentInput.changeSetHandles);
    }

    Input getInput() {
        return this.currentInput;
    }

    public ItemNamespace getItemNamespace(UUID itemId) {
        for (IConsolidatedChangesComponentReport report : this.currentInput.report.getReports()) {
            UUID componentId = report.getComponentId();
            if (report.getChangesReport(itemId) == null && !report.getParentFolderIds().contains(itemId) && !componentId.equals((Object)itemId)) continue;
            return (ItemNamespace)this.currentInput.componentNamespaces.get(componentId);
        }
        return null;
    }

    public IContextHandle getContext() {
        return this.currentInput.context;
    }

    public SnapshotId getSnapshotId() {
        return this.currentInput.snapshotId;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void open(Input input) {
        this.removeEarlyHistory(input);
        this.currentInput = input;
        this.updateEnablement();
        this.setContentDescription(this.currentInput.label);
        this.setInput();
        this.showPagingWarning(this.currentInput.report.getReports());
        this.showInaccessibleItemsWarning(this.currentInput.inaccessibleItems);
        this.showInaccessibleComponentsWarning(this.currentInput.report.getInaccessibleComponentCount());
        this.findUnresolvedPaths();
        this.parent.layout(true, true);
    }

    private void removeEarlyHistory(Input input) {
        if (!this.history.contains(input)) {
            int index = this.history.indexOf(this.currentInput);
            if (index > 0) {
                int i = index - 1;
                while (i >= 0) {
                    this.history.remove(i);
                    --i;
                }
            }
            this.history.add(0, input);
            if (this.history.size() > 10) {
                this.history.remove(10);
            }
        }
    }

    private void updateEnablement() {
        this.updateHistoryActionsEnablement();
        if (this.changeLogAction != null) {
            this.changeLogAction.setEnabled(this.currentInput != null);
        }
    }

    private void updateHistoryActionsEnablement() {
        if (this.backAction == null || this.forwardAction == null) {
            return;
        }
        if (this.history != null && this.history.size() >= 2) {
            int index = this.history.indexOf(this.currentInput);
            if (index == 0) {
                this.backAction.setEnabled(true);
                this.forwardAction.setEnabled(false);
            } else if (index == this.history.size() - 1) {
                this.backAction.setEnabled(false);
                this.forwardAction.setEnabled(true);
            } else {
                this.backAction.setEnabled(true);
                this.forwardAction.setEnabled(true);
            }
        } else {
            this.backAction.setEnabled(false);
            this.forwardAction.setEnabled(false);
        }
    }

    private void setInput() {
        Object[] expandedElements = this.viewer.getExpandedElements();
        this.aggregateChangesTree.setSnapshot(this.currentInput.snapshotId);
        this.aggregateChangesTree.show(this.currentInput.output, this.currentInput.report.getInaccessibleComponentCount());
        this.viewer.setExpandedElements(expandedElements);
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        this.aggregateChangesTree.getTreeViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        this.aggregateChangesTree.getTreeViewer().setSelection((ISelection)selection);
    }

    private void findUnresolvedPaths() {
        for (CombinedChangeSetsComponentEntry component : this.currentInput.output) {
            CombinedChangeSetsParentEntry[] combinedChangeSetsParentEntryArray = component.getParentEntries();
            int n = combinedChangeSetsParentEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                CombinedChangeSetsParentEntry parent = combinedChangeSetsParentEntryArray[n2];
                if (!parent.isPathInContext()) {
                    this.showUnresolvedPathsWarning(true);
                    return;
                }
                ++n2;
            }
        }
        this.showUnresolvedPathsWarning(false);
    }

    public static void open(SnapshotId snapshotId, List<? extends IChangeSetHandle> changeSets) {
        ChangeSummaryView.open(null, snapshotId, changeSets);
    }

    private static void open(ChangeSummaryView view, SnapshotId snapshotId, List<? extends IChangeSetHandle> changeSets) {
        ChangeSummaryView.open(view, snapshotId, changeSets, 2048);
    }

    public static void open(SnapshotId snapshotId, List<? extends IChangeSetHandle> changeSets, int pageSize) {
        ChangeSummaryView.schedule(null, snapshotId.getRepository(), snapshotId, changeSets, pageSize);
    }

    private static void open(ChangeSummaryView view, SnapshotId snapshotId, List<? extends IChangeSetHandle> changeSets, int pageSize) {
        ChangeSummaryView.schedule(view, snapshotId.getRepository(), snapshotId, changeSets, pageSize);
    }

    private static void schedule(final ChangeSummaryView view, final ITeamRepository repo, final SnapshotId snapshotId, final List<? extends IChangeSetHandle> changeSets, final int pageSize) {
        final int selectionSize = changeSets.size();
        if (selectionSize > 2048) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ChangeSummaryView.showFetchSizeExceededWarning(selectionSize);
                }
            });
            return;
        }
        JobRunner runner = new JobRunner(true);
        runner.enqueue(Messages.ChangeSummaryView_aggregateOperationTitle, (Operation)new RepositoryOperation(repo){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                Input input = ChangeSummaryView.consolidateChanges(repo, snapshotId, changeSets, monitor, pageSize);
                ChangeSummaryView.openView(view, input, true);
            }
        });
    }

    private static void showFetchSizeExceededWarning(int selectionSize) {
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        MessageDialog.openError((Shell)shell, (String)Messages.ChangeSummaryView_fetchSizeExceededErrorDialogTitle, (String)NLS.bind((String)Messages.ChangeSummaryView_fetchSizeExceededErrorDialogMessage, (Object)selectionSize, (Object)Integer.toString(2048)));
    }

    public static Input consolidateChanges(ITeamRepository repo, SnapshotId snapshotId, List<? extends IChangeSetHandle> changeSets, IProgressMonitor monitor, int pageSize) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        ISnapshot snapshot = snapshotId.getSnapshot((IProgressMonitor)subMonitor.newChild(1));
        IChangeSetHandle[] changeSetHandles = changeSets.toArray(new IChangeSetHandle[changeSets.size()]);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        IConsolidatedChangesReport report = workspaceManager.getConsolidatedChanges(changeSetHandles, IPagedFetchDescriptor.FACTORY.maxEntries(pageSize), (IProgressMonitor)subMonitor.newChild(8));
        Collection reports = report.getReports();
        IContextHandle context = ChangeSummaryView.getWorkspace(snapshotId);
        if (context == null) {
            ArrayList<IComponentHandle> components = new ArrayList<IComponentHandle>(reports.size());
            for (IConsolidatedChangesComponentReport changeSetsReport : reports) {
                if (changeSetsReport == null) continue;
                components.add((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(changeSetsReport.getComponentId(), null));
            }
            context = ComponentSyncUtil.getDefaultChangeSummaryContext((ITeamRepository)repo, components);
            if (context != null) {
                if (context instanceof IWorkspaceHandle) {
                    snapshotId = WorkspaceId.create((ITeamRepository)repo, (IWorkspaceHandle)((IWorkspaceHandle)context));
                } else if (context instanceof IBaselineHandle) {
                    snapshotId = BaselineId.create((ITeamRepository)repo, (IBaselineHandle)((IBaselineHandle)context));
                }
                snapshot = snapshotId.getSnapshot((IProgressMonitor)subMonitor.newChild(1));
            }
        }
        List<IConsolidatedChangeSetsPathReport> pathReports = null;
        if (context != null && (pathReports = ChangeSummaryView.calculateParentPaths(workspaceManager, context, reports, (IProgressMonitor)subMonitor.newChild(8))) == null) {
            context = null;
        }
        Map<UUID, ItemNamespace> componentNamespaces = ChangeSummaryView.createComponentNamespaces(snapshot, reports, (IProgressMonitor)subMonitor.newChild(1));
        List<CombinedChangeSetsComponentEntry> entries = ChangeSummaryView.parse(repo, reports, pathReports, (IProgressMonitor)subMonitor.newChild(1));
        String label = ChangeSummaryView.computeContentDescription(changeSets.size(), context == null ? null : snapshot.getName());
        long inaccessibleCount = 0L;
        for (IConsolidatedChangesComponentReport changeSetsReport : report.getReports()) {
            inaccessibleCount += changeSetsReport.getInaccessibleCount();
        }
        Input input = new Input();
        input.snapshotId = snapshotId;
        input.context = context;
        input.changeSetHandles = changeSets;
        input.report = report;
        input.output = entries;
        input.componentNamespaces = componentNamespaces;
        input.inaccessibleItems = inaccessibleCount;
        input.label = label;
        return input;
    }

    private static String computeContentDescription(int numChangeSets, String name) {
        if (numChangeSets == 1) {
            if (name == null) {
                return Messages.ChangeSummaryView_contentDescriptionUnknownContextSingular;
            }
            return NLS.bind((String)Messages.ChangeSummaryView_contentDescriptionKnownContextSingular, (Object)name);
        }
        if (name == null) {
            return NLS.bind((String)Messages.ChangeSummaryView_contentDescriptionUnknownContextPlural, (Object)numChangeSets);
        }
        return NLS.bind((String)Messages.ChangeSummaryView_contentDescriptionKnownContextPlural, (Object)numChangeSets, (Object)name);
    }

    private static Map<UUID, ItemNamespace> createComponentNamespaces(ISnapshot snapshot, Collection<IConsolidatedChangesComponentReport> reports, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)reports.size());
        HashMap<UUID, ItemNamespace> componentNamespaces = new HashMap<UUID, ItemNamespace>();
        for (IConsolidatedChangesComponentReport report : reports) {
            UUID componentId = report.getComponentId();
            IItemHandle component = IComponent.ITEM_TYPE.createItemHandle(componentId, null);
            ItemNamespace itemNamespace = snapshot.getNamespaceFor(ItemId.create((IItemHandle)component), (IProgressMonitor)subMonitor.newChild(1));
            componentNamespaces.put(componentId, itemNamespace);
        }
        return componentNamespaces;
    }

    private static IContextHandle getWorkspace(SnapshotId snapshotId) {
        if (snapshotId instanceof WorkspaceId) {
            return ((WorkspaceId)snapshotId).getWorkspaceHandle();
        }
        if (snapshotId instanceof NamespaceSetId) {
            Set namespaces = ((NamespaceSetId)snapshotId).getNamespaces();
            if (namespaces.size() == 1) {
                ItemNamespace namespace = (ItemNamespace)namespaces.iterator().next();
                if (namespace instanceof WorkspaceNamespace) {
                    return ((WorkspaceNamespace)namespace).getContextHandle();
                }
                if (namespace instanceof BaselineNamespace) {
                    return ((BaselineNamespace)namespace).getContextHandle();
                }
            }
        } else {
            if (snapshotId instanceof BaselineId) {
                return (IContextHandle)((BaselineId)snapshotId).getId().toHandle();
            }
            if (snapshotId instanceof HistoryReferenceId) {
                return ((HistoryReferenceId)snapshotId).getWorkspaceHandle();
            }
        }
        return null;
    }

    public static List<IConsolidatedChangeSetsPathReport> calculateParentPaths(IWorkspaceManager workspaceManager, IContextHandle context, Collection<IConsolidatedChangesComponentReport> reports, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)reports.size());
        ArrayList<IConsolidatedChangeSetsPathReport> pathReports = new ArrayList<IConsolidatedChangeSetsPathReport>(reports.size());
        for (IConsolidatedChangesComponentReport report : reports) {
            if (subMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            Collection parentIds = report.getParentFolderIds();
            ArrayList<IVersionableHandle> changedParents = new ArrayList<IVersionableHandle>(parentIds.size());
            for (UUID uuid : parentIds) {
                IConsolidatedItemChanges changesReport = report.getChangesReport(uuid);
                if (changesReport == null) continue;
                changedParents.add(changesReport.getVersionableHandle());
            }
            IChangeSetHandle[] changeSets = new IChangeSetHandle[report.getChangeSetIds().size()];
            Iterator iterator = report.getChangeSetIds().iterator();
            int j = 0;
            while (j < changeSets.length) {
                changeSets[j] = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((UUID)iterator.next(), null);
                ++j;
            }
            try {
                IConsolidatedChangeSetsPathReport pathReport = workspaceManager.calculateParentPaths(context, changeSets, parentIds.toArray(new UUID[parentIds.size()]), changedParents.toArray(new IVersionableHandle[changedParents.size()]), (IProgressMonitor)subMonitor.newChild(1));
                pathReports.add(pathReport);
            }
            catch (PermissionDeniedException e) {
                StatusManager manager = StatusManager.getManager();
                manager.handle((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", e.getMessage(), (Throwable)e), 1);
                return null;
            }
        }
        return pathReports;
    }

    private boolean isPinned() {
        return this.pinned;
    }

    private static void openView(final ChangeSummaryView source, final Input input, final boolean force) {
        WorkbenchJob job = new WorkbenchJob(PlatformUI.getWorkbench().getDisplay(), Messages.ChangeSummaryView_openViewOperationTitle){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    ChangeSummaryView view = ChangeSummaryView.showView(source, page, input);
                    if (force || input.equals(view.currentInput)) {
                        view.open(input);
                    }
                }
                catch (PartInitException e) {
                    IStatus status = e.getStatus();
                    return new Status(status.getSeverity(), "com.ibm.team.filesystem.ide.ui", status.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private static ChangeSummaryView showView(ChangeSummaryView source, IWorkbenchPage page, Input input) throws PartInitException {
        IViewReference[] candidates;
        IViewSite site;
        IViewReference reference;
        if (source != null && (reference = page.findViewReference((site = source.getViewSite()).getId(), site.getSecondaryId())) != null && reference.getPart(false) == source) {
            page.activate((IWorkbenchPart)source);
            return source;
        }
        IViewReference opened = null;
        IViewReference[] iViewReferenceArray = candidates = page.getViewReferences();
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                IViewReference candidate;
                block10: {
                    candidate = iViewReferenceArray[n2];
                    if (!VIEW_ID.equals(candidate.getId())) break block9;
                    ChangeSummaryView view = (ChangeSummaryView)candidate.getPart(false);
                    if (view == null) break block10;
                    if (input.equals(view.getInput())) {
                        page.activate((IWorkbenchPart)view);
                        return view;
                    }
                    if (view.isPinned()) break block9;
                    opened = candidate;
                }
                if (opened == null) {
                    opened = candidate;
                }
            }
            ++n2;
        }
        if (opened != null) {
            ChangeSummaryView view = (ChangeSummaryView)opened.getPart(true);
            page.activate((IWorkbenchPart)view);
            return view;
        }
        if (page.findView(VIEW_ID) == null) {
            return (ChangeSummaryView)page.showView(VIEW_ID);
        }
        return (ChangeSummaryView)page.showView(VIEW_ID, Long.toString(System.currentTimeMillis()), 1);
    }

    private static List<IConsolidatedChangeInfo> getSortedChanges(final IConsolidatedChangesComponentReport report, IConsolidatedItemChanges changesReport) {
        ArrayList changes = new ArrayList(changesReport.getChanges());
        Collections.sort(changes, new Comparator<IConsolidatedChangeInfo>(){

            @Override
            public int compare(IConsolidatedChangeInfo object1, IConsolidatedChangeInfo object2) {
                return report.getChangeSetInfo(object1.getChangeSetId()).getLastChangeDate().compareTo(report.getChangeSetInfo(object2.getChangeSetId()).getLastChangeDate());
            }
        });
        return Collections.unmodifiableList(changes);
    }

    private static CombinedChangeSetsItemEntry createItemEntry(IConsolidatedChangesComponentReport report, IConsolidatedItemChanges changesReport, List<IConsolidatedChangeInfo> changes, Map<UUID, CombinedChangeSetsParentEntry> parentEntries, CombinedChangeSetsParentEntry parent) {
        CombinedChangeSetsItemEntry itemEntry = new CombinedChangeSetsItemEntry(parent, changesReport);
        for (IConsolidatedChangeInfo change : changes) {
            itemEntry.addReviewEntry(ChangeSummaryView.createReviewEntry(report.getChangeSetInfo(change.getChangeSetId()), itemEntry.getVersionableHandle(), change));
        }
        if (changesReport.getParents().isEmpty()) {
            boolean isFolder = IFolder.ITEM_TYPE.equals(changesReport.getVersionableHandle().getItemType());
            if (isFolder && changesReport.getUniqueEndingStateId() != null) {
                itemEntry.setName(Messages.ChangeSummaryView_componentRootFolderLabel);
            } else {
                itemEntry.setFallbackName(Messages.ChangeSummaryView_unknownFileLabel);
                itemEntry.setPath(Messages.ChangeSummaryView_unresolvedParentFolderLabel);
                itemEntry.setSourcePath(Messages.ChangeSummaryView_unresolvedParentFolderLabel);
            }
        } else {
            ChangeSummaryView.setItemName(changesReport, changes, itemEntry);
            ChangeSummaryView.setItemParent(changesReport, parentEntries, itemEntry);
            if (ChangeSummaryView.considerMovesAndRenames(changesReport)) {
                for (IConsolidatedChangeInfo change : changes) {
                    if (!ChangeSummaryView.isRename(change.getKind())) continue;
                    itemEntry.setName((String)changesReport.getNames().get(changesReport.getFinalNameIndex()));
                    itemEntry.setSourceName((String)changesReport.getNames().get(change.getBeforeState().getNameIndex()));
                    break;
                }
                for (IConsolidatedChangeInfo change : changes) {
                    if (!ChangeSummaryView.isReparent(change.getKind())) continue;
                    UUID parentId = (UUID)changesReport.getParents().get(changesReport.getFinalParentIndex());
                    itemEntry.setPath(parentEntries.get(parentId).getPath());
                    itemEntry.setPathUUID(parentId);
                    UUID sourceParentId = (UUID)changesReport.getParents().get(change.getBeforeState().getParentIndex());
                    itemEntry.setSourcePath(parentEntries.get(sourceParentId).getPath());
                    itemEntry.setSourcePathUUID(sourceParentId);
                    break;
                }
            }
        }
        return itemEntry;
    }

    private static boolean isRename(int kind) {
        return (kind & 4) != 0;
    }

    private static boolean isReparent(int kind) {
        return (kind & 8) != 0;
    }

    private static CombinedChangeSetsItemReviewEntry createReviewEntry(IConsolidatedChangeSetInfo changeSetInfo, IVersionableHandle versionable, IConsolidatedChangeInfo change) {
        CombinedChangeSetsItemReviewEntry review = new CombinedChangeSetsItemReviewEntry(versionable, change, changeSetInfo);
        for (IConsolidatedStateInfo state : change.getMergeStates()) {
            UUID stateId = state.getStateId();
            review.addMerge(stateId == null ? null : ChangeSummaryView.createVersionableHandle(versionable, stateId));
        }
        return review;
    }

    private static IVersionableHandle createVersionableHandle(IVersionableHandle versionableHandle, UUID stateId) {
        return (IVersionableHandle)versionableHandle.getItemType().createItemHandle(versionableHandle.getOrigin(), versionableHandle.getItemId(), stateId);
    }

    private static int calculateParentIndex(IConsolidatedItemChanges changesReport) {
        int index = changesReport.getFinalParentIndex();
        return index == -1 ? changesReport.getInitialParentIndex() : index;
    }

    private static void setItemParent(IConsolidatedItemChanges changesReport, Map<UUID, CombinedChangeSetsParentEntry> parentEntries, CombinedChangeSetsItemEntry itemEntry) {
        int parentIndex;
        List parents = changesReport.getParents();
        int n = parentIndex = parents.size() == 1 ? 0 : ChangeSummaryView.calculateParentIndex(changesReport);
        if (parentIndex != -1) {
            UUID parentUUID = (UUID)parents.get(parentIndex);
            itemEntry.setPath(parentEntries.get(parentUUID).getPath());
            itemEntry.setSourcePath(itemEntry.getPath());
            itemEntry.setPathUUID(parentUUID);
            itemEntry.setSourcePathUUID(itemEntry.getPathUUID());
        }
    }

    private static int calculateNameIndex(IConsolidatedItemChanges changesReport) {
        int index = changesReport.getInitialNameIndex();
        return index == -1 ? changesReport.getFinalNameIndex() : index;
    }

    private static void setItemName(IConsolidatedItemChanges changesReport, List<IConsolidatedChangeInfo> changeInfos, CombinedChangeSetsItemEntry itemEntry) {
        int nameIndex = ChangeSummaryView.calculateNameIndex(changesReport);
        List names = changesReport.getNames();
        if (nameIndex == -1) {
            if (names.size() == 1) {
                itemEntry.setName((String)names.get(0));
                itemEntry.setSourceName(itemEntry.getName());
            } else {
                String finalName = ChangeSummaryView.getLastName(changesReport, changeInfos);
                if (changesReport.isSingleLineOfDescent()) {
                    itemEntry.setName(finalName);
                    itemEntry.setSourceName(itemEntry.getName());
                } else {
                    itemEntry.setFallbackName(finalName);
                }
            }
        } else {
            itemEntry.setName((String)names.get(nameIndex));
            itemEntry.setSourceName(itemEntry.getName());
        }
    }

    private static String getLastName(IConsolidatedItemChanges changesReport, List<IConsolidatedChangeInfo> changeInfos) {
        IConsolidatedStateInfo finalState = ChangeSummaryView.getFinalState(changeInfos);
        return finalState == null ? Messages.ChangeSummaryView_unknownFileLabel : (String)changesReport.getNames().get(finalState.getNameIndex());
    }

    private static IConsolidatedStateInfo getFinalState(List<IConsolidatedChangeInfo> changeInfos) {
        IConsolidatedChangeInfo changeInfo = changeInfos.get(changeInfos.size() - 1);
        IConsolidatedStateInfo afterState = changeInfo.getAfterState();
        if (afterState == null) {
            IConsolidatedStateInfo beforeState = changeInfo.getBeforeState();
            if (beforeState == null) {
                List mergeStates = changeInfo.getMergeStates();
                int i = mergeStates.size() - 1;
                while (i >= 0) {
                    IConsolidatedStateInfo mergeState = (IConsolidatedStateInfo)mergeStates.get(i);
                    if (mergeState.getStateId() != null) {
                        return mergeState;
                    }
                    --i;
                }
                return null;
            }
            return beforeState;
        }
        return afterState;
    }

    private static boolean considerMovesAndRenames(IConsolidatedItemChanges report) {
        return report.isSingleLineOfDescent() && report.getUniqueStartingStateId() != null && report.getUniqueEndingStateId() != null;
    }

    public static List<CombinedChangeSetsComponentEntry> parse(ITeamRepository repo, Collection<IConsolidatedChangesComponentReport> reports, List<IConsolidatedChangeSetsPathReport> pathReports, IProgressMonitor monitor) {
        ArrayList<CombinedChangeSetsComponentEntry> componentEntries = new ArrayList<CombinedChangeSetsComponentEntry>();
        for (IConsolidatedChangesComponentReport report : reports) {
            UUID componentId = report.getComponentId();
            IConsolidatedChangeSetsPathReport matchingPathReport = null;
            if (pathReports != null) {
                for (IConsolidatedChangeSetsPathReport pathReport : pathReports) {
                    if (!pathReport.getComponentId().equals((Object)componentId)) continue;
                    matchingPathReport = pathReport;
                    break;
                }
            }
            CombinedChangeSetsComponentEntry componentEntry = new CombinedChangeSetsComponentEntry(componentId, report.getComponentName(), report.getInaccessibleCount());
            List<CombinedChangeSetsParentEntry> parentEntries = ChangeSummaryView.parse(componentEntry, report, matchingPathReport);
            try {
                List<CombinedSubcomponentChangeEntry> subcomponentEntries = ChangeSummaryView.computeSubcomponentChangeEntries(report, parentEntries, repo, monitor);
                if (subcomponentEntries != null) {
                    componentEntry.addAllSubcomponentChangeEntries(subcomponentEntries);
                }
            }
            catch (IOException e) {
                StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (Throwable)e);
            }
            catch (TeamRepositoryException e) {
                StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (Throwable)e);
            }
            componentEntry.addAllParentEntries(parentEntries);
            componentEntries.add(componentEntry);
        }
        Collections.sort(componentEntries, new Comparator<CombinedChangeSetsComponentEntry>(){

            @Override
            public int compare(CombinedChangeSetsComponentEntry entry1, CombinedChangeSetsComponentEntry entry2) {
                return entry1.getComponentName().compareTo(entry2.getComponentName());
            }
        });
        return componentEntries;
    }

    private static IFileItemHandle makeFileHandle(UUID itemId, UUID stateId) {
        FileItemHandle fileHandle = FilesystemFactory.eINSTANCE.createFileItemHandle();
        fileHandle.setStateId(stateId);
        fileHandle.setItemId(itemId);
        return fileHandle;
    }

    public static List<String> extractComponentItemIds(ITeamRepository repo, IFileItemHandle fileHandle, IProgressMonitor monitor) throws IOException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        DisposableInputStreamProvider inputStream = null;
        try {
            IFileItem fileItem = (IFileItem)SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState((IVersionableHandle)fileHandle, (IProgressMonitor)progress.newChild(30));
            if (fileItem != null) {
                inputStream = TemporaryOutputStream.createLocalBuffer((IInputStreamProvider)new FileContentInputStreamProvider(repo, (IFileItemHandle)fileItem, fileItem.getContent()), (IProgressMonitor)progress.newChild(30));
                List list = SubComponentUtil.extractComponentItemIds((DisposableInputStreamProvider)inputStream, (IProgressMonitor)progress.newChild(40));
                return list;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.dispose();
                }
                catch (Exception exception) {}
            }
            progress.done();
        }
        return new ArrayList<String>();
    }

    private static List<String> removeComponentIdsOfSecondListFromFirstList(List<String> first, List<String> second) {
        ArrayList<String> diffOfCompIds = null;
        if (first != null) {
            diffOfCompIds = new ArrayList<String>(first);
            if (second != null) {
                diffOfCompIds.removeAll(second);
            }
        }
        return diffOfCompIds;
    }

    public static void getSubComponentInfo(ITeamRepository repo, UUID fileItemId, UUID oldStateId, UUID newStateId, List<String> subComponentsAdded, List<String> subComponentsRemoved, IProgressMonitor monitor) throws IOException, TeamRepositoryException {
        List<String> subCompRemoved;
        List<String> afterSubCompIds;
        ArrayList<String> beforeSubCompIds;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (oldStateId != null) {
            IFileItemHandle oldFile = ChangeSummaryView.makeFileHandle(fileItemId, oldStateId);
            beforeSubCompIds = ChangeSummaryView.extractComponentItemIds(repo, oldFile, (IProgressMonitor)progress.newChild(50));
        } else {
            beforeSubCompIds = new ArrayList();
        }
        if (newStateId != null) {
            IFileItemHandle newFile = ChangeSummaryView.makeFileHandle(fileItemId, newStateId);
            afterSubCompIds = ChangeSummaryView.extractComponentItemIds(repo, newFile, (IProgressMonitor)progress.newChild(50));
        } else {
            afterSubCompIds = new ArrayList<String>();
        }
        List<String> subCompAdded = ChangeSummaryView.removeComponentIdsOfSecondListFromFirstList(afterSubCompIds, beforeSubCompIds);
        if (subCompAdded != null) {
            subComponentsAdded.addAll(subCompAdded);
        }
        if ((subCompRemoved = ChangeSummaryView.removeComponentIdsOfSecondListFromFirstList(beforeSubCompIds, afterSubCompIds)) != null) {
            subComponentsRemoved.addAll(subCompRemoved);
        }
    }

    private static Map<UUID, IComponentHandle> getComponentHandles(ITeamRepository repo, List<String> componentItemIds) {
        HashMap<UUID, IComponentHandle> result = new HashMap<UUID, IComponentHandle>();
        for (String componentItemId : componentItemIds) {
            try {
                UUID uuid = UUID.valueOf((String)componentItemId);
                result.put(uuid, (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, uuid, null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private static List<CombinedSubcomponentChangeEntry> computeSubcomponentChangeEntries(IConsolidatedChangesComponentReport report, List<CombinedChangeSetsParentEntry> parentEntries, ITeamRepository repo, IProgressMonitor monitor) throws IOException, TeamRepositoryException {
        ArrayList<CombinedSubcomponentChangeEntry> entries = new ArrayList<CombinedSubcomponentChangeEntry>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        block2: for (CombinedChangeSetsParentEntry parentEntry : parentEntries) {
            CombinedChangeSetsItemEntry[] combinedChangeSetsItemEntryArray = parentEntry.getItemEntries();
            int n = combinedChangeSetsItemEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                CombinedChangeSetsItemEntry itemEntry = combinedChangeSetsItemEntryArray[n2];
                if (itemEntry != null && ".subcomponent_info".equals(itemEntry.getName())) {
                    IComponent component;
                    if (!itemEntry.isComparable()) break block2;
                    ArrayList<String> subComponentsAddedIds = new ArrayList<String>();
                    ArrayList<String> subComponentsRemovedIds = new ArrayList<String>();
                    UUID initialState = itemEntry.getEstimatedInitialState();
                    UUID finalState = itemEntry.getEstimatedFinalState();
                    ChangeSummaryView.getSubComponentInfo(repo, itemEntry.getItemId(), initialState, finalState, subComponentsAddedIds, subComponentsRemovedIds, (IProgressMonitor)progress.newChild(50));
                    Map<UUID, IComponentHandle> subCompsAdded = ChangeSummaryView.getComponentHandles(repo, subComponentsAddedIds);
                    Map<UUID, IComponentHandle> subCompsRemoved = ChangeSummaryView.getComponentHandles(repo, subComponentsRemovedIds);
                    HashMap<UUID, IComponent> fetchedComponents = new HashMap<UUID, IComponent>();
                    ArrayList<IComponentHandle> handlesToFetch = new ArrayList<IComponentHandle>();
                    handlesToFetch.addAll(subCompsAdded.values());
                    handlesToFetch.addAll(subCompsRemoved.values());
                    try {
                        IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(handlesToFetch, 0, (IProgressMonitor)progress.newChild(50));
                        for (Map.Entry<Object, Object> entry : fetchResult.getRetrievedItems()) {
                            if (!(entry instanceof IComponent)) continue;
                            component = (IComponent)entry;
                            fetchedComponents.put(component.getItemId(), component);
                        }
                    }
                    catch (TeamRepositoryException fetchResult) {
                        // empty catch block
                    }
                    CombinedSubcomponentChangeEntry.ChangeType changeType = CombinedSubcomponentChangeEntry.ChangeType.Addition;
                    for (Map.Entry<Object, Object> entry : subCompsAdded.entrySet()) {
                        component = (IComponent)fetchedComponents.get(entry.getKey());
                        entries.add(new CombinedSubcomponentChangeEntry(repo, (IComponentHandle)entry.getValue(), component, changeType, itemEntry));
                    }
                    changeType = CombinedSubcomponentChangeEntry.ChangeType.Removal;
                    for (Map.Entry<Object, Object> entry : subCompsRemoved.entrySet()) {
                        component = (IComponent)fetchedComponents.get(entry.getKey());
                        entries.add(new CombinedSubcomponentChangeEntry(repo, (IComponentHandle)entry.getValue(), component, changeType, itemEntry));
                    }
                    break block2;
                }
                ++n2;
            }
        }
        Collections.sort(entries, new Comparator<CombinedSubcomponentChangeEntry>(){

            @Override
            public int compare(CombinedSubcomponentChangeEntry o1, CombinedSubcomponentChangeEntry o2) {
                if (!o1.getChangeType().equals((Object)o2.getChangeType())) {
                    if (o1.getChangeType().equals((Object)CombinedSubcomponentChangeEntry.ChangeType.Addition)) {
                        return -1;
                    }
                    return 1;
                }
                if (o1.getComponent() != null && o2.getComponent() != null) {
                    return o1.getComponent().getName().compareToIgnoreCase(o2.getComponent().getName());
                }
                if (o1.getComponent() != null) {
                    return -1;
                }
                if (o2.getComponent() != null) {
                    return 1;
                }
                return o1.getComponentHandle().getItemId().compareTo((Object)o2.getComponentHandle().getItemId());
            }
        });
        return entries;
    }

    private static List<CombinedChangeSetsParentEntry> parse(CombinedChangeSetsComponentEntry component, IConsolidatedChangesComponentReport report, IConsolidatedChangeSetsPathReport pathReport) {
        final CombinedChangeSetsParentEntry unresolvedParentEntry = new CombinedChangeSetsParentEntry(component, Messages.ChangeSummaryView_unresolvedParentFolderLabel, true);
        HashMap<UUID, CombinedChangeSetsParentEntry> result = new HashMap<UUID, CombinedChangeSetsParentEntry>();
        for (UUID parentId : report.getParentFolderIds()) {
            result.put(parentId, ChangeSummaryView.createParentEntry(component, pathReport, parentId));
        }
        for (UUID changedItemId : report.getVersionableIds()) {
            List<IConsolidatedChangeInfo> changes;
            IConsolidatedItemChanges changesReport = report.getChangesReport(changedItemId);
            CombinedChangeSetsParentEntry parentEntry = ChangeSummaryView.getParentEntry(result, changesReport, changes = ChangeSummaryView.getSortedChanges(report, changesReport));
            if (parentEntry == null) {
                parentEntry = unresolvedParentEntry;
            }
            parentEntry.addItemEntry(ChangeSummaryView.createItemEntry(report, changesReport, changes, result, unresolvedParentEntry));
        }
        result.put(null, unresolvedParentEntry);
        Iterator it = result.entrySet().iterator();
        while (it.hasNext()) {
            if (((CombinedChangeSetsParentEntry)it.next().getValue()).getItemEntries().length != 0) continue;
            it.remove();
        }
        ArrayList<CombinedChangeSetsParentEntry> parentEntries = new ArrayList<CombinedChangeSetsParentEntry>(result.values());
        Collections.sort(parentEntries, new Comparator<CombinedChangeSetsParentEntry>(){

            @Override
            public int compare(CombinedChangeSetsParentEntry e1, CombinedChangeSetsParentEntry e2) {
                String p1 = e1.getPath();
                String p2 = e2.getPath();
                if (unresolvedParentEntry == e1) {
                    return -1;
                }
                if (unresolvedParentEntry == e2) {
                    return 1;
                }
                if (Messages.ChangeSummaryView_unresolvedParentFolderLabel.equals(p1)) {
                    return -1;
                }
                if (Messages.ChangeSummaryView_unresolvedParentFolderLabel.equals(p2)) {
                    return 1;
                }
                return p1.compareTo(p2);
            }
        });
        for (CombinedChangeSetsParentEntry e : parentEntries) {
            e.sort();
        }
        return parentEntries;
    }

    private static CombinedChangeSetsParentEntry createParentEntry(CombinedChangeSetsComponentEntry component, IConsolidatedChangeSetsPathReport pathReport, UUID parentId) {
        if (pathReport == null) {
            CombinedChangeSetsParentEntry parentEntry = new CombinedChangeSetsParentEntry(component, Messages.ChangeSummaryView_unresolvedParentFolderLabel, false);
            parentEntry.setFolderItemId(parentId);
            return parentEntry;
        }
        IConsolidatedParentPathInfo parentPathInfo = pathReport.getParentInfo(parentId);
        List possiblePaths = parentPathInfo.getPossiblePaths();
        int bestPathIndex = parentPathInfo.getBestPathIndex();
        if (possiblePaths.size() == 0 || bestPathIndex == -1) {
            CombinedChangeSetsParentEntry parentEntry = new CombinedChangeSetsParentEntry(component, Messages.ChangeSummaryView_unresolvedParentFolderLabel, parentPathInfo.isPathInContext());
            parentEntry.setFolderItemId(parentId);
            return parentEntry;
        }
        String path = (String)possiblePaths.get(bestPathIndex);
        if (path.length() != 1) {
            path = path.substring(1);
        }
        CombinedChangeSetsParentEntry parentEntry = new CombinedChangeSetsParentEntry(component, path, parentPathInfo.isPathInContext());
        parentEntry.setFolderItemId(parentId);
        return parentEntry;
    }

    private static CombinedChangeSetsParentEntry getParentEntry(Map<UUID, CombinedChangeSetsParentEntry> result, IConsolidatedItemChanges changesReport, List<IConsolidatedChangeInfo> changeInfos) {
        List parents = changesReport.getParents();
        switch (parents.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return result.get(parents.get(0));
            }
        }
        int index = ChangeSummaryView.calculateParentIndex(changesReport);
        if (index == -1) {
            UUID lastParent = ChangeSummaryView.getLastParent(changesReport, changeInfos);
            return lastParent == null ? null : result.get(lastParent);
        }
        return result.get(parents.get(index));
    }

    private static UUID getLastParent(IConsolidatedItemChanges changesReport, List<IConsolidatedChangeInfo> changeInfos) {
        IConsolidatedStateInfo finalState = ChangeSummaryView.getFinalState(changeInfos);
        return finalState == null ? null : (UUID)changesReport.getParents().get(finalState.getParentIndex());
    }

    public static class Input {
        private List<? extends IChangeSetHandle> changeSetHandles;
        private IConsolidatedChangesReport report;
        private SnapshotId snapshotId;
        private IContextHandle context;
        private Map<UUID, ItemNamespace> componentNamespaces;
        private List<CombinedChangeSetsComponentEntry> output;
        private String label;
        private long inaccessibleItems;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.changeSetHandles == null ? 0 : this.changeSetHandles.hashCode());
            result = 31 * result + (this.snapshotId == null ? 0 : this.snapshotId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Input other = (Input)obj;
            if (this.snapshotId == null) {
                if (other.snapshotId != null) {
                    return false;
                }
            } else {
                if (!this.snapshotId.equals(other.snapshotId)) {
                    return false;
                }
                if (this.changeSetHandles.size() != other.changeSetHandles.size()) {
                    return false;
                }
            }
            for (IChangeSetHandle iChangeSetHandle : this.changeSetHandles) {
                boolean found = false;
                for (IChangeSetHandle iChangeSetHandle2 : other.changeSetHandles) {
                    if (!iChangeSetHandle.sameItemId((IItemHandle)iChangeSetHandle2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
    }
}

