/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.ce;

import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.rcp.ui.internal.RcpUiPlugin;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsComponentEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsItemEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsParentEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedSubcomponentChangeEntry;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.dto.IVersionableIdentifier;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;

public class ChangeSummaryLabelProvider
extends BaseLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private Map<ImageDescriptor, Image> fileImages = new HashMap<ImageDescriptor, Image>();
    private Map<DecorationOverlayIcon, Image> decoratedImages = new HashMap<DecorationOverlayIcon, Image>();
    private StyledString.Styler versionsStyler = StyledString.createColorRegistryStyler((String)"DECORATIONS_COLOR", null);
    private StyledString.Styler conflictsStyler = StyledString.createColorRegistryStyler((String)"com.ibm.team.internal.filesystem.ui.ColorDefinitions.PENDING_CHANGES_CONFLICT_DESCRIPTION_COLOR", null);
    private StyledString.Styler inaccessibleComponentStyler = StyledString.createColorRegistryStyler((String)"com.ibm.team.internal.filesystem.ui.ColorDefinitions.COMPONENT_HIERARCHY_MISSING_COMPONENT", null);
    private Image componentImage = ImagePool.COMPONENT.createImage();
    private Image fileImage = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE").createImage();
    private Image folderImage = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER").createImage();
    private Image symlinkImage = ImagePool.SYMBOLIC_LINK.createImage();

    public StyledString getStyledText(Object element) {
        if (element instanceof CombinedChangeSetsItemEntry) {
            CombinedChangeSetsItemEntry entry = (CombinedChangeSetsItemEntry)element;
            String versionIdString = this.getVersionDisplayString(entry);
            if (!entry.isComparable()) {
                String text = this.getText(element);
                int changeSetCount = entry.getReviewEntries().length;
                String disjointText = NLS.bind((String)Messages.AggregateChangesTree_disjointChangesDecorator, (Object)Integer.toString(changeSetCount));
                String displayText = NLS.bind((String)Messages.AggregateChangesTree_disjointChangesText, (Object)text, (Object)disjointText);
                int startIndex = displayText.indexOf(disjointText);
                StyledString string = new StyledString();
                string.append(displayText.substring(0, startIndex));
                string.append(displayText.substring(startIndex, startIndex + disjointText.length()), this.conflictsStyler);
                string.append(displayText.substring(startIndex + disjointText.length()));
                return string;
            }
            if (entry.isMerge() && entry.getReviewEntries().length > 1) {
                String mergeText = entry.getMergeCount() == 1 ? Messages.ChangeSummaryLabelProvider_1 : NLS.bind((String)Messages.ChangeSummaryLabelProvider_0, (Object)Integer.toString(entry.getMergeCount()));
                if (versionIdString != null) {
                    mergeText = NLS.bind((String)Messages.AggregateChangesTree_disjointChangesText, (Object)versionIdString, (Object)mergeText);
                }
                String text = this.getText(element);
                String displayText = NLS.bind((String)Messages.AggregateChangesTree_disjointChangesText, (Object)text, (Object)mergeText);
                int mergeTextStart = displayText.indexOf(mergeText);
                StyledString string = new StyledString();
                string.append(displayText.substring(0, mergeTextStart));
                string.append(displayText.substring(mergeTextStart, mergeTextStart + mergeText.length()), this.conflictsStyler);
                string.append(displayText.substring(mergeTextStart + mergeText.length()));
                return string;
            }
            if (versionIdString != null) {
                return this.getStyledString(entry, versionIdString);
            }
            return new StyledString(this.getText(element));
        }
        if (element instanceof CombinedChangeSetsComponentEntry) {
            String text = this.getText(element);
            long inaccessibleCount = ((CombinedChangeSetsComponentEntry)element).getInaccessibleCount();
            if (inaccessibleCount > 0L) {
                String inaccessibleText = inaccessibleCount > 1L ? NLS.bind((String)Messages.AggregateChangesTree_inaccessibleChangesPlural, (Object)Long.toString(inaccessibleCount)) : NLS.bind((String)Messages.AggregateChangesTree_inaccessibleChangesSingular, (Object)Long.toString(inaccessibleCount));
                String displayText = NLS.bind((String)Messages.AggregateChangesTree_inaccessibleChangesText, (Object)text, (Object)inaccessibleText);
                int startIndex = displayText.indexOf(inaccessibleText);
                StyledString string = new StyledString();
                string.append(displayText.substring(0, startIndex));
                string.append(displayText.substring(startIndex, startIndex + inaccessibleText.length()), this.conflictsStyler);
                string.append(displayText.substring(startIndex + inaccessibleText.length()));
                return string;
            }
            return new StyledString(text);
        }
        if (element instanceof CombinedSubcomponentChangeEntry) {
            CombinedSubcomponentChangeEntry entry = (CombinedSubcomponentChangeEntry)element;
            String text = this.getText(element);
            if (entry.getComponent() == null) {
                StyledString string = new StyledString();
                string.append(text, this.inaccessibleComponentStyler);
                return string;
            }
            return new StyledString(text);
        }
        return new StyledString(this.getText(element));
    }

    private DecorationOverlayIcon createDecorationOverlayIcon(Image baseImage, ImageDescriptor overlay) {
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
        imageDescriptorArray[3] = overlay;
        return new DecorationOverlayIcon(baseImage, imageDescriptorArray, new Point(25, 16));
    }

    private Image getDecoratedImage(Image baseImage, ImageDescriptor overlay) {
        DecorationOverlayIcon icon = this.createDecorationOverlayIcon(baseImage, overlay);
        Image image = this.decoratedImages.get(icon);
        if (image == null) {
            image = icon.createImage();
            this.decoratedImages.put(icon, image);
        }
        return image;
    }

    public Image getImage(Object element) {
        if (element instanceof CombinedChangeSetsComponentEntry) {
            return this.componentImage;
        }
        if (element instanceof CombinedChangeSetsParentEntry) {
            return this.folderImage;
        }
        if (element instanceof CombinedChangeSetsItemEntry) {
            CombinedChangeSetsItemEntry entry = (CombinedChangeSetsItemEntry)element;
            Image baseImage = this.getBaseImage(entry);
            if (!entry.isComparable()) {
                return this.getDecoratedImage(baseImage, ImagePool.AGGREGATE_CHANGE_DISJOINT_OVR);
            }
            if (entry.getEstimatedFinalState() == null) {
                return this.getDecoratedImage(baseImage, ImagePool.AGGREGATE_CHANGE_DEL_OVR);
            }
            if (entry.getEstimatedInitialState() == null) {
                return this.getDecoratedImage(baseImage, ImagePool.AGGREGATE_CHANGE_ADD_OVR);
            }
            return baseImage;
        }
        if (element instanceof CombinedSubcomponentChangeEntry) {
            CombinedSubcomponentChangeEntry entry = (CombinedSubcomponentChangeEntry)element;
            if (entry.getChangeType() == CombinedSubcomponentChangeEntry.ChangeType.Addition) {
                return this.getDecoratedImage(this.componentImage, ImagePool.OUTGOING_ADD_OVRL);
            }
            if (entry.getChangeType() == CombinedSubcomponentChangeEntry.ChangeType.Removal) {
                return this.getDecoratedImage(this.componentImage, ImagePool.OUTGOING_DEL_OVRL);
            }
            return this.componentImage;
        }
        return null;
    }

    private Image getBaseImage(CombinedChangeSetsItemEntry entry) {
        if (entry.getVersionableHandle() instanceof IFolderHandle) {
            return this.folderImage;
        }
        if (entry.getVersionableHandle() instanceof ISymbolicLinkHandle) {
            return this.symlinkImage;
        }
        if (entry.getName() != null) {
            ImageDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(entry.getName());
            Image image = this.fileImages.get(descriptor);
            if (image == null) {
                image = descriptor.createImage();
                this.fileImages.put(descriptor, image);
            }
            return image;
        }
        return this.fileImage;
    }

    public void dispose() {
        super.dispose();
        for (Image image : this.fileImages.values()) {
            image.dispose();
        }
        this.fileImages.clear();
        for (Image image : this.decoratedImages.values()) {
            image.dispose();
        }
        this.decoratedImages.clear();
        this.componentImage.dispose();
        this.fileImage.dispose();
        this.folderImage.dispose();
        this.symlinkImage.dispose();
    }

    private String getText(Object element) {
        if (element instanceof CombinedChangeSetsComponentEntry) {
            return ((CombinedChangeSetsComponentEntry)element).getComponentName();
        }
        if (element instanceof CombinedChangeSetsParentEntry) {
            return ((CombinedChangeSetsParentEntry)element).getPath();
        }
        if (element instanceof CombinedChangeSetsItemEntry) {
            CombinedChangeSetsItemEntry item = (CombinedChangeSetsItemEntry)element;
            String name = item.getName();
            if (name == null) {
                name = item.getFallbackName();
            }
            return this.applyTextDecoration(item, name);
        }
        if (element instanceof CombinedSubcomponentChangeEntry) {
            return this.getText((CombinedSubcomponentChangeEntry)element);
        }
        return element.toString();
    }

    private String getText(CombinedSubcomponentChangeEntry entry) {
        IComponent component = entry.getComponent();
        String text = component != null ? component.getName() : NLS.bind((String)Messages.AggregateChangesTree_inaccessibleSubcomponent, (Object)entry.getComponentHandle().getItemId().getUuidValue());
        if (entry.getChangeType() == CombinedSubcomponentChangeEntry.ChangeType.Addition) {
            text = NLS.bind((String)Messages.AggregateChangesTree_subcomponentAddedDecorator, (Object)text);
        } else if (entry.getChangeType() == CombinedSubcomponentChangeEntry.ChangeType.Removal) {
            text = NLS.bind((String)Messages.AggregateChangesTree_subcomponentRemovedDecorator, (Object)text);
        }
        return text;
    }

    private String applyTextDecoration(CombinedChangeSetsItemEntry item, String string) {
        if (item.getPath() == null || item.getName() == null) {
            return string;
        }
        if (!item.getName().equals(item.getSourceName())) {
            if (!item.getPathUUID().equals((Object)item.getSourcePathUUID())) {
                return NLS.bind((String)Messages.AggregateChangesTree_movedRenamedFromLabel, (Object[])new Object[]{string, item.getSourcePath(), item.getSourceName()});
            }
            return NLS.bind((String)Messages.AggregateChangesTree_renamedFromLabel, (Object)string, (Object)item.getSourceName());
        }
        if (!item.getPathUUID().equals((Object)item.getSourcePathUUID())) {
            return NLS.bind((String)Messages.AggregateChangesTree_movedFromLabel, (Object)string, (Object)item.getSourcePath());
        }
        return string;
    }

    private StyledString getStyledString(CombinedChangeSetsItemEntry item, String versionString) {
        String name = item.getName();
        if (name == null) {
            name = item.getFallbackName();
        }
        StyledString string = new StyledString();
        String bind = NLS.bind((String)Messages.AggregateChangesTree_versionIdText, (Object)name, (Object)versionString);
        int index = bind.lastIndexOf(versionString);
        string.append(this.applyTextDecoration(item, bind));
        string.setStyle(index, versionString.length(), this.versionsStyler);
        return string;
    }

    private String getVersionDisplayString(CombinedChangeSetsItemEntry item) {
        if (item.getVersionableHandle() instanceof IFolderHandle) {
            return null;
        }
        IVersionableIdentifier versionIdentifier = item.getVersionIdentifier();
        if (versionIdentifier == null || !RcpUiPlugin.getDefault().getPreferenceStore().getBoolean("pref_show_version_identifiers_change_summary")) {
            return null;
        }
        boolean showRepo = RcpUiPlugin.getDefault().getPreferenceStore().getBoolean("pref_show_version_identifiers_repository_id");
        return showRepo ? versionIdentifier.getLongVersionId() : versionIdentifier.getShortVersionId();
    }
}

