/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.ce;

import com.ibm.team.filesystem.client.internal.ClientFileStateFactory;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.calm.OslcLinkUtil;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditorInput;
import com.ibm.team.filesystem.ide.ui.internal.util.ExternalCompareToolUtils;
import com.ibm.team.filesystem.rcp.ui.internal.RcpUiPlugin;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileChangeEditorInput;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.OpenFileChangeInExternalCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenInCompareAction;
import com.ibm.team.filesystem.ui.changes.views.DecorationImageDescriptor;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.DateLabelProvider;
import com.ibm.team.internal.filesystem.ui.views.ce.ChangeSummaryLabelProvider;
import com.ibm.team.internal.filesystem.ui.views.ce.ChangeSummaryView;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsComponentEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsItemEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsItemReviewEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsParentEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedSubcomponentChangeEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.MergeGraphColumn;
import com.ibm.team.internal.filesystem.ui.views.ce.MergeGraphEntry;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeSetInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.process.rcp.ui.UserLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import com.ibm.team.scm.common.dto.IVersionableIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.progress.WorkbenchJob;

public class AggregateChangesTree {
    private ITeamRepository repository;
    private Map<CombinedChangeSetsItemEntry, List<MergeGraphEntry>> graphEntries = new HashMap<CombinedChangeSetsItemEntry, List<MergeGraphEntry>>();
    private SashForm sashForm;
    private TreeViewer viewer;
    private TableViewer mergeGraphViewer;
    private MergeGraphColumn mergeGraphColumn;
    private IOperationRunner runner;
    private SnapshotId snapshot;
    private IWorkbenchPage page;
    private TableViewerColumn versionsColumn;
    private int versionsColumnWidth = 120;
    private IPropertyChangeListener detailsPanePropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("PREF_CHANGE_SUMMARY_SHOW_DETAILS_PANE".equals(event.getProperty())) {
                Object newValue = event.getNewValue();
                if (newValue instanceof Boolean) {
                    AggregateChangesTree.this.toggleDetailsPane((Boolean)newValue);
                } else if (newValue instanceof String) {
                    AggregateChangesTree.this.toggleDetailsPane(Boolean.parseBoolean((String)newValue));
                }
            }
        }
    };
    private IPropertyChangeListener versionIdentifiersPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("pref_show_version_identifiers_repository_id".equals(property)) {
                AggregateChangesTree.this.viewer.refresh(true);
                AggregateChangesTree.this.mergeGraphViewer.refresh(true);
            } else if ("pref_show_version_identifiers_change_summary".equals(property)) {
                Object newValue = event.getNewValue();
                boolean show = false;
                if (newValue instanceof Boolean) {
                    show = (Boolean)newValue;
                } else if (newValue instanceof String) {
                    show = Boolean.parseBoolean((String)newValue);
                }
                if (show) {
                    AggregateChangesTree.this.createVersionsColumn(AggregateChangesTree.this.versionsColumnWidth);
                    AggregateChangesTree.this.mergeGraphViewer.refresh(true);
                } else {
                    AggregateChangesTree.this.versionsColumnWidth = AggregateChangesTree.this.versionsColumn.getColumn().getWidth();
                    AggregateChangesTree.this.versionsColumn.getColumn().dispose();
                }
                AggregateChangesTree.this.viewer.refresh(true);
            }
        }
    };
    private IPropertyChangeListener decorationsPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("DECORATIONS_COLOR".equals(event.getProperty())) {
                AggregateChangesTree.this.viewer.refresh(true);
            }
        }
    };

    public AggregateChangesTree(IWorkbenchPage page, IOperationRunner runner) {
        this.page = page;
        this.runner = runner;
        RcpUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.versionIdentifiersPropertyChangeListener);
        UiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.detailsPanePropertyChangeListener);
        JFaceResources.getColorRegistry().addListener(this.decorationsPropertyChangeListener);
    }

    void setSnapshot(SnapshotId snapshot) {
        this.snapshot = snapshot;
        this.repository = snapshot.getRepository();
    }

    private void dispose() {
        RcpUiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.versionIdentifiersPropertyChangeListener);
        UiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.detailsPanePropertyChangeListener);
        JFaceResources.getColorRegistry().removeListener(this.decorationsPropertyChangeListener);
    }

    Control createControls(Composite parent) {
        this.sashForm = new SashForm(parent, 512);
        this.viewer = new TreeViewer((Composite)this.sashForm, 770);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ChangeSummaryLabelProvider()));
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                if (element instanceof CombinedChangeSetsComponentEntry) {
                    CombinedChangeSetsComponentEntry entry = (CombinedChangeSetsComponentEntry)element;
                    return entry.getSubcomponentChangeEntries().length != 0 || entry.getParentEntries().length != 0;
                }
                if (element instanceof CombinedChangeSetsParentEntry) {
                    CombinedChangeSetsParentEntry entry = (CombinedChangeSetsParentEntry)element;
                    return entry.getItemEntries().length != 0;
                }
                return false;
            }

            public Object getParent(Object element) {
                if (element instanceof CombinedChangeSetsItemEntry) {
                    return ((CombinedChangeSetsItemEntry)element).getParent();
                }
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Object[]) {
                    return (Object[])inputElement;
                }
                return ((Collection)inputElement).toArray();
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof CombinedChangeSetsComponentEntry) {
                    CombinedChangeSetsComponentEntry entry = (CombinedChangeSetsComponentEntry)parentElement;
                    CombinedSubcomponentChangeEntry[] subcomponentChanges = entry.getSubcomponentChangeEntries();
                    CombinedChangeSetsParentEntry[] folders = entry.getParentEntries();
                    ArrayList<Object> result = new ArrayList<Object>(subcomponentChanges.length + folders.length);
                    result.addAll(Arrays.asList(subcomponentChanges));
                    result.addAll(Arrays.asList(folders));
                    return result.toArray();
                }
                if (parentElement instanceof CombinedChangeSetsParentEntry) {
                    return ((CombinedChangeSetsParentEntry)parentElement).getItemEntries();
                }
                return new Object[0];
            }
        });
        this.createTable();
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new Separator("additions"));
        this.viewer.getControl().setMenu(menuManager.createContextMenu(this.viewer.getControl()));
        this.toggleDetailsPane(UiPlugin.getDefault().getPreferenceStore().getBoolean("PREF_CHANGE_SUMMARY_SHOW_DETAILS_PANE"));
        this.addListeners();
        return this.sashForm;
    }

    TreeViewer getTreeViewer() {
        return this.viewer;
    }

    private void addListeners() {
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AggregateChangesTree.this.react((IStructuredSelection)event.getSelection());
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                AggregateChangesTree.this.openSelection((IStructuredSelection)event.getSelection(), CompareEditorType.CHECK_PREFERENCE);
            }
        });
        this.sashForm.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AggregateChangesTree.this.dispose();
            }
        });
    }

    void openSelection(IStructuredSelection selection, boolean external) {
        this.openSelection(selection, external ? CompareEditorType.EXTERNAL : CompareEditorType.INTERNAL);
    }

    void openSelection(IStructuredSelection selection, CompareEditorType type) {
        if (selection.size() == 1) {
            Object e = selection.getFirstElement();
            if (e instanceof CombinedChangeSetsParentEntry || e instanceof CombinedChangeSetsComponentEntry) {
                this.viewer.setExpandedState(e, !this.viewer.getExpandedState(e));
            } else if (e instanceof CombinedSubcomponentChangeEntry) {
                CombinedSubcomponentChangeEntry entry = (CombinedSubcomponentChangeEntry)e;
                ITeamRepository repo = entry.getRepository();
                IComponent component = entry.getComponent();
                if (component != null) {
                    ComponentEditor.open(this.page, ComponentEditorInput.newForEdit(new ComponentWrapper(repo, component)));
                }
            } else if (e instanceof CombinedChangeSetsItemEntry) {
                CombinedChangeSetsItemEntry entry = (CombinedChangeSetsItemEntry)e;
                if (!entry.isComparable()) {
                    MessageDialogWithToggle dialog;
                    UiPlugin.getDefault().getPreferenceStore().setValue("PREF_CHANGE_SUMMARY_SHOW_DETAILS_PANE", true);
                    IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
                    if (store.getBoolean("PREF_CHANGE_SUMMARY_SHOW_DETAILS_PANE_PROMPT_ON_INCOMPLETE_CHANGE") && (dialog = MessageDialogWithToggle.openInformation((Shell)this.viewer.getControl().getShell(), (String)Messages.AggregateChangesTree_incompleteAggregateDialogTitle, (String)Messages.AggregateChangesTree_incompleteAggregateDialogMessage, (String)Messages.DetailsDialog_DontShowMeThisAgain, (boolean)false, (IPreferenceStore)store, (String)"PREF_CHANGE_SUMMARY_SHOW_DETAILS_PANE_PROMPT_ON_INCOMPLETE_CHANGE")).getToggleState()) {
                        store.setValue("PREF_CHANGE_SUMMARY_SHOW_DETAILS_PANE_PROMPT_ON_INCOMPLETE_CHANGE", false);
                    }
                } else if (entry.getVersionableHandle() instanceof IFileItemHandle || entry.getVersionableHandle() instanceof ISymbolicLinkHandle) {
                    this.enqueueOpenCompareEditor(e, type);
                }
            }
        }
    }

    private void openCompareEditor(Object input, CompareEditorType type, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (input instanceof CombinedChangeSetsItemEntry) {
            CombinedChangeSetsItemEntry entry = (CombinedChangeSetsItemEntry)input;
            FileState after = AggregateChangesTree.createAfterFileState(entry, (IProgressMonitor)subMonitor.newChild(1));
            FileState before = AggregateChangesTree.createBeforeFileState(entry, (IProgressMonitor)subMonitor.newChild(1));
            this.openCompareEditor(after, before, type);
        } else if (input instanceof CombinedChangeSetsItemReviewEntry) {
            CombinedChangeSetsItemReviewEntry entry = (CombinedChangeSetsItemReviewEntry)input;
            IVersionableHandle[] merges = entry.getMerges();
            if (merges.length == 0) {
                FileState after = AggregateChangesTree.createAfterFileState(entry, (IProgressMonitor)subMonitor.newChild(1));
                FileState before = AggregateChangesTree.createBeforeFileState(entry, (IProgressMonitor)subMonitor.newChild(1));
                this.openCompareEditor(after, before, type);
            } else {
                IVersionableHandle lastMergeState = merges[merges.length - 1];
                FileState after = AggregateChangesTree.createAfterFileState(entry, (IProgressMonitor)subMonitor.newChild(1));
                FileState before = AggregateChangesTree.createFileState(entry.getVersionableHandle(), lastMergeState == null ? null : lastMergeState.getStateId(), (IProgressMonitor)subMonitor.newChild(1));
                this.openCompareEditor(after, before, type);
            }
        }
    }

    private void openCompareEditor(final FileState left, final FileState right, CompareEditorType type) {
        if (type == CompareEditorType.EXTERNAL || type == CompareEditorType.CHECK_PREFERENCE && ExternalCompareToolUtils.shouldUseExternalCompareTool(left.getPath().getName())) {
            WorkbenchJob job = new WorkbenchJob(this.sashForm.getDisplay(), Messages.AggregateChangesTree_compareCalculationOperationTitle){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    OpenFileChangeInExternalCompareAction action = new OpenFileChangeInExternalCompareAction();
                    action.run(AggregateChangesTree.this.sashForm.getShell(), AggregateChangesTree.this.page, (IStructuredSelection)new StructuredSelection((Object)new FileChange(right, left, null)));
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        } else {
            FileChangeEditorInput input = AggregateChangesTree.createInput(left, right);
            OpenInCompareAction.openCompareEditor((CompareEditorInput)input, this.page);
        }
    }

    private void enqueueOpenCompareEditor(final Object o, final CompareEditorType type) {
        this.runner.enqueue(Messages.AggregateChangesTree_compareCalculationOperationTitle, (Operation)new RepositoryOperation(this.repository){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                AggregateChangesTree.this.openCompareEditor(o, type, monitor);
            }
        });
    }

    private void compare(final CombinedChangeSetsItemReviewEntry after, final CombinedChangeSetsItemReviewEntry before) {
        this.runner.enqueue(Messages.AggregateChangesTree_compareCalculationOperationTitle, (Operation)new RepositoryOperation(this.repository){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                FileState left = AggregateChangesTree.createAfterFileState(after, (IProgressMonitor)subMonitor.newChild(1));
                FileState right = AggregateChangesTree.createAfterFileState(before, (IProgressMonitor)subMonitor.newChild(1));
                AggregateChangesTree.this.openCompareEditor(left, right, CompareEditorType.CHECK_PREFERENCE);
            }
        });
    }

    private static FileChangeEditorInput createInput(FileState left, FileState right) {
        FileChangeEditorInput input = FileChangeEditorInput.createFrom((FileState)left, (FileState)right, (boolean)false);
        input.setLabels(Messages.OpenAction_0, Messages.OpenAction_1);
        return input;
    }

    private static FileState createBeforeFileState(CombinedChangeSetsItemReviewEntry entry, IProgressMonitor monitor) throws TeamRepositoryException {
        return AggregateChangesTree.createFileState(entry.getVersionableHandle(), entry.getBefore(), monitor);
    }

    public static FileState createBeforeFileState(CombinedChangeSetsItemEntry entry, IProgressMonitor monitor) throws TeamRepositoryException {
        IVersionableHandle[] merges;
        CombinedChangeSetsItemReviewEntry[] reviewEntries = entry.getReviewEntries();
        if (reviewEntries.length == 1 && (merges = reviewEntries[0].getMerges()).length > 0) {
            IVersionableHandle lastMergeState = merges[merges.length - 1];
            return AggregateChangesTree.createFileState(entry.getVersionableHandle(), lastMergeState == null ? null : lastMergeState.getStateId(), monitor);
        }
        return AggregateChangesTree.createFileState(entry.getVersionableHandle(), entry.getEstimatedInitialState(), monitor);
    }

    private static FileState createFileState(IVersionableHandle versionableHandle, UUID state, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = (ITeamRepository)versionableHandle.getOrigin();
        IItemType itemType = versionableHandle.getItemType();
        IVersionableHandle handle = state == null ? null : (IVersionableHandle)itemType.createItemHandle((Object)repository, versionableHandle.getItemId(), state);
        return AggregateChangesTree.createFileItemFileState(repository, handle, itemType, monitor);
    }

    private static FileState createAfterFileState(CombinedChangeSetsItemReviewEntry entry, IProgressMonitor monitor) throws TeamRepositoryException {
        return AggregateChangesTree.createFileState(entry.getVersionableHandle(), entry.getAfter(), monitor);
    }

    public static FileState createAfterFileState(CombinedChangeSetsItemEntry entry, IProgressMonitor monitor) throws TeamRepositoryException {
        return AggregateChangesTree.createFileState(entry.getVersionableHandle(), entry.getEstimatedFinalState(), monitor);
    }

    private static FileState createFileItemFileState(ITeamRepository repository, IVersionableHandle handle, IItemType itemType, IProgressMonitor monitor) throws TeamRepositoryException {
        if (handle == null) {
            return ClientFileStateFactory.create((IItemType)itemType);
        }
        IVersionableManager versionableManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).versionableManager();
        IVersionable versionable = versionableManager.fetchCompleteState(handle, monitor);
        return ClientFileStateFactory.create((ITeamRepository)repository, (IItemType)itemType, (IVersionable)versionable);
    }

    void react(IStructuredSelection selection) {
        Object o;
        if (selection.size() == 1 && this.sashForm.getMaximizedControl() == null && (o = selection.getFirstElement()) instanceof CombinedChangeSetsItemEntry) {
            CombinedChangeSetsItemEntry entry = (CombinedChangeSetsItemEntry)o;
            List<MergeGraphEntry> entries = this.graphEntries.get(entry);
            if (entries == null) {
                this.review(entry);
                return;
            }
            CombinedChangeSetsItemReviewEntry[] clone = entry.getReviewEntries();
            Arrays.sort(clone, new Comparator<CombinedChangeSetsItemReviewEntry>(){

                @Override
                public int compare(CombinedChangeSetsItemReviewEntry object1, CombinedChangeSetsItemReviewEntry object2) {
                    return object2.getTimestamp().compareTo(object1.getTimestamp());
                }
            });
            this.updateTable(entries, clone);
            return;
        }
        this.mergeGraphViewer.setInput((Object)new Object[0]);
    }

    private void reviewJob(CombinedChangeSetsItemEntry entry, IProgressMonitor monitor) throws TeamRepositoryException {
        CombinedChangeSetsItemReviewEntry reviewEntry;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        CombinedChangeSetsItemReviewEntry[] reviewEntries = entry.getReviewEntries();
        ArrayList<IContributorHandle> authorHandles = new ArrayList<IContributorHandle>(reviewEntries.length);
        CombinedChangeSetsItemReviewEntry[] combinedChangeSetsItemReviewEntryArray = reviewEntries;
        int n = reviewEntries.length;
        int n2 = 0;
        while (n2 < n) {
            CombinedChangeSetsItemReviewEntry review = combinedChangeSetsItemReviewEntryArray[n2];
            authorHandles.add(review.getAuthor());
            ++n2;
        }
        List authors = this.repository.itemManager().fetchCompleteItems(authorHandles, 0, (IProgressMonitor)subMonitor.newChild(1));
        final CombinedChangeSetsItemReviewEntry[] clone = entry.getReviewEntries();
        Arrays.sort(clone, new Comparator<CombinedChangeSetsItemReviewEntry>(){

            @Override
            public int compare(CombinedChangeSetsItemReviewEntry object1, CombinedChangeSetsItemReviewEntry object2) {
                return object2.getTimestamp().compareTo(object1.getTimestamp());
            }
        });
        ArrayList<IChangeSetHandle> changeSetHandles = new ArrayList<IChangeSetHandle>();
        CombinedChangeSetsItemReviewEntry[] combinedChangeSetsItemReviewEntryArray2 = clone;
        int n3 = clone.length;
        int n4 = 0;
        while (n4 < n3) {
            reviewEntry = combinedChangeSetsItemReviewEntryArray2[n4];
            changeSetHandles.add((IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)this.repository, reviewEntry.getChangeSetItemId(), null));
            ++n4;
        }
        combinedChangeSetsItemReviewEntryArray2 = entry.getReviewEntries();
        n3 = combinedChangeSetsItemReviewEntryArray2.length;
        n4 = 0;
        while (n4 < n3) {
            reviewEntry = combinedChangeSetsItemReviewEntryArray2[n4];
            reviewEntry.setLinkSummary(null);
            ++n4;
        }
        List linkSummaries = OslcLinkUtil.getChangeSetLinkSummary((ITeamRepository)this.repository, changeSetHandles, (IRepositoryResolver)IRepositoryResolver.EXISTING_SHARED, (IProgressMonitor)subMonitor.newChild(1));
        block3: for (IChangeSetLinkSummary linkSummary : linkSummaries) {
            if (linkSummary.getLinks().isEmpty()) continue;
            CombinedChangeSetsItemReviewEntry[] combinedChangeSetsItemReviewEntryArray3 = entry.getReviewEntries();
            int n5 = combinedChangeSetsItemReviewEntryArray3.length;
            int n6 = 0;
            while (n6 < n5) {
                CombinedChangeSetsItemReviewEntry reviewEntry2 = combinedChangeSetsItemReviewEntryArray3[n6];
                if (reviewEntry2.getChangeSetItemId().equals((Object)linkSummary.getChangeSet().getItemId())) {
                    reviewEntry2.setLinkSummary(linkSummary);
                    continue block3;
                }
                ++n6;
            }
        }
        final ArrayList<MergeGraphEntry> entries = new ArrayList<MergeGraphEntry>();
        int i = clone.length - 1;
        while (i >= 0) {
            MergeGraphEntry mge = new MergeGraphEntry(entry.getReviewEntry(i), (IContributor)authors.get(i));
            entries.add(mge);
            --i;
        }
        this.graphEntries.put(entry, entries);
        if (!this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!AggregateChangesTree.this.viewer.getControl().isDisposed()) {
                        AggregateChangesTree.this.updateTable(entries, clone);
                    }
                }
            });
        }
    }

    private void createVersionsColumn(int width) {
        Assert.isLegal((width >= 0 ? 1 : 0) != 0);
        this.versionsColumn = new TableViewerColumn(this.mergeGraphViewer, 16384, 4);
        this.versionsColumn.getColumn().setText(Messages.HistoryView_versionIdColumn);
        this.versionsColumn.getColumn().setWidth(width);
        this.versionsColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                CombinedChangeSetsItemReviewEntry entry = ((MergeGraphEntry)element).getReviewEntry();
                if (entry.getVersionableHandle() instanceof IFolderHandle) {
                    return "";
                }
                IVersionableIdentifier versionId = entry.getVersionIdentifier();
                if (versionId == null) {
                    return entry.getAfter() == null ? Messages.HistoryView_deletedVersionLabel : "";
                }
                boolean showRepo = RcpUiPlugin.getDefault().getPreferenceStore().getBoolean("pref_show_version_identifiers_repository_id");
                return showRepo ? versionId.getLongVersionId() : versionId.getShortVersionId();
            }
        });
    }

    private void createTable() {
        this.mergeGraphViewer = new TableViewer((Composite)this.sashForm, 66306);
        this.mergeGraphViewer.getTable().setHeaderVisible(true);
        this.mergeGraphViewer.getTable().setLinesVisible(true);
        this.mergeGraphViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.mergeGraphViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                AggregateChangesTree.this.enqueueOpenCompareEditor(((MergeGraphEntry)o).getReviewEntry(), CompareEditorType.CHECK_PREFERENCE);
            }
        });
        TableViewerColumn mergesColumn = new TableViewerColumn(this.mergeGraphViewer, 16384);
        mergesColumn.getColumn().setText(Messages.AggregateChangesTree_reviewTableMergesColumnText);
        mergesColumn.getColumn().setWidth(130);
        mergesColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }
        });
        this.mergeGraphColumn = new MergeGraphColumn(this.mergeGraphViewer);
        this.mergeGraphViewer.getTable().addListener(42, this.mergeGraphColumn.getPaintListener());
        TableViewerColumn commentColumn = new TableViewerColumn(this.mergeGraphViewer, 16384);
        commentColumn.getColumn().setText(Messages.HistoryView_commentColumn);
        commentColumn.getColumn().setWidth(320);
        commentColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            private Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();

            public void dispose() {
                for (Image image : this.images.values()) {
                    image.dispose();
                }
                this.images.clear();
                super.dispose();
            }

            private Image getImage(ImageDescriptor descriptor) {
                Image image = this.images.get(descriptor);
                if (image == null) {
                    image = descriptor.createImage();
                    this.images.put(descriptor, image);
                }
                return image;
            }

            private DecorationImageDescriptor createImageDescriptor(CombinedChangeSetsItemReviewEntry entry) {
                BitSet flags = new BitSet();
                if (entry.isActive()) {
                    return new DecorationImageDescriptor(ImagePool.CHANGE, flags, 0);
                }
                flags.set(3);
                return new DecorationImageDescriptor(ImagePool.CHANGE_COMPLETED, flags, 0);
            }

            public Image getImage(Object element) {
                CombinedChangeSetsItemReviewEntry entry = ((MergeGraphEntry)element).getReviewEntry();
                DecorationImageDescriptor descriptor = this.createImageDescriptor(entry);
                IChangeSetLinkSummary linkSummary = entry.getLinkSummary();
                if (linkSummary == null) {
                    return this.getImage((ImageDescriptor)descriptor);
                }
                switch (linkSummary.getLinks().size()) {
                    case 0: {
                        return this.getImage((ImageDescriptor)descriptor);
                    }
                    case 1: {
                        descriptor.addAdornment(16);
                        return this.getImage((ImageDescriptor)descriptor);
                    }
                }
                descriptor.addAdornment(17);
                return this.getImage((ImageDescriptor)descriptor);
            }

            public String getText(Object element) {
                CombinedChangeSetsItemReviewEntry entry = ((MergeGraphEntry)element).getReviewEntry();
                IChangeSetLinkSummary linkSummary = entry.getLinkSummary();
                String summary = linkSummary == null ? null : linkSummary.getSummary();
                String comment = entry.getComment();
                if (summary == null) {
                    return comment.isEmpty() ? Messages.AggregateChangesTree_reviewTableNoComment : comment;
                }
                if (comment.isEmpty()) {
                    return summary;
                }
                return NLS.bind((String)Messages.AggregateChangesTree_reviewTableChangeSetLink, (Object)summary, (Object)comment);
            }
        });
        TableViewerColumn creatorColumn = new TableViewerColumn(this.mergeGraphViewer, 16384);
        creatorColumn.getColumn().setText(Messages.HistoryView_creatorColumn);
        creatorColumn.getColumn().setWidth(75);
        creatorColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            private UserLabelProvider userLabelProvider = new UserLabelProvider();

            public String getText(Object element) {
                return this.userLabelProvider.getText((Object)((MergeGraphEntry)element).getAuthor());
            }

            public Image getImage(Object element) {
                return this.userLabelProvider.getImage((Object)((MergeGraphEntry)element).getAuthor());
            }

            public void dispose() {
                this.userLabelProvider.dispose();
                super.dispose();
            }
        });
        TableViewerColumn dateColumn = new TableViewerColumn(this.mergeGraphViewer, 16384);
        dateColumn.getColumn().setText(Messages.HistoryView_dateColumn);
        dateColumn.getColumn().setWidth(150);
        dateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            private DateLabelProvider dateLabelProvider = new DateLabelProvider();

            public String getText(Object element) {
                return this.dateLabelProvider.getText(((MergeGraphEntry)element).getReviewEntry().getTimestamp());
            }

            public void dispose() {
                this.dateLabelProvider.dispose();
                super.dispose();
            }
        });
        if (RcpUiPlugin.getDefault().getPreferenceStore().getBoolean("pref_show_version_identifiers_change_summary")) {
            this.createVersionsColumn(this.versionsColumnWidth);
        }
        this.mergeGraphViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                AggregateChangesTree.this.enqueueOpenCompareEditor(selection.getFirstElement(), CompareEditorType.CHECK_PREFERENCE);
            }
        });
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                final IStructuredSelection selection = (IStructuredSelection)AggregateChangesTree.this.mergeGraphViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                Action openAction = new Action(Messages.AggregateChangesTree_openInCompareEditor){

                    public void run() {
                        MergeGraphEntry entry = (MergeGraphEntry)selection.getFirstElement();
                        AggregateChangesTree.this.enqueueOpenCompareEditor(entry.getReviewEntry(), CompareEditorType.CHECK_PREFERENCE);
                    }
                };
                Action openChangeSummaryAction = new Action(Messages.AggregateChangesTree_changeSummary, ImagePool.CHANGE_SUMMARY_OBJ){

                    public void run() {
                        ArrayList<IChangeSetHandle> changeSetHandles = new ArrayList<IChangeSetHandle>();
                        Object[] objectArray = selection.toArray();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            CombinedChangeSetsItemReviewEntry entry = ((MergeGraphEntry)o).getReviewEntry();
                            changeSetHandles.add((IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(entry.getVersionableHandle().getOrigin(), entry.getChangeSetItemId(), null));
                            ++n2;
                        }
                        ChangeSummaryView.open(AggregateChangesTree.this.snapshot, changeSetHandles);
                    }
                };
                Action openChangeExplorerAction = new Action(Messages.AggregateChangesTree_changeExplorer, ImagePool.CHANGES_VIEW_ICON){

                    public void run() {
                        ArrayList<IChangeSetHandle> changeSetHandles = new ArrayList<IChangeSetHandle>();
                        Object[] objectArray = selection.toArray();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            MergeGraphEntry entry = (MergeGraphEntry)o;
                            changeSetHandles.add((IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(entry.getReviewEntry().getChangeSetItemId(), null));
                            ++n2;
                        }
                        ChangesViewConverter.openChangeExplorer(AggregateChangesTree.this.page, new ChangeSetInput(AggregateChangesTree.this.snapshot, changeSetHandles));
                    }
                };
                Action compareAction = new Action(Messages.AggregateChangesTree_compareWithEachOther){

                    public void run() {
                        Object[] array = selection.toArray();
                        MergeGraphEntry after = (MergeGraphEntry)array[0];
                        MergeGraphEntry before = (MergeGraphEntry)array[1];
                        AggregateChangesTree.this.compare(after.getReviewEntry(), before.getReviewEntry());
                    }
                };
                manager.add((IAction)openAction);
                MenuManager subMenu = new MenuManager(Messages.AggregateChangesTree_openWith);
                subMenu.add((IAction)openChangeSummaryAction);
                subMenu.add((IAction)openChangeExplorerAction);
                manager.add((IContributionItem)subMenu);
                manager.add((IAction)compareAction);
                if (selection.size() == 1) {
                    compareAction.setEnabled(false);
                } else if (selection.size() == 2) {
                    openAction.setEnabled(false);
                } else {
                    compareAction.setEnabled(false);
                    openAction.setEnabled(false);
                }
            }
        });
        manager.createContextMenu(this.mergeGraphViewer.getControl());
        this.mergeGraphViewer.getControl().setMenu(manager.getMenu());
    }

    private void updateTable(List<MergeGraphEntry> pairs, CombinedChangeSetsItemReviewEntry[] reviewEntries) {
        this.mergeGraphViewer.setInput(pairs);
        this.mergeGraphColumn.setReviewEntries(reviewEntries);
    }

    private void review(final CombinedChangeSetsItemEntry entry) {
        this.runner.enqueue(Messages.AggregateChangesTree_reviewCalculationOperationTitle, (Operation)new RepositoryOperation(this.repository){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                AggregateChangesTree.this.reviewJob(entry, monitor);
            }
        });
    }

    void show(List<CombinedChangeSetsComponentEntry> result, int inaccessibleComponents) {
        this.graphEntries.clear();
        if (result.size() == 1 && inaccessibleComponents == 0) {
            CombinedChangeSetsComponentEntry entry = result.get(0);
            CombinedSubcomponentChangeEntry[] subcomponentChanges = entry.getSubcomponentChangeEntries();
            CombinedChangeSetsParentEntry[] folders = entry.getParentEntries();
            ArrayList<Object> rootEntries = new ArrayList<Object>(subcomponentChanges.length + folders.length);
            rootEntries.addAll(Arrays.asList(subcomponentChanges));
            rootEntries.addAll(Arrays.asList(folders));
            this.viewer.setInput((Object)rootEntries.toArray());
        } else {
            this.viewer.setInput(result);
        }
        this.mergeGraphViewer.setInput((Object)new Object[0]);
    }

    private void toggleDetailsPane(boolean show) {
        if (show) {
            this.sashForm.setMaximizedControl(null);
            this.react((IStructuredSelection)this.viewer.getSelection());
        } else {
            this.sashForm.setMaximizedControl(this.viewer.getControl());
        }
    }

    public static enum CompareEditorType {
        INTERNAL,
        EXTERNAL,
        CHECK_PREFERENCE;

    }
}

