/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.SnapshotComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.SnapshotWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.ItemIdComparator;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.validation.IItemValidator;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IBaselineSetSearchCriteria;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class WorkspaceUtil {
    public static final int WORKSPACE_DESCRIPTION_LIMIT = 32768;

    private WorkspaceUtil() {
    }

    public static List<AbstractPlaceWrapper> itemsToWrappers(ITeamRepository repo, Collection<IWorkspace> workspaces) {
        return WorkspaceUtil.itemsToWrappers(repo, workspaces, false);
    }

    public static List<AbstractPlaceWrapper> itemsToWrappers(ITeamRepository repo, Collection<IWorkspace> workspaces, boolean allowFolderActions) {
        if ((workspaces = WorkspaceUtil.removeNulls(workspaces)).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AbstractPlaceWrapper> result = new ArrayList<AbstractPlaceWrapper>(workspaces.size());
        for (IWorkspace workspace : workspaces) {
            AbstractPlaceWrapper wrapper = AbstractPlaceWrapper.newWrapper(workspace);
            wrapper.setAllowFolderActions(allowFolderActions);
            result.add(wrapper);
        }
        return result;
    }

    private static <T> Collection<T> removeNulls(Collection<T> items) {
        if (!items.contains(null)) {
            return items;
        }
        ArrayList<T> result = new ArrayList<T>(items.size());
        for (T item : items) {
            if (item == null) continue;
            result.add(item);
        }
        return result;
    }

    public static AbstractPlaceWrapper toWrapper(IWorkspaceConnection connection) {
        return AbstractPlaceWrapper.newWrapper(connection.getResolvedWorkspace());
    }

    public static IAuditableHandle getComponentOwner(IWorkspaceConnection wc) {
        if (wc.getOwner() instanceof IContributorHandle || wc.getOwner() instanceof IProcessAreaHandle) {
            return wc.getOwner();
        }
        IContributor contrib = wc.teamRepository().loggedInContributor();
        Assert.isNotNull((Object)contrib);
        return (IContributorHandle)contrib.getItemHandle();
    }

    public static boolean isDeleted(IWorkspaceConnection connection) {
        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)connection.teamRepository());
        return !mgr.knownWorkspaceConnections().contains(connection);
    }

    public static IConnection getConnection(AbstractWrapper wrapper, IProgressMonitor monitor) throws TeamRepositoryException {
        if (wrapper instanceof AbstractPlaceWrapper) {
            return ((AbstractPlaceWrapper)wrapper).getWorkspaceConnection(monitor);
        }
        if (wrapper instanceof BaselineWrapper) {
            return ((BaselineWrapper)wrapper).getBaselineConnection(monitor);
        }
        if (wrapper instanceof WorkspaceComponentWrapper) {
            return ((WorkspaceComponentWrapper)wrapper).getWorkspaceConnection();
        }
        return null;
    }

    public static ItemNamespace getNamespace(AbstractWrapper wrapper) {
        if (wrapper instanceof BaselineWrapper) {
            return ((BaselineWrapper)wrapper).getNamespace();
        }
        if (wrapper instanceof WorkspaceComponentWrapper) {
            return ((WorkspaceComponentWrapper)wrapper).getNamespace();
        }
        return null;
    }

    public static IComponent getComponent(AbstractWrapper wrapper) {
        if (wrapper instanceof BaselineWrapper) {
            return ((BaselineWrapper)wrapper).getComponent();
        }
        if (wrapper instanceof WorkspaceComponentWrapper) {
            return ((WorkspaceComponentWrapper)wrapper).getComponent();
        }
        return null;
    }

    public static List<WorkspaceComponentWrapper> getComponentWrappers(IWorkspaceConnection connection, IProgressMonitor monitor) throws TeamRepositoryException {
        List handles = connection.getComponents();
        List components = connection.teamRepository().itemManager().fetchCompleteItems(handles, 0, monitor);
        ArrayList result = NewCollection.arrayList((int)components.size());
        for (IComponent component : components) {
            if (component == null) continue;
            result.add(WorkspaceComponentWrapper.newWrapper(connection, component));
        }
        return result;
    }

    public static List<SnapshotWrapper> getBaselineSetWrappers(ITeamRepository repo, IWorkspace workspace, int max, String namePattern, IProgressMonitor monitor) throws TeamRepositoryException {
        if (repo == null || workspace == null) {
            return Collections.emptyList();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.WorkspaceUtil_1, (int)100);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        IBaselineSetSearchCriteria baselineSetSearchCriteria = IBaselineSetSearchCriteria.FACTORY.newInstance();
        baselineSetSearchCriteria.setOwnerWorkspaceOptional((IWorkspaceHandle)workspace);
        baselineSetSearchCriteria.setPartialNameIgnoreCase(namePattern);
        List snapshotHandles = workspaceManager.findBaselineSets(baselineSetSearchCriteria, max, (IProgressMonitor)progress.newChild(50));
        IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(snapshotHandles, 1, (IProgressMonitor)progress.newChild(50));
        ArrayList<SnapshotWrapper> result = new ArrayList<SnapshotWrapper>(fetchResult.getRetrievedItems().size());
        for (Object o : fetchResult.getRetrievedItems()) {
            if (!(o instanceof IBaselineSet)) continue;
            result.add(new SnapshotWrapper(workspace, (IBaselineSet)o));
        }
        return result;
    }

    public static List<SnapshotWrapper> getBaselineSetWrappers(ITeamRepository repo, IWorkspace workspace, int max, IProgressMonitor monitor) throws TeamRepositoryException {
        return WorkspaceUtil.getBaselineSetWrappers(repo, workspace, max, null, monitor);
    }

    public static List<SnapshotComponentWrapper> getBaselineSetComponentWrappers(IWorkspaceConnection connection, IBaselineSet bset, IProgressMonitor monitor) throws TeamRepositoryException {
        List baselineHandles = bset.getBaselines();
        IFetchResult fetchResult = connection.teamRepository().itemManager().fetchCompleteItemsPermissionAware(baselineHandles, 0, monitor);
        List baselines = fetchResult.getRetrievedItems();
        ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>();
        for (IBaseline baseline : baselines) {
            componentHandles.add(baseline.getComponent());
        }
        List components = connection.teamRepository().itemManager().fetchCompleteItems(componentHandles, 0, monitor);
        ArrayList<SnapshotComponentWrapper> result = new ArrayList<SnapshotComponentWrapper>(baselines.size());
        int count = 0;
        for (IBaseline baseline : baselines) {
            if (baseline != null && components.get(count) != null) {
                result.add(new SnapshotComponentWrapper(connection, (IComponent)components.get(count), baseline, bset));
            }
            ++count;
        }
        return result;
    }

    public static List getItems(List wrappers) {
        ArrayList<IItem> result = new ArrayList<IItem>(wrappers.size());
        for (AbstractWrapper wrapper : wrappers) {
            result.add(wrapper.getItem());
        }
        return result;
    }

    public static WorkspaceComponentWrapper getComponentWrapper(Object element) {
        IComponentSyncContext context;
        if (element instanceof WorkspaceComponentWrapper) {
            return (WorkspaceComponentWrapper)element;
        }
        if (element instanceof IComponentSyncContext && (context = (IComponentSyncContext)element).isLocal()) {
            return WorkspaceComponentWrapper.newWrapper(context.getOutgoingTeamPlace(), context.getComponent());
        }
        return null;
    }

    public static IWorkspaceHandle getAdditionWorkspaceScopes(Object element) {
        if (element instanceof IComponentSyncContext) {
            IComponentSyncContext context = (IComponentSyncContext)element;
            IWorkspaceConnection incomingTeamPlace = context.getRemoteIncomingTeamPlace();
            if (context.getLoggedIn() && context.isLocal()) {
                if (incomingTeamPlace != null) {
                    return incomingTeamPlace.getResolvedWorkspace();
                }
                IWorkspaceConnection outgoingTeamPlace = context.getRemoteOutgoingTeamPlace();
                if (outgoingTeamPlace != null) {
                    return outgoingTeamPlace.getResolvedWorkspace();
                }
            }
        }
        return null;
    }

    public static boolean confirmComponentOperationOnStream(Shell shell) {
        String title = Messages.WorkspaceUtil_2;
        String message = Messages.WorkspaceUtil_3;
        return DialogUtil.openConfirm(shell, title, message, 4, false);
    }

    public static boolean hasActiveChanges(ContributorPlaceComponentWrapper wrapper) {
        return !wrapper.getWorkspaceConnection().activeChangeSets((IComponentHandle)wrapper.getComponent()).isEmpty();
    }

    public static boolean hasPendingChanges(WorkspaceComponentWrapper wrapper) {
        IComponentSyncContext[] contexts;
        IComponentSyncContext[] iComponentSyncContextArray = contexts = FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncContexts((IConnection)wrapper.getWorkspaceConnection(), (IComponentHandle)wrapper.getComponent());
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext context = iComponentSyncContextArray[n2];
            if (WorkspaceUtil.hasPendingChanges(context)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean hasPendingChanges(IComponentSyncContext context) {
        return context.getLocalChangeSource().size() > 0;
    }

    public static boolean hasUndeliveredChanges(WorkspaceComponentWrapper wrapper, boolean excludeActive) {
        return WorkspaceUtil.hasUndeliveredChanges(wrapper.getWorkspaceConnection(), (IComponentHandle)wrapper.getComponent(), excludeActive);
    }

    public static boolean hasUndeliveredChanges(IWorkspaceConnection workspace, IComponentHandle component, boolean excludeActive) {
        IComponentSyncContext[] contexts;
        IComponentSyncContext[] iComponentSyncContextArray = contexts = FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncContexts((IConnection)workspace, component);
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext context = iComponentSyncContextArray[n2];
            if (WorkspaceUtil.hasUndeliveredChanges(context, excludeActive)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean hasUndeliveredChanges(IComponentSyncContext context, boolean excludeActive) {
        if (context.getOutgoingActivitySource().size() > 0) {
            if (!excludeActive) {
                return true;
            }
            Collection outgoing = ComponentSyncUtil.getActivities((IActivitySource)context.getOutgoingActivitySource());
            TreeSet active = new TreeSet(ItemIdComparator.INSTANCE);
            active.addAll(context.getOutgoingTeamPlace().activeChangeSets((IComponentHandle)context.getComponent()));
            for (IRemoteActivity change : outgoing) {
                IChangeSet cs = change.getChangeSet();
                if (cs == null || active.contains(cs)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasChanges(IComponentSyncContext[] contexts) {
        IComponentSyncContext[] iComponentSyncContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext context = iComponentSyncContextArray[n2];
            if (WorkspaceUtil.hasChanges(context)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasChanges(IComponentSyncContext context) {
        if (context.getOutgoingTeamPlace().isStream()) {
            return false;
        }
        return WorkspaceUtil.hasUndeliveredChanges(context, false) || WorkspaceUtil.hasPendingChanges(context);
    }

    public static IWorkspaceConnection getKnownConnection(ITeamRepository repo, IWorkspaceHandle workspace) {
        List known = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).knownWorkspaceConnections();
        for (IWorkspaceConnection connection : known) {
            if (!connection.getResolvedWorkspace().sameItemId((IItemHandle)workspace)) continue;
            return connection;
        }
        return null;
    }

    public static IWorkspace getWorkspace(Object element) {
        if (element != null && Adapters.hasAdapter((Object)element, AbstractPlaceWrapper.class)) {
            AbstractPlaceWrapper wrapper = (AbstractPlaceWrapper)((Object)Adapters.getAdapter((Object)element, AbstractPlaceWrapper.class));
            return wrapper.getWorkspace();
        }
        if (element instanceof IWorkspaceSyncContext) {
            IWorkspaceSyncContext context = (IWorkspaceSyncContext)element;
            return context.getLocal().getResolvedWorkspace();
        }
        throw new IllegalArgumentException();
    }

    public static ITeamRepository getRepository(Object element) {
        if (element != null && Adapters.hasAdapter((Object)element, AbstractPlaceWrapper.class)) {
            AbstractPlaceWrapper wrapper = (AbstractPlaceWrapper)((Object)Adapters.getAdapter((Object)element, AbstractPlaceWrapper.class));
            return wrapper.getRepository();
        }
        if (element instanceof IWorkspaceSyncContext) {
            IWorkspaceSyncContext context = (IWorkspaceSyncContext)element;
            return context.teamRepository();
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean confirmUnresolvedAndConflictsForReplace(Shell shell, List<? extends Object> contexts) {
        void var4_10;
        boolean hasConflicts = false;
        boolean hasUncheckedInChanges = false;
        for (Object object : contexts) {
            ArrayList<IComponentSyncContext> syncCtx = new ArrayList<IComponentSyncContext>();
            if (object instanceof IComponentSyncContext) {
                syncCtx.add((IComponentSyncContext)object);
            } else if (object instanceof IWorkspaceSyncContext) {
                IWorkspaceSyncContext iWorkspaceSyncContext = (IWorkspaceSyncContext)object;
                syncCtx.addAll(Arrays.asList(iWorkspaceSyncContext.getComponentSyncContexts()));
            } else if (object instanceof WorkspaceComponentWrapper) {
                WorkspaceComponentWrapper workspaceComponentWrapper = (WorkspaceComponentWrapper)object;
                syncCtx.addAll(Arrays.asList(FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncContexts((IConnection)workspaceComponentWrapper.getWorkspaceConnection(), (IComponentHandle)workspaceComponentWrapper.getComponent())));
            }
            for (IComponentSyncContext iComponentSyncContext : syncCtx) {
                if (iComponentSyncContext.getOutgoingActivitySource().getConflictItems().size() > 0) {
                    hasConflicts = true;
                }
                if (iComponentSyncContext.getLocalChangeSource().size() <= 0) continue;
                hasUncheckedInChanges = true;
            }
        }
        Object var4_6 = null;
        if (hasConflicts && hasUncheckedInChanges) {
            String string = Messages.WorkspaceUtil_4;
        } else if (hasConflicts) {
            String string = Messages.WorkspaceUtil_5;
        } else if (hasUncheckedInChanges) {
            String string = Messages.WorkspaceUtil_6;
        }
        if (var4_10 != null) {
            return DialogUtil.openConfirm(shell, Messages.WorkspaceUtil_7, (String)var4_10, 4, false);
        }
        return true;
    }

    public static String getOwnerName(IAuditable owner) {
        if (owner instanceof IContributor) {
            IContributor contributor = (IContributor)owner;
            return contributor.getName();
        }
        if (owner instanceof IProcessArea) {
            IProcessArea teamArea = (IProcessArea)owner;
            return teamArea.getName();
        }
        return Messages.WorkspaceUtil_8;
    }

    public static IInputValidator getComponentNameValidator() {
        return new IInputValidator(){

            public String isValid(String newText) {
                if (newText.equals("")) {
                    return "";
                }
                IStatus status = IItemValidator.INSTANCE.validateAttribute((IType)IComponent.ITEM_TYPE, IComponent.NAME_PROPERTY, (Object)newText);
                return status.isOK() ? null : status.getMessage();
            }
        };
    }

    public static IInputValidator getWorkspaceStreamNameValidator() {
        return new IInputValidator(){

            public String isValid(String newText) {
                if (newText.equals("")) {
                    return "";
                }
                IStatus status = IItemValidator.INSTANCE.validateAttribute((IType)IWorkspace.ITEM_TYPE, IWorkspace.NAME_PROPERTY, (Object)newText);
                return status.isOK() ? null : status.getMessage();
            }
        };
    }

    public static String getDefaultComponentName(String workspaceName) {
        return NLS.bind((String)Messages.WorkspaceUtil_defaultComponentName, (Object)workspaceName);
    }

    public static IConfiguration configuration(AbstractWrapper wrapper, IProgressMonitor monitor) throws TeamRepositoryException {
        if (wrapper instanceof WorkspaceComponentWrapper) {
            WorkspaceComponentWrapper workspace = (WorkspaceComponentWrapper)wrapper;
            return workspace.getWorkspaceConnection().configuration((IComponentHandle)workspace.getComponent());
        }
        if (wrapper instanceof BaselineWrapper) {
            BaselineWrapper baseline = (BaselineWrapper)wrapper;
            return baseline.getBaselineConnection(monitor).configuration();
        }
        return null;
    }

    public static String convertToRegex(String text, boolean matchAnyAtBeginning, boolean matchAnyAtEnd) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (matchAnyAtBeginning && i == 0 && ch != '*') {
                buffer.append(".*");
            }
            switch (ch) {
                case '(': {
                    buffer.append("\\(");
                    break;
                }
                case ')': {
                    buffer.append("\\)");
                    break;
                }
                case '[': {
                    buffer.append("\\[");
                    break;
                }
                case ']': {
                    buffer.append("\\]");
                    break;
                }
                case '*': {
                    buffer.append(".*");
                    break;
                }
                case '?': {
                    buffer.append(".");
                    break;
                }
                case '.': {
                    buffer.append("\\.");
                    break;
                }
                case '\\': {
                    buffer.append("\\\\");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            if (matchAnyAtEnd && i == text.length() - 1 && ch != '*') {
                buffer.append(".*");
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String reverseConvertToQueryPattern(String text) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            switch (ch) {
                case '%': {
                    buffer.append("*");
                    break;
                }
                case '_': {
                    buffer.append("?");
                    break;
                }
                case '\\': {
                    try {
                        if ('%' == text.charAt(i + 1)) {
                            buffer.append("%");
                            ++i;
                            break;
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    try {
                        if ('_' == text.charAt(i + 1)) {
                            buffer.append("_");
                            ++i;
                            break;
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    try {
                        if ('\\' == text.charAt(i + 1)) {
                            buffer.append("\\");
                            ++i;
                            break;
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                default: {
                    buffer.append(ch);
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

