/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.rcp.core.internal.resources.IRepositoryProviderMappingEvent;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class WorkingSetUtils
implements IListener {
    private void updateWorkingSets(Collection<IResource> resouces, IProgressMonitor monitor) {
        HashMap<ItemId, HashSet<IResource>> componentsToProjects = new HashMap<ItemId, HashSet<IResource>>();
        HashMap reposToComponents = new HashMap();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(resouces.size() + 50));
        for (IResource resource : resouces) {
            ISharingDescriptor sharingDescriptor;
            IShare share;
            IShareable shareable = (IShareable)resource.getAdapter(IShareable.class);
            if (shareable == null) continue;
            try {
                share = shareable.getShare((IProgressMonitor)progress.newChild(1));
            }
            catch (FileSystemException e) {
                throw TempHelper.throwEx((TeamRepositoryException)((Object)e));
            }
            if (share == null || (sharingDescriptor = share.getSharingDescriptor()) == null || !sharingDescriptor.associatedWithWorkspace()) continue;
            IComponentHandle componentHandle = sharingDescriptor.getComponent();
            ITeamRepository repo = RepositoryUtils.getTeamRepositoryById((UUID)sharingDescriptor.getRepositoryId());
            if (repo == null) continue;
            HashSet<ItemId> components = (HashSet<ItemId>)reposToComponents.get(repo);
            if (components == null) {
                components = new HashSet<ItemId>();
                reposToComponents.put(repo, components);
            }
            ItemId componentItemId = new ItemId((IItemHandle)componentHandle);
            components.add(componentItemId);
            HashSet<IResource> projects = (HashSet<IResource>)componentsToProjects.get(componentItemId);
            if (projects == null) {
                projects = new HashSet<IResource>();
                componentsToProjects.put(componentItemId, projects);
            }
            projects.add(resource);
        }
        try {
            if (componentsToProjects.size() > 0) {
                progress.setWorkRemaining(componentsToProjects.size());
                HashMap<ItemId, String> componentNames = new HashMap<ItemId, String>();
                for (Map.Entry entry : reposToComponents.entrySet()) {
                    ITeamRepository repo = (ITeamRepository)entry.getKey();
                    Set componentIds = (Set)entry.getValue();
                    Map fetched = RepoFetcher.fetchCurrents((ITeamRepository)repo, (Collection)componentIds, (boolean)false, (IProgressMonitor)progress.newChild(1));
                    for (Map.Entry entry2 : fetched.entrySet()) {
                        componentNames.put((ItemId)entry2.getKey(), ((IComponent)entry2.getValue()).getName());
                    }
                }
                for (Map.Entry entry : componentsToProjects.entrySet()) {
                    String name = (String)componentNames.get(entry.getKey());
                    if (name == null) continue;
                    IResource[] projects = ((Set)entry.getValue()).toArray(new IResource[((Set)entry.getValue()).size()]);
                    this.createWorkingSets(name, projects);
                }
            }
        }
        catch (NotLoggedInException componentNames) {
        }
        catch (ConnectionException componentNames) {
        }
        catch (TeamRepositoryException e) {
            StatusUtil.log((Object)this, (String)"Unable to update working sets with new projects", (Throwable)e);
        }
    }

    private void createWorkingSets(final String workingSetName, final IResource[] resources) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
                    IWorkingSet oldSet = manager.getWorkingSet(workingSetName);
                    if (oldSet == null) {
                        IWorkingSet newSet = manager.createWorkingSet(workingSetName, (IAdaptable[])resources);
                        newSet.setId("org.eclipse.ui.resourceWorkingSetPage");
                        manager.addWorkingSet(newSet);
                    } else {
                        LinkedHashSet<IAdaptable> resourcesToAdd = new LinkedHashSet<IAdaptable>(Arrays.asList(oldSet.getElements()));
                        boolean modified = false;
                        int i = 0;
                        while (i < resources.length) {
                            modified |= resourcesToAdd.add((IAdaptable)resources[i]);
                            ++i;
                        }
                        if (modified) {
                            oldSet.setElements(resourcesToAdd.toArray(new IAdaptable[resourcesToAdd.size()]));
                        }
                    }
                }
                catch (IllegalStateException e) {
                    return;
                }
            }
        });
    }

    public void handleEvents(List events) {
        ArrayList<Object> toNotify = new ArrayList<IResource>();
        for (IEvent candidate : events) {
            IRepositoryProviderMappingEvent event;
            IProject project;
            if (!(candidate instanceof IRepositoryProviderMappingEvent) || RepositoryProvider.getProvider((IProject)(project = (event = (IRepositoryProviderMappingEvent)candidate).getProject()), (String)"com.ibm.team.filesystem.rcp.core.provider") == null) continue;
            if (toNotify == null) {
                toNotify = new ArrayList();
            }
            toNotify.add((IResource)project);
        }
        if (toNotify != null) {
            ArrayList<IResource> projects = toNotify;
            Job job = this.updateWorkingSetsJob(projects);
            job.schedule();
        }
    }

    private Job updateWorkingSetsJob(final Collection<IResource> projects) {
        Job job = new Job(Messages.WorkingSetUtils_UpdateJobName){

            protected IStatus run(IProgressMonitor monitor) {
                WorkingSetUtils.this.updateWorkingSets(projects, monitor);
                return Status.OK_STATUS;
            }
        };
        return job;
    }
}

