/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.AutoResolveConflictsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.OpenPortEditorAction;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.ListDetailsDialog;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.gap.GapFillingDialog;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.lock.LockPreventsDeliverDialog;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.ui.internal.util.StandardAutoResolveDilemmaHandler;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnOutOfSync;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.AcceptFailedPart;
import com.ibm.team.filesystem.ui.changes.actions.ApplyAsPatchAction;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.DecoratingWorkspaceComponentLabelProvider;
import com.ibm.team.internal.filesystem.ui.util.LocksByContributor;
import com.ibm.team.internal.filesystem.ui.util.WarnAutoResolveDilemmaHandler;
import com.ibm.team.internal.filesystem.ui.util.WarnBackupUserWithConsole;
import com.ibm.team.internal.filesystem.ui.util.WarnCommitUser;
import com.ibm.team.internal.filesystem.ui.util.WarnUpdateCurrentPortDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class WarnWorkspaceUpdate
extends WorkspaceUpdateDilemmaHandler {
    private WarnBackupUserWithConsole backupHandler;
    private final WarnOutOfSync warnOutOfSync;
    private final WarnCommitUser warnCommitUser;
    private final WarnUpdateCurrentPortDilemmaHandler warnUpdateCurrentPort;
    protected final UIContext context;
    private String uncheckedInChangesMsg;
    private String checkinAndAcceptButtonMsg;
    private String acceptButtonMsg;
    private String[] yesNoButtons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};

    public WarnWorkspaceUpdate(UIContext context, String title, String uncheckedInChangesMsg, String checkinAndAcceptButtonMsg, String acceptButtonMsg) {
        this.context = context;
        this.backupHandler = new WarnBackupUserWithConsole(context.getShell(), title);
        this.warnOutOfSync = new WarnOutOfSync(context.getShell(), title, (BackupDilemmaHandler)this.backupHandler);
        this.warnCommitUser = new WarnCommitUser(context.getShell(), title, (BackupDilemmaHandler)this.backupHandler);
        this.warnUpdateCurrentPort = new WarnAutoResolveDilemmaHandler(context.getShell());
        this.uncheckedInChangesMsg = uncheckedInChangesMsg;
        this.checkinAndAcceptButtonMsg = checkinAndAcceptButtonMsg;
        this.acceptButtonMsg = acceptButtonMsg;
        this.setFileContentMerger(FileSystemResourcesPlugin.getConfiguredExternalFileContentMerger());
    }

    public WarnWorkspaceUpdate(UIContext context, String title) {
        this(context, title, Messages.PreferencesListener_11, Messages.PreferencesListener_12, Messages.PreferencesListener_13);
    }

    private int getIndexOfYesButton() {
        int i = 0;
        while (i < this.yesNoButtons.length) {
            if (IDialogConstants.YES_LABEL.equals(this.yesNoButtons[i])) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private int getIndexOfNoButton() {
        int i = 0;
        while (i < this.yesNoButtons.length) {
            if (IDialogConstants.NO_LABEL.equals(this.yesNoButtons[i])) {
                return i;
            }
            ++i;
        }
        return 1;
    }

    public static IPreferenceStore getPreferences() {
        IPreferenceStore result = UiPlugin.getDefault().getPreferenceStore();
        return result;
    }

    public int activeChangeSets(IWorkspaceConnection workspace, Collection<IChangeSetHandle> activeChangeSets) {
        return super.activeChangeSets(workspace, activeChangeSets);
    }

    public int activeChangeSetsOverlap(IWorkspaceConnection workspace, Collection<? extends IChangeSetHandle> activeChangeSets) {
        return super.activeChangeSetsOverlap(workspace, activeChangeSets);
    }

    public int activeChangeSetsComponent(IWorkspaceConnection workspace, IComponentHandle component, Collection<? extends IChangeSetHandle> activeChangeSets) {
        int returnCode = 0;
        final boolean[] result = new boolean[1];
        this.context.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = MessageDialog.open((int)5, (Shell)WarnWorkspaceUpdate.this.context.getShell(), (String)Messages.WarnWorkspaceUpdate_ActiveChangeSetsComponent_Title, (String)Messages.WarnWorkspaceUpdate_ActiveChangeSetsComponent_Message, (int)0);
            }
        });
        returnCode = result[0] ? 0 : 1;
        return returnCode;
    }

    public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
        return this.warnOutOfSync;
    }

    public UpdateCurrentPatchDilemmaHandler getUpdateCurrentPortDilemmaHandler() {
        return this.warnUpdateCurrentPort;
    }

    public int componentReplacementCandidates(Collection<ConfigurationFacade> replaceConfigurations) {
        return super.componentReplacementCandidates(replaceConfigurations);
    }

    public int componentsToBeAddedOrRemoved(Collection<ConfigurationFacade> added, Collection<ConfigurationFacade> removed) {
        return 0;
    }

    public int disconnectedComponents(Collection<ConfigurationFacade> configurations) {
        boolean onlyStreams = true;
        for (ConfigurationFacade configuration : configurations) {
            IWorkspace workspace;
            IConnection connection = configuration.getCachedConnection();
            if (!(connection instanceof IWorkspaceConnection) || (workspace = ((IWorkspaceConnection)connection).getResolvedWorkspace()).isStream()) continue;
            onlyStreams = false;
            break;
        }
        if (onlyStreams) {
            return 0;
        }
        final IPreferenceStore store = WarnWorkspaceUpdate.getPreferences();
        String prefKey = "warn_disconnected_components";
        boolean prompt = store.getBoolean("warn_disconnected_components");
        final boolean[] proceed = new boolean[]{true};
        if (prompt) {
            this.context.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)WarnWorkspaceUpdate.this.context.getShell(), (String)Messages.PreferencesListener_16, (String)Messages.PreferencesListener_17, (String)Messages.PreferencesListener_18, (boolean)false, null, null);
                    if (dialog.getReturnCode() == 0) {
                        store.setValue("warn_disconnected_components", !dialog.getToggleState());
                    } else {
                        proceed[0] = false;
                    }
                }
            });
        }
        return proceed[0] ? 0 : 1;
    }

    public int portInProgress(IWorkspaceConnection workspace, final List<IChangeSetHandle> changeSetsWithGap) {
        final boolean[] proceed = new boolean[1];
        this.context.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                String message = changeSetsWithGap != null && changeSetsWithGap.size() == 1 ? Messages.WarnWorkspaceUpdate_Port_In_Progress_Message_Single : Messages.WarnWorkspaceUpdate_Port_In_Progress_Message_Plural;
                proceed[0] = MessageDialog.openConfirm((Shell)WarnWorkspaceUpdate.this.context.getShell(), (String)Messages.WarnWorkspaceUpdate_Port_In_Progress_Title, (String)message);
            }
        });
        return proceed[0] ? 0 : 1;
    }

    public int gap(IWorkspaceConnection workspace, List<IChangeSetHandle> changeSetsWithGapHandles, boolean handlingSuspended) {
        int returnCode = 2;
        returnCode = this.isPortingEnabled() ? this.promptToPort(changeSetsWithGapHandles) : this.promptToApplyPatch(workspace, changeSetsWithGapHandles);
        return returnCode;
    }

    public int gap(IWorkspaceConnection workspace, List<IChangeSetHandle> changeSetsWithGap, Map<IComponentHandle, List<IChangeSetHandle>> gapFillingChangeSets, boolean handlingSuspended) {
        int returnCode = 2;
        returnCode = this.isPortingEnabled() ? this.promptToFillGaps(workspace, changeSetsWithGap, gapFillingChangeSets, handlingSuspended) : this.gap(workspace, changeSetsWithGap, handlingSuspended);
        return returnCode;
    }

    private int promptToApplyPatch(final IWorkspaceConnection workspace, final List<IChangeSetHandle> changeSetsWithGapHandles) {
        UIJob job = new UIJob(Messages.PreferencesListener_0){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Parts.openDialog((Shell)WarnWorkspaceUpdate.this.context.getShell(), (Object)new IPartResult(){

                    public void setResult(Object result) {
                        if (result == AcceptFailedPart.APPLY_PATCH.getValue()) {
                            ApplyAsPatchAction.applyAsPatch((this).WarnWorkspaceUpdate.this.context, workspace, changeSetsWithGapHandles);
                        }
                    }
                }, (IPartFactory)AcceptFailedPart.acceptFailedGapsPart());
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return 1;
    }

    private int promptToPort(final List<IChangeSetHandle> changeSetsWithGapHandles) {
        final boolean[] proceed = new boolean[1];
        this.context.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                String dialogTitle = Messages.WarnWorkspaceUpdate_PortTitle;
                String dialogMessage = changeSetsWithGapHandles != null && changeSetsWithGapHandles.size() == 1 ? Messages.WarnWorkspaceUpdate_Port_Message_Single : Messages.WarnWorkspaceUpdate_Port_Message_Plural;
                String[] buttons = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
                String helpID = "com.ibm.team.filesystem.ide.ui.dialog_acceptwithgap";
                proceed[0] = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMessage, (String[])buttons, (int)5, (int)0, (String)helpID) == 0;
            }
        });
        return proceed[0] ? 0 : 1;
    }

    private int promptToFillGaps(final IWorkspaceConnection workspace, final List<IChangeSetHandle> changeSetsWithGap, final Map<IComponentHandle, List<IChangeSetHandle>> gapFillingChangeSets, final boolean handlingSuspended) {
        final int[] returnCode = new int[]{1};
        this.context.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                GapFillingDialog gapFillingDialog = new GapFillingDialog(WarnWorkspaceUpdate.this.context, workspace, changeSetsWithGap, gapFillingChangeSets, handlingSuspended, (IOperationRunner)new JobRunner(true));
                gapFillingDialog.open();
                returnCode[0] = gapFillingDialog.getReturnCode();
            }
        });
        switch (returnCode[0]) {
            case 0: {
                return 3;
            }
            case 2: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 1;
    }

    private boolean isPortingEnabled() {
        return true;
    }

    public CommitDilemmaHandler getCommitDilemmaHandler() {
        return this.warnCommitUser;
    }

    public int staleData(IWorkspaceConnection workspaceConnection, IWorkspaceConnection sourceWorkspaceConnection) {
        return super.staleData(workspaceConnection, sourceWorkspaceConnection);
    }

    public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> changes) {
        DialogUtil.pauseIfNeededBeforeShowingDialog();
        int code = JFaceUtils.showMessageButtonsBlocking((String)Messages.PreferencesListener_10, (String)this.uncheckedInChangesMsg, (String[])new String[]{this.checkinAndAcceptButtonMsg, this.acceptButtonMsg, Messages.PreferencesListener_14}, (int)4, (int)0, (String)"com.ibm.team.filesystem.ide.ui.dialog_localchangesaccept");
        if (code == 1) {
            return 3;
        }
        if (code == -1 || code == 2) {
            return 1;
        }
        return 0;
    }

    public BackupDilemmaHandler getBackupDilemmaHandler() {
        return this.backupHandler;
    }

    public int deletedContent(Collection<IShareable> contentDeleted) {
        return this.warnOutOfSync.deletedContent(contentDeleted);
    }

    public int inaccessibleForUpdate(Collection<IShareable> shareables) {
        return this.warnCommitUser.inaccessibleForUpdate(shareables);
    }

    public int siblingSharesToAdd(Collection<IShareable> shareables) {
        return this.warnCommitUser.siblingSharesToAdd(shareables);
    }

    public void currentPortsPresent(final IWorkspaceConnection workspace, List<IComponentHandle> components, IProgressMonitor monitor) {
        try {
            final List items = workspace.teamRepository().itemManager().fetchCompleteItems(components, 0, monitor);
            UIJob job = new UIJob(Messages.PreferencesListener_0){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    for (Object component : items) {
                        OpenPortEditorAction.openPortEditor(WarnWorkspaceUpdate.this.context.getPage(), workspace, (IComponent)component);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        catch (TeamRepositoryException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
    }

    public void locksWereHeld(Map<IStreamLockReport, IWorkspaceConnection> locks) {
        if (locks.isEmpty()) {
            return;
        }
        if (PlatformUI.isWorkbenchRunning()) {
            Collection<LocksByContributor> locksByContributor = LocksByContributor.getLocks(locks);
            LockPreventsDeliverDialog dialog = new LockPreventsDeliverDialog(this.context.getShell(), Messages.WarnDeliverUser_14, WarnWorkspaceUpdate.getLocksWereHeldMessage(locksByContributor), Messages.WarnResumeUser_LOCKS_HELD_BY_OTHER_USERS, 8, locks, DetailsDialog.ButtonBar.OkDetails);
            dialog.setDefaultButtonId(0);
            dialog.initializeToggleButtonDontShowMeThisAgain(null, null);
            dialog.open(this.context.getShell().getDisplay());
        }
    }

    private static String getLocksWereHeldMessage(Collection<LocksByContributor> locksByContributor) {
        return LocksByContributor.getLocksHeldMsg(locksByContributor, Messages.WarnResumeUser_6, Messages.WarnResumeUser_7, Messages.WarnResumeUser_8, Messages.WarnResumeUser_9);
    }

    public Map<IStreamLockReport, IWorkspaceConnection> locksToAcquire(Map<IStreamLockReport, IWorkspaceConnection> locks) {
        if (locks.isEmpty()) {
            return locks;
        }
        if (PlatformUI.isWorkbenchRunning()) {
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            LockPreventsDeliverDialog dialog = new LockPreventsDeliverDialog(this.context.getShell(), Messages.WarnResumeUser_4, Messages.WarnResumeUser_5, Messages.WarnResumeUser_LOCKS_TO_ACQUIRE, 2, locks, DetailsDialog.ButtonBar.YesNoDetails);
            dialog.initializeToggleButtonRememberMyDecision(WarnWorkspaceUpdate.getPreferences(), "resume_locksToRelease");
            dialog.setDefaultButtonId(3);
            int code = dialog.openOrGetPreference(this.context.getShell().getDisplay());
            switch (code) {
                case 2: {
                    return locks;
                }
            }
        }
        return Collections.emptyMap();
    }

    public int nWayConflict(IWorkspaceConnection workspaceConnection, IComponent component, List<IBaseline> affectedBaselines, IProgressMonitor monitor) {
        DialogUtil.pauseIfNeededBeforeShowingDialog();
        String message = component == null ? Messages.WarnWorkspaceUpdate_0 : NLS.bind((String)Messages.WarnWorkspaceUpdate_1, (Object)component.getName());
        int code = JFaceUtils.showMessageButtonsBlocking((String)Messages.WarnWorkspaceUpdate_2, (String)message, (String[])new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, (int)4, (int)0, (String)"com.ibm.team.filesystem.ide.ui.dialog_localchangesaccept");
        if (code == -1 || code == 1) {
            return 1;
        }
        return 0;
    }

    public int noBackupBaselineForComponent(Collection<ConfigurationFacade> configurations, IProgressMonitor monitor) {
        if (PlatformUI.isWorkbenchRunning()) {
            String dialogTitle = Messages.WarnWorkspaceUpdate_NoBackupBaselineForComponentDialogTitle;
            String dialogMessage = Messages.WarnWorkspaceUpdate_NoBackupBaselineForComponentDialogMessage;
            int yesButtonIndex = this.getIndexOfYesButton();
            int noButtonIndex = this.getIndexOfNoButton();
            int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMessage, (String[])this.yesNoButtons, (int)4, (int)noButtonIndex);
            if (code == yesButtonIndex) {
                return 0;
            }
        }
        return 1;
    }

    public int noBackupBaselineForReplace(Collection<ConfigurationFacade> configurations, IProgressMonitor monitor) {
        if (PlatformUI.isWorkbenchRunning()) {
            final boolean[] proceed = new boolean[]{true};
            final IPreferenceStore store = WarnWorkspaceUpdate.getPreferences();
            String prefKey = "warn_no_backup_baseline_before_replace";
            boolean prompt = store.getBoolean("warn_no_backup_baseline_before_replace");
            if (prompt) {
                final String dialogTitle = WarnWorkspaceUpdate.getNoBackupBaselineForReplaceTitle();
                String tempDialogMessage = WarnWorkspaceUpdate.getNoBackupBaselineForReplacePluralMessage();
                if (configurations.size() == 1) {
                    try {
                        ConfigurationFacade configuration = configurations.iterator().next();
                        IComponentHandle componentHandle = configuration.getComponentHandle();
                        IComponent component = (IComponent)configuration.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, monitor);
                        tempDialogMessage = WarnWorkspaceUpdate.getNoBackupBaselineForReplaceSingleMessage(component);
                    }
                    catch (TeamRepositoryException configuration) {
                        // empty catch block
                    }
                }
                final String dialogMessage = tempDialogMessage;
                this.context.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialogWithToggle dialog = new MessageDialogWithToggle(WarnWorkspaceUpdate.this.context.getShell(), dialogTitle, null, dialogMessage, 4, WarnWorkspaceUpdate.this.yesNoButtons, WarnWorkspaceUpdate.this.getIndexOfNoButton(), Messages.PreferencesListener_18, false);
                        dialog.open();
                        if (dialog.getReturnCode() == 2) {
                            store.setValue("warn_no_backup_baseline_before_replace", !dialog.getToggleState());
                        } else {
                            proceed[0] = false;
                        }
                    }
                });
            }
            return proceed[0] ? 0 : 1;
        }
        return 1;
    }

    public static String getNoBackupBaselineForReplaceTitle() {
        return Messages.WarnWorkspaceUpdate_NoBackupBaselineForReplaceDialogTitle;
    }

    public static String getNoBackupBaselineForReplaceSingleMessage(IComponent component) {
        return NLS.bind((String)Messages.WarnWorkspaceUpdate_NoBackupBaselineForReplaceDialogMessageSingular, (Object)component.getName());
    }

    public static String getNoBackupBaselineForReplacePluralMessage() {
        return Messages.WarnWorkspaceUpdate_NoBackupBaselineForReplaceDialogMessagePlural;
    }

    public static String getNoBackupBaselineForRemoveTitle() {
        return Messages.WarnWorkspaceUpdate_NoBackupBaselineForRemoveDialogTitle;
    }

    public static String getNoBackupBaselineForRemoveSingleMessage(IComponent component) {
        return NLS.bind((String)Messages.WarnWorkspaceUpdate_NoBackupBaselineForRemoveDialogMessageSingular, (Object)component.getName());
    }

    public static String getNoBackupBaselineForRemovePluralMessage() {
        return Messages.WarnWorkspaceUpdate_NoBackupBaselineForRemoveDialogMessagePlural;
    }

    public int componentInMultipleHierarchies(IWorkspaceConnection workspace, Collection<IComponentHandle> selectedComponents, Collection<IComponentHandle> subcomponents, IProgressMonitor monitor) {
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbenchPage page;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            final String dialogTitle = this.getComponentsInMultipleHierarchiesDialogTitle(selectedComponents, subcomponents);
            final String dialogMessage = Messages.WarnWorkspaceUpdate_ComponentInMultipleHierarchiesDialogMessage;
            IWorkbenchPage iWorkbenchPage = page = this.context.getPage() != null ? this.context.getPage() : JFaceUtils.getWorkbenchPage();
            if (page != null && page.getWorkbenchWindow().getShell() != null) {
                final Shell shell = page.getWorkbenchWindow().getShell();
                try {
                    ArrayList<IComponentHandle> allComponents = new ArrayList<IComponentHandle>(selectedComponents.size() + subcomponents.size());
                    allComponents.addAll(selectedComponents);
                    allComponents.addAll(subcomponents);
                    final Set<WorkspaceComponentWrapper> allWrappers = WorkspaceComponentWrapper.getWrappersFromComponentHandles(workspace, allComponents, (IProgressMonitor)progress.newChild(100));
                    final int[] dialogResult = new int[]{3};
                    shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ListDetailsDialog dialog = new ListDetailsDialog(shell, dialogTitle, dialogMessage, 8, DetailsDialog.ButtonBar.YesNoDetails, allWrappers);
                            dialog.setDefaultButtonId(3);
                            dialog.setLabelProvider((IBaseLabelProvider)new DecoratingWorkspaceComponentLabelProvider());
                            dialogResult[0] = dialog.open();
                        }
                    });
                    if (dialogResult[0] == 2) {
                        return 0;
                    }
                    return 1;
                }
                catch (TeamRepositoryException e) {
                    StatusUtil.log((Object)((Object)this), (Throwable)e);
                }
            }
            int yesButtonIndex = this.getIndexOfYesButton();
            int noButtonIndex = this.getIndexOfNoButton();
            int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMessage, (String[])this.yesNoButtons, (int)4, (int)noButtonIndex);
            if (code == yesButtonIndex) {
                return 0;
            }
        }
        return 1;
    }

    public int componentInMultipleHierarchiesForReplace(IWorkspaceConnection workspace, Collection<IComponentHandle> selectedComponents, Collection<IComponentHandle> subcomponents, Collection<Object> initialSelection, IProgressMonitor monitor) {
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbenchPage page;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            final String dialogTitle = this.getComponentsInMultipleHierarchiesDialogTitle(selectedComponents, subcomponents);
            final String dialogMessage = this.getComponentsInMultipleHierarchiesForReplaceDialogMessage(workspace, selectedComponents, subcomponents, initialSelection, (IProgressMonitor)progress.newChild(20));
            IWorkbenchPage iWorkbenchPage = page = this.context.getPage() != null ? this.context.getPage() : JFaceUtils.getWorkbenchPage();
            if (page != null && page.getWorkbenchWindow().getShell() != null) {
                final Shell shell = page.getWorkbenchWindow().getShell();
                try {
                    ArrayList<IComponentHandle> allComponents = new ArrayList<IComponentHandle>(selectedComponents.size() + subcomponents.size());
                    allComponents.addAll(selectedComponents);
                    allComponents.addAll(subcomponents);
                    final Set<WorkspaceComponentWrapper> allWrappers = WorkspaceComponentWrapper.getWrappersFromComponentHandles(workspace, allComponents, (IProgressMonitor)progress.newChild(80));
                    final int[] dialogResult = new int[]{3};
                    shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ListDetailsDialog dialog = new ListDetailsDialog(shell, dialogTitle, dialogMessage, 8, DetailsDialog.ButtonBar.YesNoDetails, allWrappers);
                            dialog.setDefaultButtonId(3);
                            dialog.setLabelProvider((IBaseLabelProvider)new DecoratingWorkspaceComponentLabelProvider());
                            dialogResult[0] = dialog.open();
                        }
                    });
                    if (dialogResult[0] == 2) {
                        return 0;
                    }
                    return 1;
                }
                catch (TeamRepositoryException e) {
                    StatusUtil.log((Object)((Object)this), (Throwable)e);
                }
            }
            int yesButtonIndex = this.getIndexOfYesButton();
            int noButtonIndex = this.getIndexOfNoButton();
            int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMessage, (String[])this.yesNoButtons, (int)4, (int)noButtonIndex);
            if (code == yesButtonIndex) {
                return 0;
            }
        }
        return 1;
    }

    private String getComponentsInMultipleHierarchiesDialogTitle(Collection<IComponentHandle> selectedComponents, Collection<IComponentHandle> subcomponents) {
        return selectedComponents.size() + subcomponents.size() == 1 ? Messages.WarnWorkspaceUpdate_ComponentInMultipleHierarchiesDialogTitle : Messages.WarnWorkspaceUpdate_ComponentsInMultipleHierarchiesDialogTitle;
    }

    private String getComponentsInMultipleHierarchiesForReplaceDialogMessage(IWorkspaceConnection workspace, Collection<IComponentHandle> selectedComponents, Collection<IComponentHandle> subcomponents, Collection<Object> initialSelection, IProgressMonitor monitor) {
        String message;
        block28: {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            message = Messages.WarnWorkspaceUpdate_ComponentInMultipleHierarchiesForReplaceDialogDefaultMessage;
            ITeamRepository repo = workspace.teamRepository();
            if (!selectedComponents.isEmpty() && subcomponents.isEmpty()) {
                if (selectedComponents.size() == 1) {
                    try {
                        IComponentHandle componentHandle = selectedComponents.iterator().next();
                        IComponent component = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progress.newChild(100));
                        String componentName = component.getName();
                        message = NLS.bind((String)Messages.WarnWorkspaceUpdate_ComponentInMultipleHierarchiesForReplaceDialogMessage, (Object)componentName);
                    }
                    catch (TeamRepositoryException componentHandle) {}
                } else {
                    message = selectedComponents.size() == initialSelection.size() ? Messages.WarnWorkspaceUpdate_AllComponentsInMultipleHierarchiesForReplaceDialogMessage : Messages.WarnWorkspaceUpdate_SomeComponentsInMultipleHierarchiesForReplaceDialogMessage;
                }
            } else if (selectedComponents.isEmpty() && !subcomponents.isEmpty()) {
                if (subcomponents.size() == 1) {
                    try {
                        IComponentHandle subcomponentHandle = subcomponents.iterator().next();
                        IComponent subcomponent = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)subcomponentHandle, 0, (IProgressMonitor)progress.newChild(100));
                        String subcomponentName = subcomponent.getName();
                        message = NLS.bind((String)Messages.WarnWorkspaceUpdate_SubcomponentInMultipleHierarchiesForReplaceDialogMessage, (Object)subcomponentName);
                    }
                    catch (TeamRepositoryException subcomponentHandle) {}
                } else {
                    message = Messages.WarnWorkspaceUpdate_SubcomponentsInMultipleHierarchiesForReplaceDialogMessage;
                }
            } else if (selectedComponents.size() == 1 && subcomponents.size() == 1) {
                try {
                    IComponentHandle componentHandle = selectedComponents.iterator().next();
                    IComponentHandle subcomponentHandle = subcomponents.iterator().next();
                    List components = repo.itemManager().fetchCompleteItems(Arrays.asList(componentHandle, subcomponentHandle), 0, (IProgressMonitor)progress.newChild(100));
                    String componentName = null;
                    String subcomponentName = null;
                    for (Object o : components) {
                        if (!(o instanceof IComponent)) continue;
                        IComponent c = (IComponent)o;
                        if (c.sameItemId((IItemHandle)componentHandle)) {
                            componentName = c.getName();
                            continue;
                        }
                        if (!c.sameItemId((IItemHandle)subcomponentHandle)) continue;
                        subcomponentName = c.getName();
                    }
                    if (componentName != null && subcomponentName != null) {
                        message = NLS.bind((String)Messages.WarnWorkspaceUpdate_MixedComponentsInMultipleHierarchiesForReplaceDialogMessage1, componentName, subcomponentName);
                    }
                }
                catch (TeamRepositoryException componentHandle) {}
            } else if (selectedComponents.size() == 1 && subcomponents.size() > 1) {
                try {
                    IComponentHandle componentHandle = selectedComponents.iterator().next();
                    IComponent component = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progress.newChild(100));
                    String componentName = component.getName();
                    message = NLS.bind((String)Messages.WarnWorkspaceUpdate_MixedComponentsInMultipleHierarchiesForReplaceDialogMessage2, (Object)componentName);
                }
                catch (TeamRepositoryException componentHandle) {}
            } else if (selectedComponents.size() > 1 && subcomponents.size() == 1) {
                try {
                    IComponentHandle subcomponentHandle = subcomponents.iterator().next();
                    IComponent subcomponent = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)subcomponentHandle, 0, (IProgressMonitor)progress.newChild(100));
                    String subcomponentName = subcomponent.getName();
                    if (selectedComponents.size() == initialSelection.size()) {
                        message = NLS.bind((String)Messages.WarnWorkspaceUpdate_MixedComponentsInMultipleHierarchiesForReplaceDialogMessage3, (Object)subcomponentName);
                        break block28;
                    }
                    message = NLS.bind((String)Messages.WarnWorkspaceUpdate_MixedComponentsInMultipleHierarchiesForReplaceDialogMessage4, (Object)subcomponentName);
                }
                catch (TeamRepositoryException teamRepositoryException) {}
            } else {
                message = selectedComponents.size() == initialSelection.size() ? Messages.WarnWorkspaceUpdate_MixedComponentsInMultipleHierarchiesForReplaceDialogMessage5 : Messages.WarnWorkspaceUpdate_MixedComponentsInMultipleHierarchiesForReplaceDialogMessage6;
            }
        }
        return message;
    }

    public int inaccessibleComponentsNotInSeedWorkspace(Collection<ConfigurationFacade> inaccessibleComponents, IProgressMonitor monitor) {
        if (PlatformUI.isWorkbenchRunning()) {
            String dialogMessage;
            String dialogTitle = this.getInaccessibleComponentsNotInSeedWorkspaceDialogTitle(inaccessibleComponents);
            boolean isStream = false;
            ConfigurationFacade configuration = inaccessibleComponents.iterator().next();
            try {
                IWorkspaceConnection workspaceConnection = configuration.getWorkspaceConnection(monitor);
                isStream = workspaceConnection.isStream();
            }
            catch (TeamRepositoryException workspaceConnection) {
                // empty catch block
            }
            if (inaccessibleComponents.size() == 1) {
                String componentUUID = configuration.getComponentHandle().getItemId().getUuidValue();
                dialogMessage = isStream ? NLS.bind((String)Messages.WarnWorkspaceUpdate_InaccessibleSubcomponentNotInStreamDialogMessage, (Object)componentUUID) : NLS.bind((String)Messages.WarnWorkspaceUpdate_InaccessibleSubcomponentNotInWorkspaceDialogMessage, (Object)componentUUID);
            } else {
                dialogMessage = isStream ? Messages.WarnWorkspaceUpdate_InaccessibleSubcomponentsNotInStreamDialogMessage : Messages.WarnWorkspaceUpdate_InaccessibleSubcomponentsNotInWorkspaceDialogMessage;
            }
            int yesButtonIndex = this.getIndexOfYesButton();
            int noButtonIndex = this.getIndexOfNoButton();
            int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMessage, (String[])this.yesNoButtons, (int)4, (int)noButtonIndex);
            if (code == yesButtonIndex) {
                return 0;
            }
            return 1;
        }
        return 1;
    }

    public int inaccessibleComponentsNotInSeedWorkspaceForReplace(Collection<ConfigurationFacade> inaccessibleComponents, IProgressMonitor monitor) {
        if (PlatformUI.isWorkbenchRunning()) {
            String dialogMessage;
            String dialogTitle = this.getInaccessibleComponentsNotInSeedWorkspaceDialogTitle(inaccessibleComponents);
            boolean isStream = false;
            ConfigurationFacade configuration = inaccessibleComponents.iterator().next();
            try {
                IWorkspaceConnection workspaceConnection = configuration.getWorkspaceConnection(monitor);
                isStream = workspaceConnection.isStream();
            }
            catch (TeamRepositoryException workspaceConnection) {
                // empty catch block
            }
            if (inaccessibleComponents.size() == 1) {
                String componentUUID = configuration.getComponentHandle().getItemId().getUuidValue();
                dialogMessage = isStream ? NLS.bind((String)Messages.WarnWorkspaceUpdate_InaccessibleSubcomponentNotInStreamForReplaceDialogMessage, (Object)componentUUID) : NLS.bind((String)Messages.WarnWorkspaceUpdate_InaccessibleSubcomponentNotInWorkspaceForReplaceDialogMessage, (Object)componentUUID);
            } else {
                dialogMessage = isStream ? Messages.WarnWorkspaceUpdate_InaccessibleSubcomponentsNotInStreamForReplaceDialogMessage : Messages.WarnWorkspaceUpdate_InaccessibleSubcomponentsNotInWorkspaceForReplaceDialogMessage;
            }
            int yesButtonIndex = this.getIndexOfYesButton();
            int noButtonIndex = this.getIndexOfNoButton();
            int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMessage, (String[])this.yesNoButtons, (int)4, (int)noButtonIndex);
            if (code == yesButtonIndex) {
                return 0;
            }
            return 1;
        }
        return 1;
    }

    private String getInaccessibleComponentsNotInSeedWorkspaceDialogTitle(Collection<ConfigurationFacade> inaccessibleComponents) {
        return inaccessibleComponents.size() == 1 ? Messages.WarnWorkspaceUpdate_InaccessibleSubcomponentDialogTitle : Messages.WarnWorkspaceUpdate_InaccessibleSubcomponentsDialogTitle;
    }

    public boolean isAutoResolveEnabled() {
        return UiPlugin.getBooleanPreference("com.ibm.team.filesystem.ide.ui.prefs_attempt_to_auto_resolve_conflicts_on_accept");
    }

    public AutoResolveConflictsDilemmaHandler getAutoResolveConflictsDilemmaHandler() {
        return new StandardAutoResolveDilemmaHandler(this.context, true);
    }

    public void setConflictsAutoResolved(int numberOfConflictsResolved) {
        if (!PlatformUI.isWorkbenchRunning() || numberOfConflictsResolved < 1) {
            return;
        }
        String message = numberOfConflictsResolved == 1 ? Messages.WarnWorkspaceUpdate_3 : NLS.bind((String)Messages.WarnWorkspaceUpdate_4, (Object)numberOfConflictsResolved);
        JFaceUtils.showMessage((String)Messages.WarnWorkspaceUpdate_5, (String)message, (int)1);
    }

    public int changeSetAlreadyInHistoryDilemmaHandler() {
        boolean force = JFaceUtils.showMessageBlocking((String)Messages.ResumeAction_CS_AlreadyInHistoryHandler_Title, (String)Messages.ResumeAction_CS_AlreadyInHistoryHandler_Message, (String[])new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, (int)3);
        return force ? 0 : 3;
    }
}

