/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.ListDetailsDialog;
import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnCommitUser;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import com.ibm.team.scm.common.IVersionableChange;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class WarnUpdateCurrentPortDilemmaHandler
extends UpdateCurrentPatchDilemmaHandler {
    private final WarnCommitUser warnCommitUser;
    protected final Shell shell;

    public WarnUpdateCurrentPortDilemmaHandler(Shell shell) {
        String title = Messages.WarnUpdateCurrentPortDilemmaHandler_DILEMMA_TITLE;
        this.warnCommitUser = new WarnCommitUser(shell, title);
        this.shell = shell;
    }

    public CommitDilemmaHandler getCommitDilemmaHandler() {
        return this.warnCommitUser;
    }

    public int performAutoResolveForModificationsToMissing(IWorkspaceConnection workspace, IComponentHandle component, final List<IVersionableHandle> versionables) {
        DialogUtil.pauseIfNeededBeforeShowingDialog();
        final Display display = PlatformUI.getWorkbench().getDisplay();
        int[] result = new int[]{1};
        final int[] returnCode = new int[]{2};
        int prompt = -1;
        if (prompt == -1) {
            final ICurrentPatch currentPort = workspace.getCurrentPatch(component);
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    ListDetailsDialog dialog = new ListDetailsDialog(WarnUpdateCurrentPortDilemmaHandler.this.shell, Messages.WarnUpdateCurrentPortDilemmaHandler_AUTO_RESOLVE_OF_MISSING_FILES_DIALOG_TITLE, Messages.WarnUpdateCurrentPortDilemmaHandler_AUTO_RESOLVE_OF_MISSING_FILES_DIALOG_MESSAGE, 4, DetailsDialog.ButtonBar.YesNoDetails, versionables);
                    dialog.setLabelProvider((IBaseLabelProvider)new BaseLabelProvider(){

                        public void updateLabel(ViewerLabel label, Object element) {
                            if (element instanceof IVersionableHandle) {
                                IVersionableHandle vh = (IVersionableHandle)element;
                                IVersionableChange vc = currentPort.getVersionableChange(vh.getItemId());
                                String parent = PathUtils.getString((String[])vc.getParentPathHint());
                                String path = PathUtils.appendPath((String)parent, (String)vc.getName());
                                label.setText(path);
                            }
                        }
                    });
                    dialog.setDefaultButtonId(3);
                    dialog.openOrGetPreference(display);
                    returnCode[0] = dialog.getReturnCode();
                }
            });
        } else {
            returnCode[0] = prompt;
        }
        if (returnCode[0] == 2) {
            result[0] = 0;
        } else if (returnCode[0] == 3) {
            result[0] = 3;
        }
        return result[0];
    }
}

