/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UndoDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.lock.LockPreventsDeliverDialog;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnOutOfSync;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnBackupUserWithConsole;
import com.ibm.team.internal.filesystem.ui.util.WarnCommitUser;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class WarnUndoUser
extends UndoDilemmaHandler {
    protected final Shell shell;
    private WarnBackupUserWithConsole backupHandler;
    private OutOfSyncDilemmaHandler warnOutOfSync;
    private WarnCommitUser warnCommitUser;

    public WarnUndoUser(Shell shell, String title, boolean localChangesOnly) {
        this.shell = shell;
        this.backupHandler = new WarnBackupUserWithConsole(shell, title);
        this.warnOutOfSync = localChangesOnly ? new OutOfSyncDilemmaHandler(){

            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                return 0;
            }

            public boolean willIgnoreAllSharesOutOfSync() {
                return true;
            }
        } : new WarnOutOfSync(shell, title, (BackupDilemmaHandler)this.backupHandler);
        this.warnCommitUser = new WarnCommitUser(shell, title, (BackupDilemmaHandler)this.backupHandler);
    }

    public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
        return this.warnOutOfSync;
    }

    public BackupDilemmaHandler getBackupDilemmaHandler() {
        return this.backupHandler;
    }

    public int deletedContent(Collection<IShareable> contentDeleted) {
        return this.warnOutOfSync.deletedContent(contentDeleted);
    }

    public int inaccessibleForUpdate(Collection<IShareable> shareables) {
        return this.warnCommitUser.inaccessibleForUpdate(shareables);
    }

    public Map<IStreamLockReport, IWorkspaceConnection> locksToRelease(Map<IStreamLockReport, IWorkspaceConnection> locks) {
        if (locks.isEmpty()) {
            return locks;
        }
        if (PlatformUI.isWorkbenchRunning()) {
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            LockPreventsDeliverDialog dialog = new LockPreventsDeliverDialog(this.shell, Messages.WarnDeliverUser_14, Messages.WarnUndoUser_1, Messages.WarnDeliverUser_LOCKS_TO_RELEASE, 2, locks, DetailsDialog.ButtonBar.YesNoDetails);
            dialog.initializeToggleButtonRememberMyDecision(WarnUndoUser.getPreferences(), "undo_locksToRelease");
            dialog.setDefaultButtonId(3);
            int code = dialog.openOrGetPreference(this.shell.getDisplay());
            switch (code) {
                case 2: {
                    return locks;
                }
            }
        }
        return Collections.emptyMap();
    }

    public static IPreferenceStore getPreferences() {
        IPreferenceStore result = UiPlugin.getDefault().getPreferenceStore();
        return result;
    }
}

