/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.changes.dialogs.MessageDialogWithToggleAndButtonLabels;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnCommitUser;
import com.ibm.team.scm.client.internal.IConfigurationDescriptor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class WarnUnShareUser
extends UnshareDilemmaHandler {
    private Shell shell;
    private String title;
    private boolean isDeleteContent;

    public WarnUnShareUser(Shell shell, String title, boolean isDeleteContent) {
        this.shell = shell;
        this.title = title;
        this.isDeleteContent = isDeleteContent;
    }

    public CommitDilemmaHandler getCommitDilemmaHandler() {
        return new WarnCommitUser(this.shell, this.title);
    }

    public int uncheckedInChanges(Map<IConfigurationDescriptor, Collection<ILocalChange>> changes) {
        int result = 1;
        if (PlatformUI.isWorkbenchRunning()) {
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            boolean prompt = store.getInt("uncheckedInUnshareChanges") == 0;
            final int[] code = new int[]{3};
            final boolean[] toggle = new boolean[1];
            if (!prompt) {
                code[0] = store.getInt("uncheckedInUnshareChanges");
                switch (code[0]) {
                    case 2: {
                        result = 0;
                        break;
                    }
                    case 3: {
                        result = 3;
                    }
                }
            } else {
                Iterator<Map.Entry<IConfigurationDescriptor, Collection<ILocalChange>>> i = changes.entrySet().iterator();
                int count = 0;
                while (i.hasNext()) {
                    Map.Entry<IConfigurationDescriptor, Collection<ILocalChange>> entry = i.next();
                    count += entry.getValue().size();
                }
                final int changesCount = count;
                this.shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String message = WarnUnShareUser.this.isDeleteContent ? NLS.bind((String)Messages.WarnUnshareUser_2, (Object)changesCount) : NLS.bind((String)Messages.WarnUnshareUser_4, (Object)changesCount);
                        String checkinMessage = WarnUnShareUser.this.isDeleteContent ? Messages.WarnUnshareUser_0 : Messages.WarnUnshareUser_5;
                        String noCheckinMessage = WarnUnShareUser.this.isDeleteContent ? Messages.WarnUnshareUser_1 : Messages.WarnUnshareUser_6;
                        MessageDialogWithToggleAndButtonLabels dialog = new MessageDialogWithToggleAndButtonLabels(WarnUnShareUser.this.shell, Messages.WarnUnshareUser_3, null, message, 4, new String[]{checkinMessage, noCheckinMessage, IDialogConstants.CANCEL_LABEL}, 0, Messages.WarnDeliverUser_15, false);
                        code[0] = dialog.open();
                        toggle[0] = dialog.getToggleState();
                    }
                });
            }
            int prefValue = 0;
            if (code[0] == 0) {
                prefValue = 2;
                result = 0;
            } else if (code[0] == 1) {
                prefValue = 3;
                result = 3;
            }
            if (toggle[0]) {
                store.setValue("uncheckedInUnshareChanges", prefValue);
            }
        }
        return result;
    }
}

