/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.SuspendDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.lock.LockPreventsDeliverDialog;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnOutOfSync;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.changes.dialogs.MessageDialogWithToggleAndButtonLabels;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnBackupUserWithConsole;
import com.ibm.team.internal.filesystem.ui.util.WarnCommitUser;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class WarnSuspendUser
extends SuspendDilemmaHandler {
    private WarnBackupUserWithConsole backupHandler;
    private WarnOutOfSync outOfSyncHandler;
    private WarnCommitUser commitHandler;
    private Shell shell;

    public WarnSuspendUser(Shell shell, String title) {
        this.shell = shell;
        this.backupHandler = new WarnBackupUserWithConsole(shell, title);
        this.outOfSyncHandler = new WarnOutOfSync(shell, title, (BackupDilemmaHandler)this.backupHandler);
        this.commitHandler = new WarnCommitUser(shell, title, (BackupDilemmaHandler)this.backupHandler);
    }

    public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
        return this.outOfSyncHandler;
    }

    public BackupDilemmaHandler getBackupDilemmaHandler() {
        return this.backupHandler;
    }

    public CommitDilemmaHandler getCommitDilemmaHandler() {
        return this.commitHandler;
    }

    public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> changes) {
        int result = 1;
        if (PlatformUI.isWorkbenchRunning()) {
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            boolean prompt = store.getInt("uncheckedInChangesForSuspend") == 0;
            IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
            final boolean[] toggle = new boolean[1];
            final int[] code = new int[1];
            if (!prompt) {
                code[0] = store.getInt("uncheckedInChangesForSuspend") == 2 ? 0 : 1;
            } else {
                Iterator<Map.Entry<ConfigurationFacade, Collection<ILocalChange>>> i = changes.entrySet().iterator();
                int changesCount = 0;
                while (i.hasNext()) {
                    Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry = i.next();
                    changesCount += entry.getValue().size();
                }
                final String message = NLS.bind((String)Messages.WarnSuspendUser_1, (Object)changesCount);
                if (page != null) {
                    final Shell shell = page.getWorkbenchWindow().getShell();
                    shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialogWithToggleAndButtonLabels dialog = new MessageDialogWithToggleAndButtonLabels(shell, Messages.WarnSuspendUser_0, null, message, 4, new String[]{Messages.WarnSuspendUser_2, Messages.WarnSuspendUser_3, IDialogConstants.CANCEL_LABEL}, 0, Messages.WarnSuspendUser_RememberThisDecision, false);
                            code[0] = dialog.open();
                            toggle[0] = dialog.getToggleState();
                        }
                    });
                }
            }
            int prefValue = 0;
            if (code[0] == 0) {
                result = 0;
                prefValue = 2;
            } else if (code[0] == 1) {
                result = 3;
                prefValue = 3;
            }
            if (toggle[0]) {
                store.setValue("uncheckedInChangesForSuspend", prefValue);
            }
        }
        return result;
    }

    public int deletedContent(Collection<IShareable> contentDeleted) {
        return this.outOfSyncHandler.deletedContent(contentDeleted);
    }

    public int inaccessibleForUpdate(Collection<IShareable> shareables) {
        return this.commitHandler.inaccessibleForUpdate(shareables);
    }

    public int siblingSharesToAdd(Collection<IShareable> shareables) {
        return this.commitHandler.siblingSharesToAdd(shareables);
    }

    public Map<IStreamLockReport, IWorkspaceConnection> locksToRelease(Map<IStreamLockReport, IWorkspaceConnection> locks) {
        if (locks.isEmpty()) {
            return locks;
        }
        if (PlatformUI.isWorkbenchRunning()) {
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            LockPreventsDeliverDialog dialog = new LockPreventsDeliverDialog(this.shell, Messages.WarnDeliverUser_14, Messages.WarnSuspendUser_4, Messages.WarnDeliverUser_LOCKS_TO_RELEASE, 2, locks, DetailsDialog.ButtonBar.YesNoDetails);
            dialog.initializeToggleButtonRememberMyDecision(WarnSuspendUser.getPreferences(), "suspend_locksToRelease");
            dialog.setDefaultButtonId(3);
            int code = dialog.openOrGetPreference(this.shell.getDisplay());
            switch (code) {
                case 2: {
                    return locks;
                }
            }
        }
        return Collections.emptyMap();
    }

    public static IPreferenceStore getPreferences() {
        IPreferenceStore result = UiPlugin.getDefault().getPreferenceStore();
        return result;
    }
}

