/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ILineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ShareDilemmaHandler;
import com.ibm.team.filesystem.rcp.ui.internal.util.StatusDialog;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnBackupUserWithConsole;
import com.ibm.team.internal.filesystem.ui.util.WarnCommitUser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class WarnShareUser
extends ShareDilemmaHandler {
    private Shell shell;
    private String title;
    private BackupDilemmaHandler backupHandler;
    private WarnCommitUser warnCommitUser;

    public WarnShareUser(Shell shell, String title) {
        this.shell = shell;
        this.title = title;
        this.backupHandler = new WarnBackupUserWithConsole(shell, title);
        this.warnCommitUser = new WarnCommitUser(shell, title, this.backupHandler);
    }

    public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
        return new OutOfSyncDilemmaHandler(){

            public int outOfSync(final Collection<IShareOutOfSync> sharesOutOfSync) {
                if (sharesOutOfSync.isEmpty()) {
                    return 0;
                }
                final int[] result = new int[]{1};
                IShare[] shares = new IShare[sharesOutOfSync.size()];
                int i = 0;
                for (IShareOutOfSync shareOutOfSync : sharesOutOfSync) {
                    shares[i] = shareOutOfSync.getShare();
                    ++i;
                }
                if (PlatformUI.isWorkbenchRunning()) {
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            IStatus[] statuses = new IStatus[sharesOutOfSync.size()];
                            int i = 0;
                            for (IShareOutOfSync shareOutOfSync : sharesOutOfSync) {
                                String componentInfo = "";
                                ISharingDescriptor descriptor = shareOutOfSync.getShare().getSharingDescriptor();
                                if (descriptor != null) {
                                    componentInfo = NLS.bind((String)Messages.WarnShareUser_3, (Object)descriptor.getConnectionName(), (Object)descriptor.getComponentName());
                                }
                                statuses[i] = FileSystemStatusUtil.getStatusFor((int)1, (String)NLS.bind((String)Messages.WarnShareUser_4, (Object)shareOutOfSync.getShare().getPath(), (Object)componentInfo));
                                ++i;
                            }
                            Arrays.sort(statuses, new Comparator(){

                                public int compare(Object o1, Object o2) {
                                    String msg1 = ((IStatus)o1).getMessage();
                                    String msg2 = ((IStatus)o2).getMessage();
                                    return msg1.compareToIgnoreCase(msg2);
                                }
                            });
                            Object status = statuses.length > 1 ? new MultiStatus("com.ibm.team.filesystem.client", 4, statuses, NLS.bind((String)Messages.WarnShareUser_5, (Object)statuses.length), null) : statuses[0];
                            StatusDialog dialog = new StatusDialog(DialogUtil.checkShell(WarnShareUser.this.shell), WarnShareUser.this.title, Messages.WarnShareUser_0, "", status, 7);
                            if (dialog.open() == 0) {
                                result[0] = 0;
                            }
                        }
                    });
                }
                return result[0];
            }

            public boolean willIgnoreAllSharesOutOfSync() {
                return false;
            }

            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return WarnShareUser.this.backupHandler;
            }
        };
    }

    public BackupDilemmaHandler getBackupDilemmaHandler() {
        return this.backupHandler;
    }

    public int lineDelimiterErrors(Collection<? extends ILineDelimiterUploadFailure> failures, IProgressMonitor monitor) throws FileSystemException {
        return this.warnCommitUser.lineDelimiterErrors(failures, monitor);
    }
}

