/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ResumeDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.lock.LockPreventsDeliverDialog;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnOutOfSync;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.LocksByContributor;
import com.ibm.team.internal.filesystem.ui.util.WarnBackupUserWithConsole;
import com.ibm.team.internal.filesystem.ui.util.WarnCommitUser;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class WarnResumeUser
extends ResumeDilemmaHandler {
    private WarnBackupUserWithConsole backupHandler;
    private WarnOutOfSync outOfSyncHandler;
    private WarnCommitUser commitHandler;
    private Shell shell;

    public WarnResumeUser(Shell shell, String title) {
        this.shell = shell;
        this.backupHandler = new WarnBackupUserWithConsole(shell, title);
        this.outOfSyncHandler = new WarnOutOfSync(shell, title, (BackupDilemmaHandler)this.backupHandler);
        this.commitHandler = new WarnCommitUser(shell, title, (BackupDilemmaHandler)this.backupHandler);
    }

    public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
        return this.outOfSyncHandler;
    }

    public BackupDilemmaHandler getBackupDilemmaHandler() {
        return this.backupHandler;
    }

    public CommitDilemmaHandler getCommitDilemmaHandler() {
        return this.commitHandler;
    }

    public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> changes) {
        int result = 1;
        if (PlatformUI.isWorkbenchRunning()) {
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            int code = JFaceUtils.showMessageButtonsBlocking((String)Messages.WarnResumeUser_0, (String)Messages.WarnResumeUser_1, (String[])new String[]{Messages.WarnResumeUser_2, Messages.WarnResumeUser_3, IDialogConstants.CANCEL_LABEL}, (int)4, (int)0);
            if (code == 0) {
                result = 0;
            } else if (code == 1) {
                result = 3;
            }
        }
        return result;
    }

    public int deletedContent(Collection<IShareable> contentDeleted) {
        return this.outOfSyncHandler.deletedContent(contentDeleted);
    }

    public void locksWereHeld(Map<IStreamLockReport, IWorkspaceConnection> locks) {
        if (locks.isEmpty()) {
            return;
        }
        if (PlatformUI.isWorkbenchRunning()) {
            Collection<LocksByContributor> locksByContributor = LocksByContributor.getLocks(locks);
            LockPreventsDeliverDialog dialog = new LockPreventsDeliverDialog(this.shell, Messages.WarnDeliverUser_14, WarnResumeUser.getLocksWereHeldMessage(locksByContributor), Messages.WarnResumeUser_LOCKS_HELD_BY_OTHER_USERS, 8, locks, DetailsDialog.ButtonBar.OkDetails);
            dialog.setDefaultButtonId(0);
            dialog.initializeToggleButtonDontShowMeThisAgain(null, null);
            dialog.open(this.shell.getDisplay());
        }
    }

    private static String getLocksWereHeldMessage(Collection<LocksByContributor> locksByContributor) {
        return LocksByContributor.getLocksHeldMsg(locksByContributor, Messages.WarnResumeUser_6, Messages.WarnResumeUser_7, Messages.WarnResumeUser_8, Messages.WarnResumeUser_9);
    }

    public Map<IStreamLockReport, IWorkspaceConnection> locksToAcquire(Map<IStreamLockReport, IWorkspaceConnection> locks) {
        if (locks.isEmpty()) {
            return locks;
        }
        if (PlatformUI.isWorkbenchRunning()) {
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            LockPreventsDeliverDialog dialog = new LockPreventsDeliverDialog(this.shell, Messages.WarnResumeUser_4, Messages.WarnResumeUser_5, Messages.WarnResumeUser_LOCKS_TO_ACQUIRE, 2, locks, DetailsDialog.ButtonBar.YesNoDetails);
            dialog.initializeToggleButtonRememberMyDecision(WarnResumeUser.getPreferences(), "resume_locksToRelease");
            dialog.setDefaultButtonId(3);
            int code = dialog.openOrGetPreference(this.shell.getDisplay());
            switch (code) {
                case 2: {
                    return locks;
                }
            }
        }
        return Collections.emptyMap();
    }

    public int changeSetAlreadyInHistoryDilemmaHandler() {
        boolean force = JFaceUtils.showMessageBlocking((String)Messages.ResumeAction_CS_AlreadyInHistoryHandler_Title, (String)Messages.ResumeAction_CS_AlreadyInHistoryHandler_Message, (String[])new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, (int)3);
        return force ? 0 : 3;
    }

    public static IPreferenceStore getPreferences() {
        IPreferenceStore result = UiPlugin.getDefault().getPreferenceStore();
        return result;
    }
}

