/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.ide.ui.internal.compare.DelegatingSaveableCompareEditorInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IAbstractConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.compare.ComparePropertiesState;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.compare.ShareableComparePropertiesState;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileChangeEditorInput;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.OpenInCompareAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class WarnOpenInExternalCompare
extends OpenInExternalCompareDilemmaHandler {
    private final boolean TRACE = Boolean.getBoolean(System.getProperty("jazz.scm.externalCompare.trace", Boolean.toString(false)));
    private UIContext context;

    public WarnOpenInExternalCompare(UIContext context) {
        this.context = context;
    }

    protected UIContext getContext() {
        return this.context;
    }

    public int differentProperties(ComparePropertiesState comparison, String errorMessage) throws TeamRepositoryException {
        if (comparison instanceof ShareableComparePropertiesState) {
            ShareableComparePropertiesState scps = (ShareableComparePropertiesState)comparison;
            this.openFilteredLocalFileCompareEditor(scps.getShareable(), scps.getRight());
        } else {
            this.openFilteredFileChangeCompareEditor(comparison.getLeft(), comparison.getLeftLabel(), comparison.getRight(), comparison.getRightLabel());
        }
        this.TRACE(errorMessage);
        return 0;
    }

    public int filesMovedButDidNotChangeStatesInRemoteCompare(FileState leftState, FileState rightState, String errorMessage) {
        JFaceUtils.showMessageBlocking((String)Messages.WarnOpenInExternalCompare_8, (String)NLS.bind((String)Messages.WarnOpenInExternalCompare_9, (Object)rightState.getPath(), (Object[])new Object[]{leftState.getPath()}), (String[])new String[]{IDialogConstants.OK_LABEL}, (int)4);
        this.TRACE(errorMessage);
        return 1;
    }

    public int mergeHasUnloadedComponent(IComponentSyncContext context, String errorMessage) {
        JFaceUtils.showMessageBlocking((String)Messages.WarnOpenInExternalCompare_4, (String)NLS.bind((String)Messages.WarnOpenInExternalCompare_5, (Object)context.getComponent().getName(), (Object[])new Object[0]), (String[])new String[]{IDialogConstants.OK_LABEL}, (int)4);
        this.TRACE(errorMessage);
        return 0;
    }

    public int mergeIsDeleteToDeleteConflict(IAbstractConflictItem conflict, String errorMessage) {
        JFaceUtils.showMessageBlocking((String)Messages.WarnOpenInExternalCompare_6, (String)Messages.WarnOpenInExternalCompare_7, (String[])new String[]{IDialogConstants.OK_LABEL}, (int)4);
        this.TRACE(errorMessage);
        return 1;
    }

    private void openFilteredLocalFileCompareEditor(final IShareable shareable, final FileState remoteFileState) {
        if (this.doOpenInternalCompare(remoteFileState.isDeleted())) {
            this.context.asyncExec(new Runnable(){

                @Override
                public void run() {
                    OpenInCompareAction.openCompareEditor(DelegatingSaveableCompareEditorInput.createInput(WarnOpenInExternalCompare.this.context.getPage(), shareable, remoteFileState, null, true), WarnOpenInExternalCompare.this.context.getPage());
                }
            });
        }
    }

    private void openFilteredFileChangeCompareEditor(final FileState leftFileState, final String givenLeftLabel, final FileState rightFileState, final String givenRightLabel) {
        if (this.doOpenInternalCompare(leftFileState.isDeleted() || rightFileState.isDeleted())) {
            this.context.asyncExec(new Runnable(){

                @Override
                public void run() {
                    FileChangeEditorInput editorInput = FileChangeEditorInput.createFrom((FileState)leftFileState, (FileState)rightFileState, (boolean)true);
                    editorInput.setLabels(givenLeftLabel, givenRightLabel);
                    OpenInCompareAction.openCompareEditor((CompareEditorInput)editorInput, WarnOpenInExternalCompare.this.context.getPage());
                }
            });
        }
    }

    protected boolean doOpenInternalCompare(final boolean addedOrRemoved) {
        final boolean[] result = new boolean[]{true};
        IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
        if (page != null) {
            final Shell shell = page.getWorkbenchWindow().getShell();
            final IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            String[] pref = new String[]{store.getString("compare_properties")};
            if (pref[0].equals("always")) {
                result[0] = true;
            } else if (pref[0].equals("never")) {
                result[0] = false;
            } else {
                shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialogWithToggle dialog;
                        result[0] = addedOrRemoved ? (dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)Messages.WarnOpenInExternalCompare_0, (String)Messages.WarnOpenInExternalCompare_1, (String)Messages.WarnOpenInExternalCompare_1_REMEMBER, (boolean)false, (IPreferenceStore)store, (String)"compare_properties")).getReturnCode() == 2 : MessageDialog.openQuestion((Shell)shell, (String)Messages.WarnOpenInExternalCompare_0, (String)Messages.WarnOpenInExternalCompare_1);
                    }
                });
            }
        }
        return result[0];
    }

    private void TRACE(String message) {
        if (this.TRACE) {
            System.out.println("WarnOpenInExternalCompare dilemma message: " + message);
        }
    }
}

