/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnUpdateCurrentPortDilemmaHandler;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collection;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class WarnMarkAsResolvedDilemmaHandler
extends WarnUpdateCurrentPortDilemmaHandler {
    public WarnMarkAsResolvedDilemmaHandler(Shell shell) {
        super(shell);
    }

    public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> changes) {
        String resourceType = Messages.WarnMarkAsResolvedDilemmaHandler_RESOURCES;
        String dialogTitle = this.getUncheckedInChangesDialogTitle();
        String dialogMsg = this.getUncheckedInChangesDialogMessagePlural(resourceType);
        String checkInAndMarkAsDoneButton = this.getCheckInAndMarkAsDoneButtonText();
        String markAsDoneButton = this.getMarkAsDoneButtonText();
        String cancelButton = this.getCancelButtonText();
        if (changes.size() == 1 && changes.entrySet().iterator().next().getValue().size() == 1) {
            ILocalChange localChange = changes.entrySet().iterator().next().getValue().iterator().next();
            if (localChange != null) {
                dialogMsg = this.getUncheckedInChangesDialogMessageSingle(localChange);
            }
        } else {
            boolean containsFiles = false;
            boolean containsFolders = false;
            boolean containsSymLinks = false;
            block4: for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : changes.entrySet()) {
                for (ILocalChange localChange : entry.getValue()) {
                    IVersionableHandle versionable = localChange.getTarget();
                    if (versionable instanceof IFileItemHandle) {
                        containsFiles = true;
                    } else if (versionable instanceof IFolderHandle) {
                        containsFolders = true;
                    } else if (versionable instanceof ISymbolicLinkHandle) {
                        containsSymLinks = true;
                    }
                    if (containsFiles && containsFolders || containsFiles && containsSymLinks || containsFolders && containsSymLinks) break block4;
                }
            }
            if (containsFiles && !containsFolders && !containsSymLinks) {
                dialogMsg = this.getUncheckedInChangesDialogMessagePlural(Messages.WarnMarkAsResolvedDilemmaHandler_FILES);
            } else if (!containsFiles && containsFolders && !containsSymLinks) {
                dialogMsg = this.getUncheckedInChangesDialogMessagePlural(Messages.WarnMarkAsResolvedDilemmaHandler_FOLDERS);
            } else if (!containsFiles && !containsFolders && containsSymLinks) {
                dialogMsg = this.getUncheckedInChangesDialogMessagePlural(Messages.WarnMarkAsResolvedDilemmaHandler_SYMBOLIC_LINKS);
            }
        }
        DialogUtil.pauseIfNeededBeforeShowingDialog();
        int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMsg, (String[])new String[]{checkInAndMarkAsDoneButton, markAsDoneButton, cancelButton}, (int)4, (int)0, (String)this.getUncheckedInChangesDialogHelpID());
        switch (code) {
            case 0: {
                return 0;
            }
            case 1: {
                return 3;
            }
        }
        return 1;
    }

    protected String getUncheckedInChangesDialogTitle() {
        return Messages.WarnMarkAsResolvedDilemmaHandler_UNCHECKED_IN_CHANGES_DIALOG_TITLE;
    }

    protected String getUncheckedInChangesDialogMessageSingle(ILocalChange localChange) {
        return NLS.bind((String)Messages.WarnMarkAsResolvedDilemmaHandler_UNCHECKED_IN_CHANGES_DIALOG_MESSAGE_SINGLE_CHANGE, (Object)ItemUtil.getVersionableType((IVersionableHandle)localChange.getTarget(), (boolean)false), (Object)localChange.getPath().getName());
    }

    protected String getUncheckedInChangesDialogMessagePlural(String resourceType) {
        return NLS.bind((String)Messages.WarnMarkAsResolvedDilemmaHandler_UNCHECKED_IN_CHANGES_DIALOG_MESSAGE, (Object)resourceType);
    }

    protected String getCheckInAndMarkAsDoneButtonText() {
        return Messages.WarnMarkAsResolvedDilemmaHandler_UNCHECKED_IN_CHANGES_DIALOG_CHECK_IN_BUTTON;
    }

    protected String getMarkAsDoneButtonText() {
        return Messages.WarnMarkAsResolvedDilemmaHandler_UNCHECKED_IN_CHANGES_DIALOG_DO_NOT_CHECK_IN_BUTTON;
    }

    protected String getCancelButtonText() {
        return Messages.WarnMarkAsResolvedDilemmaHandler_UNCHECKED_IN_CHANGES_DIALOG_CANCEL_BUTTON;
    }

    protected String getUncheckedInChangesDialogHelpID() {
        return "com.ibm.team.filesystem.ide.ui.dialog_localchangesupdatecurrentport";
    }
}

