/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.lock.LockPreventsDeliverDialog;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnOutOfSync;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.changes.dialogs.MessageDialogWithToggleAndButtonLabels;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.LocksByContributor;
import com.ibm.team.internal.filesystem.ui.util.UnlockConfirmationHandler;
import com.ibm.team.internal.filesystem.ui.util.WarnBackupUserWithConsole;
import com.ibm.team.internal.filesystem.ui.util.WarnCommitUser;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class WarnDeliverUser
extends DeliverDilemmaHandler {
    private WarnBackupUserWithConsole backupHandler;
    private WarnOutOfSync outOfSyncHandler;
    private WarnCommitUser commitHandler;
    private Shell shell;

    public WarnDeliverUser(Shell shell, String title) {
        this.shell = shell;
        this.backupHandler = new WarnBackupUserWithConsole(shell, title);
        this.outOfSyncHandler = new WarnOutOfSync(shell, title, (BackupDilemmaHandler)this.backupHandler);
        this.commitHandler = new WarnCommitUser(shell, title, (BackupDilemmaHandler)this.backupHandler);
    }

    public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
        return this.outOfSyncHandler;
    }

    public BackupDilemmaHandler getBackupDilemmaHandler() {
        return this.backupHandler;
    }

    public CommitDilemmaHandler getCommitDilemmaHandler() {
        return this.commitHandler;
    }

    public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> changes) {
        int result = 1;
        if (PlatformUI.isWorkbenchRunning()) {
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            boolean prompt = store.getInt("uncheckedInChanges") == 0;
            final int[] code = new int[]{3};
            final boolean[] toggle = new boolean[1];
            if (!prompt) {
                code[0] = store.getInt("uncheckedInChanges");
                switch (code[0]) {
                    case 2: {
                        result = 0;
                        break;
                    }
                    case 3: {
                        result = 3;
                    }
                }
            } else {
                Iterator<Map.Entry<ConfigurationFacade, Collection<ILocalChange>>> i = changes.entrySet().iterator();
                int count = 0;
                while (i.hasNext()) {
                    Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry = i.next();
                    count += entry.getValue().size();
                }
                final int changesCount = count;
                this.shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String message = NLS.bind((String)Messages.WarnDeliverUser_1, (Object)changesCount);
                        MessageDialogWithToggleAndButtonLabels dialog = new MessageDialogWithToggleAndButtonLabels(WarnDeliverUser.this.shell, Messages.WarnDeliverUser_0, null, message, 4, new String[]{Messages.WarnDeliverUser_29, Messages.WarnDeliverUser_30, IDialogConstants.CANCEL_LABEL}, 0, Messages.WarnDeliverUser_15, false);
                        code[0] = dialog.open();
                        toggle[0] = dialog.getToggleState();
                    }
                });
            }
            int prefValue = 0;
            if (code[0] == 0) {
                prefValue = 2;
                result = 0;
            } else if (code[0] == 1) {
                prefValue = 3;
                result = 3;
            }
            if (toggle[0]) {
                store.setValue("uncheckedInChanges", prefValue);
            }
        }
        return result;
    }

    public int notDefaultTarget(Collection<IWorkspaceConnection> targets) {
        IWorkspaceConnection wc;
        String dialogTitle = Messages.WarnDeliverUser_2;
        String dialogMessage = targets.size() == 1 ? ((wc = targets.iterator().next()).isStream() ? NLS.bind((String)Messages.WarnDeliverUser_31, (Object)wc.getName()) : NLS.bind((String)Messages.WarnDeliverUser_3, (Object)wc.getName())) : NLS.bind((String)Messages.WarnDeliverUser_13, (Object)targets.size());
        boolean result = DialogUtil.openConfirm(null, dialogTitle, dialogMessage, 4, true);
        if (result) {
            return 0;
        }
        return 1;
    }

    public int componentsToBeAddedRemovedOrReplaced(List<DeliverDilemmaHandler.IWorkspaceComponentOperations> workspaceComponentOperationsList, IProgressMonitor monitor) {
        String caption;
        String title;
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        ArrayList replaced = new ArrayList();
        for (DeliverDilemmaHandler.IWorkspaceComponentOperations ops : workspaceComponentOperationsList) {
            added.addAll(ops.getAddedComponents());
            removed.addAll(ops.getRemovedComponents());
            replaced.addAll(ops.getReplacedComponents());
        }
        int nDeletions = removed.size();
        int nAdditions = added.size();
        int nReplaces = replaced.size();
        if (nReplaces > 0) {
            if (nAdditions > 0 && nDeletions > 0) {
                title = Messages.WarnDeliverUser_5;
                caption = Messages.WarnDeliverUser_7;
            } else if (nDeletions > 0) {
                title = Messages.WarnDeliverUser_9;
                caption = Messages.WarnDeliverUser_10;
            } else if (nAdditions > 0) {
                title = Messages.WarnDeliverUser_32;
                caption = Messages.WarnDeliverUser_33;
            } else if (nReplaces == 1) {
                title = Messages.WarnDeliverUser_34;
                caption = Messages.WarnDeliverUser_35;
            } else {
                title = Messages.WarnDeliverUser_36;
                caption = NLS.bind((String)Messages.WarnDeliverUser_37, (Object)nReplaces);
            }
        } else if (nAdditions > 0 && nDeletions > 0) {
            title = Messages.WarnDeliverUser_4;
            caption = nAdditions == 1 && nDeletions == 1 ? NLS.bind((String)Messages.WarnDeliverUser_COMPONENT_DIALOG_MSG_1_ADD_1_DELETE, (Object)nAdditions, (Object)nDeletions) : (nAdditions == 1 && nDeletions > 1 ? NLS.bind((String)Messages.WarnDeliverUser_COMPONENT_DIALOG_MSG_1_ADD_MANY_DELETE, (Object)nAdditions, (Object)nDeletions) : (nAdditions > 0 && nDeletions == 1 ? NLS.bind((String)Messages.WarnDeliverUser_COMPONENT_DIALOG_MSG_MANY_ADD_1_DELETE, (Object)nAdditions, (Object)nDeletions) : NLS.bind((String)Messages.WarnDeliverUser_COMPONENT_DIALOG_MSG_MANY_ADD_MANY_DELETE, (Object)nAdditions, (Object)nDeletions)));
        } else if (nDeletions > 0) {
            title = Messages.WarnDeliverUser_6;
            caption = nDeletions == 1 ? NLS.bind((String)Messages.WarnDeliverUser_COMPONENT_DIALOG_MSG_1_DELETE, (Object)nDeletions) : NLS.bind((String)Messages.WarnDeliverUser_COMPONENT_DIALOG_MSG_MANY_DELETE, (Object)nDeletions);
        } else {
            title = Messages.WarnDeliverUser_8;
            caption = nAdditions == 1 ? NLS.bind((String)Messages.WarnDeliverUser_COMPONENT_DIALOG_MSG_1_ADD, (Object)nAdditions) : NLS.bind((String)Messages.WarnDeliverUser_COMPONENT_DIALOG_MSG_MANY_ADD, (Object)nAdditions);
        }
        caption = nAdditions + nDeletions + nReplaces == 1 ? String.valueOf(caption) + Messages.WarnDeliverUser_COMPONENT_DIALOG_MSG_QUESTION_SINGLE : String.valueOf(caption) + Messages.WarnDeliverUser_COMPONENT_DIALOG_MSG_QUESTION_PLURAL;
        final String message = caption;
        final String choice1 = Messages.WarnDeliverUser_11;
        final String choice2 = Messages.WarnDeliverUser_12;
        final int[] result = new int[]{1};
        IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
        if (page != null) {
            final Shell shell = page.getWorkbenchWindow().getShell();
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ChoiceDialog dialog = new ChoiceDialog(shell, title, message, choice1, choice2);
                    dialog.setBlockOnOpen(true);
                    if (dialog.open() == 0) {
                        if (dialog.getChoice1()) {
                            result[0] = 3;
                        } else if (dialog.getChoice2()) {
                            result[0] = 0;
                        }
                    }
                }
            });
        }
        return result[0];
    }

    public int deliveryWithIncomingReplace(List<IComponentHandle> components, IProgressMonitor monitor) {
        String caption = components.size() == 1 ? Messages.WarnDeliverUser_45 : NLS.bind((String)Messages.WarnDeliverUser_46, (Object)components.size());
        final String message = caption = NLS.bind((String)Messages.WarnDeliverUser_47, (Object)caption);
        final String choice1 = Messages.WarnDeliverUser_48;
        final String choice2 = Messages.WarnDeliverUser_49;
        final int[] result = new int[]{1};
        IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
        if (page != null) {
            final Shell shell = page.getWorkbenchWindow().getShell();
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ChoiceDialog dialog = new ChoiceDialog(shell, Messages.WarnDeliverUser_50, message, choice1, choice2);
                    dialog.setBlockOnOpen(true);
                    if (dialog.open() == 0) {
                        if (dialog.getChoice1()) {
                            result[0] = 3;
                        } else if (dialog.getChoice2()) {
                            result[0] = 0;
                        }
                    }
                }
            });
        }
        return result[0];
    }

    public int lockBeingHeld(IStreamLockReport lock, IWorkspaceConnection workspaceConnection, int requestsLeft) {
        if (requestsLeft == 0) {
            return 0;
        }
        if (PlatformUI.isWorkbenchRunning()) {
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            Collection<LocksByContributor> locksByContributor = LocksByContributor.getLocks(workspaceConnection, lock);
            HashMap<IStreamLockReport, IWorkspaceConnection> locks = new HashMap<IStreamLockReport, IWorkspaceConnection>();
            locks.put(lock, workspaceConnection);
            LockPreventsDeliverDialog dialog = new LockPreventsDeliverDialog(this.shell, Messages.WarnDeliverUser_14, WarnDeliverUser.getLockBeingHeldMsg(locksByContributor), Messages.WarnDeliverUser_LOCKS_PREVENTING_DELIVERY, 8, locks, DetailsDialog.ButtonBar.YesNoDetails);
            dialog.initializeToggleButtonRememberMyDecision(WarnDeliverUser.getPreferences(), "lockBeingHeld");
            int code = dialog.openOrGetPreference(this.shell.getDisplay());
            switch (code) {
                case 0: {
                    return 0;
                }
            }
            return 1;
        }
        return super.lockBeingHeld(lock, workspaceConnection, requestsLeft);
    }

    public void locksWereHeld(Map<IStreamLockReport, IWorkspaceConnection> locks) {
        if (locks.isEmpty()) {
            return;
        }
        if (PlatformUI.isWorkbenchRunning()) {
            Collection<LocksByContributor> locksByContributor = LocksByContributor.getLocks(locks);
            IPreferenceStore store = WarnDeliverUser.getPreferences();
            boolean prompt = store.getBoolean("locksWereHeld");
            if (!prompt) {
                return;
            }
            LockPreventsDeliverDialog dialog = new LockPreventsDeliverDialog(this.shell, Messages.WarnDeliverUser_14, WarnDeliverUser.getLocksWereHeldMessage(locksByContributor), Messages.WarnDeliverUser_LOCKS_PREVENTING_DELIVERY, 8, locks, DetailsDialog.ButtonBar.OkDetails);
            dialog.setDefaultButtonId(0);
            dialog.initializeToggleButtonDontShowMeThisAgain(null, null);
            dialog.open(this.shell.getDisplay());
            if (dialog.getToggleState()) {
                store.setValue("locksWereHeld", false);
            }
        }
    }

    public int deliveryRequiresHistoryReordering(IWorkspaceConnection source, IWorkspaceConnection target, final IComponent component) {
        if (PlatformUI.isWorkbenchRunning()) {
            final int[] dilemmaResult = new int[]{1};
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            this.shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog dialog = new MessageDialog(WarnDeliverUser.this.shell, Messages.WarnDeliverUser_16, null, NLS.bind((String)Messages.WarnDeliverUser_17, (Object)component.getName()), 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    int result = dialog.open();
                    if (result == 0) {
                        dilemmaResult[0] = 0;
                    }
                }
            });
            return dilemmaResult[0];
        }
        return super.deliveryRequiresHistoryReordering(source, target, component);
    }

    private static String getLockBeingHeldMsg(Collection<LocksByContributor> locksByContributor) {
        return LocksByContributor.getLocksHeldMsg(locksByContributor, Messages.WarnDeliverUser_21, Messages.WarnDeliverUser_22, Messages.WarnDeliverUser_23, Messages.WarnDeliverUser_24);
    }

    private static String getLocksWereHeldMessage(Collection<LocksByContributor> locksByContributor) {
        return LocksByContributor.getLocksHeldMsg(locksByContributor, Messages.WarnDeliverUser_25, Messages.WarnDeliverUser_26, Messages.WarnDeliverUser_27, Messages.WarnDeliverUser_28);
    }

    public Map<IStreamLockReport, IWorkspaceConnection> locksToRelease(Map<IStreamLockReport, IWorkspaceConnection> locks) {
        if (locks.isEmpty()) {
            return locks;
        }
        if (PlatformUI.isWorkbenchRunning()) {
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            LockPreventsDeliverDialog dialog = new LockPreventsDeliverDialog(this.shell, Messages.WarnDeliverUser_14, Messages.WarnDeliverUser_18, Messages.WarnDeliverUser_LOCKS_TO_RELEASE, 2, locks, DetailsDialog.ButtonBar.YesNoDetails);
            dialog.initializeToggleButtonRememberMyDecision(WarnDeliverUser.getPreferences(), "locksToRelease");
            dialog.setDefaultButtonId(3);
            int code = dialog.openOrGetPreference(this.shell.getDisplay());
            switch (code) {
                case 2: {
                    return locks;
                }
            }
        }
        return Collections.emptyMap();
    }

    public LockDilemmaHandler getLockDilemmaHandler() {
        return new UnlockConfirmationHandler();
    }

    public static IPreferenceStore getPreferences() {
        IPreferenceStore result = UiPlugin.getDefault().getPreferenceStore();
        return result;
    }

    public int deletedContent(Collection<IShareable> contentDeleted) {
        return this.outOfSyncHandler.deletedContent(contentDeleted);
    }

    public class ChoiceDialog
    extends MessageDialog {
        private Button button1;
        private Button button2;
        private boolean choice1;
        private boolean choice2;
        private String label1;
        private String label2;

        public ChoiceDialog(Shell shell, String title, String message, String label1, String label2) {
            super(shell, title, null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.label1 = label1;
            this.label2 = label2;
        }

        protected Control createCustomArea(Composite parent) {
            Composite choices = new Composite(parent, 8);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            choices.setLayout((Layout)gridLayout);
            this.button1 = new Button(choices, 16);
            this.button1.setText(this.label1);
            this.button1.setSelection(true);
            this.button2 = new Button(choices, 16);
            this.button2.setText(this.label2);
            return choices;
        }

        protected void buttonPressed(int buttonId) {
            this.choice1 = this.button1.getSelection();
            this.choice2 = this.button2.getSelection();
            super.buttonPressed(buttonId);
        }

        public boolean getChoice1() {
            return this.choice1;
        }

        public boolean getChoice2() {
            return this.choice2;
        }
    }
}

