/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.CreateSnapshotDilemmaHandler;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class WarnCreateSnapshotDilemmaHandler
extends CreateSnapshotDilemmaHandler {
    private final String CANNOT_CREATE_SNAPSHOT = Messages.WarnCreateSnapshotDilemmaHandler_cannotCreateSnapshot;
    private final String CONFIRM_CREATE_SNAPSHOT = Messages.WarnCreateSnapshotDilemmaHandler_confirmSnapshotCreation;
    private String[] yesNoButtons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
    private final boolean fCreateSnapshotOnStream;

    public WarnCreateSnapshotDilemmaHandler(boolean createSnapshotOnStream) {
        this.fCreateSnapshotOnStream = createSnapshotOnStream;
    }

    private int getIndexOfYesButton() {
        int i = 0;
        while (i < this.yesNoButtons.length) {
            if (IDialogConstants.YES_LABEL.equals(this.yesNoButtons[i])) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public int entireHierarchyNotInSnapshot(List<ConfigurationFacade> missingConfigurations) {
        int yesIndex;
        String dialogMessage;
        String dialogTitle;
        int code;
        if (PlatformUI.isWorkbenchRunning() && (code = JFaceUtils.showMessageButtonsBlocking((String)(dialogTitle = this.CONFIRM_CREATE_SNAPSHOT), (String)(dialogMessage = Messages.WarnCreateSnapshotDilemmaHandler_entireHierarchyNotInSnapshot), (String[])this.yesNoButtons, (int)4, (int)(yesIndex = this.getIndexOfYesButton()))) == yesIndex) {
            return 0;
        }
        return 1;
    }

    public int conflictedConfigurations(Set<ConfigurationFacade> conflictedConfigurations, IProgressMonitor monitor) {
        if (PlatformUI.isWorkbenchRunning()) {
            String dialogMessage;
            String dialogTitle = this.CANNOT_CREATE_SNAPSHOT;
            if (conflictedConfigurations.size() == 1) {
                dialogMessage = Messages.WarnCreateSnapshotDilemmaHandler_conflictedConfiguration;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    ConfigurationFacade configuration = conflictedConfigurations.iterator().next();
                    ITeamRepository repo = configuration.getTeamRepository();
                    IComponentHandle componentHandle = configuration.getComponentHandle();
                    IComponent component = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progress.newChild(100));
                    String componentName = component.getName();
                    dialogMessage = NLS.bind((String)Messages.WarnCreateSnapshotDilemmaHandler_conflictedConfigurationSpecific, (Object)componentName);
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
                progress.done();
            } else {
                dialogMessage = Messages.WarnCreateSnapshotDilemmaHandler_conflictedConfigurations;
            }
            JFaceUtils.showMessageBlocking((String)dialogTitle, (String)dialogMessage, (int)2);
        }
        return 1;
    }

    public int conflictedConfigurationsInSubcomponents(Set<ConfigurationFacade> conflictedConfigurations, IProgressMonitor monitor) {
        if (PlatformUI.isWorkbenchRunning()) {
            String dialogMessage;
            String dialogTitle = this.CANNOT_CREATE_SNAPSHOT;
            if (conflictedConfigurations.size() == 1) {
                dialogMessage = Messages.WarnCreateSnapshotDilemmaHandler_conflictedConfigurationInSubcomponent;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    ConfigurationFacade configuration = conflictedConfigurations.iterator().next();
                    ITeamRepository repo = configuration.getTeamRepository();
                    IComponentHandle componentHandle = configuration.getComponentHandle();
                    IComponent component = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progress.newChild(100));
                    String componentName = component.getName();
                    dialogMessage = NLS.bind((String)Messages.WarnCreateSnapshotDilemmaHandler_conflictedConfigurationInSubcomponentSpecific, (Object)componentName);
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
                progress.done();
            } else {
                dialogMessage = Messages.WarnCreateSnapshotDilemmaHandler_conflictedConfigurationsInSubcomponents;
            }
            JFaceUtils.showMessageBlocking((String)dialogTitle, (String)dialogMessage, (int)2);
        }
        return 1;
    }

    public int activeChangeSetsInConfiguration(Map<ConfigurationFacade, Collection<IChangeSetHandle>> activeChangeSets, IProgressMonitor monitor) {
        if (PlatformUI.isWorkbenchRunning()) {
            String dialogMessage;
            String dialogTitle = this.CONFIRM_CREATE_SNAPSHOT;
            if (activeChangeSets.size() == 1) {
                dialogMessage = Messages.WarnCreateSnapshotDilemmaHandler_activeChangeSetsInConfiguration;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    ConfigurationFacade configuration = activeChangeSets.keySet().iterator().next();
                    ITeamRepository repo = configuration.getTeamRepository();
                    IComponentHandle componentHandle = configuration.getComponentHandle();
                    IComponent component = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progress.newChild(100));
                    String componentName = component.getName();
                    dialogMessage = NLS.bind((String)Messages.WarnCreateSnapshotDilemmaHandler_activeChangeSetsInConfigurationSpecific, (Object)componentName);
                }
                catch (TeamRepositoryException configuration) {
                    // empty catch block
                }
                progress.done();
            } else {
                dialogMessage = Messages.WarnCreateSnapshotDilemmaHandler_activeChangeSetsInConfigurations;
            }
            int yesIndex = this.getIndexOfYesButton();
            int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMessage, (String[])this.yesNoButtons, (int)4, (int)yesIndex);
            if (code == yesIndex) {
                return 0;
            }
        }
        return 1;
    }

    public int activeChangeSetsInSubcomponents(Map<ConfigurationFacade, Collection<IChangeSetHandle>> activeChangeSets, IProgressMonitor monitor) {
        if (PlatformUI.isWorkbenchRunning()) {
            String dialogMessage;
            String dialogTitle = this.CONFIRM_CREATE_SNAPSHOT;
            if (activeChangeSets.size() == 1) {
                dialogMessage = Messages.WarnCreateSnapshotDilemmaHandler_activeChangeSetsInSubcomponent;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    ConfigurationFacade configuration = activeChangeSets.keySet().iterator().next();
                    ITeamRepository repo = configuration.getTeamRepository();
                    IComponentHandle componentHandle = configuration.getComponentHandle();
                    IComponent component = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progress.newChild(100));
                    String componentName = component.getName();
                    dialogMessage = NLS.bind((String)Messages.WarnCreateSnapshotDilemmaHandler_activeChangeSetsInSubcomponentSpecific, (Object)componentName);
                }
                catch (TeamRepositoryException configuration) {
                    // empty catch block
                }
                progress.done();
            } else {
                dialogMessage = Messages.WarnCreateSnapshotDilemmaHandler_activeChangeSetsInSubcomponents;
            }
            int yesIndex = this.getIndexOfYesButton();
            int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMessage, (String[])this.yesNoButtons, (int)4, (int)yesIndex);
            if (code == yesIndex) {
                return 0;
            }
        }
        return 1;
    }

    public int inaccessibleSubcomponents(Set<ConfigurationFacade> inaccessibleConfigurations, IProgressMonitor monitor) {
        if (PlatformUI.isWorkbenchRunning()) {
            boolean allowInaccessibleSubcomponentsNotInWorkspace = true;
            if (allowInaccessibleSubcomponentsNotInWorkspace) {
                String dialogMessage;
                String dialogTitle = this.CONFIRM_CREATE_SNAPSHOT;
                if (inaccessibleConfigurations.size() == 1) {
                    String componentUUID = inaccessibleConfigurations.iterator().next().getComponentHandle().getItemId().getUuidValue();
                    dialogMessage = this.fCreateSnapshotOnStream ? NLS.bind((String)Messages.WarnCreateSnapshotDilemmaHandler_allowInaccessibleSubcomponentNotInStream, (Object)componentUUID) : NLS.bind((String)Messages.WarnCreateSnapshotDilemmaHandler_allowInaccessibleSubcomponentNotInWorkspace, (Object)componentUUID);
                } else {
                    dialogMessage = this.fCreateSnapshotOnStream ? NLS.bind((String)Messages.WarnCreateSnapshotDilemmaHandler_allowInaccessibleSubcomponentsNotInStream, (Object)inaccessibleConfigurations.size()) : NLS.bind((String)Messages.WarnCreateSnapshotDilemmaHandler_allowInaccessibleSubcomponentsNotInWorkspace, (Object)inaccessibleConfigurations.size());
                }
                int yesIndex = this.getIndexOfYesButton();
                int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMessage, (String[])this.yesNoButtons, (int)4, (int)yesIndex);
                if (code == yesIndex) {
                    return 0;
                }
            } else {
                String dialogMessage;
                String dialogTitle = this.CANNOT_CREATE_SNAPSHOT;
                if (inaccessibleConfigurations.size() == 1) {
                    String componentUUID = inaccessibleConfigurations.iterator().next().getComponentHandle().getItemId().getUuidValue();
                    dialogMessage = NLS.bind((String)Messages.WarnCreateSnapshotDilemmaHandler_inaccessibleSubcomponent, (Object)componentUUID);
                } else {
                    dialogMessage = NLS.bind((String)Messages.WarnCreateSnapshotDilemmaHandler_inaccessibleSubcomponents, (Object)inaccessibleConfigurations.size());
                }
                JFaceUtils.showMessageBlocking((String)dialogTitle, (String)dialogMessage, (int)2);
            }
        }
        return 1;
    }

    public int subcomponentsNotInWorkspace(Set<ConfigurationFacade> configurationsNotInWorkspace, IProgressMonitor monitor) {
        if (PlatformUI.isWorkbenchRunning()) {
            String dialogMessage;
            String dialogTitle = this.CONFIRM_CREATE_SNAPSHOT;
            if (configurationsNotInWorkspace.size() == 1) {
                dialogMessage = Messages.WarnCreateSnapshotDilemmaHandler_subcomponentNotInWorkspace;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    ConfigurationFacade configuration = configurationsNotInWorkspace.iterator().next();
                    ITeamRepository repo = configuration.getTeamRepository();
                    IComponentHandle componentHandle = configuration.getComponentHandle();
                    IComponent component = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progress.newChild(100));
                    String componentName = component.getName();
                    dialogMessage = this.fCreateSnapshotOnStream ? NLS.bind((String)Messages.WarnCreateSnapshotDilemmaHandler_subcomponentsNotInWorkspaceSpecificStream, (Object)componentName) : NLS.bind((String)Messages.WarnCreateSnapshotDilemmaHandler_subcomponentsNotInWorkspaceSpecificWorkspace, (Object)componentName);
                }
                catch (TeamRepositoryException configuration) {
                    // empty catch block
                }
                progress.done();
            } else {
                dialogMessage = Messages.WarnCreateSnapshotDilemmaHandler_subcomponentsNotInWorkspace;
            }
            int yesIndex = this.getIndexOfYesButton();
            int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMessage, (String[])this.yesNoButtons, (int)4, (int)yesIndex);
            if (code == yesIndex) {
                return 0;
            }
        }
        return 1;
    }

    public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> changes) {
        int yesIndex;
        String dialogMessage;
        String dialogTitle;
        int code;
        if (PlatformUI.isWorkbenchRunning() && (code = JFaceUtils.showMessageButtonsBlocking((String)(dialogTitle = this.CONFIRM_CREATE_SNAPSHOT), (String)(dialogMessage = changes.size() == 1 ? Messages.WarnCreateSnapshotDilemmaHandler_uncheckedInChange : Messages.WarnCreateSnapshotDilemmaHandler_uncheckedInChanges), (String[])this.yesNoButtons, (int)4, (int)(yesIndex = this.getIndexOfYesButton()))) == yesIndex) {
            return 3;
        }
        return 1;
    }

    public int uncheckedInChangesInSubcomponents(Map<ConfigurationFacade, Collection<ILocalChange>> changes, IProgressMonitor monitor) {
        if (PlatformUI.isWorkbenchRunning()) {
            String dialogMessage;
            String dialogTitle = this.CONFIRM_CREATE_SNAPSHOT;
            if (changes.size() == 1) {
                dialogMessage = Messages.WarnCreateSnapshotDilemmaHandler_uncheckedInChangesInSubcomponent;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    ConfigurationFacade configuration = changes.keySet().iterator().next();
                    ITeamRepository repo = configuration.getTeamRepository();
                    IComponentHandle componentHandle = configuration.getComponentHandle();
                    IComponent component = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progress.newChild(100));
                    String componentName = component.getName();
                    dialogMessage = NLS.bind((String)Messages.WarnCreateSnapshotDilemmaHandler_uncheckedInChangesInSubcomponentSpecific, (Object)componentName);
                }
                catch (TeamRepositoryException configuration) {
                    // empty catch block
                }
                progress.done();
            } else {
                dialogMessage = Messages.WarnCreateSnapshotDilemmaHandler_uncheckedInChangesInSubcomponents;
            }
            int yesIndex = this.getIndexOfYesButton();
            int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMessage, (String[])this.yesNoButtons, (int)4, (int)yesIndex);
            if (code == yesIndex) {
                return 3;
            }
        }
        return 1;
    }
}

