/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.CreateBaselineDilemmaHandler;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class WarnCreateBaselineDilemmaHandler
extends CreateBaselineDilemmaHandler {
    private final String CANNOT_CREATE_BASELINE = Messages.WarnCreateBaselineDilemmaHandler_cannotCreateBaseline;
    private final String CONFIRM_CREATE_BASELINE = Messages.WarnCreateBaselineDilemmaHandler_confirmBaselineCreation;
    private final Map<IWorkspaceConnection, Map<UUID, IComponent>> fWorkspaceToComponentSelection;
    private String[] yesNoButtons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};

    public WarnCreateBaselineDilemmaHandler(Map<IWorkspaceConnection, Map<UUID, IComponent>> workspaceToComponentSelection) {
        this.fWorkspaceToComponentSelection = workspaceToComponentSelection;
    }

    private int getIndexOfYesButton() {
        int i = 0;
        while (i < this.yesNoButtons.length) {
            if (IDialogConstants.YES_LABEL.equals(this.yesNoButtons[i])) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public int conflictedConfigurations(Set<ConfigurationFacade> conflictedConfigurations, IProgressMonitor monitor) {
        if (PlatformUI.isWorkbenchRunning()) {
            String dialogMessage;
            String dialogTitle = this.CANNOT_CREATE_BASELINE;
            if (conflictedConfigurations.size() == 1) {
                dialogMessage = Messages.WarnCreateBaselineDilemmaHandler_conflictedConfiguration;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    ConfigurationFacade configuration = conflictedConfigurations.iterator().next();
                    ITeamRepository repo = configuration.getTeamRepository();
                    IComponentHandle componentHandle = configuration.getComponentHandle();
                    IComponent component = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progress.newChild(50));
                    String componentName = component.getName();
                    if (this.fWorkspaceToComponentSelection.size() > 1) {
                        IWorkspaceConnection workspaceConnection = configuration.getWorkspaceConnection((IProgressMonitor)progress.newChild(50));
                        String workspaceName = workspaceConnection.getName();
                        dialogMessage = workspaceConnection.isStream() ? NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_conflictedConfigurationSpecificStream, (Object)workspaceName, (Object)componentName) : NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_conflictedConfigurationSpecificWorkspace, (Object)workspaceName, (Object)componentName);
                    } else {
                        dialogMessage = NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_conflictedConfigurationSpecificComponent, (Object)componentName);
                    }
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
                progress.done();
            } else {
                dialogMessage = Messages.WarnCreateBaselineDilemmaHandler_conflictedConfigurations;
            }
            JFaceUtils.showMessageBlocking((String)dialogTitle, (String)dialogMessage, (int)2);
        }
        return 1;
    }

    public int conflictedConfigurationsInSubcomponents(Set<ConfigurationFacade> conflictedConfigurations, IProgressMonitor monitor) {
        if (PlatformUI.isWorkbenchRunning()) {
            String dialogMessage;
            String dialogTitle = this.CANNOT_CREATE_BASELINE;
            if (conflictedConfigurations.size() == 1) {
                dialogMessage = Messages.WarnCreateBaselineDilemmaHandler_conflictedConfigurationsInSubcomponent;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    ConfigurationFacade configuration = conflictedConfigurations.iterator().next();
                    ITeamRepository repo = configuration.getTeamRepository();
                    IComponentHandle componentHandle = configuration.getComponentHandle();
                    IComponent component = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progress.newChild(50));
                    String componentName = component.getName();
                    if (this.fWorkspaceToComponentSelection.size() > 1) {
                        IWorkspaceConnection workspaceConnection = configuration.getWorkspaceConnection((IProgressMonitor)progress.newChild(50));
                        String workspaceName = workspaceConnection.getName();
                        dialogMessage = workspaceConnection.isStream() ? NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_conflictedConfigurationsInSubcomponentSpecificStream, (Object)workspaceName, (Object)componentName) : NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_conflictedConfigurationsInSubcomponentSpecificWorkspace, (Object)workspaceName, (Object)componentName);
                    } else {
                        dialogMessage = NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_conflictedConfigurationsInSubcomponentSpecificComponent, (Object)componentName);
                    }
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
                progress.done();
            } else {
                dialogMessage = Messages.WarnCreateBaselineDilemmaHandler_conflictedConfigurationsInSubcomponents;
            }
            JFaceUtils.showMessageBlocking((String)dialogTitle, (String)dialogMessage, (int)2);
        }
        return 1;
    }

    public int activeChangeSetsInSubcomponents(Map<ConfigurationFacade, Collection<IChangeSetHandle>> activeChangeSets, IProgressMonitor monitor) {
        if (PlatformUI.isWorkbenchRunning()) {
            String dialogMessage;
            String dialogTitle = this.CONFIRM_CREATE_BASELINE;
            if (activeChangeSets.size() == 1) {
                dialogMessage = Messages.WarnCreateBaselineDilemmaHandler_activeChangeSetsInSubcomponent;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    ConfigurationFacade configuration = activeChangeSets.keySet().iterator().next();
                    ITeamRepository repo = configuration.getTeamRepository();
                    IComponentHandle componentHandle = configuration.getComponentHandle();
                    IComponent component = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progress.newChild(50));
                    String componentName = component.getName();
                    if (this.fWorkspaceToComponentSelection.size() > 1) {
                        IWorkspaceConnection workspaceConnection = configuration.getWorkspaceConnection((IProgressMonitor)progress.newChild(50));
                        String workspaceName = workspaceConnection.getName();
                        dialogMessage = workspaceConnection.isStream() ? NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_activeChangeSetsInSubcomponentSpecificStream, (Object)workspaceName, (Object)componentName) : NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_activeChangeSetsInSubcomponentSpecificWorkspace, (Object)workspaceName, (Object)componentName);
                    } else {
                        dialogMessage = NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_activeChangeSetsInSubcomponentSpecificComponent, (Object)componentName);
                    }
                }
                catch (TeamRepositoryException configuration) {
                    // empty catch block
                }
                progress.done();
            } else {
                dialogMessage = Messages.WarnCreateBaselineDilemmaHandler_activeChangeSetsInSubcomponents;
            }
            int yesIndex = this.getIndexOfYesButton();
            int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMessage, (String[])this.yesNoButtons, (int)4, (int)yesIndex);
            if (code == yesIndex) {
                return 0;
            }
        }
        return 1;
    }

    public int inaccessibleSubcomponents(Set<ConfigurationFacade> inaccessibleConfigurations, IProgressMonitor monitor) {
        if (PlatformUI.isWorkbenchRunning()) {
            boolean allowInaccessibleSubcomponents = true;
            if (allowInaccessibleSubcomponents) {
                int yesIndex;
                int code;
                String dialogMessage;
                String dialogTitle;
                block16: {
                    dialogTitle = this.CONFIRM_CREATE_BASELINE;
                    if (inaccessibleConfigurations.size() == 1) {
                        ConfigurationFacade configuration = inaccessibleConfigurations.iterator().next();
                        String componentUUID = configuration.getComponentHandle().getItemId().getUuidValue();
                        dialogMessage = NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_allowInaccessibleComponentSpecific, (Object)componentUUID);
                        if (this.fWorkspaceToComponentSelection.size() > 1) {
                            try {
                                IWorkspaceConnection workspaceConnection = configuration.getWorkspaceConnection(monitor);
                                String workspaceName = workspaceConnection.getName();
                                if (workspaceConnection.isStream()) {
                                    dialogMessage = NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_allowInaccessibleComponentSpecificStream, (Object)workspaceName, (Object)componentUUID);
                                    break block16;
                                }
                                dialogMessage = NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_allowInaccessibleComponentSpecificWorkspace, (Object)workspaceName, (Object)componentUUID);
                            }
                            catch (TeamRepositoryException workspaceConnection) {}
                        }
                    } else {
                        dialogMessage = NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_allowInaccessibleComponents, (Object)inaccessibleConfigurations.size());
                    }
                }
                if ((code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMessage, (String[])this.yesNoButtons, (int)4, (int)(yesIndex = this.getIndexOfYesButton()))) == yesIndex) {
                    return 0;
                }
            } else {
                String dialogMessage;
                String dialogTitle;
                block17: {
                    dialogTitle = this.CANNOT_CREATE_BASELINE;
                    if (inaccessibleConfigurations.size() == 1) {
                        ConfigurationFacade configuration = inaccessibleConfigurations.iterator().next();
                        String componentUUID = configuration.getComponentHandle().getItemId().getUuidValue();
                        dialogMessage = NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_inaccessibleComponentSpecific, (Object)componentUUID);
                        if (this.fWorkspaceToComponentSelection.size() > 1) {
                            try {
                                IWorkspaceConnection workspaceConnection = configuration.getWorkspaceConnection(monitor);
                                String workspaceName = workspaceConnection.getName();
                                if (workspaceConnection.isStream()) {
                                    dialogMessage = NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_inaccessibleComponentSpecificStream, (Object)workspaceName, (Object)componentUUID);
                                    break block17;
                                }
                                dialogMessage = NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_inaccessibleComponentSpecificWorkspace, (Object)workspaceName, (Object)componentUUID);
                            }
                            catch (TeamRepositoryException teamRepositoryException) {}
                        }
                    } else {
                        dialogMessage = NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_inaccessibleComponents, (Object)inaccessibleConfigurations.size());
                    }
                }
                JFaceUtils.showMessageBlocking((String)dialogTitle, (String)dialogMessage, (int)2);
            }
        }
        return 1;
    }

    public int subcomponentsNotInWorkspace(Set<ConfigurationFacade> configurationsNotInWorkspace, IProgressMonitor monitor) {
        if (PlatformUI.isWorkbenchRunning()) {
            String dialogMessage;
            String dialogTitle = this.CONFIRM_CREATE_BASELINE;
            if (configurationsNotInWorkspace.size() == 1) {
                dialogMessage = Messages.WarnCreateBaselineDilemmaHandler_subcomponentNotInWorkspace;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    ConfigurationFacade configuration = configurationsNotInWorkspace.iterator().next();
                    ITeamRepository repo = configuration.getTeamRepository();
                    IComponentHandle componentHandle = configuration.getComponentHandle();
                    IComponent component = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progress.newChild(50));
                    IWorkspaceConnection workspaceConnection = configuration.getWorkspaceConnection((IProgressMonitor)progress.newChild(50));
                    String componentName = component.getName();
                    String workspaceName = workspaceConnection.getName();
                    dialogMessage = this.fWorkspaceToComponentSelection.size() > 1 ? (workspaceConnection.isStream() ? NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_subcomponentsNotInWorkspaceSpecificStream, (Object)componentName, (Object)workspaceName) : NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_subcomponentsNotInWorkspaceSpecificWorkspace, (Object)componentName, (Object)workspaceName)) : (workspaceConnection.isStream() ? NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_subcomponentsNotInWorkspaceSpecificStreamNoName, (Object)componentName) : NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_subcomponentsNotInWorkspaceSpecificWorkspaceNoName, (Object)componentName));
                }
                catch (TeamRepositoryException configuration) {
                    // empty catch block
                }
                progress.done();
            } else {
                dialogMessage = Messages.WarnCreateBaselineDilemmaHandler_subcomponentsNotInWorkspace;
            }
            int yesIndex = this.getIndexOfYesButton();
            int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMessage, (String[])this.yesNoButtons, (int)4, (int)yesIndex);
            if (code == yesIndex) {
                return 0;
            }
        }
        return 1;
    }

    public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> changes) {
        int yesIndex;
        String dialogMessage;
        String dialogTitle;
        int code;
        if (PlatformUI.isWorkbenchRunning() && (code = JFaceUtils.showMessageButtonsBlocking((String)(dialogTitle = this.CONFIRM_CREATE_BASELINE), (String)(dialogMessage = changes.size() == 1 ? Messages.WarnCreateBaselineDilemmaHandler_uncheckedInChangesInComponent : Messages.WarnCreateBaselineDilemmaHandler_uncheckedInChangesInComponents), (String[])this.yesNoButtons, (int)4, (int)(yesIndex = this.getIndexOfYesButton()))) == yesIndex) {
            return 3;
        }
        return 1;
    }

    public int uncheckedInChangesInSubcomponents(Map<ConfigurationFacade, Collection<ILocalChange>> changes, IProgressMonitor monitor) {
        if (PlatformUI.isWorkbenchRunning()) {
            String dialogMessage;
            String dialogTitle = this.CONFIRM_CREATE_BASELINE;
            if (changes.size() == 1) {
                dialogMessage = Messages.WarnCreateBaselineDilemmaHandler_uncheckedInChangesInSubcomponent;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    ConfigurationFacade configuration = changes.keySet().iterator().next();
                    ITeamRepository repo = configuration.getTeamRepository();
                    IComponentHandle componentHandle = configuration.getComponentHandle();
                    IComponent component = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progress.newChild(50));
                    String componentName = component.getName();
                    if (this.fWorkspaceToComponentSelection.size() > 1) {
                        IWorkspaceConnection workspaceConnection = configuration.getWorkspaceConnection((IProgressMonitor)progress.newChild(50));
                        String workspaceName = workspaceConnection.getName();
                        dialogMessage = workspaceConnection.isStream() ? NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_uncheckedInChangesInSubcomponentSpecificStream, (Object)workspaceName, (Object)componentName) : NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_uncheckedInChangesInSubcomponentSpecificWorkspace, (Object)workspaceName, (Object)componentName);
                    } else {
                        dialogMessage = NLS.bind((String)Messages.WarnCreateBaselineDilemmaHandler_uncheckedInChangesInSubcomponentSpecificComponent, (Object)componentName);
                    }
                }
                catch (TeamRepositoryException configuration) {
                    // empty catch block
                }
                progress.done();
            } else {
                dialogMessage = Messages.WarnCreateBaselineDilemmaHandler_uncheckedInChangesInSubcomponents;
            }
            int yesIndex = this.getIndexOfYesButton();
            int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMessage, (String[])this.yesNoButtons, (int)4, (int)yesIndex);
            if (code == yesIndex) {
                return 3;
            }
        }
        return 1;
    }
}

