/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IEncodingUploadFailure;
import com.ibm.team.filesystem.client.operations.ILineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IUploadFailure;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.ListDetailsDialog;
import com.ibm.team.filesystem.rcp.ui.internal.util.CollisionListSelectionDialog;
import com.ibm.team.filesystem.rcp.ui.internal.util.StatusDialog;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.ShareableLabelProvider;
import com.ibm.team.internal.filesystem.ui.util.SymbolicLinkDetailsDialog;
import com.ibm.team.internal.filesystem.ui.util.WarnBackupUserWithConsole;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class WarnCommitUser
extends CommitDilemmaHandler {
    private Shell shell;
    private String title;
    private BackupDilemmaHandler warnBackupUser;
    private HashSet<IShare> sharesToRefresh = null;

    public WarnCommitUser(Shell shell, String title) {
        this(shell, title, (BackupDilemmaHandler)new WarnBackupUserWithConsole(shell, title));
    }

    public WarnCommitUser(Shell shell, String title, BackupDilemmaHandler backupHandler) {
        this.shell = shell;
        this.title = title;
        this.warnBackupUser = backupHandler;
    }

    public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
        return new OutOfSyncDilemmaHandler(){

            public int deletedContent(Collection<IShareable> contentDeleted) {
                return WarnCommitUser.this.promptDeletedContent(contentDeleted, Messages.WarnCommitUser_contentDeletedMessage_outOfSyncHandler);
            }

            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return WarnCommitUser.this.warnBackupUser;
            }

            public int outOfSync(final Collection<IShareOutOfSync> sharesOutOfSync) {
                if (sharesOutOfSync.isEmpty()) {
                    return 0;
                }
                final int[] result = new int[]{1};
                IShare[] shares = new IShare[sharesOutOfSync.size()];
                int i = 0;
                for (IShareOutOfSync shareOutOfSync : sharesOutOfSync) {
                    shares[i] = shareOutOfSync.getShare();
                    ++i;
                }
                if (PlatformUI.isWorkbenchRunning()) {
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            IStatus[] statuses = new IStatus[sharesOutOfSync.size()];
                            int i = 0;
                            for (IShareOutOfSync shareOutOfSync : sharesOutOfSync) {
                                String componentInfo = "";
                                ISharingDescriptor descriptor = shareOutOfSync.getShare().getSharingDescriptor();
                                if (descriptor != null) {
                                    componentInfo = NLS.bind((String)Messages.WarnCommitUser_workspaceAndComponentNameFormatString, (Object)descriptor.getConnectionName(), (Object)descriptor.getComponentName());
                                }
                                statuses[i] = FileSystemStatusUtil.getStatusFor((int)1, (String)NLS.bind((String)Messages.WarnCommitUser_3, (Object)shareOutOfSync.getShare().getPath(), (Object)componentInfo));
                                ++i;
                            }
                            Arrays.sort(statuses, new Comparator<IStatus>(){

                                @Override
                                public int compare(IStatus status1, IStatus status2) {
                                    String msg1 = status1.getMessage();
                                    String msg2 = status2.getMessage();
                                    return msg1.compareToIgnoreCase(msg2);
                                }
                            });
                            Object status = statuses.length > 1 ? new MultiStatus("com.ibm.team.filesystem.client", 4, statuses, NLS.bind((String)Messages.WarnCommitUser_4, (Object)statuses.length), null) : statuses[0];
                            StatusDialog dialog = new StatusDialog(DialogUtil.checkShell(WarnCommitUser.this.shell), WarnCommitUser.this.title, Messages.WarnCommitUser_0, "", status, 7);
                            if (dialog.open() == 0) {
                                result[0] = 0;
                            }
                        }
                    });
                }
                return result[0];
            }

            public boolean willIgnoreAllSharesOutOfSync() {
                return false;
            }
        };
    }

    public BackupDilemmaHandler getBackupDilemmaHandler() {
        return this.warnBackupUser;
    }

    public int lineDelimiterErrors(Collection<? extends ILineDelimiterUploadFailure> failedUploads, IProgressMonitor monitor) {
        return this.promptForConversion(failedUploads);
    }

    public int nonPatchShareables(Collection<IShareable> nonPatchContent) {
        return this.promptNonPatchContent(nonPatchContent, Messages.WarnCommitUser_nonPatchContent);
    }

    public int localConflicts(List<IShareable> conflictedLocalChanges) {
        if (!conflictedLocalChanges.isEmpty()) {
            return this.promptForLocalConflicts(conflictedLocalChanges, Messages.WarnCommitUser_localConflicts);
        }
        return 0;
    }

    public int encodingErrors(Collection<? extends IEncodingUploadFailure> failedUploads, IProgressMonitor monitor) {
        ArrayList<IEncodingUploadFailure> toPrompt = new ArrayList<IEncodingUploadFailure>(failedUploads.size());
        super.encodingErrors(failedUploads, monitor);
        for (IEncodingUploadFailure iEncodingUploadFailure : failedUploads) {
            if (iEncodingUploadFailure.hasDirection()) continue;
            toPrompt.add(iEncodingUploadFailure);
        }
        if (!toPrompt.isEmpty()) {
            return this.promptForEncoding(toPrompt);
        }
        return 0;
    }

    public void refreshed(IShareable shareable, IProgressMonitor progress) {
        IShare share;
        if (this.sharesToRefresh == null) {
            this.sharesToRefresh = new HashSet();
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress);
        try {
            share = shareable.getShare((IProgressMonitor)mon);
        }
        catch (FileSystemException e) {
            LoggingHelper.error((String)"com.ibm.team.filesystem.ide.ui", (String)"Couldn't get share", (Throwable)e);
            return;
        }
        if (share == null) {
            LoggingHelper.error((String)"com.ibm.team.filesystem.ide.ui", (String)NLS.bind((String)"Missing share for {0}", (Object)shareable.getFullPath()), (Throwable)new Exception());
            return;
        }
        this.sharesToRefresh.add(share);
    }

    public void unsupportedOutOfSync(IShareable shareable, IProgressMonitor prog) {
        this.refreshed(shareable, prog);
    }

    public void linkWarnings(boolean anyBrokenLinks, boolean anyNonInteroperableLinks, final IShareable[] shareables, final String[] targets, final Boolean[] directoryLinks, final Boolean[] broken, final Boolean[] nonInteroperable) {
        if (PlatformUI.isWorkbenchRunning()) {
            boolean promptForNonInteroperable;
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            final IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            boolean promptForBroken = store.getInt("checkinLinkWarnings") == 0 || store.getInt("checkinLinkWarnings") == 1;
            boolean bl = promptForNonInteroperable = store.getInt("checkinLinkWarnings") == 0;
            if (anyBrokenLinks && promptForBroken || anyNonInteroperableLinks && promptForNonInteroperable) {
                this.shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        SymbolicLinkDetailsDialog dialog = new SymbolicLinkDetailsDialog(WarnCommitUser.this.shell, promptForNonInteroperable, shareables, targets, directoryLinks, broken, nonInteroperable);
                        dialog.open();
                        if (!dialog.shouldPromptAgain()) {
                            store.setValue("checkinLinkWarnings", 2);
                        }
                    }
                });
            }
        }
    }

    public void commitComplete() {
        if (this.sharesToRefresh != null) {
            this.notifyRefreshed();
        }
    }

    private void notifyRefreshed() {
        if (this.sharesToRefresh.size() == 0) {
            final MessageDialog dialog = new MessageDialog(this.shell, Messages.WarnCommitUser_REFRESHED_TITLE, null, Messages.WarnCommitUser_REFRESHED_TEXT, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.setBlockOnOpen(false);
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    dialog.open();
                }
            });
            return;
        }
        final MessageDialog dialog = new MessageDialog(this.shell, Messages.WarnCommitUser_RESOURCES_REFRESHED_DIALOG_TITLE, null, Messages.WarnCommitUser_RESOURCES_REFRESHED_DIALOG_MESSAGE, 2, new String[]{Messages.WarnCommitUser_BUTTON_COMPONENTS, Messages.WarnCommitUser_BUTTON_SHARES, Messages.WarnCommitUser_BUTTON_NONE}, 2);
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                int r = dialog.open();
                if (r == 0) {
                    Job job = new Job(Messages.WarnCommitUser_PROGRESS_REFRESHING_COMPONENTS){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                WarnCommitUser.this.refreshComponents(WarnCommitUser.this.sharesToRefresh, monitor);
                            }
                            catch (FileSystemException e) {
                                return FileSystemStatusUtil.getStatusFor((Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                } else if (r == 1) {
                    Job job = new Job(Messages.WarnCommitUser_PROGRESS_REFRESHING_SHARES){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                ArrayList<IShareable> toRefresh = new ArrayList<IShareable>(WarnCommitUser.this.sharesToRefresh.size());
                                for (IShare share : WarnCommitUser.this.sharesToRefresh) {
                                    toRefresh.add(share.getShareable());
                                }
                                FileSystemCore.getSharingManager().getLocalChangeManager().refreshChanges(toRefresh, ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN, monitor);
                            }
                            catch (FileSystemException e) {
                                return FileSystemStatusUtil.getStatusFor((Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                } else if (r != 2) {
                    LoggingHelper.log((String)"com.ibm.team.filesystem.ide.ui", (TeamRepositoryException)new TeamRepositoryException("Unexpected return value from refresh dialog: " + r));
                }
            }
        });
    }

    private void refreshComponents(HashSet<IShare> sharesInComps, IProgressMonitor progress) throws FileSystemException {
        SharingManager sm = SharingManager.getInstance();
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)(sharesInComps.size() * 2));
        HashMap visited = new HashMap();
        for (IShare exemplar : sharesInComps) {
            IShare[] allShares;
            HashSet compSet;
            ISandbox sb = exemplar.getSandbox();
            ISharingDescriptor desc = exemplar.getSharingDescriptor();
            HashMap<UUID, HashSet<UUID>> wsAndComp = (HashMap<UUID, HashSet<UUID>>)visited.get(sb);
            if (wsAndComp == null) {
                compSet = new HashSet();
                compSet.add(desc.getComponent().getItemId());
                wsAndComp = new HashMap<UUID, HashSet<UUID>>();
                wsAndComp.put(desc.getConnectionHandle().getItemId(), compSet);
            } else {
                compSet = (HashSet)wsAndComp.get(desc.getConnectionHandle().getItemId());
                if (compSet == null) {
                    HashSet<UUID> compSet2 = new HashSet<UUID>();
                    compSet2.add(desc.getComponent().getItemId());
                    wsAndComp.put(desc.getConnectionHandle().getItemId(), compSet2);
                } else {
                    if (compSet.contains(desc.getComponent().getItemId())) {
                        mon.worked(1);
                        continue;
                    }
                    compSet.add(desc.getComponent().getItemId());
                }
            }
            IShare[] iShareArray = allShares = sm.allShares(sb.getRoot(), desc.getConnectionHandle(), desc.getComponent(), (IProgressMonitor)mon.newChild(1));
            int n = allShares.length;
            int n2 = 0;
            while (n2 < n) {
                IShare toRefresh = iShareArray[n2];
                LocalChangeManager.getInstance().addToRefresh(toRefresh.getShareable(), ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN);
                ++n2;
            }
        }
        mon.setWorkRemaining(1);
        LocalChangeManager.getInstance().doRefresh((IProgressMonitor)mon.newChild(1));
    }

    private int promptForEncoding(final Collection<? extends IEncodingUploadFailure> lineDelimiterFailures) {
        final int[] result = new int[]{1};
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                IEncodingUploadFailure[] failures = lineDelimiterFailures.toArray(new IEncodingUploadFailure[lineDelimiterFailures.size()]);
                int i = 0;
                while (i < failures.length) {
                    failures[i].setIgnoreEncoding(false);
                    ++i;
                }
                Arrays.sort(failures, new Comparator<IEncodingUploadFailure>(){

                    @Override
                    public int compare(IEncodingUploadFailure failure1, IEncodingUploadFailure failure2) {
                        String msg1 = failure1.getShareable().getLocalPath().toString();
                        String msg2 = failure2.getShareable().getLocalPath().toString();
                        return msg1.compareToIgnoreCase(msg2);
                    }
                });
                String msg = Messages.WarnCommitUser_2;
                CollisionListSelectionDialog dialog = new CollisionListSelectionDialog(DialogUtil.checkShell(WarnCommitUser.this.shell), (Object)failures, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new UploadFailureLabelProvider(), msg, false, "com.ibm.team.filesystem.ide.ui.dialog_warn_of_bad_encoding");
                dialog.setTitle(WarnCommitUser.this.title);
                if (dialog.open() == 0) {
                    Object[] toConvert = dialog.getResult();
                    int i2 = 0;
                    while (i2 < toConvert.length) {
                        IEncodingUploadFailure lineDelimiterFailure = (IEncodingUploadFailure)toConvert[i2];
                        lineDelimiterFailure.setIgnoreEncoding(true);
                        ++i2;
                    }
                    int cfr_ignored_0 = toConvert.length;
                    int cfr_ignored_1 = failures.length;
                    result[0] = 0;
                }
            }
        });
        return result[0];
    }

    private int promptForConversion(final Collection<? extends ILineDelimiterUploadFailure> lineDelimiterFailures) {
        final int[] result = new int[]{1};
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ILineDelimiterUploadFailure[] failures = lineDelimiterFailures.toArray(new ILineDelimiterUploadFailure[lineDelimiterFailures.size()]);
                int i = 0;
                while (i < failures.length) {
                    failures[i].setForceConsistentDelimiters(false);
                    ++i;
                }
                Arrays.sort(failures, new Comparator<ILineDelimiterUploadFailure>(){

                    @Override
                    public int compare(ILineDelimiterUploadFailure failure1, ILineDelimiterUploadFailure failure2) {
                        String msg1 = failure1.getShareable().getLocalPath().toString();
                        String msg2 = failure2.getShareable().getLocalPath().toString();
                        return msg1.compareToIgnoreCase(msg2);
                    }
                });
                String msg = Messages.WarnCommitUser_6;
                CollisionListSelectionDialog dialog = new CollisionListSelectionDialog(DialogUtil.checkShell(WarnCommitUser.this.shell), (Object)failures, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new UploadFailureLabelProvider(), msg, false, "com.ibm.team.filesystem.ide.ui.dialog_warn_of_inconsistent_line_delimiters");
                dialog.setTitle(WarnCommitUser.this.title);
                if (dialog.open() == 0) {
                    Object[] toConvert = dialog.getResult();
                    int i2 = 0;
                    while (i2 < toConvert.length) {
                        ILineDelimiterUploadFailure lineDelimiterFailure = (ILineDelimiterUploadFailure)toConvert[i2];
                        lineDelimiterFailure.setForceConsistentDelimiters(true);
                        ++i2;
                    }
                    result[0] = 0;
                }
            }
        });
        return result[0];
    }

    public int predecessorContentDeletedErrors(Collection<IShareable> failedUploads) {
        String message = Messages.WarnCommitUser_contentDeletedMessage;
        int result = this.promptDeletedContent(failedUploads, message);
        if (result == 2) {
            return 0;
        }
        if (result == 3) {
            return 3;
        }
        return 1;
    }

    public int deletedContent(Collection<IShareable> contentDeleted) {
        String message = Messages.WarnCommitUser_contentDeletedMessage;
        int result = this.promptDeletedContent(contentDeleted, message);
        if (result == 2) {
            return 0;
        }
        if (result == 3) {
            return 1;
        }
        return 2;
    }

    private int promptForLocalConflicts(final List<IShareable> conflictedShareables, final String message) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        final int[] result = new int[]{-1};
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ListDetailsDialog dialog = new ListDetailsDialog(WarnCommitUser.this.shell, WarnCommitUser.this.title, message, 8, DetailsDialog.ButtonBar.YesNoDetails, conflictedShareables);
                LinkedHashMap<Integer, String> buttons = new LinkedHashMap<Integer, String>();
                buttons.put(2, Messages.WarnCommitUser_checkinButton);
                buttons.put(1, IDialogConstants.CANCEL_LABEL);
                buttons.put(13, IDialogConstants.SHOW_DETAILS_LABEL);
                dialog.initializeButtons(buttons);
                dialog.setDefaultButtonId(1);
                dialog.setLabelProvider((IBaseLabelProvider)new ShareableLabelProvider());
                result[0] = dialog.open();
            }
        });
        if (result[0] == 2) {
            return 0;
        }
        return 1;
    }

    private int promptDeletedContent(final Collection<IShareable> deletedContent, final String message) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        final int[] result = new int[]{-1};
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ListDetailsDialog dialog = new ListDetailsDialog(WarnCommitUser.this.shell, WarnCommitUser.this.title, message, 4, DetailsDialog.ButtonBar.YesNoDetails, deletedContent);
                LinkedHashMap<Integer, String> buttons = new LinkedHashMap<Integer, String>();
                buttons.put(2, Messages.WarnCommitUser_checkinButton);
                buttons.put(3, Messages.WarnCommitUser_skipButton);
                buttons.put(1, IDialogConstants.CANCEL_LABEL);
                buttons.put(13, IDialogConstants.SHOW_DETAILS_LABEL);
                dialog.initializeButtons(buttons);
                dialog.setDefaultButtonId(3);
                dialog.setLabelProvider((IBaseLabelProvider)new ShareableLabelProvider());
                result[0] = dialog.open();
            }
        });
        return result[0];
    }

    private int promptNonPatchContent(final Collection<IShareable> nonPatchContent, final String message) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        final int[] result = new int[]{-1};
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ListDetailsDialog dialog = new ListDetailsDialog(WarnCommitUser.this.shell, WarnCommitUser.this.title, message, 4, DetailsDialog.ButtonBar.YesNoDetails, nonPatchContent);
                LinkedHashMap<Integer, String> buttons = new LinkedHashMap<Integer, String>();
                buttons.put(2, Messages.WarnCommitUser_checkinButton);
                buttons.put(1, IDialogConstants.CANCEL_LABEL);
                buttons.put(13, IDialogConstants.SHOW_DETAILS_LABEL);
                dialog.initializeButtons(buttons);
                dialog.setDefaultButtonId(1);
                dialog.setLabelProvider((IBaseLabelProvider)new ShareableLabelProvider());
                result[0] = dialog.open();
            }
        });
        if (result[0] == 2) {
            return 0;
        }
        return 1;
    }

    public int inaccessibleForUpdate(final Collection<IShareable> shareables) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        final IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        boolean prompt = prefStore.getBoolean("warn_commit_inaccessible_changes");
        if (prompt) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    ListDetailsDialog dialog = new ListDetailsDialog(WarnCommitUser.this.shell, WarnCommitUser.this.title, Messages.WarnCommitUser_inaccessibleForUpdateMessage, 8, DetailsDialog.ButtonBar.OkDetails, shareables);
                    dialog.setLabelProvider((IBaseLabelProvider)new ShareableLabelProvider());
                    dialog.setDefaultButtonId(0);
                    dialog.initializeToggleButtonDontShowMeThisAgain(prefStore, "warn_commit_inaccessible_changes");
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        prefStore.setValue("warn_commit_inaccessible_changes", !dialog.getToggleState());
                    }
                }
            });
        }
        return 0;
    }

    public int siblingSharesToAdd(final Collection<IShareable> shareables) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        int[] result = new int[]{1};
        final IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        final int[] returnCode = new int[]{2};
        if (this.containsOnlySubcomponentInfoFiles(shareables)) {
            returnCode[0] = 3;
        } else {
            int prompt = prefStore.getInt("prompt_sibling_shares_to_add");
            if (prompt == -1) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ListDetailsDialog dialog = new ListDetailsDialog(WarnCommitUser.this.shell, WarnCommitUser.this.title, Messages.WarnCommitUser_siblingSharesToAddMessage, 4, DetailsDialog.ButtonBar.YesNoDetails, shareables);
                        dialog.setLabelProvider((IBaseLabelProvider)new ShareableLabelProvider());
                        dialog.setDefaultButtonId(3);
                        dialog.initializeToggleButtonRememberMyDecision(prefStore, "prompt_sibling_shares_to_add");
                        dialog.openOrGetPreference(display);
                        returnCode[0] = dialog.getReturnCode();
                    }
                });
            } else {
                returnCode[0] = prompt;
            }
        }
        if (returnCode[0] == 2) {
            result[0] = 0;
        } else if (returnCode[0] == 3) {
            result[0] = 3;
        }
        return result[0];
    }

    private boolean containsOnlySubcomponentInfoFiles(Collection<IShareable> shareables) {
        if (shareables == null || shareables.isEmpty()) {
            return false;
        }
        for (IShareable shareable : shareables) {
            if (shareable == null || ".subcomponent_info".equals(shareable.getLocalPath().getName())) continue;
            return false;
        }
        return true;
    }

    private class UploadFailureLabelProvider
    extends BaseLabelProvider {
        private UploadFailureLabelProvider() {
        }

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof IUploadFailure) {
                IUploadFailure failure = (IUploadFailure)element;
                String name = failure.getShareable().getLocalPath().toString();
                if (element instanceof IEncodingUploadFailure) {
                    name = NLS.bind((String)Messages.WarnCommitUser_7, (Object)name, (Object)((IEncodingUploadFailure)element).getEncoding());
                }
                label.setText(name);
                ImageDescriptor desc = this.getImageDescriptor(failure);
                label.setImage(desc == null ? null : this.getResources().createImageWithDefault(desc));
            }
        }

        private ImageDescriptor getImageDescriptor(IUploadFailure failure) {
            IWorkbenchAdapter wbAdapter;
            IResource resource = (IResource)failure.getShareable().getAdapter(IResource.class);
            if (resource != null && (wbAdapter = (IWorkbenchAdapter)resource.getAdapter(IWorkbenchAdapter.class)) != null) {
                return wbAdapter.getImageDescriptor((Object)resource);
            }
            return null;
        }
    }
}

