/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.operations.CloseChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CompleteCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.OpenPortEditorAction;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.ListDetailsDialog;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.ChangeSetLabelProvider;
import com.ibm.team.internal.filesystem.ui.util.WarnCompleteCurrentPortsUser;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class WarnCloseChangeSets
extends CloseChangeSetsDilemmaHandler {
    private Shell shell;
    private IWorkspaceConnection workspaceConnection;

    public WarnCloseChangeSets(Shell shell, IWorkspaceConnection workspaceConnection) {
        this.shell = shell;
        this.workspaceConnection = workspaceConnection;
    }

    public int portsInProgress(final List<IChangeSet> targetChangeSets) {
        DialogUtil.pauseIfNeededBeforeShowingDialog();
        Display display = PlatformUI.getWorkbench().getDisplay();
        final int[] result = new int[]{1};
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ListDetailsDialog dialog = new ListDetailsDialog(WarnCloseChangeSets.this.shell, Messages.WarnCloseChangeSets_DILEMMA_TITLE, Messages.WarnCloseChangeSets_PORTS_IN_PROGRESS_MESSAGE, 8, DetailsDialog.ButtonBar.OkCancelDetails, targetChangeSets);
                LinkedHashMap<Integer, String> buttons = new LinkedHashMap<Integer, String>();
                buttons.put(0, Messages.WarnCloseChangeSets_CONTINUE_BUTTON);
                buttons.put(1, IDialogConstants.CANCEL_LABEL);
                buttons.put(13, IDialogConstants.SHOW_DETAILS_LABEL);
                dialog.initializeButtons(buttons);
                dialog.setDefaultButtonId(1);
                dialog.setLabelProvider((IBaseLabelProvider)new ChangeSetLabelProvider());
                result[0] = dialog.open();
            }
        });
        if (result[0] == 0) {
            this.openGapEditors(targetChangeSets);
            return 0;
        }
        return 1;
    }

    private void openGapEditors(final List<IChangeSet> targetChangeSets) {
        final IItemManager itemManager = this.workspaceConnection.teamRepository().itemManager();
        UIJob job = new UIJob(Messages.PreferencesListener_0){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                for (IChangeSet changeSet : targetChangeSets) {
                    IComponentHandle componentHandle = changeSet.getComponent();
                    try {
                        IComponent component = (IComponent)itemManager.fetchCompleteItem((IItemHandle)componentHandle, 0, monitor);
                        OpenPortEditorAction.openPortEditor(null, WarnCloseChangeSets.this.workspaceConnection, component);
                    }
                    catch (TeamRepositoryException e) {
                        StatusUtil.log((Object)((Object)this), (Throwable)e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public CompleteCurrentPatchDilemmaHandler getCompleteCurrentPortDilemmaHandler() {
        return new WarnCompleteCurrentPortsUser(this.shell);
    }
}

