/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public abstract class TableOrTreeResizer
implements ControlListener {
    private Column[] columns;

    private Column newColumn(Item item, int index) {
        if (item instanceof TreeColumn) {
            return this.newColumn((TreeColumn)item, index);
        }
        if (item instanceof TableColumn) {
            return this.newColumn((TableColumn)item, index);
        }
        throw new IllegalArgumentException();
    }

    private TreeColumn2 newColumn(TreeColumn treeColumn, int index) {
        return new TreeColumn2(treeColumn, index);
    }

    private TableColumn2 newColumn(TableColumn tableColumn, int index) {
        return new TableColumn2(tableColumn, index);
    }

    public abstract Scrollable getScrollable();

    public abstract int getHeaderHeight();

    public abstract Item[] getColumnItems();

    private Column[] getColumns() {
        Item[] items = this.getColumnItems();
        if (this.columns.length != items.length) {
            this.makeColumns();
        } else {
            int i = 0;
            while (i < this.columns.length) {
                if (this.columns[i].getItem() != items[i]) {
                    this.makeColumns();
                }
                ++i;
            }
        }
        return this.columns;
    }

    protected void makeColumns() {
        Item[] items = this.getColumnItems();
        if (this.columns != null) {
            Column[] columnArray = this.columns;
            int n = this.columns.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                Item item = column.getItem();
                item.removeListener(11, (Listener)column);
                ++n2;
            }
        }
        this.columns = new Column[items.length];
        int i = 0;
        while (i < items.length) {
            Item item = items[i];
            this.columns[i] = this.newColumn(item, i);
            item.addListener(11, (Listener)this.columns[i]);
            ++i;
        }
    }

    public static void addResizeListener(Table table) {
        TableResizer resizer = new TableResizer(table);
        table.getParent().addControlListener((ControlListener)resizer);
    }

    public static void addResizeListener(Tree tree) {
        TreeResizer resizer = new TreeResizer(tree);
        tree.getParent().addControlListener((ControlListener)resizer);
        tree.addTreeListener((TreeListener)resizer);
    }

    protected void resize() {
        Scrollable scrollable = this.getScrollable();
        Rectangle area = scrollable.getParent().getClientArea();
        area.height = scrollable.getBounds().height;
        int newWidth = area.width;
        int resizableWidth = newWidth - scrollable.computeTrim((int)0, (int)0, (int)0, (int)0).width;
        int oldWidth = scrollable.getSize().x;
        Column[] columns = this.getColumns();
        if (oldWidth > newWidth) {
            TableOrTreeResizer.resize(columns, 0, resizableWidth);
            scrollable.setSize(newWidth, area.height);
        } else {
            scrollable.setSize(newWidth, area.height);
            TableOrTreeResizer.resize(columns, 0, resizableWidth);
        }
    }

    private static void resize(Column[] columns, int startIndex, int resizableWidth) {
        Column column;
        int totalWeight = 0;
        int columnLength = columns.length;
        int i = 0;
        while (i < startIndex) {
            column = columns[i];
            resizableWidth -= column.getWidth();
            ++i;
        }
        i = startIndex;
        while (i < columnLength) {
            column = columns[i];
            if (column.getResizable()) {
                totalWeight += column.getWeight();
            } else {
                resizableWidth -= column.getWidth();
            }
            ++i;
        }
        if (resizableWidth > 0) {
            i = startIndex;
            while (i < columnLength) {
                column = columns[i];
                if (column.getResizable()) {
                    float ratio = (float)column.getWeight() / (float)totalWeight;
                    int newWidth = (int)(ratio * (float)resizableWidth);
                    column.setWidth(Math.max(1, newWidth));
                }
                ++i;
            }
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.resize();
    }

    private abstract class Column
    implements Listener {
        private int index;
        private boolean autoResize;
        private int weight;

        protected Column(int index, int weight) {
            this.index = index;
            this.setWeight(weight);
        }

        public abstract int getWidth();

        public void setWidth(int width) {
            this.autoResize = true;
            this.setItemWidth(width);
            this.autoResize = false;
        }

        protected abstract void setItemWidth(int var1);

        public abstract boolean getResizable();

        public abstract Item getItem();

        public void handleEvent(Event event) {
            if (event.type == 11 && !this.autoResize) {
                Scrollable scrollable = TableOrTreeResizer.this.getScrollable();
                Rectangle area = scrollable.getParent().getClientArea();
                int resizableWidth = area.width - scrollable.computeTrim((int)0, (int)0, (int)0, (int)0).width;
                Column[] columns = TableOrTreeResizer.this.getColumns();
                TableOrTreeResizer.resize(columns, this.index + 1, resizableWidth);
                int i = 0;
                while (i < columns.length) {
                    columns[i].setWeight(columns[i].getWidth());
                    ++i;
                }
            }
        }

        public void setWeight(int weight) {
            this.weight = Math.max(1, weight);
        }

        public int getWeight() {
            return this.weight;
        }
    }

    public class TableColumn2
    extends Column {
        private TableColumn tableColumn;

        public TableColumn2(TableColumn tableColumn, int index) {
            super(index, tableColumn.getWidth());
            this.tableColumn = tableColumn;
        }

        @Override
        public boolean getResizable() {
            return this.tableColumn.getResizable();
        }

        @Override
        public int getWidth() {
            return this.tableColumn.getWidth();
        }

        @Override
        public void setItemWidth(int width) {
            this.tableColumn.setWidth(width);
        }

        @Override
        public Item getItem() {
            return this.tableColumn;
        }
    }

    private static class TableResizer
    extends TableOrTreeResizer {
        private Table table;

        public TableResizer(Table table) {
            this.table = table;
            this.makeColumns();
        }

        @Override
        public Item[] getColumnItems() {
            return this.table.getColumns();
        }

        @Override
        public int getHeaderHeight() {
            return this.table.getHeaderHeight();
        }

        @Override
        public Scrollable getScrollable() {
            return this.table;
        }
    }

    public class TreeColumn2
    extends Column {
        private TreeColumn treeColumn;

        public TreeColumn2(TreeColumn treeColumn, int index) {
            super(index, treeColumn.getWidth());
            this.treeColumn = treeColumn;
        }

        @Override
        public boolean getResizable() {
            return this.treeColumn.getResizable();
        }

        @Override
        public int getWidth() {
            return this.treeColumn.getWidth();
        }

        @Override
        public void setItemWidth(int width) {
            this.treeColumn.setWidth(width);
        }

        @Override
        public Item getItem() {
            return this.treeColumn;
        }
    }

    private static class TreeResizer
    extends TableOrTreeResizer
    implements TreeListener {
        private Tree tree;

        public TreeResizer(Tree tree) {
            this.tree = tree;
            this.makeColumns();
        }

        public void treeCollapsed(TreeEvent e) {
            this.resize();
        }

        public void treeExpanded(TreeEvent e) {
            this.resize();
        }

        @Override
        public Item[] getColumnItems() {
            return this.tree.getColumns();
        }

        @Override
        public int getHeaderHeight() {
            return this.tree.getHeaderHeight();
        }

        @Override
        public Scrollable getScrollable() {
            return this.tree;
        }
    }
}

