/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SymbolicLinkDetailsDialog
extends DetailsDialog {
    private List<Object[]> links = new ArrayList<Object[]>();
    private boolean showNonInteroperableLinks;

    public SymbolicLinkDetailsDialog(Shell parent, boolean showNonInteroperableLinks, IShareable[] shareables, String[] targets, Boolean[] directoryLinks, Boolean[] brokenLinks, Boolean[] nonInteroperableLinks) {
        super(parent, Messages.WarnCommitUser_12, SymbolicLinkDetailsDialog.getDialogMessage(shareables, brokenLinks, showNonInteroperableLinks), 8, DetailsDialog.ButtonBar.OkDetails);
        int i = 0;
        while (i < shareables.length) {
            Object[] entry = new Object[]{shareables[i], targets[i], directoryLinks[i], brokenLinks[i], nonInteroperableLinks[i]};
            this.links.add(entry);
            ++i;
        }
        this.showNonInteroperableLinks = showNonInteroperableLinks;
        this.initializeToggleButtonDontShowMeThisAgain(null, null);
    }

    private static String getDialogMessage(IShareable[] shareables, Boolean[] brokenLinks, boolean showNonInteroperableLinks) {
        if (showNonInteroperableLinks) {
            if (shareables.length == 1) {
                return Messages.WarnCommitUser_8;
            }
            return NLS.bind((String)Messages.SymbolicLinkDetailsDialog_0, (Object)shareables.length);
        }
        int brokenOnly = 0;
        Boolean[] booleanArray = brokenLinks;
        int n = brokenLinks.length;
        int n2 = 0;
        while (n2 < n) {
            Boolean broken = booleanArray[n2];
            if (broken.booleanValue()) {
                ++brokenOnly;
            }
            ++n2;
        }
        if (brokenOnly == 1) {
            return Messages.SymbolicLinkDetailsDialog_1;
        }
        return NLS.bind((String)Messages.SymbolicLinkDetailsDialog_2, (Object)brokenOnly);
    }

    @Override
    protected Composite createDropDownDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        TableViewer table = new TableViewer(composite, 2560);
        table.setLabelProvider((IBaseLabelProvider)new SymbolicLinkDetailsLabelProvider());
        table.setContentProvider((IContentProvider)new ArrayContentProvider());
        table.setInput(this.applyFilter());
        SymbolicLinkDetailsDialog.applyDialogFont((Control)composite);
        GridLayoutFactory.fillDefaults().generateLayout(composite);
        return composite;
    }

    private Object applyFilter() {
        if (this.showNonInteroperableLinks) {
            return this.links;
        }
        ArrayList<Object[]> filteredLinks = new ArrayList<Object[]>(this.links.size());
        for (Object[] entry : this.links) {
            if (!((Boolean)entry[3]).booleanValue()) continue;
            filteredLinks.add(entry);
        }
        return filteredLinks;
    }

    public boolean shouldPromptAgain() {
        return !this.getToggleState();
    }

    class SymbolicLinkDetailsLabelProvider
    extends TypeLabelProvider {
        private Image symbolicLink = this.getImage(ImagePool.SYMBOLIC_LINK);

        public void updateLabel(ViewerLabel label, Object element) {
            IShareable shareable = (IShareable)((Object[])element)[0];
            String target = (String)((Object[])element)[1];
            Boolean directoryLink = (Boolean)((Object[])element)[2];
            Boolean brokenLink = (Boolean)((Object[])element)[3];
            Boolean nonInteroperableLink = (Boolean)((Object[])element)[4];
            if (SymbolicLinkDetailsDialog.this.showNonInteroperableLinks) {
                label.setText(NLS.bind((String)Messages.WarnCommitUser_13, (Object[])new Object[]{shareable.getLocalPath().toString(), target, directoryLink != false ? Messages.WarnCommitUser_14 : Messages.WarnCommitUser_15, shareable.getSandbox().getRoot().toString(), brokenLink != false ? Messages.WarnCommitUser_17 : Messages.WarnCommitUser_18, nonInteroperableLink != false ? Messages.WarnCommitUser_19 : Messages.WarnCommitUser_20}));
            } else {
                label.setText(NLS.bind((String)Messages.SymbolicLinkDetailsDialog_3, (Object[])new Object[]{shareable.getLocalPath().toString(), target, directoryLink != false ? Messages.WarnCommitUser_14 : Messages.WarnCommitUser_15, shareable.getSandbox().getRoot().toString()}));
            }
            label.setImage(this.symbolicLink);
        }
    }
}

