/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.util.PendingChangesUtil;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class ShareablesUtil {
    public static Map<ItemId<IComponent>, WorkspaceNamespace> selectTargetWorkspaces(final UIContext uiContext, Collection<ItemId<IComponent>> components, final boolean checkLocal, final boolean checkShared, final String dialogMessage) throws TeamRepositoryException {
        HashMap selectedWorkspaces = NewCollection.hashMap();
        Iterator<ItemId<IComponent>> iterator = components.iterator();
        while (iterator.hasNext()) {
            ItemId<IComponent> next;
            final ItemId<IComponent> finalNext = next = iterator.next();
            final WorkspaceNamespace[] namespace = new WorkspaceNamespace[1];
            uiContext.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!uiContext.getShell().isDisposed()) {
                        namespace[0] = PendingChangesUtil.getTrackedWorkspaceForComponent(uiContext.getShell(), (ItemId<IComponent>)finalNext, checkLocal, checkShared, dialogMessage);
                    }
                }
            });
            if (namespace[0] == null) {
                throw new OperationCanceledException();
            }
            selectedWorkspaces.put(next, namespace[0]);
        }
        return selectedWorkspaces;
    }

    public static IShareable getShareableWithoutSandbox(IResource resource) {
        IShareable shareable = (IShareable)resource.getAdapter(IShareable.class);
        if (shareable == null) {
            Sandbox sandbox = new Sandbox((ILocation)new PathLocation(resource.getProject().getLocation().removeLastSegments(1)));
            shareable = new Shareable((ISandbox)sandbox, (IRelativeLocation)new RelativeLocation(resource.getFullPath().segments()), resource.getType() == 1 ? ResourceType.FILE : ResourceType.FOLDER);
        }
        return shareable;
    }

    public static VersionablePath getPathTo(IResource resource, IProgressMonitor monitor) throws FileSystemException {
        return CoreShareablesUtil.getPathTo((IResource)resource, (IProgressMonitor)monitor);
    }

    public static VersionablePathSegment getSegment(IResource resource, IProgressMonitor monitor) throws FileSystemException {
        return CoreShareablesUtil.getSegment((IResource)resource, (IProgressMonitor)monitor);
    }

    public static ItemId<IVersionable> getItem(IResource resource, IProgressMonitor monitor) throws FileSystemException {
        IShareable shareable = (IShareable)Adapters.getAdapter((Object)resource, IShareable.class);
        return ShareablesUtil.getItem(shareable, monitor);
    }

    public static SiloedItemId<IVersionable> getSiloedItem(IResource resource, IProgressMonitor monitor) throws FileSystemException {
        ISharingDescriptor descriptor;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IShareable shareable = (IShareable)Adapters.getAdapter((Object)resource, IShareable.class);
        ItemId component = null;
        IShare share = shareable.getShare((IProgressMonitor)progress.newChild(50));
        if (share != null && (descriptor = share.getSharingDescriptor()) != null) {
            component = ItemUtil.getComponent((IComponentHandle)descriptor.getComponent());
        }
        if (component == null) {
            component = ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);
        }
        return SiloedItemId.create((ItemId)ShareablesUtil.getItem(shareable, (IProgressMonitor)progress.newChild(50)), (ItemId)component);
    }

    public static ItemId getItem(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        return CoreShareablesUtil.getItem((IShareable)shareable, (IProgressMonitor)monitor);
    }

    public static ItemId getItem(ILocalChange next) {
        return new ItemId((IItemHandle)next.getTarget());
    }
}

