/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.rcp.ui.internal.RcpUiPlugin;
import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.SymbolicLinkItemWrapper;
import com.ibm.team.internal.filesystem.ui.views.search.files.FileSearchCriteria;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.IManagedItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IFileSearchCriteria;
import com.ibm.team.scm.common.dto.IQueryPageDescriptor;
import com.ibm.team.scm.common.dto.ISiloedVersionablePath;
import com.ibm.team.scm.common.dto.ISiloedVersionablePathResult;
import com.ibm.team.scm.common.dto.ISynchronizationTimes;
import com.ibm.team.scm.common.dto.IVersionableIdentifier;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class SearchFilesUtil {
    public static final String PATH_SEPARATOR = "/";

    public static List<AbstractFileSystemItemWrapper> fetchFileListForCriteria(FileSearchCriteria criteria, boolean needRefresh, ISynchronizationTimes[] syncTimes, IProgressMonitor monitor) throws TeamRepositoryException {
        return SearchFilesUtil.fetchFileList(criteria.getRepo(), criteria.getWorkspaceHandle(), criteria.getComponentHandle(), criteria.getFileNamePattern(), criteria.isCaseSensitive(), criteria.getMaxResults(), needRefresh, syncTimes, monitor);
    }

    private static List<AbstractFileSystemItemWrapper> fetchFileList(ITeamRepository repo, IWorkspaceHandle workspace, IComponentHandle componentHandle, String namePattern, boolean caseSensitive, int maxResults, boolean needRefresh, ISynchronizationTimes[] syncTimes, IProgressMonitor monitor) throws TeamRepositoryException {
        int siloedVersionablePathListSize;
        int MAX_QUERY_PAGE_SIZE;
        List<AbstractFileSystemItemWrapper> wrapperList = new ArrayList<AbstractFileSystemItemWrapper>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFileSearchCriteria criteria = IFileSearchCriteria.FACTORY.newInstance();
        criteria.setNamePattern(namePattern);
        criteria.setCaseSensitive(caseSensitive);
        criteria.setContextHandle((IManagedItemHandle)workspace);
        if (componentHandle != null) {
            criteria.getComponents().add(componentHandle);
        }
        maxResults = maxResults >= (MAX_QUERY_PAGE_SIZE = 512) ? MAX_QUERY_PAGE_SIZE : maxResults;
        IQueryPageDescriptor pageDescriptor = IQueryPageDescriptor.FACTORY.forFirstPage(maxResults);
        ISiloedVersionablePathResult queryResult = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).searchFiles(criteria, pageDescriptor, syncTimes, (IProgressMonitor)progress.newChild(50));
        List pathList = queryResult.getSiloedVersionables();
        ISiloedVersionablePath[] siloedVersionablePathList = pathList.toArray(new ISiloedVersionablePath[pathList.size()]);
        int n = siloedVersionablePathListSize = siloedVersionablePathList != null ? siloedVersionablePathList.length : 0;
        if (siloedVersionablePathListSize > 0) {
            HashMap<UUID, IComponentHandle> componentHandleMap = new HashMap<UUID, IComponentHandle>();
            ISiloedVersionablePath[] iSiloedVersionablePathArray = siloedVersionablePathList;
            int n2 = siloedVersionablePathList.length;
            int n3 = 0;
            while (n3 < n2) {
                ISiloedVersionablePath siloedVersionablePath = iSiloedVersionablePathArray[n3];
                if (siloedVersionablePath != null) {
                    componentHandleMap.put(siloedVersionablePath.getComponent().getItemId(), siloedVersionablePath.getComponent());
                }
                ++n3;
            }
            HashMap<UUID, IComponent> componentMap = new HashMap<UUID, IComponent>(componentHandleMap.size());
            if (!componentHandleMap.isEmpty()) {
                int refreshFlag = needRefresh ? 1 : 0;
                IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(new ArrayList(componentHandleMap.values()), refreshFlag, (IProgressMonitor)progress.newChild(20));
                for (Object listItem : fetchResult.getRetrievedItems()) {
                    if (!(listItem instanceof IComponent)) continue;
                    IComponent comp = (IComponent)listItem;
                    componentMap.put(comp.getItemHandle().getItemId(), comp);
                }
            }
            componentHandleMap.clear();
            componentHandleMap = null;
            LinkedHashMap<VersionableHandleMapKey, AbstractFileSystemItemWrapper> versionableHandleWrapperMap = new LinkedHashMap<VersionableHandleMapKey, AbstractFileSystemItemWrapper>();
            if (componentMap.size() > 0) {
                ISiloedVersionablePath[] iSiloedVersionablePathArray2 = siloedVersionablePathList;
                int n4 = siloedVersionablePathList.length;
                int n5 = 0;
                while (n5 < n4) {
                    ISiloedVersionablePath siloedVersionablePath = iSiloedVersionablePathArray2[n5];
                    IComponent wrapperComponent = (IComponent)componentMap.get(siloedVersionablePath.getComponent().getItemId());
                    if (wrapperComponent != null) {
                        WorkspaceNamespace wrkSpcNameSpace = (WorkspaceNamespace)WorkspaceNamespace.create((IWorkspaceHandle)workspace, (IComponentHandle)siloedVersionablePath.getComponent());
                        StateId stateId = SearchFilesUtil.getStateIdFromVersionableHandle(siloedVersionablePath.getItem());
                        Object wrapper = SearchFilesUtil.createWrapper(stateId, PathUtils.getBaseName((String)siloedVersionablePath.getVersionablePath()), (ItemNamespace)wrkSpcNameSpace);
                        if (wrapper != null) {
                            ((AbstractFileSystemItemWrapper)((Object)wrapper)).setPath(siloedVersionablePath.getVersionablePath());
                            ((AbstractFileSystemItemWrapper)((Object)wrapper)).setComponent(wrapperComponent);
                            VersionableHandleMapKey versionHndlMapKey = new VersionableHandleMapKey(wrapperComponent.getItemId(), stateId.getItemUUID(), stateId.getStateUUID());
                            versionableHandleWrapperMap.put(versionHndlMapKey, (AbstractFileSystemItemWrapper)((Object)wrapper));
                            wrapperList.add((AbstractFileSystemItemWrapper)((Object)wrapper));
                        }
                    }
                    ++n5;
                }
                wrapperList = SearchFilesUtil.fillVersionPropertyIntoWrappers(repo, versionableHandleWrapperMap, (IProgressMonitor)progress.newChild(30));
            }
        }
        return wrapperList;
    }

    private static <T extends AbstractFileSystemItemWrapper> T createWrapper(StateId state, String fqName, ItemNamespace workspace) {
        IItemType itemType = state.getItemType();
        if (IFileItem.ITEM_TYPE.equals(itemType)) {
            return (T)((Object)new FileItemWrapper(state, fqName, workspace));
        }
        if (ISymbolicLink.ITEM_TYPE.equals(itemType)) {
            return (T)((Object)new SymbolicLinkItemWrapper(state, fqName, workspace));
        }
        return null;
    }

    private static StateId getStateIdFromVersionableHandle(IVersionableHandle versionableHandle) {
        StateId stateId = new StateId(versionableHandle.getItemType(), versionableHandle.getItemId(), versionableHandle.getStateId());
        return stateId;
    }

    private static List<AbstractFileSystemItemWrapper> fillVersionPropertyIntoWrappers(ITeamRepository repository, Map<VersionableHandleMapKey, AbstractFileSystemItemWrapper> versionableHandleWrapperMap, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (versionableHandleWrapperMap != null && versionableHandleWrapperMap.size() > 0) {
            Set<Map.Entry<VersionableHandleMapKey, AbstractFileSystemItemWrapper>> versionHandleFileItemEntrySet = versionableHandleWrapperMap.entrySet();
            List<Map.Entry<VersionableHandleMapKey, IVersionableHandle>> versionableHandleEntryList = SearchFilesUtil.getVersionableHandleList(versionHandleFileItemEntrySet);
            Map<VersionableHandleMapKey, IVersionableIdentifier> versionHandleVersionIdMap = SearchFilesUtil.getVersionHandleVersionIdMap(repository, versionableHandleEntryList, (IProgressMonitor)progress);
            if (RcpUiPlugin.getDefault().getPreferenceStore().getBoolean("pref_show_version_identifiers_repository_id")) {
                for (Map.Entry<VersionableHandleMapKey, AbstractFileSystemItemWrapper> vhFileWrapperEntry : versionHandleFileItemEntrySet) {
                    IVersionableIdentifier versionableIdentifier = versionHandleVersionIdMap.get(vhFileWrapperEntry.getKey());
                    if (versionableIdentifier == null) continue;
                    vhFileWrapperEntry.getValue().setVersionNumber(SearchFilesUtil.showVersionId(versionableIdentifier));
                }
            } else {
                for (Map.Entry<VersionableHandleMapKey, AbstractFileSystemItemWrapper> vhFileWrapperEntry : versionHandleFileItemEntrySet) {
                    IVersionableIdentifier versionableIdentifier = versionHandleVersionIdMap.get(vhFileWrapperEntry.getKey());
                    if (versionableIdentifier == null) continue;
                    vhFileWrapperEntry.getValue().setVersionNumber(SearchFilesUtil.showVersionNumber(versionableIdentifier));
                }
            }
            return new ArrayList<AbstractFileSystemItemWrapper>(versionableHandleWrapperMap.values());
        }
        return new ArrayList<AbstractFileSystemItemWrapper>();
    }

    private static List<Map.Entry<VersionableHandleMapKey, IVersionableHandle>> getVersionableHandleList(Set<Map.Entry<VersionableHandleMapKey, AbstractFileSystemItemWrapper>> vHandleFileItemEntrySet) {
        LinkedHashMap<VersionableHandleMapKey, IVersionableHandle> versionableHandleMap = new LinkedHashMap<VersionableHandleMapKey, IVersionableHandle>();
        if (vHandleFileItemEntrySet != null && vHandleFileItemEntrySet.size() > 0) {
            for (Map.Entry<VersionableHandleMapKey, AbstractFileSystemItemWrapper> vhFileEntry : vHandleFileItemEntrySet) {
                IVersionableHandle versionHndl = (IVersionableHandle)vhFileEntry.getValue().getFileItem().toHandle();
                if (versionableHandleMap.containsKey(vhFileEntry.getKey())) continue;
                versionableHandleMap.put(vhFileEntry.getKey(), versionHndl);
            }
        }
        LinkedList<Map.Entry<VersionableHandleMapKey, IVersionableHandle>> versionableHandleEntryList = new LinkedList<Map.Entry<VersionableHandleMapKey, IVersionableHandle>>();
        if (!versionableHandleMap.isEmpty()) {
            versionableHandleEntryList.addAll(versionableHandleMap.entrySet());
        }
        return versionableHandleEntryList;
    }

    private static Map<VersionableHandleMapKey, IVersionableIdentifier> getVersionHandleVersionIdMap(ITeamRepository repository, List<Map.Entry<VersionableHandleMapKey, IVersionableHandle>> versionableHandleEntryList, IProgressMonitor monitor) throws TeamRepositoryException {
        LinkedHashMap<VersionableHandleMapKey, IVersionableIdentifier> versionHandleVersionIdMap = new LinkedHashMap<VersionableHandleMapKey, IVersionableIdentifier>();
        if (versionableHandleEntryList != null && versionableHandleEntryList.size() > 0) {
            LinkedList<IVersionableHandle> versionableHandleList = new LinkedList<IVersionableHandle>();
            for (Map.Entry<VersionableHandleMapKey, IVersionableHandle> entry : versionableHandleEntryList) {
                versionableHandleList.add(entry.getValue());
            }
            IVersionableHandle[] versionableHandleArray = versionableHandleList.toArray(new IVersionableHandle[versionableHandleList.size()]);
            IVersionableIdentifier[] identifiers = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).getVersionableIdentifiers(versionableHandleArray, monitor);
            int i = 0;
            while (i < identifiers.length) {
                if (identifiers[i] != null) {
                    versionHandleVersionIdMap.put(versionableHandleEntryList.get(i).getKey(), identifiers[i]);
                }
                ++i;
            }
        }
        return versionHandleVersionIdMap;
    }

    private static String showVersionId(IVersionableIdentifier versionableId) {
        return versionableId != null ? versionableId.getLongVersionId() : "";
    }

    private static String showVersionNumber(IVersionableIdentifier versionableId) {
        return versionableId != null ? versionableId.getShortVersionId() : "";
    }

    public static class VersionableHandleMapKey {
        private UUID stateId;
        private UUID itemId;
        private UUID compItemId;

        public VersionableHandleMapKey(UUID compItemId, UUID itemId, UUID stateId) {
            this.compItemId = compItemId;
            this.itemId = itemId;
            this.stateId = stateId;
        }

        public UUID getCompItemId() {
            return this.compItemId;
        }

        public void setCompItemId(UUID compItemId) {
            this.compItemId = compItemId;
        }

        public UUID getStateId() {
            return this.stateId;
        }

        public void setStateId(UUID stateId) {
            this.stateId = stateId;
        }

        public UUID getItemId() {
            return this.itemId;
        }

        public void setItemId(UUID itemId) {
            this.itemId = itemId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.compItemId == null ? 0 : this.compItemId.hashCode());
            result = 31 * result + (this.itemId == null ? 0 : this.itemId.hashCode());
            result = 31 * result + (this.stateId == null ? 0 : this.stateId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof VersionableHandleMapKey)) {
                return false;
            }
            VersionableHandleMapKey other = (VersionableHandleMapKey)obj;
            if (this.compItemId == null ? other.compItemId != null : !this.compItemId.equals((Object)other.compItemId)) {
                return false;
            }
            if (this.itemId == null ? other.itemId != null : !this.itemId.equals((Object)other.itemId)) {
                return false;
            }
            return !(this.stateId == null ? other.stateId != null : !this.stateId.equals((Object)other.stateId));
        }

        public String toString() {
            return "VersionableHandleMapKey [stateId=" + this.stateId + ", itemId=" + this.itemId + ", componentId=" + this.compItemId + "]";
        }
    }
}

