/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;

public class RepositoryUtils {
    private RepositoryUtils() {
    }

    public static String getLabel(ITeamRepository repo) {
        if (repo == null) {
            return Messages.RepositoryUtils_2;
        }
        String label = repo.getName();
        if (label == null || label.equals("")) {
            label = repo.getRepositoryURI();
        }
        return label;
    }

    public static void asyncLogin(final ITeamRepository repo, IOperationRunner runner) {
        runner.enqueue(Messages.RepositoryUtils_1, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                repo.login(monitor);
            }
        });
    }

    public static void loggedInDo(final UIContext context, final ITeamRepository repo, final Runnable runnable) {
        if (Display.getCurrent() == context.getDisplay() && repo.loggedIn()) {
            runnable.run();
            return;
        }
        context.getUserOperationRunner().enqueue(Messages.RepositoryUtils_1, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                repo.login(monitor);
                context.asyncExec(runnable);
            }
        });
    }
}

