/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IInvalidLoadLocation;
import com.ibm.team.filesystem.client.operations.IInvalidLoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.filesystem.client.operations.IMultipleSandboxLoad;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareableToLoad;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadOperationInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.ProblemReport;
import com.ibm.team.filesystem.rcp.ui.internal.util.StatusDialog;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnBackupUserWithConsole;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class PreparedLoadHandler
extends LoadDilemmaHandler {
    private Map<String, Boolean> preparedSharesToLoad;
    private Map<IRelativeLocation, ILoadLocation> preparedCollisionLocations;
    private Map<String, Boolean> preparedRemovedShares;
    private Collection<ILoadRequest> preparedInvalidRequests;
    private Map<IRelativeLocation, IShareOutOfSync> preparedSharesOutOfSync;
    private final LoadOperationInput input;

    public PreparedLoadHandler(LoadOperationInput input) {
        this.input = input;
        this.preparedSharesToLoad = new HashMap<String, Boolean>();
        this.preparedCollisionLocations = new HashMap<IRelativeLocation, ILoadLocation>();
        this.preparedRemovedShares = new HashMap<String, Boolean>();
        this.preparedInvalidRequests = new HashSet<ILoadRequest>();
        this.preparedSharesOutOfSync = new HashMap<IRelativeLocation, IShareOutOfSync>();
    }

    public void setLocation(IRelativeLocation path, ILoadLocation location) {
        this.preparedCollisionLocations.put(path, location);
    }

    public void newLoad(String path, boolean load) {
        this.preparedSharesToLoad.put(path, load);
    }

    public void removeShare(String path, boolean remove) {
        this.preparedRemovedShares.put(path, remove);
    }

    public void setInvalidLoadRequests(Collection<ILoadRequest> invalidRequests) {
        this.preparedInvalidRequests.clear();
        this.preparedInvalidRequests.addAll(invalidRequests);
    }

    public void setOutOfSync(IRelativeLocation path, IShareOutOfSync shareOutOfSync) {
        if (shareOutOfSync == null) {
            this.preparedSharesOutOfSync.remove(path);
        } else {
            this.preparedSharesOutOfSync.put(path, shareOutOfSync);
        }
    }

    public ILoadLocation getLocation(IRelativeLocation path) {
        return this.preparedCollisionLocations.get(path);
    }

    public Boolean isNewLoad(String path) {
        return this.preparedSharesToLoad.get(path);
    }

    public Boolean isRemoved(String path) {
        return this.preparedRemovedShares.get(path);
    }

    public void clearNewLoad() {
        for (String path : this.preparedSharesToLoad.keySet()) {
            this.preparedSharesToLoad.put(path, false);
        }
    }

    public void clearRemoveShare() {
        for (String path : this.preparedRemovedShares.keySet()) {
            this.preparedRemovedShares.put(path, false);
        }
    }

    public List<IStatus> isPreparedForCollisions(ILoadOperation loadOperation) {
        return this.preparedCollisions(loadOperation.getCollisions());
    }

    public List<IStatus> isPreparedForRemovedShares(ILoadOperation loadOperation) {
        return this.preparedRemovedShares(loadOperation.getSharesToBeRemoved());
    }

    public List<IStatus> isPreparedForNewItemsToLoad(ILoadOperation loadOperation) {
        return this.preparedNewItemsToLoad(loadOperation.getNewSharesToLoad(), false);
    }

    public boolean isPreparedFor(ILoadOperation loadOperation) {
        return this.isPreparedForCollisions(loadOperation).size() == 0 && this.isPreparedForNewItemsToLoad(loadOperation).size() == 0;
    }

    public void trimAnswersFor(ILoadOperation loadOperation) {
        Boolean answer;
        String path;
        HashMap<IRelativeLocation, ILoadLocation> newCollisionLocations = new HashMap<IRelativeLocation, ILoadLocation>();
        HashMap<String, Boolean> newRemovedShares = new HashMap<String, Boolean>();
        HashMap<String, Boolean> newSharesToLoad = new HashMap<String, Boolean>();
        ArrayList<ICollision> doNotOverwrite = new ArrayList<ICollision>();
        for (ICollision collision : loadOperation.getCollisions()) {
            path = collision.getShareable().getLocalPath().toString();
            Boolean overwrite = this.preparedSharesToLoad.get(path);
            if (overwrite == null) continue;
            newSharesToLoad.put(path, overwrite);
            if (overwrite.booleanValue()) continue;
            doNotOverwrite.add(collision);
        }
        for (ICollision collision : loadOperation.getCollisions()) {
            path = collision.getShareable().getLocalPath();
            ILoadLocation location = this.preparedCollisionLocations.get(path);
            if (location == null || doNotOverwrite.contains(collision) || !collision.getLocations().contains(location)) continue;
            newCollisionLocations.put((IRelativeLocation)path, location);
        }
        this.preparedCollisionLocations = newCollisionLocations;
        for (IRemovedShare removedShare : loadOperation.getSharesToBeRemoved()) {
            path = removedShare.getLocalPath().toString();
            answer = this.preparedRemovedShares.get(path);
            if (answer == null) continue;
            newRemovedShares.put(path, answer);
        }
        this.preparedRemovedShares = newRemovedShares;
        for (IShareableToLoad shareToLoad : loadOperation.getNewSharesToLoad()) {
            path = shareToLoad.getShareable().getLocalPath().toString();
            answer = this.preparedSharesToLoad.get(path);
            if (answer == null) continue;
            newSharesToLoad.put(path, answer);
        }
        this.preparedSharesToLoad = newSharesToLoad;
    }

    public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
        List<IStatus> stats = this.preparedCollisions(collisions);
        if (stats.size() > 0) {
            JFaceUtils.showError((String)Messages.PreparedLoadHandler_0, null, (IStatus)new MultiStatus("com.ibm.team.filesystem.client", 1, stats.toArray(new IStatus[stats.size()]), Messages.PreparedLoadHandler_2, null));
        }
        if ((stats = this.preparedRemovedShares(removedShares)).size() > 0) {
            JFaceUtils.showError((String)Messages.PreparedLoadHandler_1, null, (IStatus)new MultiStatus("com.ibm.team.filesystem.client", 1, stats.toArray(new IStatus[stats.size()]), Messages.PreparedLoadHandler_9, null));
        }
        return 0;
    }

    public int deletedContent(Collection<IShareable> contentDeleted) {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        final ArrayList<IRelativeLocation> input = new ArrayList<IRelativeLocation>();
        for (IShareable share : contentDeleted) {
            input.add(share.getLocalPath());
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = workbench.getActiveWorkbenchWindow().getShell();
                ListDialog dialog = new ListDialog(shell);
                dialog.setInput((Object)input);
                dialog.setMessage(Messages.PreparedLoadHandler_contentDeletedMessage);
                dialog.setTitle(Messages.PreparedLoadHandler_cannotLoadContent);
                dialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                dialog.setLabelProvider((ILabelProvider)new LabelProvider());
                dialog.open();
            }
        });
        return 0;
    }

    private List<IStatus> preparedCollisions(Collection<ICollision> collisions) {
        IRelativeLocation path;
        ArrayList<IStatus> stats = new ArrayList<IStatus>();
        ArrayList<ICollision> toChooseLocation = new ArrayList<ICollision>();
        for (ICollision collision : collisions) {
            if (collision.collidedWithExistingContent()) {
                path = collision.getShareable().getLocalPath();
                String stringPath = path.toString();
                if (this.preparedSharesOutOfSync.containsKey(path) || this.preparedSharesToLoad.containsKey(stringPath)) {
                    toChooseLocation.add(collision);
                    continue;
                }
                stats.add(FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.PreparedLoadHandler_3, (Object)stringPath)));
                collision.setLoadLocation(null);
                continue;
            }
            toChooseLocation.add(collision);
        }
        for (ICollision collision : toChooseLocation) {
            path = collision.getShareable().getLocalPath();
            String pathString = path.toString();
            Boolean load = this.preparedSharesToLoad.get(pathString);
            if (load == null) {
                stats.add(FileSystemStatusUtil.getStatusFor((int)1, (String)NLS.bind((String)Messages.PreparedLoadHandler_4, (Object)pathString)));
                collision.setLoadLocation(null);
                continue;
            }
            if (!load.booleanValue()) continue;
            ILoadLocation location = null;
            IShareOutOfSync outOfSync = this.preparedSharesOutOfSync.get(path);
            if (outOfSync != null) {
                for (ILoadLocation possibleLocation : collision.getLocations()) {
                    ISharingDescriptor sharingDescriptor = outOfSync.getShare().getSharingDescriptor();
                    if (!possibleLocation.getComponent().sameItemId((IItemHandle)sharingDescriptor.getComponent()) || !possibleLocation.getRootToLoad().sameItemId((IItemHandle)sharingDescriptor.getRootVersionable())) continue;
                    location = possibleLocation;
                    break;
                }
            }
            if (location == null) {
                location = this.preparedCollisionLocations.get(path);
            }
            if (location == null) {
                stats.add(FileSystemStatusUtil.getStatusFor((int)1, (String)NLS.bind((String)Messages.PreparedLoadHandler_5, (Object)pathString)));
                collision.setLoadLocation(null);
                continue;
            }
            if (!collision.getLocations().contains(location)) {
                stats.add(FileSystemStatusUtil.getStatusFor((int)1, (String)NLS.bind((String)Messages.PreparedLoadHandler_6, (Object)pathString, (Object)location.getComponent().getName())));
                collision.setLoadLocation(null);
                continue;
            }
            collision.setLoadLocation(location);
        }
        return stats;
    }

    private List<IStatus> preparedRemovedShares(Collection<IRemovedShare> removedShares) {
        ArrayList<IStatus> stats = new ArrayList<IStatus>();
        for (IRemovedShare removedShare : removedShares) {
            String path = removedShare.getLocalPath().toString();
            Boolean answer = this.preparedRemovedShares.get(path);
            if (answer == null) {
                stats.add(FileSystemStatusUtil.getStatusFor((int)1, (String)NLS.bind((String)path, (Object)Messages.PreparedLoadHandler_7)));
                removedShare.isToBeDeleted(false);
                continue;
            }
            removedShare.isToBeDeleted(answer.booleanValue());
        }
        return stats;
    }

    public int newItemsToLoad(Collection<IShareableToLoad> sharesToLoad) {
        List<IStatus> stats = this.preparedNewItemsToLoad(sharesToLoad, true);
        if (stats.size() > 0) {
            JFaceUtils.showError((String)Messages.PreparedLoadHandler_8, null, (IStatus)new MultiStatus("com.ibm.team.filesystem.client", 1, stats.toArray(new IStatus[stats.size()]), Messages.PreparedLoadHandler_10, null));
        }
        return 0;
    }

    private List<IStatus> preparedNewItemsToLoad(Collection<IShareableToLoad> sharesToLoad, boolean setShareToLoad) {
        String message = setShareToLoad ? Messages.PreparedLoadHandler_11 : Messages.PreparedLoadHandler_12;
        ArrayList<IStatus> stats = new ArrayList<IStatus>();
        for (IShareableToLoad shareToLoad : sharesToLoad) {
            String path = shareToLoad.getShareable().getLocalPath().toString();
            Boolean answer = this.preparedSharesToLoad.get(path);
            if (answer == null) {
                stats.add(FileSystemStatusUtil.getStatusFor((int)1, (String)NLS.bind((String)message, (Object)path)));
                answer = false;
            }
            if (!setShareToLoad) continue;
            shareToLoad.setWillLoad(answer.booleanValue());
        }
        return stats;
    }

    public int overlappingLoadRequests(Collection<ILoadOverlap> foldersOverlapping) {
        List<IStatus> stats = this.preparedOverlappingRequests(foldersOverlapping);
        JFaceUtils.showError((String)Messages.PreparedLoadHandler_13, (String)Messages.PreparedLoadHandler_14, (IStatus)new MultiStatus("com.ibm.team.filesystem.client", 4, stats.toArray(new IStatus[stats.size()]), Messages.PreparedLoadHandler_15, null));
        if (stats.size() > 0) {
            return 1;
        }
        return 0;
    }

    private List<IStatus> preparedOverlappingRequests(Collection<ILoadOverlap> foldersOverlapping) {
        ArrayList<IStatus> stats = new ArrayList<IStatus>();
        for (ILoadOverlap overlap : foldersOverlapping) {
            String[][] messages;
            String[][] stringArray = messages = ProblemReport.getOverlapMessages(this.input, overlap);
            int n = messages.length;
            int n2 = 0;
            while (n2 < n) {
                String[] shareOrFolderOverlap;
                String[] stringArray2 = shareOrFolderOverlap = stringArray[n2];
                int n3 = shareOrFolderOverlap.length;
                int n4 = 0;
                while (n4 < n3) {
                    String message = stringArray2[n4];
                    stats.add(FileSystemStatusUtil.getStatusFor((int)4, (String)message));
                    ++n4;
                }
                ++n2;
            }
        }
        return stats;
    }

    public int invalidLoadRequest(Collection<IInvalidLoadRequest> requests) {
        ArrayList<IStatus> stats = new ArrayList<IStatus>();
        for (IInvalidLoadRequest invalid : requests) {
            ILoadRequest request = invalid.getInvalidRequest();
            if (this.preparedInvalidRequests.contains(request)) continue;
            stats.add(invalid.getStatus());
        }
        if (!stats.isEmpty()) {
            JFaceUtils.showError((String)Messages.PreparedLoadHandler_16, null, (IStatus)new MultiStatus("com.ibm.team.filesystem.client", 1, stats.toArray(new IStatus[stats.size()]), Messages.PreparedLoadHandler_17, null));
        }
        return 0;
    }

    public int invalidLoadLocations(Collection<IInvalidLoadLocation> invalidLoadLocations) {
        ArrayList<IStatus> stats = new ArrayList<IStatus>();
        for (IInvalidLoadLocation ill : invalidLoadLocations) {
            if (this.preparedInvalidRequests.contains(ill.getLoadRequest())) continue;
            this.input.accumulateStatus(ill, stats);
        }
        if (!stats.isEmpty()) {
            JFaceUtils.showError((String)Messages.PreparedLoadHandler_16, null, (IStatus)StatusUtil.newStatus((Object)((Object)this), (String)Messages.PreparedLoadHandler_17, stats));
        }
        return 0;
    }

    public int multipleSandboxLoad(final Collection<IMultipleSandboxLoad> locations) {
        final int[] result = new int[]{1};
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IStatus status = PreparedLoadHandler.this.createStatus(locations);
                StatusDialog dialog = new StatusDialog(null, Messages.PreparedLoadHandler_MultipleSandboxLoadDialogTitle, Messages.PreparedLoadHandler_MultipleSandboxLoadDialogMessage, null, status, 7);
                if (dialog.open() == 0) {
                    result[0] = 0;
                }
            }
        });
        return result[0];
    }

    public BackupDilemmaHandler getBackupDilemmaHandler() {
        return new WarnBackupUserWithConsole(null, null);
    }

    private IStatus createStatus(Collection<IMultipleSandboxLoad> locations) {
        ArrayList<IStatus> info = new ArrayList<IStatus>();
        for (IMultipleSandboxLoad location : locations) {
            this.input.accumulateStatus(location, info);
        }
        if (info.size() == 1) {
            return (IStatus)info.get(0);
        }
        return StatusUtil.newStatus((Object)((Object)this), (String)Messages.PreparedLoadHandler_MultipleSandboxLoadMultiStatus, info);
    }

    public void reset() {
        this.preparedSharesToLoad.clear();
        this.preparedCollisionLocations.clear();
        this.preparedRemovedShares.clear();
        this.preparedInvalidRequests.clear();
        this.preparedSharesOutOfSync.clear();
    }
}

