/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.ContextNameUtil;
import com.ibm.team.filesystem.client.internal.namespace.impl.WorkspaceContext;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceId;
import com.ibm.team.filesystem.client.internal.utils.ConnectionFacade;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.changes.actions.AcceptChangeSetFromWildAction;
import com.ibm.team.filesystem.ui.item.Repositories;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Shell;

public class PendingChangesUtil {
    public static Map<ITeamRepository, List<IRemoteActivity>> groupActivitiesByRepository(Collection<IRemoteActivity> activities) {
        HashMap resultMap = NewCollection.hashMap();
        for (IRemoteActivity next : activities) {
            ITeamRepository nextRepository = Repositories.getRepository(next);
            CollectionUtil.addToMapOfLists((Map)resultMap, (Object)nextRepository, (Object)next);
        }
        return resultMap;
    }

    public static Map<IComponentSyncContext, List<IRemoteActivity>> groupActivitiesBySyncContext(Collection<IRemoteActivity> activities) {
        HashMap resultMap = NewCollection.hashMap();
        for (IRemoteActivity next : activities) {
            IComponentSyncContext nextNamespace = next.getActivitySource().getModel();
            CollectionUtil.addToMapOfLists((Map)resultMap, (Object)nextNamespace, (Object)next);
        }
        return resultMap;
    }

    public static ItemNamespace getContributorPlace(IRemoteActivity next) {
        return PendingChangesUtil.getLocalNamespace(next.getActivitySource().getModel());
    }

    public static ItemId<IChangeSet> getChangeSet(IRemoteActivity remoteActivity) {
        IChangeSetHandle cs = remoteActivity.getChangeSetHandle();
        if (cs == null) {
            return ItemId.getNullItem((IItemType)IChangeSet.ITEM_TYPE);
        }
        return new ItemId((IItemHandle)cs);
    }

    public static IWorkspaceConnection getIncomingCollaboratorStream(IWorkspaceConnection contributorPlace, IComponentHandle component) {
        IComponentSyncContext context = FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncContext((IConnection)contributorPlace, component);
        if (context != null) {
            return context.getRemoteIncomingTeamPlace();
        }
        return null;
    }

    public static IWorkspaceConnection getOutgoingCollaboratorStream(IWorkspaceConnection contributorPlace, IComponentHandle component) {
        IComponentSyncContext context = FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncContext((IConnection)contributorPlace, component);
        if (context != null) {
            return context.getRemoteOutgoingTeamPlace();
        }
        return null;
    }

    private static IComponentSyncContext getCurrentCollaboration(ItemNamespace contributorPlace) {
        IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
        IComponentSyncContext[] contexts = model.getComponentSyncContexts();
        int i = 0;
        while (i < contexts.length) {
            IComponentSyncContext componentSyncContext = contexts[i];
            ItemNamespace outgoing = PendingChangesUtil.getLocalNamespace(componentSyncContext);
            if (outgoing.equals((Object)contributorPlace)) {
                return componentSyncContext;
            }
            ++i;
        }
        return null;
    }

    public static ItemNamespace getCurrentIncomingCollaboration(ItemNamespace contributorPlace) {
        IComponentSyncContext context = PendingChangesUtil.getCurrentCollaboration(contributorPlace);
        if (context != null) {
            return PendingChangesUtil.getRemoteIncomingNamespace(context);
        }
        return null;
    }

    public static ItemNamespace getCurrentOutgoingCollaboration(ItemNamespace contributorPlace) {
        IComponentSyncContext context = PendingChangesUtil.getCurrentCollaboration(contributorPlace);
        if (context != null) {
            return PendingChangesUtil.getRemoteOutgoingNamespace(context);
        }
        return null;
    }

    private static IWorkspaceConnection getConnection(ItemNamespace contributorPlace, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IConnection connection = null;
        try {
            connection = contributorPlace.getConnection((IProgressMonitor)progress.newChild(50));
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        if (connection instanceof IWorkspaceConnection) {
            return (IWorkspaceConnection)connection;
        }
        return null;
    }

    public static ItemNamespace getCurrentIncomingCollaboration(ItemNamespace contributorPlace, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponentHandle component;
        IWorkspaceConnection collaboratorStream;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceConnection connection = PendingChangesUtil.getConnection(contributorPlace, (IProgressMonitor)progress.newChild(50));
        if (connection != null && (collaboratorStream = PendingChangesUtil.getIncomingCollaboratorStream(connection, component = (IComponentHandle)contributorPlace.fetchComponentId((IProgressMonitor)progress.newChild(50)).toHandle())) != null) {
            return WorkspaceNamespace.create((IWorkspaceConnection)collaboratorStream, (IComponentHandle)component);
        }
        return null;
    }

    public static ItemNamespace getCurrentOutgoingCollaboration(ItemNamespace contributorPlace, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponentHandle component;
        IWorkspaceConnection collaboratorStream;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceConnection connection = PendingChangesUtil.getConnection(contributorPlace, (IProgressMonitor)progress.newChild(50));
        if (connection != null && (collaboratorStream = PendingChangesUtil.getOutgoingCollaboratorStream(connection, component = (IComponentHandle)contributorPlace.fetchComponentId((IProgressMonitor)progress.newChild(50)).toHandle())) != null) {
            return WorkspaceNamespace.create((IWorkspaceConnection)collaboratorStream, (IComponentHandle)component);
        }
        return null;
    }

    public static ItemId getItem(IRemoteChangeSummary changeSummary) {
        return new ItemId((IItemHandle)changeSummary.getItem());
    }

    public static WorkspaceNamespace getTrackedWorkspaceForComponent(Shell shell, ItemId<IComponent> component, boolean checkLocal, boolean checkShared, String dialogMessage) {
        Collection contexts = ComponentSyncUtil.getTrackedContexts((IComponentHandle)((IComponentHandle)component.toHandle()), (boolean)checkLocal, (boolean)checkShared);
        if (contexts.isEmpty()) {
            MessageDialogFactory.showMessage((Shell)shell, (int)1, (String)Messages.PendingChangesUtil_0, (String)Messages.PendingChangesUtil_1);
            return null;
        }
        IComponentSyncContext context = (IComponentSyncContext)contexts.iterator().next();
        Set workspaceContexts = ComponentSyncUtil.getWorkspaceContexts((Collection)contexts);
        if (workspaceContexts.size() > 1) {
            context = AcceptChangeSetFromWildAction.promptForContext(shell, context.getComponent(), dialogMessage, checkLocal, checkShared);
        }
        if (context == null) {
            return null;
        }
        return WorkspaceNamespace.create((IWorkspaceConnection)context.getOutgoingTeamPlace(), (IComponentHandle)context.getComponent());
    }

    public static List<IComponentSyncContext> getSyncContexts(Collection<ItemNamespace> namespaces, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList result = NewCollection.arrayList();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)namespaces.size());
        for (ItemNamespace next : namespaces) {
            IComponentSyncContext context = PendingChangesUtil.getComponentSyncContext(next, (IProgressMonitor)progress.newChild(1));
            if (context == null) continue;
            result.add(context);
        }
        return result;
    }

    public static IComponentSyncContext getComponentSyncContext(ItemNamespace namespace, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (namespace instanceof WorkspaceNamespace) {
            WorkspaceNamespace wn = (WorkspaceNamespace)namespace;
            try {
                IWorkspaceConnection connection = wn.getWorkspaceConnection((IProgressMonitor)progress.newChild(50));
                ItemId component = wn.fetchComponentId((IProgressMonitor)progress.newChild(50));
                return PendingChangesUtil.getComponentSyncContext(connection, (ItemId<IComponent>)component);
            }
            catch (ItemNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public static IComponentSyncContext getComponentSyncContext(WorkspaceContext workspace) {
        return PendingChangesUtil.getComponentSyncContext(workspace.getWorkspace(), (ItemId<IComponent>)workspace.getComponentId());
    }

    public static IComponentSyncContext getComponentSyncContext(IWorkspaceConnection connection, ItemId<IComponent> component) {
        return FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncContext((IConnection)connection, (IComponentHandle)component.toHandle());
    }

    public static ItemNamespace getRemoteIncomingNamespace(IComponentSyncContext context) {
        ConnectionFacade desc = context.getRemoteIncomingConnection();
        IConnection cachedConnection = desc.getCachedConnection();
        if (cachedConnection == null) {
            return PendingChangesUtil.getLocalNamespace(context);
        }
        return ItemNamespace.getNamespace((IConnection)cachedConnection, (IComponentHandle)context.getComponent());
    }

    public static ItemNamespace getRemoteOutgoingNamespace(IComponentSyncContext context) {
        ConnectionFacade desc = context.getRemoteOutgoingConnection();
        IConnection cachedConnection = desc.getCachedConnection();
        if (cachedConnection == null) {
            return PendingChangesUtil.getLocalNamespace(context);
        }
        return ItemNamespace.getNamespace((IConnection)cachedConnection, (IComponentHandle)context.getComponent());
    }

    public static ItemNamespace getLocalNamespace(IComponentSyncContext context) {
        return ItemNamespace.getNamespace((IConnection)context.getOutgoingConnection(), (IComponentHandle)context.getComponent());
    }

    public static String getContextName(IComponentSyncContext context) {
        return ContextNameUtil.getContextName((IConnection)context.getOutgoingConnection(), (IComponent)context.getComponent());
    }

    public static IWorkspaceHandle getCurrentIncomingCollaboration(IWorkspaceHandle local, IComponentHandle component) {
        IWorkspaceSyncContext[] iWorkspaceSyncContextArray = FileSystemResourcesPlugin.getComponentSyncModel().getWorkspaceSyncContexts();
        int n = iWorkspaceSyncContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkspaceSyncContext workspaceSyncContext = iWorkspaceSyncContextArray[n2];
            if (workspaceSyncContext.getLocal().getResolvedWorkspace().sameItemId((IItemHandle)local)) {
                IComponentSyncContext[] iComponentSyncContextArray = workspaceSyncContext.getComponentSyncContexts();
                int n3 = iComponentSyncContextArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IComponentSyncContext componentSyncContext = iComponentSyncContextArray[n4];
                    if (componentSyncContext.getComponent().sameItemId((IItemHandle)component)) {
                        IWorkspaceConnection incomingTeamPlace = componentSyncContext.getRemoteIncomingTeamPlace();
                        if (incomingTeamPlace == null) {
                            return null;
                        }
                        return incomingTeamPlace.getResolvedWorkspace();
                    }
                    ++n4;
                }
                IContextHandle contextHandle = workspaceSyncContext.getRemoteIncomingConnectionDescriptor().getContextHandle();
                if (contextHandle instanceof IWorkspaceHandle) {
                    return (IWorkspaceHandle)contextHandle;
                }
                return null;
            }
            ++n2;
        }
        return null;
    }

    public static IWorkspaceHandle getCurrentOutgoingCollaboration(IWorkspaceHandle local, IComponentHandle component) {
        IWorkspaceSyncContext[] iWorkspaceSyncContextArray = FileSystemResourcesPlugin.getComponentSyncModel().getWorkspaceSyncContexts();
        int n = iWorkspaceSyncContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkspaceSyncContext workspaceSyncContext = iWorkspaceSyncContextArray[n2];
            if (workspaceSyncContext.getLocal().getResolvedWorkspace().sameItemId((IItemHandle)local)) {
                IComponentSyncContext[] iComponentSyncContextArray = workspaceSyncContext.getComponentSyncContexts();
                int n3 = iComponentSyncContextArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IComponentSyncContext componentSyncContext = iComponentSyncContextArray[n4];
                    if (componentSyncContext.getComponent().sameItemId((IItemHandle)component)) {
                        IWorkspaceConnection outgoingTeamPlace = componentSyncContext.getRemoteOutgoingTeamPlace();
                        if (outgoingTeamPlace == null) {
                            return null;
                        }
                        return outgoingTeamPlace.getResolvedWorkspace();
                    }
                    ++n4;
                }
                IContextHandle contextHandle = workspaceSyncContext.getRemoteOutgoingConnectionDescriptor().getContextHandle();
                if (contextHandle instanceof IWorkspaceHandle) {
                    return (IWorkspaceHandle)contextHandle;
                }
                return null;
            }
            ++n2;
        }
        return null;
    }

    public static ItemId<IComponent> getComponent(IComponentSyncContext model) {
        IComponent component = model.getComponent();
        if (component == null) {
            return ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);
        }
        return ItemId.forItem((IItem)component);
    }

    public static boolean isLoaded(IComponentSyncContext context) {
        return !ComponentSyncUtil.isDisconnected((IComponentSyncContext)context);
    }

    public static ItemNamespace getCurrentIncomingCollaboration(WorkspaceNamespace wn, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponentSyncContext context = PendingChangesUtil.getComponentSyncContext((ItemNamespace)wn, monitor);
        if (context == null) {
            return null;
        }
        return PendingChangesUtil.getRemoteIncomingNamespace(context);
    }

    public static ItemNamespace getCurrentOutgoingCollaboration(WorkspaceNamespace wn, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponentSyncContext context = PendingChangesUtil.getComponentSyncContext((ItemNamespace)wn, monitor);
        if (context == null) {
            return null;
        }
        return PendingChangesUtil.getRemoteOutgoingNamespace(context);
    }

    public static SnapshotId getSnapshot(IComponentSyncContext componentSyncContext) {
        return WorkspaceId.create((ITeamRepository)componentSyncContext.localTeamRepository(), (IWorkspaceHandle)componentSyncContext.getOutgoingTeamPlace().getResolvedWorkspace());
    }

    public static SnapshotId getLocalSnapshot(IWorkspaceSyncContext wcs) {
        return WorkspaceId.create((ITeamRepository)wcs.teamRepository(), (IWorkspaceHandle)wcs.getLocal().getResolvedWorkspace());
    }
}

