/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IVersionableLock;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class LocksByContributor {
    private IWorkspaceConnection workspaceConnection;
    private IContributorHandle contributorHandle;
    private int numLocks;

    public LocksByContributor(IWorkspaceConnection workspaceConnection, IContributorHandle contributorHandle) {
        this.workspaceConnection = workspaceConnection;
        this.contributorHandle = contributorHandle;
    }

    public IContributorHandle getContributorHandle() {
        return this.contributorHandle;
    }

    public IWorkspaceConnection getWorkspaceConnection() {
        return this.workspaceConnection;
    }

    public int getNumLocks() {
        return this.numLocks;
    }

    public void setNumLocks(int numLocks) {
        this.numLocks = numLocks;
    }

    public static Collection<LocksByContributor> getLocks(Map<IStreamLockReport, IWorkspaceConnection> locks) {
        HashMap<UUID, LocksByContributor> allLocksByUUID = new HashMap<UUID, LocksByContributor>();
        for (Map.Entry<IStreamLockReport, IWorkspaceConnection> entry : locks.entrySet()) {
            IStreamLockReport streamLock = entry.getKey();
            IWorkspaceConnection connection = entry.getValue();
            Collection<LocksByContributor> locksByContributors = LocksByContributor.getLocks(connection, streamLock);
            for (LocksByContributor locksByContributor : locksByContributors) {
                UUID uuid = locksByContributor.getContributorHandle().getItemId();
                LocksByContributor versionableLocks = (LocksByContributor)allLocksByUUID.get(uuid);
                if (versionableLocks == null) {
                    versionableLocks = new LocksByContributor(locksByContributor.getWorkspaceConnection(), locksByContributor.getContributorHandle());
                    allLocksByUUID.put(uuid, versionableLocks);
                }
                versionableLocks.setNumLocks(versionableLocks.getNumLocks() + locksByContributor.getNumLocks());
            }
        }
        return allLocksByUUID.values();
    }

    public static Collection<LocksByContributor> getLocks(IWorkspaceConnection workspaceConnection, IStreamLockReport streamLock) {
        HashMap<UUID, LocksByContributor> locksByUUID = new HashMap<UUID, LocksByContributor>();
        for (IComponentLockReport componentLock : streamLock.getComponentLocks()) {
            for (IVersionableLock lock : componentLock.getLocks()) {
                LocksByContributor locks = (LocksByContributor)locksByUUID.get(lock.getContributor().getItemId());
                if (locks == null) {
                    locks = new LocksByContributor(workspaceConnection, lock.getContributor());
                    locksByUUID.put(lock.getContributor().getItemId(), locks);
                }
                locks.setNumLocks(locks.getNumLocks() + 1);
            }
        }
        return locksByUUID.values();
    }

    public static String getLocksHeldMsg(Collection<LocksByContributor> locksByContributor, String oneLockUnknownOwner, String manyLocksUnknownOwner, String oneLockKnownOwner, String manyLocksKnownOwner) {
        if (locksByContributor.size() == 1) {
            LocksByContributor locks = locksByContributor.iterator().next();
            int numLocks = locks.getNumLocks();
            IContributorHandle contributorHandle = locks.getContributorHandle();
            IContributor contributor = (IContributor)locks.getWorkspaceConnection().teamRepository().itemManager().getSharedItemIfKnown((IItemHandle)contributorHandle);
            if (contributor == null) {
                try {
                    contributor = (IContributor)locks.getWorkspaceConnection().teamRepository().itemManager().fetchCompleteItem((IItemHandle)contributorHandle, 0, null);
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
            }
            if (numLocks == 1) {
                if (contributor == null) {
                    return oneLockUnknownOwner;
                }
                return NLS.bind((String)oneLockKnownOwner, (Object)contributor.getName(), (Object)contributor.getUserId());
            }
            if (contributor == null) {
                return NLS.bind((String)manyLocksUnknownOwner, (Object)numLocks);
            }
            return NLS.bind((String)manyLocksKnownOwner, (Object[])new String[]{Integer.toString(numLocks), contributor.getName(), contributor.getUserId()});
        }
        int numLocks = 0;
        for (LocksByContributor locks : locksByContributor) {
            numLocks += locks.getNumLocks();
        }
        return NLS.bind((String)manyLocksUnknownOwner, (Object)numLocks);
    }
}

