/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.client.IAccessGroupClientService;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IAccessGroupHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IPermissionContextProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ItemPermissionUtil {
    private ItemPermissionUtil() {
    }

    public static IAuditable fetchPermissionContext(IVersionableHandle vh, IComponentHandle ch, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        IPermissionContextProvider permissions = workspaceManager.getPermissions(vh, ch, (IProgressMonitor)progress.newChild(1));
        if (permissions == null) {
            return null;
        }
        IAuditableHandle contextHandle = permissions.getReadContext();
        IAuditable context = null;
        if (contextHandle instanceof IAccessGroupHandle) {
            IAccessGroupClientService accessGroupService = (IAccessGroupClientService)repo.getClientLibrary(IAccessGroupClientService.class);
            context = accessGroupService.getAccessGroupForGroupContextId(contextHandle.getItemId(), (IProgressMonitor)progress.newChild(1));
        } else {
            context = (IAuditable)repo.itemManager().fetchCompleteItem((IItemHandle)permissions.getReadContext(), 0, (IProgressMonitor)progress.newChild(1));
        }
        return context;
    }

    public static String getPermissionContextName(IAuditable context) {
        if (context instanceof IContributor) {
            IContributor contributor = (IContributor)context;
            return NLS.bind((String)Messages.ItemPermissionUtil_ContributorScopeAndName, (Object)contributor.getName());
        }
        if (context instanceof IProcessArea) {
            IProcessArea area = (IProcessArea)context;
            if (area instanceof ITeamArea) {
                return NLS.bind((String)Messages.ItemPermissionUtil_TeamAreaScopeAndName, (Object)area.getName());
            }
            return NLS.bind((String)Messages.ItemPermissionUtil_ProjectAreaScopeAndName, (Object)area.getName());
        }
        if (context instanceof IAccessGroup) {
            IAccessGroup accessGroup = (IAccessGroup)context;
            return NLS.bind((String)Messages.ItemPermissionUtil_AccessGroupScopeAndName, (Object)accessGroup.getName());
        }
        return Messages.ItemPermissionUtil_public;
    }
}

