/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.filesystem.ui.UiPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorUtils {
    public static ITextEditor getEditor(IEditorInput input, String editorId) throws PartInitException {
        return (ITextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(input, editorId, false);
    }

    public static String getEditorId(String filename) {
        String id;
        IEditorRegistry registry = UiPlugin.getDefault().getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(filename);
        if (descriptor == null || !descriptor.isInternal() || !(descriptor instanceof EditorDescriptor)) {
            id = "org.eclipse.ui.DefaultTextEditor";
        } else {
            try {
                Object obj = IDEWorkbenchPlugin.createExtension((IConfigurationElement)((EditorDescriptor)descriptor).getConfigurationElement(), (String)"class");
                id = obj instanceof ITextEditor ? descriptor.getId() : "org.eclipse.ui.DefaultTextEditor";
            }
            catch (CoreException e) {
                id = "org.eclipse.ui.DefaultTextEditor";
            }
        }
        return id;
    }

    public static IEditorReference getEditorReference(IEditorPart editor, IWorkbenchPage page) {
        IEditorReference[] editorReferences = page.getEditorReferences();
        int i = 0;
        while (i < editorReferences.length) {
            if (editor.equals(editorReferences[i].getEditor(false))) {
                return editorReferences[i];
            }
            ++i;
        }
        return null;
    }
}

