/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.util;

import com.ibm.team.internal.filesystem.ui.util.AsyncRepositoryItemFetcher;
import com.ibm.team.internal.filesystem.ui.util.FetchItemFuture;
import com.ibm.team.internal.filesystem.ui.util.IFetchItemListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Display;

public class AsyncItemFetcher {
    private Map<ITeamRepository, AsyncRepositoryItemFetcher> fetchers = new HashMap<ITeamRepository, AsyncRepositoryItemFetcher>();
    private Display display;

    public AsyncItemFetcher(Display display) {
        Assert.isLegal((display != null ? 1 : 0) != 0);
        this.display = display;
    }

    public FetchItemFuture fetch(ITeamRepository repo, IItemHandle handle, IFetchItemListener listener) {
        return this.getFetcher(repo).fetch(handle, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncRepositoryItemFetcher getFetcher(ITeamRepository repo) {
        AsyncRepositoryItemFetcher fetcher;
        Map<ITeamRepository, AsyncRepositoryItemFetcher> map = this.fetchers;
        synchronized (map) {
            fetcher = this.fetchers.get(repo);
            if (fetcher == null) {
                fetcher = new AsyncRepositoryItemFetcher(this.display, repo);
                this.fetchers.put(repo, fetcher);
            }
        }
        return fetcher;
    }
}

