/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.queries;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.Query;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;

public class ResourceQuery
extends Query
implements IResourceChangeListener {
    final IResource resource;

    public ResourceQuery(IOperationRunner runner, IResource r) {
        super(runner);
        this.resource = r;
    }

    public List computeResult(IProgressMonitor monitor) throws InvocationTargetException {
        switch (this.resource.getType()) {
            case 2: 
            case 4: 
            case 8: {
                try {
                    return Arrays.asList(((IContainer)this.resource).members());
                }
                catch (CoreException e) {
                    StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (int)4, (String)("Could not get members of " + this.resource), (Throwable)e);
                }
            }
            case 1: {
                throw new RuntimeException("Asked to handle file resource: " + this.resource.getFullPath());
            }
        }
        throw new RuntimeException("Unknown resource type (" + this.resource.getType() + ") for " + this.resource);
    }

    protected void allocate() {
        super.allocate();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    protected void deallocate() {
        super.deallocate();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public String getName() {
        return "Children of " + this.resource.getFullPath();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] childChanges;
        IResourceDelta delta = event.getDelta().findMember(this.resource.getFullPath());
        if (delta == null) {
            return;
        }
        IResourceDelta[] iResourceDeltaArray = childChanges = delta.getAffectedChildren(3, 0);
        int n = childChanges.length;
        int n2 = 0;
        while (n2 < n) {
            final IResourceDelta child = iResourceDeltaArray[n2];
            int flags = child.getKind();
            if ((flags & 1) != 0) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ResourceQuery.this.fireAdded(child.getResource());
                    }
                });
            } else if ((flags & 2) != 0) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ResourceQuery.this.fireRemoved(child.getResource());
                    }
                });
            } else {
                StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (int)4, (String)("Unexpected flag: " + flags), null);
            }
            ++n2;
        }
    }
}

