/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.queries;

import com.ibm.team.filesystem.client.internal.queries.IQuery;
import com.ibm.team.filesystem.client.internal.queries.QueryCache;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class QueryToSetAdapter
extends AbstractSetWithListeners {
    private int pageSize;
    private IQuery query;
    private IConversion conversion;
    private HashSet elements = new HashSet();
    private IOperationRunner runner;
    private String description;
    private Operation fetchOperation = new Operation(){

        public void run(IProgressMonitor reporter, IStatusCollector problems) throws OperationFailedException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)reporter, (int)100);
            int index = 0;
            boolean searching = true;
            do {
                List nextResult;
                IQuery nextQuery = QueryToSetAdapter.this.query.getPage(index, QueryToSetAdapter.this.pageSize);
                progress.setWorkRemaining(2);
                try {
                    nextResult = QueryCache.execute((IQuery)nextQuery, (IProgressMonitor)progress.newChild(1));
                }
                catch (TeamRepositoryException e) {
                    throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
                SWTUtil.greedyExec((Realm)QueryToSetAdapter.this.getRealm(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        HashSet<Object> toAdd = new HashSet<Object>();
                        for (Object next : nextResult) {
                            Object converted = QueryToSetAdapter.this.conversion.createAdapter(next);
                            if (!QueryToSetAdapter.this.elements.add(converted)) continue;
                            toAdd.add(converted);
                        }
                        QueryToSetAdapter.this.fireCollectionAdded(toAdd);
                    }
                });
                index += QueryToSetAdapter.this.pageSize;
                searching = nextResult.size() == QueryToSetAdapter.this.pageSize;
                progress.setWorkRemaining(2);
                progress.worked(1);
            } while (searching);
        }
    };

    public QueryToSetAdapter(IQuery theQuery, IConversion fastConversion, int pageSize, IOperationRunner runner, String description) {
        this.query = theQuery;
        this.pageSize = pageSize;
        this.conversion = fastConversion;
        this.runner = runner;
        this.description = description;
        this.recompute();
    }

    private void recompute() {
        this.setStale(true);
        HashSet removed = new HashSet(this.elements);
        this.elements.clear();
        this.runner.enqueue(this.description, this.fetchOperation);
        this.fireCollectionRemoved(removed);
    }

    protected Collection computeElements() {
        return this.elements;
    }
}

