/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.properties;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.filesystem.rcp.ui.IPropertyEntry;
import com.ibm.team.filesystem.rcp.ui.internal.properties.PropertyNamespaceManager;
import com.ibm.team.filesystem.rcp.ui.internal.properties.SCMPropertyDialog;
import com.ibm.team.filesystem.rcp.ui.internal.properties.SCMPropertyEntry;
import com.ibm.team.filesystem.ui.actions.UnShareProjectAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.properties.VersionablePropertiesArea;
import com.ibm.team.internal.filesystem.ui.views.properties.ScmPropertiesView;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class VersionablePropertiesPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Composite composite;
    private JobRunner jobRunner = new JobRunner(false);
    private VersionablePropertiesArea propertiesArea;
    private VersionablePropertiesArea.SCMProperties properties = new VersionablePropertiesArea.SCMProperties();
    private IMetadataProperties metadataProperties;
    private boolean isResourceShared = true;

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.team.filesystem.ide.ui.property_page_versionable_properties");
    }

    protected Control createContents(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().applyTo(this.composite);
        final IShareable target = this.getTarget();
        if (target == null) {
            IResource resource = (IResource)this.getElement().getAdapter(IResource.class);
            this.setErrorMessage(Messages.SourceControlPropertyPage_ERROR_GETTING_PROPERTIES);
            if (resource != null) {
                final IProject project = resource.getProject();
                boolean disconnect = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.SourceControlPropertyPage_ERROR_GETTING_PROPERTIES, (String)Messages.SourceControlPropertyPage_ERROR_GETTING_PROPERTIES_MESSAGE);
                if (disconnect) {
                    this.jobRunner.enqueue(Messages.SourceControlPropertyPage_DISCONNECT_PROJECT, (Operation)new RepositoryOperation(){

                        public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                            UnShareProjectAction.unshare(Collections.singletonList(project), monitor, problems, VersionablePropertiesPropertyPage.this.getShell());
                        }
                    });
                }
            }
            return this.composite;
        }
        final Display display = parent.getDisplay();
        final IResource resource = (IResource)target.getAdapter(IResource.class);
        this.jobRunner.enqueue(Messages.VersionablePropertiesPropertyPage_IsSharedJobName, new Operation(){

            public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)105);
                int state = 0;
                try {
                    state = target.getState((IProgressMonitor)progress.newChild(15));
                }
                catch (FileSystemException e) {
                    problems.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
                if ((state & 1) == 0 || resource != null && this.isUnderSymbolicLink((IResource)resource.getParent())) {
                    VersionablePropertiesPropertyPage.this.isResourceShared = false;
                    SWTUtil.greedyExec((Display)display, (Control)VersionablePropertiesPropertyPage.this.composite, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Label label = new Label(VersionablePropertiesPropertyPage.this.composite, 0);
                            label.setText(Messages.VersionablePropertiesPropertyPage_NotShared);
                            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
                            VersionablePropertiesPropertyPage.this.composite.layout();
                        }
                    });
                } else {
                    SWTUtil.greedyExec((Display)display, (Control)VersionablePropertiesPropertyPage.this.composite, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Label label = new Label(VersionablePropertiesPropertyPage.this.composite, 0);
                            label.setText(Messages.VersionablePropertiesPropertyPage_0);
                            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
                            Composite propertiesAreaComposite = new Composite(VersionablePropertiesPropertyPage.this.composite, 0);
                            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)propertiesAreaComposite);
                            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(propertiesAreaComposite);
                            Composite tableArea = new Composite(propertiesAreaComposite, 0);
                            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableArea);
                            GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(tableArea);
                            VersionablePropertiesPropertyPage.this.createPropertiesTable(tableArea);
                            Composite buttonsArea = new Composite(propertiesAreaComposite, 0);
                            GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)buttonsArea);
                            GridLayoutFactory.fillDefaults().applyTo(buttonsArea);
                            VersionablePropertiesPropertyPage.this.createButtons(buttonsArea);
                            VersionablePropertiesPropertyPage.this.propertiesArea.setInput(VersionablePropertiesPropertyPage.this.properties);
                            VersionablePropertiesPropertyPage.this.composite.layout();
                            VersionablePropertiesPropertyPage.this.jobRunner.enqueue(Messages.VersionablePropertiesPropertyPage_14, new Operation(){

                                public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                                    try {
                                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                                        final IMetadataProperties metadataProperties = target.getMetadataProperties((IProgressMonitor)progress.newChild(9));
                                        SWTUtil.greedyExec((Display)VersionablePropertiesPropertyPage.this.composite.getDisplay(), (Control)VersionablePropertiesPropertyPage.this.composite, (Runnable)new Runnable(){

                                            @Override
                                            public void run() {
                                                VersionablePropertiesPropertyPage.this.initializeProperties(metadataProperties);
                                            }
                                        });
                                        IShare share = target.getShare((IProgressMonitor)progress.newChild(1));
                                        if (share != null) {
                                            ISharingDescriptor desc = share.getSharingDescriptor();
                                            ITeamRepository repo = VersionablePropertiesPropertyPage.getTeamRepository(desc);
                                            ScmPropertiesView.populatePropertiesBG(metadataProperties.getCurrentProperties(), VersionablePropertiesPropertyPage.this.propertiesArea, display, (Control)VersionablePropertiesPropertyPage.this.composite, repo, (IProgressMonitor)progress.newChild(90));
                                        }
                                    }
                                    catch (FileSystemException e) {
                                        throw new OperationFailedException(FileSystemStatusUtil.getStatusFor((Throwable)e));
                                    }
                                }
                            });
                        }
                    });
                }
            }

            private boolean isUnderSymbolicLink(IResource resource2) {
                if (resource2 == null) {
                    return false;
                }
                ResourceAttributes attributes = resource2.getResourceAttributes();
                if (attributes != null && attributes.isSymbolicLink()) {
                    return true;
                }
                return this.isUnderSymbolicLink((IResource)resource2.getParent());
            }
        });
        Dialog.applyDialogFont((Control)this.composite);
        return this.composite;
    }

    public static ITeamRepository getTeamRepository(ISharingDescriptor desc) {
        return VersionablePropertiesPropertyPage.getTeamRepository(desc.getRepositoryId());
    }

    public static ITeamRepository getTeamRepository(UUID repositoryId) {
        ITeamRepository[] repositories;
        ITeamRepository result = null;
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            if (repositoryId.equals((Object)repository.getId())) {
                result = repository;
                break;
            }
            ++n2;
        }
        return result;
    }

    void initializeProperties(IMetadataProperties metadataProperties) {
        PropertyNamespaceManager namespaceManager = PropertyNamespaceManager.getInstance();
        this.metadataProperties = metadataProperties;
        Map currentProperties = metadataProperties.getCurrentProperties();
        ArrayList<SCMPropertyEntry> entries = new ArrayList<SCMPropertyEntry>(currentProperties.size());
        for (Map.Entry entry : currentProperties.entrySet()) {
            String value = namespaceManager.hasDisplayValue((String)entry.getKey()) ? Messages.StructuralChangesView_pendingDescription : (String)entry.getValue();
            SCMPropertyEntry scmPropertyEntry = new SCMPropertyEntry((String)entry.getKey(), value);
            entries.add(scmPropertyEntry);
        }
        this.properties.addEntries(entries);
    }

    private void createPropertiesTable(Composite tableArea) {
        this.propertiesArea = new VersionablePropertiesArea(tableArea);
    }

    private void createButtons(Composite buttonsArea) {
        Button addButton = new Button(buttonsArea, 8);
        addButton.setText(Messages.VersionablePropertiesPropertyPage_3);
        addButton.setToolTipText(Messages.VersionablePropertiesPropertyPage_4);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VersionablePropertiesPropertyPage.this.addProperty();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)addButton);
        final Button editButton = new Button(buttonsArea, 8);
        editButton.setText(Messages.VersionablePropertiesPropertyPage_5);
        editButton.setToolTipText(Messages.VersionablePropertiesPropertyPage_6);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VersionablePropertiesPropertyPage.this.editProperty();
            }
        });
        editButton.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)editButton);
        final Button removeButton = new Button(buttonsArea, 8);
        removeButton.setText(Messages.VersionablePropertiesPropertyPage_7);
        removeButton.setToolTipText(Messages.VersionablePropertiesPropertyPage_8);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VersionablePropertiesPropertyPage.this.removeProperty();
            }
        });
        removeButton.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)removeButton);
        this.propertiesArea.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                Collection<SCMPropertyEntry> entries = VersionablePropertiesPropertyPage.this.getSelectedEntries(selection);
                editButton.setEnabled(entries.size() == 1);
                removeButton.setEnabled(!entries.isEmpty());
            }
        });
    }

    protected Collection<SCMPropertyEntry> getSelectedEntries(ISelection selection) {
        ArrayList<SCMPropertyEntry> result = new ArrayList<SCMPropertyEntry>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object object : ss) {
                if (!(object instanceof SCMPropertyEntry)) continue;
                SCMPropertyEntry spe = (SCMPropertyEntry)object;
                result.add(spe);
            }
        }
        return result;
    }

    protected SCMPropertyEntry getSelectedEntry(ISelection selection) {
        Collection<SCMPropertyEntry> entries = this.getSelectedEntries(selection);
        if (entries.size() == 1) {
            return entries.iterator().next();
        }
        return null;
    }

    protected void removeProperty() {
        this.properties.removeEntries(this.getSelectedEntries(this.propertiesArea.getSelectionProvider().getSelection()));
    }

    protected void editProperty() {
        IPropertyEntry result;
        SCMPropertyEntry entry = this.getSelectedEntry(this.propertiesArea.getSelectionProvider().getSelection());
        if (entry != null && (result = PropertyNamespaceManager.getInstance().editProperty(this.composite.getShell(), this.getTarget(), (IPropertyEntry)entry)) != null) {
            this.properties.removeEntries(Collections.singleton(entry));
            this.properties.addEntry((SCMPropertyEntry)result);
        }
    }

    protected void addProperty() {
        AddScmPropertyDialog dialog = new AddScmPropertyDialog(this.composite.getShell(), Messages.VersionablePropertiesPropertyPage_13);
        int result = dialog.open();
        if (result == 0) {
            this.properties.addEntry(dialog.getPropertyEntry());
        }
    }

    private IShareable getTarget() {
        return (IShareable)this.getElement().getAdapter(IShareable.class);
    }

    public void dispose() {
        super.dispose();
        this.jobRunner.dispose();
    }

    public boolean performOk() {
        Shell shell = this.getShell();
        final ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        final boolean[] result = new boolean[]{true};
        if (this.isResourceShared) {
            try {
                dialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                            if (!VersionablePropertiesPropertyPage.this.isResourceShared || VersionablePropertiesPropertyPage.this.metadataProperties == null || VersionablePropertiesPropertyPage.this.properties == null) {
                                result[0] = true;
                            } else if (VersionablePropertiesPropertyPage.this.handlePropertiesChangedOnDisk(dialog.getShell(), (IProgressMonitor)progress.newChild(1))) {
                                IChangePropertiesOperation operation = IOperationFactory.instance.getChangePropertiesOperation(new ChangePropertiesDilemmaHandler());
                                operation.setProperties(VersionablePropertiesPropertyPage.this.getTarget(), VersionablePropertiesPropertyPage.this.properties.toPropertyMap());
                                operation.run((IProgressMonitor)progress.newChild(1));
                                VersionablePropertiesPropertyPage.this.metadataProperties = VersionablePropertiesPropertyPage.this.getTarget().getMetadataProperties(monitor);
                            } else {
                                result[0] = false;
                            }
                        }
                        catch (FileSystemException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                ErrorDialog.openError((Shell)shell, null, null, (IStatus)FileSystemStatusUtil.getStatusFor((Throwable)e.getCause()));
            }
            catch (InterruptedException e) {
                result[0] = this.performCancel();
            }
        }
        return result[0];
    }

    protected boolean handlePropertiesChangedOnDisk(final Shell shell, IProgressMonitor monitor) throws FileSystemException {
        IShareable target = this.getTarget();
        final IMetadataProperties currentProperties = target.getMetadataProperties(monitor);
        HashSet keys = new HashSet();
        keys.addAll(this.metadataProperties.getCurrentProperties().keySet());
        keys.addAll(currentProperties.getCurrentProperties().keySet());
        final HashSet<String> conflicts = new HashSet<String>();
        for (String key : keys) {
            final String currentValue = (String)currentProperties.getCurrentProperties().get(key);
            String originalValue = (String)this.metadataProperties.getCurrentProperties().get(key);
            final SCMPropertyEntry entry = this.properties.get(key);
            String modifiedValue = null;
            if (entry != null) {
                modifiedValue = entry.getValue();
            }
            if (this.sameValue(currentValue, originalValue)) continue;
            if (this.sameValue(originalValue, modifiedValue)) {
                final String theKey = key;
                shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (currentValue == null) {
                            VersionablePropertiesPropertyPage.this.properties.removeEntries(Collections.singletonList(entry));
                        } else {
                            VersionablePropertiesPropertyPage.this.properties.addEntry(new SCMPropertyEntry(theKey, currentValue));
                        }
                    }
                });
                continue;
            }
            conflicts.add(key);
        }
        if (!conflicts.isEmpty()) {
            final boolean[] result = new boolean[1];
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog dialog = new MessageDialog(shell, Messages.VersionablePropertiesPropertyPage_10, null, Messages.VersionablePropertiesPropertyPage_11, 4, new String[]{Messages.VersionablePropertiesPropertyPage_12, Messages.VersionablePropertiesPropertyPage_15, IDialogConstants.CANCEL_LABEL}, 2);
                    int index = dialog.open();
                    switch (index) {
                        case 0: {
                            result[0] = true;
                            break;
                        }
                        case 1: {
                            for (String key : conflicts) {
                                String currentValue = (String)currentProperties.getCurrentProperties().get(key);
                                SCMPropertyEntry entry = VersionablePropertiesPropertyPage.this.properties.get(key);
                                if (currentValue == null && entry != null) {
                                    VersionablePropertiesPropertyPage.this.properties.removeEntries(Collections.singletonList(entry));
                                    continue;
                                }
                                if (currentValue == null) continue;
                                VersionablePropertiesPropertyPage.this.properties.addEntry(new SCMPropertyEntry(key, currentValue));
                            }
                            result[0] = true;
                            break;
                        }
                        default: {
                            result[0] = false;
                        }
                    }
                }
            });
            return result[0];
        }
        return true;
    }

    private boolean sameValue(String currentValue, String originalValue) {
        if (currentValue == originalValue) {
            return true;
        }
        if (currentValue == null || originalValue == null) {
            return false;
        }
        return currentValue.equals(originalValue);
    }

    protected void performDefaults() {
        if (this.metadataProperties != null) {
            Map originalProperties = this.metadataProperties.getOriginalProperties();
            this.properties.clear();
            this.properties.addProperties(originalProperties);
        }
    }

    private class AddScmPropertyDialog
    extends SCMPropertyDialog {
        protected AddScmPropertyDialog(Shell parentShell, String title) {
            super(parentShell, "", "", title);
        }

        protected void updateEnablement() {
            String name;
            super.updateEnablement();
            if (this.getErrorMessage() == null && (name = this.getPropertyEntry().getName()).length() != 0 && VersionablePropertiesPropertyPage.this.properties.get(name) != null) {
                this.setErrorMessage(Messages.VersionablePropertiesPropertyPage_9);
            }
        }
    }
}

