/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.properties;

import com.ibm.team.filesystem.rcp.ui.internal.properties.PropertyNamespaceManager;
import com.ibm.team.filesystem.rcp.ui.internal.properties.SCMPropertyEntry;
import com.ibm.team.filesystem.rcp.ui.internal.util.SCMPropertiesUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class VersionablePropertiesArea {
    private SimpleTableViewer<SCMPropertyEntry> viewer;

    public SimpleTableViewer<SCMPropertyEntry> getViewer() {
        return this.viewer;
    }

    public VersionablePropertiesArea(Composite parent) {
        SashForm form = new SashForm(parent, 512);
        Table table = new Table((Composite)form, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer = new SimpleTableViewer(table);
        ConvertColumn nameColumn = new ConvertColumn(this.viewer, Messages.VersionablePropertiesPropertyPage_1, 150, (IConversion)new IConversion<SCMPropertyEntry, String>(){

            public String createAdapter(SCMPropertyEntry source) {
                return PropertyNamespaceManager.getInstance().getDisplayLabel(source.getName());
            }
        });
        nameColumn.setCellComparator((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        ConvertColumn valueColumn = new ConvertColumn(this.viewer, Messages.VersionablePropertiesPropertyPage_2, 200, (IConversion)new IConversion<SCMPropertyEntry, String>(){

            public String createAdapter(SCMPropertyEntry source) {
                return SCMPropertiesUtil.getShortValue((String)source.getPresentationValue(), (int)64);
            }
        });
        valueColumn.setCellComparator((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        final StyledText text = new StyledText((Composite)form, 2826);
        text.setIndent(2);
        this.viewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                SCMPropertyEntry entry = VersionablePropertiesArea.this.getSelectedEntry(selection);
                if (entry != null) {
                    if (entry.getDisplayValue() != null) {
                        text.setText(NLS.bind((String)Messages.VersionablePropertiesArea_DISPLAYVALUE_WITH_RAW_VALUE, (Object)entry.getDisplayValue(), (Object)entry.getValue()));
                    } else {
                        text.setText(entry.getValue());
                    }
                } else {
                    text.setText("");
                }
            }
        });
        form.setWeights(new int[]{75, 25});
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)form);
    }

    protected SCMPropertyEntry getSelectedEntry(ISelection selection) {
        Collection<SCMPropertyEntry> entries = this.getSelectedEntries(selection);
        if (entries.size() == 1) {
            return entries.iterator().next();
        }
        return null;
    }

    protected Collection<SCMPropertyEntry> getSelectedEntries(ISelection selection) {
        ArrayList<SCMPropertyEntry> result = new ArrayList<SCMPropertyEntry>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object object : ss) {
                if (!(object instanceof SCMPropertyEntry)) continue;
                SCMPropertyEntry spe = (SCMPropertyEntry)object;
                result.add(spe);
            }
        }
        return result;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.viewer.getSelectionProvider();
    }

    public void setInput(SCMProperties properties) {
        this.viewer.setInput((ISetWithListeners)properties);
    }

    public SCMProperties getInput() {
        return (SCMProperties)this.viewer.getInput();
    }

    public static class SCMProperties
    extends AbstractSetWithListeners<SCMPropertyEntry> {
        private Map<String, SCMPropertyEntry> properties = new HashMap<String, SCMPropertyEntry>();

        public SCMProperties() {
        }

        public SCMProperties(Map<String, String> initialProperties) {
            for (Map.Entry<String, String> entry : initialProperties.entrySet()) {
                SCMPropertyEntry scmPropertyEntry = new SCMPropertyEntry(entry.getKey(), entry.getValue());
                this.properties.put(scmPropertyEntry.getName(), scmPropertyEntry);
            }
        }

        protected Collection<SCMPropertyEntry> computeElements() {
            return this.properties.values();
        }

        public void removeEntries(Collection<SCMPropertyEntry> c) {
            for (SCMPropertyEntry scmPropertyEntry : c) {
                this.properties.remove(scmPropertyEntry.getName());
            }
            this.fireCollectionRemoved(c);
        }

        public void addEntry(SCMPropertyEntry entry) {
            SCMPropertyEntry oldEntry = this.properties.put(entry.getName(), entry);
            if (oldEntry != null) {
                this.fireRemoved(oldEntry);
            }
            this.fireAdded(entry);
        }

        public void addEntries(List<SCMPropertyEntry> entries) {
            for (SCMPropertyEntry scmPropertyEntry : entries) {
                this.properties.put(scmPropertyEntry.getName(), scmPropertyEntry);
            }
            this.fireCollectionAdded(entries);
        }

        public Map<String, String> toPropertyMap() {
            HashMap<String, String> result = new HashMap<String, String>();
            for (SCMPropertyEntry scmPropertyEntry : this.properties.values()) {
                result.put(scmPropertyEntry.getName(), scmPropertyEntry.getValue());
            }
            return result;
        }

        public SCMPropertyEntry get(String name) {
            return this.properties.get(name);
        }

        public void addProperties(Map<String, String> originalProperties) {
            for (Map.Entry<String, String> entry : originalProperties.entrySet()) {
                SCMPropertyEntry scmPropertyEntry = new SCMPropertyEntry(entry.getKey(), entry.getValue());
                this.properties.put(scmPropertyEntry.getName(), scmPropertyEntry);
            }
            this.fireCollectionAdded(this.properties.values());
        }

        public void clear() {
            ArrayList<SCMPropertyEntry> removed = new ArrayList<SCMPropertyEntry>(this.properties.size());
            removed.addAll(this.properties.values());
            this.properties.clear();
            this.fireCollectionRemoved(removed);
        }
    }
}

