/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.properties;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.operations.ChangePropertiesOperation;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentPropertiesPreference;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentPropertiesPreferenceManager;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.filesystem.rcp.ui.internal.properties.ChangeFilePropertiesUtil;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnChangeFileProperties;
import com.ibm.team.filesystem.ui.actions.UnShareProjectAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.properties.SharingDescriptorPane;
import com.ibm.team.internal.filesystem.ui.util.ItemPermissionUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IVersionableIdentifier;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URLConnection;
import java.util.Collections;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class SourceControlPropertyPage
extends PropertyPage {
    private JobRunner jobRunner = new JobRunner(false);
    private CCombo lineDelimiterCombo;
    private Button directoryCheckBox;
    private String targetMimeType;
    private FileLineDelimiter targetLineDelimiter;
    private String originalMimeType;
    private boolean originalExecutable;
    private boolean targetExecutable;
    private FileLineDelimiter originalLineDelimiter;
    private CCombo mimeCombo;
    private CCombo executableCombo;
    private Composite composite;
    private boolean originalIsDirectoryLink = false;
    private boolean targetIsDirectoryLink = false;

    public void dispose() {
        super.dispose();
        this.jobRunner.dispose();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.team.filesystem.ide.ui.property_page_source_control");
    }

    protected Control createContents(final Composite parent) {
        IProject project;
        RepositoryProvider provider;
        this.composite = new Composite(parent, 0);
        final IShareable target = this.getTarget();
        if (target == null) {
            IResource resource = (IResource)this.getElement().getAdapter(IResource.class);
            this.setErrorMessage(Messages.SourceControlPropertyPage_ERROR_GETTING_PROPERTIES);
            if (resource != null) {
                final IProject project2 = resource.getProject();
                boolean disconnect = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.SourceControlPropertyPage_ERROR_GETTING_PROPERTIES, (String)Messages.SourceControlPropertyPage_ERROR_GETTING_PROPERTIES_MESSAGE);
                if (disconnect) {
                    final Shell shell = this.getShell();
                    this.jobRunner.enqueue(Messages.SourceControlPropertyPage_DISCONNECT_PROJECT, (Operation)new RepositoryOperation(){

                        public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                            UnShareProjectAction.unshare(Collections.singletonList(project2), monitor, problems, shell);
                        }
                    });
                }
            }
            return this.composite;
        }
        final IResource resource = (IResource)target.getAdapter(IResource.class);
        String providerID = resource != null ? ((provider = RepositoryProvider.getProvider((IProject)(project = resource.getProject()))) == null ? null : provider.getID()) : "com.ibm.team.filesystem.rcp.core.provider";
        SourceControlPropertyPage.createLabel(this.composite, Messages.SourceControlPropertyPage_2);
        final Text providerText = SourceControlPropertyPage.createReadOnlyText(this.composite, providerID == null ? Messages.SourceControlPropertyPage_1 : providerID);
        final Display display = parent.getDisplay();
        this.jobRunner.enqueue(Messages.SourceControlPropertyPage_28, new Operation(){

            public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)105);
                int state = 0;
                try {
                    state = target.getState((IProgressMonitor)progress.newChild(15));
                }
                catch (FileSystemException e) {
                    problems.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
                if ((state & 1) == 0 || resource != null && this.isUnderSymbolicLink((IResource)resource.getParent())) {
                    SWTUtil.greedyExec((Display)display, (Control)SourceControlPropertyPage.this.composite, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            providerText.setText(Messages.SourceControlPropertyPage_1);
                        }
                    });
                } else {
                    boolean shouldBeIgnored = false;
                    try {
                        shouldBeIgnored = target.shouldBeIgnored((IProgressMonitor)progress.newChild(5));
                    }
                    catch (FileSystemException e) {
                        problems.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
                    }
                    String ignoreReasons = null;
                    if (shouldBeIgnored) {
                        try {
                            ignoreReasons = SourceControlPropertyPage.this.describeIgnoreReasons(target, (IProgressMonitor)progress.newChild(15));
                        }
                        catch (FileSystemException e) {
                            problems.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
                            ignoreReasons = Messages.SourceControlPropertyPage_22;
                        }
                    }
                    boolean isExecutable = false;
                    ResourceType type = null;
                    boolean isDirectoryLink = false;
                    try {
                        type = target.getResourceType((IProgressMonitor)progress.newChild(1));
                    }
                    catch (FileSystemException e) {
                        problems.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
                    }
                    final ResourceType resourceType = type;
                    if (resourceType == ResourceType.FILE) {
                        try {
                            isExecutable = ((Shareable)target).getFileStorage().isExecutable((IProgressMonitor)progress.newChild(15));
                        }
                        catch (FileSystemException e) {
                            problems.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
                        }
                        try {
                            String string = target.getContentType((IProgressMonitor)progress.newChild(10));
                            SourceControlPropertyPage.this.targetMimeType = string;
                            SourceControlPropertyPage.this.originalMimeType = string;
                        }
                        catch (FileSystemException e) {
                            problems.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
                        }
                        try {
                            boolean bl = target.isExecutable((IProgressMonitor)progress.newChild(15));
                            SourceControlPropertyPage.this.targetExecutable = bl;
                            SourceControlPropertyPage.this.originalExecutable = bl;
                        }
                        catch (FileSystemException e) {
                            problems.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
                        }
                        try {
                            FileLineDelimiter fileLineDelimiter = target.getLineDelimiter((IProgressMonitor)progress.newChild(10));
                            SourceControlPropertyPage.this.targetLineDelimiter = fileLineDelimiter;
                            SourceControlPropertyPage.this.originalLineDelimiter = fileLineDelimiter;
                        }
                        catch (FileSystemException e) {
                            problems.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
                        }
                    } else if (resourceType == ResourceType.SYMBOLIC_LINK) {
                        try {
                            isDirectoryLink = ((Shareable)target).getFileItemInfo((IProgressMonitor)progress.newChild(1)).isDirectoryLink();
                            SourceControlPropertyPage.this.originalIsDirectoryLink = isDirectoryLink;
                        }
                        catch (FileSystemException e) {
                            problems.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
                        }
                    }
                    progress.setWorkRemaining(100);
                    IShare share = null;
                    IComponentHandle componentHandle = null;
                    try {
                        share = target.getShare((IProgressMonitor)progress.newChild(45));
                    }
                    catch (FileSystemException e) {
                        problems.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
                    }
                    IVersionableHandle vh = null;
                    try {
                        vh = target.getVersionable((IProgressMonitor)progress.newChild(45));
                    }
                    catch (FileSystemException e) {
                        problems.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
                    }
                    String versionId = Messages.SourceControlPropertyPage_UNKNOWN_VERSION_ID;
                    IAuditable accessContext = null;
                    boolean hasContext = false;
                    if (vh != null && share != null) {
                        ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
                        componentHandle = sharingDescriptor.getComponent();
                        ITeamRepository repo = RepositoryUtils.getTeamRepositoryById((UUID)sharingDescriptor.getRepositoryId());
                        try {
                            if (repo != null && vh.hasStateId()) {
                                IVersionableIdentifier[] identifiers = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getVersionableIdentifiers(new IVersionableHandle[]{vh}, (IProgressMonitor)progress.newChild(5));
                                versionId = identifiers[0] == null ? "" : identifiers[0].getLongVersionId();
                            }
                        }
                        catch (TeamRepositoryException e) {
                            problems.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
                        }
                        try {
                            if (componentHandle != null && repo != null) {
                                accessContext = ItemPermissionUtil.fetchPermissionContext(vh, componentHandle, repo, (IProgressMonitor)progress.newChild(5));
                                hasContext = true;
                            }
                        }
                        catch (TeamRepositoryException e) {
                            hasContext = false;
                        }
                    }
                    final String permissionContext = hasContext ? ItemPermissionUtil.getPermissionContextName(accessContext) : Messages.SourceControlPropertyPage_UNKNOWN_READ_ACCESS;
                    final boolean shouldBeIgnoredF = shouldBeIgnored;
                    final String ignoreReasonsF = ignoreReasons;
                    final boolean isExecutableF = isExecutable;
                    final IShare shareF = share;
                    final IComponentHandle componentHandleF = componentHandle;
                    final IVersionableHandle versionable = vh;
                    final boolean isDirectoryLinkF = isDirectoryLink;
                    final String versionIdF = versionId;
                    SWTUtil.greedyExec((Display)display, (Control)SourceControlPropertyPage.this.composite, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (resource != null) {
                                SourceControlPropertyPage.createLabel(SourceControlPropertyPage.this.composite, Messages.SourceControlPropertyPage_3);
                                URI uri = resource.getLocationURI();
                                SourceControlPropertyPage.createReadOnlyText(SourceControlPropertyPage.this.composite, uri != null ? uri.toString() : Messages.SourceControlPropertyPage_4);
                            }
                            new SharingDescriptorPane(SourceControlPropertyPage.this.composite, target, SourceControlPropertyPage.this.jobRunner){

                                @Override
                                protected void resetScrollableMinSize() {
                                    SourceControlPropertyPage.this.resetScrollableMinSize();
                                }
                            };
                            if (shouldBeIgnoredF) {
                                SourceControlPropertyPage.createLabel(SourceControlPropertyPage.this.composite, Messages.SourceControlPropertyPage_20);
                                SourceControlPropertyPage.createReadOnlyText(SourceControlPropertyPage.this.composite, ignoreReasonsF);
                            }
                            SourceControlPropertyPage.createLabel(SourceControlPropertyPage.this.composite, Messages.SourceControlPropertyPage_READ_ACCESS_PERMISSION);
                            SourceControlPropertyPage.createReadOnlyText(SourceControlPropertyPage.this.composite, permissionContext);
                            SourceControlPropertyPage.createLabel(SourceControlPropertyPage.this.composite, Messages.SourceControlPropertyPage_VERSION_ID);
                            SourceControlPropertyPage.createReadOnlyText(SourceControlPropertyPage.this.composite, versionIdF);
                            if (resourceType == ResourceType.FILE) {
                                Group fileProperties = new Group(SourceControlPropertyPage.this.composite, 0);
                                GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)fileProperties);
                                fileProperties.setText(Messages.SourceControlPropertyPage_23);
                                Link link = ChangeFilePropertiesUtil.createLinkToFilePropertiesPreferencePage((Composite)fileProperties, (Shell)SourceControlPropertyPage.this.getShell());
                                GridDataFactory.fillDefaults().span(2, 1).hint(400, -1).align(4, 128).applyTo((Control)link);
                                SourceControlPropertyPage.createLabel((Composite)fileProperties, Messages.SourceControlPropertyPage_63);
                                SourceControlPropertyPage.this.executableCombo = new CCombo((Composite)fileProperties, 2060);
                                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)SourceControlPropertyPage.this.executableCombo);
                                SourceControlPropertyPage.this.executableCombo.setToolTipText(Messages.ChangeFilePropertiesUtil_Executabletip);
                                SourceControlPropertyPage.this.executableCombo.setBackground(SourceControlPropertyPage.this.composite.getDisplay().getSystemColor(25));
                                SourceControlPropertyPage.this.executableCombo.setItems(new String[]{Messages.SourceControlPropertyPage_64, Messages.SourceControlPropertyPage_65});
                                int index = 0;
                                if (!isExecutableF) {
                                    index = 1;
                                }
                                SourceControlPropertyPage.this.executableCombo.setText(SourceControlPropertyPage.this.executableCombo.getItem(index));
                                SourceControlPropertyPage.this.executableCombo.select(index);
                                SourceControlPropertyPage.this.executableCombo.addSelectionListener(new SelectionListener(){

                                    public void widgetSelected(SelectionEvent e) {
                                        SourceControlPropertyPage.this.targetExecutable = ((CCombo)e.widget).getText().equals(SourceControlPropertyPage.this.executableCombo.getItem(0));
                                    }

                                    public void widgetDefaultSelected(SelectionEvent e) {
                                        SourceControlPropertyPage.this.targetExecutable = ((CCombo)e.widget).getText().equals(SourceControlPropertyPage.this.executableCombo.getItem(0));
                                    }
                                });
                                Label mimeLabel = new Label((Composite)fileProperties, 0);
                                mimeLabel.setText(Messages.SourceControlPropertyPage_24);
                                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)mimeLabel);
                                SourceControlPropertyPage.this.mimeCombo = new CCombo((Composite)fileProperties, 2052);
                                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)SourceControlPropertyPage.this.mimeCombo);
                                SourceControlPropertyPage.this.mimeCombo.setToolTipText(Messages.ChangeFilePropertiesUtil_MimeTooltip);
                                TreeSet<String> uniqueMimeTypes = new TreeSet<String>();
                                if (SourceControlPropertyPage.this.targetMimeType != null) {
                                    uniqueMimeTypes.add(SourceControlPropertyPage.this.targetMimeType);
                                }
                                String name = target.getLocalPath().getName();
                                String fileMapMimeType = URLConnection.getFileNameMap().getContentTypeFor(name);
                                if (fileMapMimeType != null) {
                                    uniqueMimeTypes.add(fileMapMimeType);
                                }
                                ContentPropertiesPreferenceManager manager = new ContentPropertiesPreferenceManager();
                                ContentPropertiesPreference pref = manager.get(ResourceUtil.getContentTypeFor((String)name), name);
                                uniqueMimeTypes.add(pref.getMimeType());
                                if (SourceControlPropertyPage.this.targetMimeType != null) {
                                    uniqueMimeTypes.remove(SourceControlPropertyPage.this.targetMimeType);
                                    SourceControlPropertyPage.this.mimeCombo.add(SourceControlPropertyPage.this.targetMimeType);
                                    SourceControlPropertyPage.this.mimeCombo.select(0);
                                    SourceControlPropertyPage.this.setMessage(null);
                                    if (!ChangePropertiesOperation.validMimeType((String)SourceControlPropertyPage.this.targetMimeType)) {
                                        SourceControlPropertyPage.this.setMessage(NLS.bind((String)Messages.SourceControlPropertyPage_INVALID_MIME, (Object)SourceControlPropertyPage.this.targetMimeType), 3);
                                    }
                                }
                                for (String mimeType : uniqueMimeTypes) {
                                    SourceControlPropertyPage.this.mimeCombo.add(mimeType);
                                }
                                if (SourceControlPropertyPage.this.targetMimeType == null) {
                                    SourceControlPropertyPage.this.mimeCombo.setText(Messages.SourceControlPropertyPage_0);
                                }
                                SourceControlPropertyPage.this.mimeCombo.addModifyListener(new ModifyListener(){

                                    public void modifyText(ModifyEvent e) {
                                        String mimeType = SourceControlPropertyPage.this.mimeCombo.getText().trim().toLowerCase();
                                        SourceControlPropertyPage.this.setMessage(null);
                                        if (!ChangePropertiesOperation.validMimeType((String)mimeType)) {
                                            SourceControlPropertyPage.this.setMessage(NLS.bind((String)Messages.SourceControlPropertyPage_INVALID_MIME, (Object)mimeType), 3);
                                            SourceControlPropertyPage.this.setValid(false);
                                        } else {
                                            SourceControlPropertyPage.this.targetMimeType = mimeType;
                                            SourceControlPropertyPage.this.setValid(true);
                                        }
                                    }
                                });
                                Label lineDelimiterLabel = new Label((Composite)fileProperties, 0);
                                lineDelimiterLabel.setText(Messages.SourceControlPropertyPage_25);
                                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)lineDelimiterLabel);
                                SourceControlPropertyPage.this.lineDelimiterCombo = new CCombo((Composite)fileProperties, 2060);
                                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)SourceControlPropertyPage.this.lineDelimiterCombo);
                                SourceControlPropertyPage.this.lineDelimiterCombo.setToolTipText(Messages.ChangeFilePropertiesUtil_LineDelimiterTooltip);
                                SourceControlPropertyPage.this.lineDelimiterCombo.setBackground(SourceControlPropertyPage.this.composite.getDisplay().getSystemColor(25));
                                FileLineDelimiter[] fileLineDelimiterArray = FileLineDelimiter.values();
                                int n = fileLineDelimiterArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    FileLineDelimiter lineDelimiter = fileLineDelimiterArray[n2];
                                    String string = ChangeFilePropertiesUtil.delimiterToString((FileLineDelimiter)lineDelimiter);
                                    SourceControlPropertyPage.this.lineDelimiterCombo.add(string);
                                    SourceControlPropertyPage.this.lineDelimiterCombo.setData(string, (Object)lineDelimiter);
                                    if (lineDelimiter.equals((Object)SourceControlPropertyPage.this.targetLineDelimiter)) {
                                        SourceControlPropertyPage.this.lineDelimiterCombo.select(SourceControlPropertyPage.this.lineDelimiterCombo.getItemCount() - 1);
                                    }
                                    ++n2;
                                }
                                if (SourceControlPropertyPage.this.targetLineDelimiter == null) {
                                    SourceControlPropertyPage.this.lineDelimiterCombo.setText(Messages.SourceControlPropertyPage_0);
                                }
                                SourceControlPropertyPage.this.lineDelimiterCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        SourceControlPropertyPage.this.targetLineDelimiter = (FileLineDelimiter)SourceControlPropertyPage.this.lineDelimiterCombo.getData(SourceControlPropertyPage.this.lineDelimiterCombo.getText());
                                    }
                                });
                                GridLayoutFactory.fillDefaults().numColumns(2).margins(LayoutConstants.getMargins()).generateLayout((Composite)fileProperties);
                            } else if (resourceType == ResourceType.SYMBOLIC_LINK) {
                                Group linkProperties = new Group(SourceControlPropertyPage.this.composite, 0);
                                GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)linkProperties);
                                linkProperties.setText(Messages.SourceControlPropertyPage_29);
                                SourceControlPropertyPage.this.directoryCheckBox = SourceControlPropertyPage.createCheckBox((Composite)linkProperties, isDirectoryLinkF, Messages.SourceControlPropertyPage_30);
                                SourceControlPropertyPage.this.directoryCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        SourceControlPropertyPage.this.targetIsDirectoryLink = SourceControlPropertyPage.this.directoryCheckBox.getSelection();
                                    }
                                });
                                GridLayoutFactory.fillDefaults().numColumns(2).margins(LayoutConstants.getMargins()).generateLayout((Composite)linkProperties);
                            } else {
                                SourceControlPropertyPage.this.noDefaultAndApplyButton();
                            }
                            ExpandableComposite showUUIDs = new ExpandableComposite(SourceControlPropertyPage.this.composite, 18);
                            showUUIDs.setText(Messages.SourceControlPropertyPage_27);
                            Composite uuidComposite = new Composite((Composite)showUUIDs, 0);
                            showUUIDs.setClient((Control)uuidComposite);
                            showUUIDs.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                                public void expansionStateChanged(ExpansionEvent e) {
                                    SourceControlPropertyPage.this.composite.layout();
                                    SourceControlPropertyPage.this.resetScrollableMinSize();
                                }
                            });
                            if (shareF != null) {
                                SourceControlPropertyPage.createLabel(uuidComposite, Messages.SourceControlPropertyPage_12);
                                SourceControlPropertyPage.createReadOnlyText(uuidComposite, shareF.getSharingDescriptor().getRepositoryId().toString());
                            }
                            if (componentHandleF != null) {
                                SourceControlPropertyPage.createLabel(uuidComposite, Messages.SourceControlPropertyPage_COMPONENT_ID);
                                SourceControlPropertyPage.createReadOnlyText(uuidComposite, componentHandleF.getItemId().toString());
                            }
                            if (versionable != null) {
                                SourceControlPropertyPage.createLabel(uuidComposite, Messages.SourceControlPropertyPage_17);
                                SourceControlPropertyPage.createReadOnlyText(uuidComposite, versionable.getItemId().toString());
                                SourceControlPropertyPage.createLabel(uuidComposite, Messages.SourceControlPropertyPage_18);
                                SourceControlPropertyPage.createReadOnlyText(uuidComposite, versionable.hasStateId() ? versionable.getStateId().toString() : Messages.SourceControlPropertyPage_19);
                            }
                            Dialog.applyDialogFont((Control)showUUIDs);
                            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)showUUIDs);
                            GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(uuidComposite);
                            Dialog.applyDialogFont((Control)parent);
                            GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(SourceControlPropertyPage.this.composite);
                            SourceControlPropertyPage.this.composite.layout();
                        }
                    });
                }
            }

            private boolean isUnderSymbolicLink(IResource resource2) {
                if (resource2 == null) {
                    return false;
                }
                ResourceAttributes attributes = resource2.getResourceAttributes();
                if (attributes != null && attributes.isSymbolicLink()) {
                    return true;
                }
                return this.isUnderSymbolicLink((IResource)resource2.getParent());
            }
        });
        Dialog.applyDialogFont((Control)parent);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(this.composite);
        return this.composite;
    }

    protected void performDefaults() {
        final IShareable target = this.getTarget();
        if (target == null || this.mimeCombo == null) {
            return;
        }
        final Display display = this.composite.getDisplay();
        this.jobRunner.enqueue(Messages.SourceControlPropertyPage_28, new Operation(){

            public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)150);
                try {
                    SourceControlPropertyPage.this.targetMimeType = target.getContentType((IProgressMonitor)progress.newChild(50));
                }
                catch (FileSystemException e) {
                    problems.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
                try {
                    SourceControlPropertyPage.this.targetLineDelimiter = target.getLineDelimiter((IProgressMonitor)progress.newChild(50));
                }
                catch (FileSystemException e) {
                    problems.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
                try {
                    SourceControlPropertyPage.this.targetExecutable = target.isExecutable((IProgressMonitor)progress.newChild(50));
                }
                catch (FileSystemException e) {
                    problems.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
                SWTUtil.greedyExec((Display)display, (Control)SourceControlPropertyPage.this.mimeCombo, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SourceControlPropertyPage.this.executableCombo.select(SourceControlPropertyPage.this.targetExecutable ? 0 : 1);
                        SourceControlPropertyPage.this.mimeCombo.setText(SourceControlPropertyPage.this.targetMimeType == null ? Messages.SourceControlPropertyPage_0 : SourceControlPropertyPage.this.targetMimeType);
                        if (SourceControlPropertyPage.this.targetLineDelimiter == null) {
                            SourceControlPropertyPage.this.lineDelimiterCombo.setText(Messages.SourceControlPropertyPage_0);
                        } else {
                            int i = 0;
                            FileLineDelimiter[] fileLineDelimiterArray = FileLineDelimiter.values();
                            int n = fileLineDelimiterArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                FileLineDelimiter lineDelimiter = fileLineDelimiterArray[n2];
                                if (lineDelimiter.equals((Object)SourceControlPropertyPage.this.targetLineDelimiter)) {
                                    SourceControlPropertyPage.this.lineDelimiterCombo.select(i);
                                    break;
                                }
                                ++i;
                                ++n2;
                            }
                        }
                        SourceControlPropertyPage.this.superPerformDefaults();
                    }
                });
            }
        });
    }

    protected void superPerformDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        final IChangePropertiesOperation operation = IOperationFactory.instance.getChangePropertiesOperation((ChangePropertiesDilemmaHandler)new WarnChangeFileProperties(this.getShell(), Messages.SourceControlPropertyPage_26));
        IShareable target = this.getTarget();
        if (target == null) {
            return true;
        }
        boolean doOp = false;
        if (this.targetLineDelimiter != null && !this.targetLineDelimiter.equals((Object)this.originalLineDelimiter)) {
            operation.setLineDelimiter(target, this.targetLineDelimiter);
            doOp = true;
        }
        if (this.directoryCheckBox != null && this.targetIsDirectoryLink != this.originalIsDirectoryLink) {
            operation.setIsDirectoryLink(target, this.targetIsDirectoryLink);
            doOp = true;
        }
        if (this.targetMimeType != null && !this.targetMimeType.equals(this.originalMimeType)) {
            operation.setContentType(target, this.targetMimeType);
            doOp = true;
        }
        if (this.targetExecutable != this.originalExecutable) {
            operation.setExecutable(target, this.targetExecutable);
            doOp = true;
        }
        if (doOp) {
            Shell shell = this.getShell();
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
            try {
                dialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            operation.run(monitor);
                            SourceControlPropertyPage.this.originalLineDelimiter = SourceControlPropertyPage.this.targetLineDelimiter;
                            SourceControlPropertyPage.this.originalMimeType = SourceControlPropertyPage.this.targetMimeType;
                        }
                        catch (FileSystemException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                ErrorDialog.openError((Shell)shell, (String)Messages.SourceControlPropertyPage_31, (String)Messages.SourceControlPropertyPage_32, (IStatus)FileSystemStatusUtil.getStatusFor((Throwable)e.getCause()));
            }
            catch (InterruptedException e) {
                return this.performCancel();
            }
        }
        return super.performOk();
    }

    private void resetScrollableMinSize() {
        Point size = this.getControl().computeSize(-1, -1);
        Point oldSize = this.getControl().getSize();
        if (oldSize.x > size.x) {
            size.x = oldSize.x;
        }
        if (oldSize.y > size.y) {
            size.y = oldSize.y;
        }
        this.setSize(size);
        Composite ancestor = this.composite;
        int i = 0;
        while (i < 4) {
            if (ancestor == null) break;
            if (ancestor instanceof ScrolledComposite) {
                ScrolledComposite scrolled = (ScrolledComposite)ancestor;
                ScrollBar vBar = scrolled.getVerticalBar();
                int x = size.x;
                if (vBar != null) {
                    x -= vBar.getSize().x;
                }
                scrolled.setMinSize(x, size.y);
                break;
            }
            ancestor = ancestor.getParent();
            ++i;
        }
    }

    private String describeIgnoreReasons(IShareable target, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IIgnoreManager manager = SharingManager.getInstance().getIgnoreManager();
        IIgnoreManager.IIgnoreReason reason = manager.findIgnoreReasons(target, (IProgressMonitor)progress.newChild(75));
        if (reason == null) {
            return Messages.SourceControlPropertyPage_39;
        }
        SubMonitor loopProgress = progress.newChild(25).setWorkRemaining(reason.getRules().size());
        StringBuffer buf = new StringBuffer();
        for (IIgnoreProvider.IIgnoreRule rule : reason.getRules()) {
            if (buf.length() > 0) {
                buf.append(Messages.SourceControlPropertyPage_54);
            }
            if (rule instanceof IgnoreRule) {
                buf.append(((IgnoreRule)rule).getShortDescriptionCheckingFileExistance((IProgressMonitor)loopProgress.newChild(1)));
                continue;
            }
            buf.append(rule.getShortDescription());
        }
        if (reason.inherited()) {
            buf.append("\n  ");
            if (reason.getRules().size() > 1) {
                buf.append(NLS.bind((String)Messages.SourceControlPropertyPage_57, (Object)reason.inheritsFrom().getLocalPath()));
            } else {
                buf.append(NLS.bind((String)Messages.SourceControlPropertyPage_58, (Object)reason.inheritsFrom().getLocalPath()));
            }
        }
        return buf.toString();
    }

    private IShareable getTarget() {
        return (IShareable)this.getElement().getAdapter(IShareable.class);
    }

    public static Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridDataFactory.defaultsFor((Control)label).align(4, 1).applyTo((Control)label);
        return label;
    }

    public static Text createReadOnlyText(Composite parent, String text) {
        Text textWidget = new Text(parent, 262216);
        textWidget.setText(text);
        GridDataFactory.defaultsFor((Control)textWidget).align(4, 4).grab(true, false).applyTo((Control)textWidget);
        textWidget.setBackground(textWidget.getDisplay().getSystemColor(22));
        return textWidget;
    }

    public static Button createCheckBox(Composite parent, boolean checked, String label) {
        Button button = new Button(parent, 32);
        button.setSelection(checked);
        button.setText(label);
        GridDataFactory.defaultsFor((Control)button).align(16384, 1).applyTo((Control)button);
        return button;
    }
}

