/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.properties;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.ui.item.Repositories;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.properties.SourceControlPropertyPage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.location.SCMLocationUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public class SharingDescriptorPane {
    private final JobRunner jobRunner;

    public SharingDescriptorPane(Composite composite, IShareable target, JobRunner jobRunner) {
        this.jobRunner = jobRunner;
        this.createLabel(composite, Messages.SourceControlPropertyPage_5);
        FormText formText = this.createLink(composite, Messages.SourceControlPropertyPage_6, null, 1);
        this.createLabel(composite, Messages.SourceControlPropertyPage_7);
        this.createReadOnlyText(composite, target.getLocalPath().toString());
        this.createLabel(composite, Messages.SourceControlPropertyPage_8);
        Text remotePath = this.createReadOnlyText(composite, Messages.SourceControlPropertyPage_6);
        this.createLabel(composite, Messages.SourceControlPropertyPage_10);
        Text stateText = this.createReadOnlyText(composite, Messages.SourceControlPropertyPage_6);
        this.createLabel(composite, Messages.SourceControlPropertyPage_11);
        Text repositoryURIText = this.createReadOnlyText(composite, Messages.SourceControlPropertyPage_6);
        this.createLabel(composite, Messages.SharingDescriptorPane_SandboxLabel);
        this.createReadOnlyText(composite, target.getSandbox().getRoot().toOSString());
        this.createLabel(composite, Messages.SourceControlPropertyPage_13);
        Text sharePathText = this.createReadOnlyText(composite, Messages.SourceControlPropertyPage_6);
        Label connectionName = this.createLabel(composite, Messages.SharingDescriptorPane_0);
        Text connectionText = this.createReadOnlyText(composite, Messages.SourceControlPropertyPage_6);
        this.createLabel(composite, Messages.SourceControlPropertyPage_16);
        Text componentText = this.createReadOnlyText(composite, Messages.SourceControlPropertyPage_6);
        this.populatePane(remotePath, formText, stateText, repositoryURIText, sharePathText, connectionName, connectionText, componentText, target);
    }

    private String getStateString(int state) {
        StringBuffer result = new StringBuffer();
        if ((state & 1) != 0) {
            result.append(Messages.SourceControlPropertyPage_59);
        }
        if ((state & 8) != 0) {
            result.append(Messages.SourceControlPropertyPage_60);
        }
        if ((state & 2) != 0) {
            result.append(Messages.SourceControlPropertyPage_61);
        }
        return result.length() == 0 ? Messages.SourceControlPropertyPage_52 : result.deleteCharAt(result.length() - 1).toString();
    }

    private Text createReadOnlyText(Composite parent, String text) {
        return SourceControlPropertyPage.createReadOnlyText(parent, text);
    }

    private Label createLabel(Composite parent, String text) {
        return SourceControlPropertyPage.createLabel(parent, text);
    }

    private void populatePane(final Text remotePathText, final FormText formText, final Text stateText, final Text repositoryURIText, final Text sharePathText, final Label connectionName, final Text connectionText, final Text componentText, final IShareable target) {
        final Display display = remotePathText.getDisplay();
        this.jobRunner.enqueue(Messages.SourceControlPropertyPage_28, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                String rPath = null;
                String wURL = null;
                IShare s = null;
                try {
                    s = target.getShare((IProgressMonitor)progress.newChild(33));
                    rPath = this.getRemoteFullPath(target, s, (IProgressMonitor)progress.newChild(66));
                    if (rPath != null) {
                        wURL = SharingDescriptorPane.this.getWebURL(target, (IPath)new Path(rPath), s);
                    }
                }
                catch (FileSystemException e) {
                    problems.reportProblem(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                }
                int st = 0;
                try {
                    st = target.getState((IProgressMonitor)progress.newChild(5));
                }
                catch (FileSystemException e) {
                    problems.reportProblem(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                }
                final String remotePath = rPath;
                final String webURL = wURL;
                final IShare share = s;
                final int state = st;
                SWTUtil.greedyExec((Display)display, (Control)remotePathText, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (share == null) {
                            stateText.setText(Messages.SharingDescriptorPane_1);
                            repositoryURIText.setText(Messages.SharingDescriptorPane_1);
                            sharePathText.setText(Messages.SharingDescriptorPane_1);
                            connectionText.setText(Messages.SharingDescriptorPane_1);
                            componentText.setText(Messages.SharingDescriptorPane_1);
                            remotePathText.setText(Messages.SharingDescriptorPane_1);
                            formText.setText(Messages.SharingDescriptorPane_1, false, false);
                        } else {
                            stateText.setText(SharingDescriptorPane.this.getStateString(state));
                            ISharingDescriptor desc = share.getSharingDescriptor();
                            ITeamRepository teamRepository = RepositoryUtils.getTeamRepositoryById((UUID)desc.getRepositoryId());
                            if (teamRepository != null) {
                                repositoryURIText.setText(teamRepository.getRepositoryURI());
                            } else {
                                repositoryURIText.setText(Messages.SourceControlPropertyPage_9);
                            }
                            sharePathText.setText(share.getPath().toString());
                            String typeLabel = desc.getConnectionHandle() instanceof IBaselineHandle ? Messages.SourceControlPropertyPage_14 : Messages.SourceControlPropertyPage_15;
                            connectionName.setText(typeLabel);
                            connectionText.setText(desc.getConnectionName());
                            componentText.setText(desc.getComponentName());
                            if (remotePath == null) {
                                remotePathText.setText(Messages.SourceControlPropertyPage_9);
                                formText.setText(Messages.SourceControlPropertyPage_9, false, false);
                            } else {
                                remotePathText.setText(remotePath);
                                SharingDescriptorPane.this.fetchWebURL(formText, webURL);
                            }
                        }
                    }
                });
            }

            private String getRemoteFullPath(IShareable target2, IShare share, IProgressMonitor monitor) throws FileSystemException {
                IVersionableHandle h;
                String remotePath = null;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (share != null && (h = target2.getRemote((IProgressMonitor)progress.newChild(1))) != null) {
                    ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
                    try {
                        IAncestorReport ancestors;
                        ConfigurationFacade descriptor;
                        IConfiguration configuration;
                        ITeamRepository repo = RepositoryUtils.getTeamRepositoryById((UUID)sharingDescriptor.getRepositoryId());
                        if (repo != null && (configuration = (descriptor = new ConfigurationFacade(repo, sharingDescriptor.getConnectionHandle(), sharingDescriptor.getComponent())).getConfiguration((IProgressMonitor)progress.newChild(9))) != null && !(ancestors = (IAncestorReport)configuration.locateAncestors(Collections.singletonList(h), (IProgressMonitor)progress.newChild(90)).get(0)).getNameItemPairs().isEmpty()) {
                            StringBuilder builder = new StringBuilder();
                            Iterator iterator = ancestors.getNameItemPairs().iterator();
                            iterator.next();
                            while (iterator.hasNext()) {
                                INameItemPair nameItemPair = (INameItemPair)iterator.next();
                                builder.append('/');
                                builder.append(nameItemPair.getName());
                            }
                            remotePath = builder.length() == 0 ? "/" : builder.toString();
                        }
                    }
                    catch (TeamRepositoryException teamRepositoryException) {
                        // empty catch block
                    }
                }
                return remotePath;
            }
        });
    }

    private void fetchWebURL(FormText formText, final String webURL) {
        String convertedURL = webURL == null ? null : XMLString.createFromPlainText((String)webURL).getXMLText();
        String webURLText = webURL == null ? Messages.SourceControlPropertyPage_35 : Messages.SourceControlPropertyPage_66;
        SharingDescriptorPane.setLinkText(formText, webURLText, convertedURL);
        this.resetScrollableMinSize();
        final Display display = formText.getDisplay();
        if (webURL != null) {
            formText.setToolTipText(webURL);
            MenuItem menuItem = new MenuItem(formText.getMenu(), 0, 0);
            menuItem.setText(Messages.SourceControlPropertyPage_36);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SharingDescriptorPane.this.copyToClipboard(display, webURL);
                }
            });
        }
    }

    protected void resetScrollableMinSize() {
    }

    private void copyToClipboard(Display display, String text) {
        Clipboard clipboard = new Clipboard(display);
        Object[] o = new Object[]{text};
        Transfer[] t = new Transfer[]{TextTransfer.getInstance()};
        clipboard.setContents(o, t);
        clipboard.dispose();
    }

    private String getWebURL(IShareable target, IPath remotePath, IShare share) {
        if (remotePath == null) {
            return null;
        }
        ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
        ITeamRepository repo = RepositoryUtils.getTeamRepositoryById((UUID)sharingDescriptor.getRepositoryId());
        if (repo == null) {
            return null;
        }
        String repoURI = Repositories.getPublicURI(repo);
        IContextHandle connectionHandle = sharingDescriptor.getConnectionHandle();
        IComponentHandle component = sharingDescriptor.getComponent();
        Location versionableLoc = SCMLocationUtil.getVersionableLocation((String)repoURI, (IWorkspaceHandle)((IWorkspaceHandle)connectionHandle), (IComponentHandle)component, (IPath)remotePath);
        URI uri = versionableLoc.toAbsoluteUri();
        String asciid = uri.toASCIIString();
        String result = asciid.replaceAll("%2[fF]", "/");
        return result;
    }

    public static void setLinkText(FormText formText, String text, String url) {
        if (url != null) {
            String xmlText = XMLString.createFromPlainText((String)text).getXMLText();
            try {
                formText.setText("<form><p><a href=\"" + url + "\">" + xmlText + "</a></p></form>", true, false);
            }
            catch (IllegalArgumentException e) {
                formText.setText(url, false, false);
            }
        } else {
            formText.setText(text, false, false);
        }
    }

    protected FormText createLink(Composite parent, String text, String url, int span) {
        FormText formText = new FormText(parent, 0);
        formText.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                SharingDescriptorPane.this.openURL((String)e.getHref());
            }
        });
        SharingDescriptorPane.setLinkText(formText, text, url);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 128;
        data.widthHint = 200;
        data.grabExcessHorizontalSpace = true;
        formText.setLayoutData((Object)data);
        return formText;
    }

    private void openURL(String url) {
        try {
            PlatformUI.getWorkbench().getBrowserSupport().createBrowser(null).openURL(new URL(url));
        }
        catch (PartInitException e) {
            StatusUtil.log((Object)this, (Throwable)e);
        }
        catch (MalformedURLException e) {
            StatusUtil.log((Object)this, (Throwable)e);
        }
    }
}

