/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.internal.filesystem.ui.picker.Messages;
import com.ibm.team.internal.filesystem.ui.picker.VisibilityPart;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.common.dto.IReadScope;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class VisibilityPicker
extends TitleAreaDialog {
    private IReadScope readScope;
    private VisibilityPart part;
    private ITeamRepository repo;
    private final String description;
    private PickerMode mode = null;
    private IProjectArea projectArea;
    private ITeamArea teamArea;
    private IAuditable processOwner;

    public VisibilityPicker(IShellProvider parentShell, ITeamRepository repo, IReadScope readScope, PickerMode mode, String description) {
        super(parentShell.getShell());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.repo = repo;
        this.readScope = readScope;
        this.description = description;
        this.mode = mode;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.VisibilityPicker_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = (Composite)super.createDialogArea(parent);
        Composite area = new Composite(top, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        area.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)area);
        this.setTitle(Messages.VisibilityPicker_DIALOG_MESSAGE);
        this.setMessage(this.description);
        this.part = new VisibilityPart(area, WidgetFactoryContext.forDialogBox(), this.mode, this.processOwner){

            @Override
            protected void setPartComplete(boolean finished) {
                Button button = VisibilityPicker.this.getButton(0);
                if (button != null) {
                    button.setEnabled(finished);
                    if (!finished) {
                        String message = null;
                        if (this.getReadScope() == null) {
                            switch (VisibilityPicker.this.mode) {
                                case COMPONENT: {
                                    message = Messages.VisibilityPicker_COMPONENT_ERROR__NEED_TO_PICK_AN_ACCESS_GROUP;
                                    break;
                                }
                                case COMPONENTS: {
                                    message = Messages.VisibilityPicker_COMPONENTS_ERROR__NEED_TO_PICK_AN_ACCESS_GROUP;
                                    break;
                                }
                                case WORKSPACE: {
                                    message = Messages.VisibilityPicker_WORKSPACE_ERROR__NEED_TO_PICK_AN_ACCESS_GROUP;
                                    break;
                                }
                                case STREAM: {
                                    message = Messages.VisibilityPicker_STREAM_ERROR__NEED_TO_PICK_AN_ACCESS_GROUP;
                                    break;
                                }
                                case QUERY: {
                                    message = Messages.VisibilityPicker_QUERY_ERROR__NEED_TO_PICK_AN_ACCESS_GROUP;
                                    break;
                                }
                                case QUERIES: {
                                    message = Messages.VisibilityPicker_QUERIES_ERROR__NEED_TO_PICK_AN_ACCESS_GROUP;
                                }
                            }
                        } else {
                            switch (VisibilityPicker.this.mode) {
                                case COMPONENT: {
                                    message = Messages.VisibilityPicker_COMPONENT_ERROR__NEED_TO_PICK_A_PROJECT;
                                    break;
                                }
                                case COMPONENTS: {
                                    message = Messages.VisibilityPicker_COMPONENTS_ERROR__NEED_TO_PICK_A_PROJECT;
                                    break;
                                }
                                case WORKSPACE: {
                                    message = Messages.VisibilityPicker_ERROR_NEED_TO_PICK_A_PROJECT;
                                    break;
                                }
                                case STREAM: {
                                    message = Messages.VisibilityPicker_STREAM_ERROR_NEED_TO_PICK_A_PROJECT;
                                    break;
                                }
                                case QUERY: {
                                    message = Messages.VisibilityPicker_QUERY_ERROR_NEED_TO_PICK_A_PROJECT;
                                    break;
                                }
                                case QUERIES: {
                                    message = Messages.VisibilityPicker_QUERIES_ERROR_NEED_TO_PICK_A_PROJECT;
                                }
                            }
                        }
                        VisibilityPicker.this.setErrorMessage(message);
                    } else {
                        VisibilityPicker.this.setErrorMessage(null);
                    }
                }
            }
        };
        this.part.setInput(this.repo, this.readScope, this.projectArea, this.teamArea);
        GridLayoutFactory.fillDefaults().applyTo(area);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpId());
        return area;
    }

    public IReadScope getReadScope() {
        return this.part.getReadScope();
    }

    protected String getHelpId() {
        return "com.ibm.team.filesystem.ide.ui.dialog_workspacereadaccesspermission";
    }

    public void setProcessAreas(IProjectArea projectArea, ITeamArea teamArea) {
        this.projectArea = projectArea;
        this.teamArea = teamArea;
    }

    public void setOwner(IAuditable owner) {
        this.processOwner = owner;
    }

    public static enum PickerMode {
        COMPONENT,
        COMPONENTS,
        WORKSPACE,
        WORKSPACES,
        STREAM,
        STREAMS,
        QUERY,
        QUERIES;

    }
}

