/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.picker;

import com.ibm.team.filesystem.rcp.ui.internal.util.DialogUtil;
import com.ibm.team.internal.filesystem.ui.picker.Messages;
import com.ibm.team.internal.filesystem.ui.picker.VisibilityPicker;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.client.IAccessGroupClientService;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.ide.ui.accessgroups.dialogs.AccessGroupSelectionDialog;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.common.dto.IAccessGroupScope;
import com.ibm.team.scm.common.dto.IContributorDeferringScope;
import com.ibm.team.scm.common.dto.IProcessAreaScope;
import com.ibm.team.scm.common.dto.IPublicScope;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.ITeamAreaPrivateScope;
import com.ibm.team.scm.common.internal.dto.PrivateScope;
import com.ibm.team.scm.common.internal.util.ReadScopeUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class VisibilityPart {
    public static final int DEFAULT_WIDTH_HINT = 275;
    public static final int DEFAULT_INDENT_WIDTH = 17;
    private WidgetFactoryContext widgetFactoryContext;
    private VisibilityPicker.PickerMode pickerMode;
    private IAuditable owner;
    private IOperationRunner runner;
    private IReadScope inputReadScope;
    private IReadScope selectedReadScope;
    private static ConnectedProjectAreaRegistry fgRegistry = ConnectedProjectAreaRegistry.getDefault();
    private ITeamRepository repo;
    private StandardLabelProvider standardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
    private Composite visibilityPartComposite;
    private Button publicScopeRadioButton;
    private Button privateScopeRadioButton;
    private Button processAreaScopeRadioButton;
    private SimpleTableViewer projectAreasTableViewer;
    private Combo processAreaCombo;
    private static final int PROJECT_AREA = 0;
    private static final int TEAM_AREA = 1;
    private IProcessArea[] processAreaOptions;
    private Button accessGroupScopeRadioButton;
    private Label accessGroupScopeImage;
    private Label accessGroupScopeLabel;
    private Button accessGroupScopeBrowseButton;
    private IAccessGroup currentAccessGroup;

    public VisibilityPart(Composite parent, WidgetFactoryContext context, VisibilityPicker.PickerMode pickerMode, IAuditable owner) {
        this.widgetFactoryContext = context;
        this.pickerMode = pickerMode;
        this.owner = owner;
        this.runner = context.getBackgroundOperationRunner();
        this.visibilityPartComposite = context.getToolkit().createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).applyTo(this.visibilityPartComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.visibilityPartComposite);
        boolean showPublicPrivateSections = false;
        if (pickerMode == VisibilityPicker.PickerMode.WORKSPACE) {
            showPublicPrivateSections = true;
        } else if (!(pickerMode != VisibilityPicker.PickerMode.COMPONENT && pickerMode != VisibilityPicker.PickerMode.COMPONENTS && pickerMode != VisibilityPicker.PickerMode.QUERY && pickerMode != VisibilityPicker.PickerMode.QUERIES || owner instanceof IProcessArea)) {
            showPublicPrivateSections = true;
        }
        if (showPublicPrivateSections) {
            this.createPublicScopeSection(this.visibilityPartComposite);
            this.createPrivateScopeSection(this.visibilityPartComposite);
        }
        this.createProcessAreaScopeSection(this.visibilityPartComposite);
        this.createAccessGroupScopeSection(this.visibilityPartComposite);
        Dialog.applyDialogFont((Control)this.visibilityPartComposite);
    }

    private void createPublicScopeSection(Composite parent) {
        this.publicScopeRadioButton = new Button(parent, 16);
        this.publicScopeRadioButton.setText(Messages.VisibilityPart_PUBLIC_RADIO_LABEL);
        GridDataFactory.swtDefaults().indent(0, 5).applyTo((Control)this.publicScopeRadioButton);
        this.publicScopeRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisibilityPart.this.updateSelection();
            }
        });
        Label publicScopeLabel = new Label(parent, 64);
        String publicScopeDescription = "";
        switch (this.pickerMode) {
            case COMPONENT: {
                publicScopeDescription = Messages.VisibilityPart_COMPONENT_PUBLIC_MESSAGE;
                break;
            }
            case COMPONENTS: {
                publicScopeDescription = Messages.VisibilityPart_COMPONENTS_PUBLIC_MESSAGE;
                break;
            }
            case WORKSPACE: {
                publicScopeDescription = Messages.VisibilityPart_PUBLIC_RADIO_DESCRIPTION;
                break;
            }
            case STREAM: {
                publicScopeDescription = Messages.VisibilityPart_PUBLIC_RADIO_DESCRIPTION;
                break;
            }
            case QUERY: {
                publicScopeDescription = Messages.VisibilityPart_PUBLIC_QUERY_RADIO_DESCRIPTION;
                break;
            }
            case QUERIES: {
                publicScopeDescription = Messages.VisibilityPart_PUBLIC_QUERIES_RADIO_DESCRIPTION;
            }
        }
        publicScopeLabel.setText(publicScopeDescription);
        DialogUtil.setAccessibleDescription((Button)this.publicScopeRadioButton, (String)publicScopeDescription);
        GridDataFactory.fillDefaults().indent(17, 0).grab(true, false).hint(275, -1).applyTo((Control)publicScopeLabel);
    }

    private void createPrivateScopeSection(Composite parent) {
        this.privateScopeRadioButton = new Button(parent, 16);
        this.privateScopeRadioButton.setText(Messages.VisibilityPart_PRIVATE_RADIO_LABEL);
        GridDataFactory.swtDefaults().indent(0, 5).applyTo((Control)this.privateScopeRadioButton);
        this.privateScopeRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisibilityPart.this.updateSelection();
            }
        });
        Label privateScopeLabel = new Label(parent, 64);
        String privateScopeDescription = "";
        switch (this.pickerMode) {
            case COMPONENT: {
                privateScopeDescription = Messages.VisibilityPart_PRIVATE_COMPONENT_MESSAGE;
                break;
            }
            case COMPONENTS: {
                privateScopeDescription = Messages.VisibilityPart_PRIVATE_COMPONENTS_MESSAGE;
                break;
            }
            case WORKSPACE: {
                privateScopeDescription = Messages.VisibilityPart_PRIVATE_RADIO_DESCRIPTION;
                break;
            }
            case STREAM: {
                privateScopeDescription = Messages.VisibilityPart_PRIVATE_RADIO_DESCRIPTION;
                break;
            }
            case QUERY: {
                privateScopeDescription = Messages.VisibilityPart_PRIVATE_QUERY_MESSAGE;
                break;
            }
            case QUERIES: {
                privateScopeDescription = Messages.VisibilityPart_PRIVATE_QUERIES_MESSAGE;
            }
        }
        privateScopeLabel.setText(privateScopeDescription);
        DialogUtil.setAccessibleDescription((Button)this.privateScopeRadioButton, (String)privateScopeDescription);
        GridDataFactory.fillDefaults().indent(17, 0).grab(true, false).hint(275, -1).applyTo((Control)privateScopeLabel);
    }

    private void createProcessAreaScopeSection(Composite parent) {
        boolean canPickProjectAreas;
        this.processAreaScopeRadioButton = new Button(parent, 16);
        String processAreaScopeRadioButtonText = this.owner instanceof ITeamArea ? Messages.VisibilityPart_PROTECTED_RADIO_LABEL : Messages.VisibilityPart_PROJECT_AREAS_RADIO_LABEL;
        this.processAreaScopeRadioButton.setText(processAreaScopeRadioButtonText);
        GridDataFactory.swtDefaults().indent(0, 5).applyTo((Control)this.processAreaScopeRadioButton);
        this.processAreaScopeRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisibilityPart.this.updateSelection();
            }
        });
        Label processAreaScopeDescriptionLabel = new Label(parent, 64);
        String processAreaScopeDescription = "";
        switch (this.pickerMode) {
            case COMPONENT: {
                if (this.owner instanceof ITeamArea) {
                    processAreaScopeDescription = Messages.VisibilityPart_COMPONENT_PROTECTED_WITH_TEAM_AREA_MESSAGE;
                    break;
                }
                processAreaScopeDescription = Messages.VisibilityPart_COMPONENT_PROTECTED_MESSAGE;
                break;
            }
            case COMPONENTS: {
                if (this.owner instanceof ITeamArea) {
                    processAreaScopeDescription = Messages.VisibilityPart_COMPONENTS_PROTECTED_WITH_TEAM_AREA_MESSAGE;
                    break;
                }
                processAreaScopeDescription = Messages.VisibilityPart_COMPONENTS_PROTECTED_MESSAGE;
                break;
            }
            case WORKSPACE: {
                processAreaScopeDescription = Messages.VisibilityPart_PROTECTED_RADIO_DESCRIPTION;
                break;
            }
            case STREAM: {
                if (this.owner instanceof ITeamArea) {
                    processAreaScopeDescription = Messages.VisibilityPart_PROTECTED_RADIO_STREAM_WITH_TEAM_AREA_DESCRIPTION;
                    break;
                }
                processAreaScopeDescription = Messages.VisibilityPart_PROTECTED_RADIO_STREAM_DESCRIPTION;
                break;
            }
            case QUERY: {
                if (this.owner instanceof ITeamArea) {
                    processAreaScopeDescription = Messages.VisibilityPart_PROTECTED_RADIO_QUERY_WITH_TEAM_AREA_MESSAGE;
                    break;
                }
                processAreaScopeDescription = Messages.VisibilityPart_PROTECTED_RADIO_QUERY_DESCRIPTION;
                break;
            }
            case QUERIES: {
                processAreaScopeDescription = this.owner instanceof ITeamArea ? Messages.VisibilityPart_PROTECTED_RADIO_QUERIES_WITH_TEAM_AREA_MESSAGE : Messages.VisibilityPart_PROTECTED_RADIO_QUERIES_DESCRIPTION;
            }
        }
        processAreaScopeDescriptionLabel.setText(processAreaScopeDescription);
        DialogUtil.setAccessibleDescription((Button)this.processAreaScopeRadioButton, (String)processAreaScopeDescription);
        GridDataFactory.fillDefaults().indent(17, 0).grab(true, false).hint(275, -1).applyTo((Control)processAreaScopeDescriptionLabel);
        boolean bl = canPickProjectAreas = this.pickerMode == VisibilityPicker.PickerMode.WORKSPACE || (this.pickerMode == VisibilityPicker.PickerMode.COMPONENT || this.pickerMode == VisibilityPicker.PickerMode.COMPONENTS || this.pickerMode == VisibilityPicker.PickerMode.QUERY || this.pickerMode == VisibilityPicker.PickerMode.QUERIES) && !(this.owner instanceof IProcessArea);
        if (canPickProjectAreas) {
            Table table = new Table(parent, 2816);
            table.setHeaderVisible(false);
            this.projectAreasTableViewer = new SimpleTableViewer(table, null, null);
            new LabelColumn(this.projectAreasTableViewer, "", -1);
            this.setProjectAreaSelectionFilter();
            this.projectAreasTableViewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    VisibilityPart.this.updateSelection();
                }
            });
            Table projectAreaTable = this.projectAreasTableViewer.getTable();
            int minHeight = projectAreaTable.getItemHeight() * 3 + projectAreaTable.getBorderWidth();
            GridDataFactory.fillDefaults().grab(true, true).indent(17, 0).minSize(-1, minHeight).hint(275, -1).applyTo((Control)projectAreaTable);
        } else {
            this.processAreaCombo = new Combo(parent, 12);
            GridDataFactory.fillDefaults().grab(true, false).indent(17, 0).span(2, 1).hint(275, -1).applyTo((Control)this.processAreaCombo);
            this.processAreaCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    VisibilityPart.this.updateSelection();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
    }

    private void setProjectAreaSelectionFilter() {
        this.projectAreasTableViewer.setSelectionCriteria(new IFilter(){

            public boolean select(Object object) {
                if (VisibilityPart.this.pickerMode == VisibilityPicker.PickerMode.WORKSPACE || VisibilityPart.this.pickerMode == VisibilityPicker.PickerMode.COMPONENT) {
                    IProcessArea projectArea = (IProcessArea)object;
                    if (VisibilityPart.this.selectedReadScope instanceof IProcessAreaScope) {
                        return projectArea.sameItemId((IItemHandle)((IProcessAreaScope)VisibilityPart.this.selectedReadScope).getProcessArea());
                    }
                    if (VisibilityPart.this.selectedReadScope instanceof IContributorDeferringScope) {
                        return projectArea.sameItemId((IItemHandle)((IContributorDeferringScope)VisibilityPart.this.selectedReadScope).getScope());
                    }
                }
                return false;
            }
        });
    }

    private void createAccessGroupScopeSection(final Composite parent) {
        this.accessGroupScopeRadioButton = new Button(parent, 16);
        this.accessGroupScopeRadioButton.setText(Messages.VisibilityPart_ACCESS_GROUP_LABEL);
        GridDataFactory.swtDefaults().indent(0, 5).applyTo((Control)this.accessGroupScopeRadioButton);
        this.accessGroupScopeRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisibilityPart.this.updateSelection();
            }
        });
        Label accessGroupScopeDescriptionLabel = new Label(parent, 64);
        String accessGroupScopeDescription = "";
        switch (this.pickerMode) {
            case COMPONENT: {
                accessGroupScopeDescription = Messages.VisibilityPart_ACCESS_GROUP_DESCRIPTION_COMPONENT;
                break;
            }
            case COMPONENTS: {
                accessGroupScopeDescription = Messages.VisibilityPart_ACCESS_GROUP_DESCRIPTION_COMPONENTS;
                break;
            }
            case WORKSPACE: {
                accessGroupScopeDescription = Messages.VisibilityPart_ACCESS_GROUP_DESCRIPTION_WORKSPACE;
                break;
            }
            case STREAM: {
                accessGroupScopeDescription = Messages.VisibilityPart_ACCESS_GROUP_DESCRIPTION_STREAM;
                break;
            }
            case QUERY: {
                accessGroupScopeDescription = Messages.VisibilityPart_ACCESS_GROUP_DESCRIPTION_QUERY;
                break;
            }
            case QUERIES: {
                accessGroupScopeDescription = Messages.VisibilityPart_ACCESS_GROUP_DESCRIPTION_QUERIES;
            }
        }
        accessGroupScopeDescriptionLabel.setText(accessGroupScopeDescription);
        DialogUtil.setAccessibleDescription((Button)this.accessGroupScopeRadioButton, (String)accessGroupScopeDescription);
        GridDataFactory.fillDefaults().indent(17, 0).grab(true, false).hint(275, -1).applyTo((Control)accessGroupScopeDescriptionLabel);
        Composite accessGroupComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(accessGroupComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)accessGroupComposite);
        this.accessGroupScopeImage = new Label(accessGroupComposite, 0);
        GridDataFactory.fillDefaults().indent(17, 0).align(1, 1).applyTo((Control)this.accessGroupScopeImage);
        this.accessGroupScopeLabel = new Label(accessGroupComposite, 64);
        GridDataFactory.fillDefaults().hint(343, -1).grab(true, false).applyTo((Control)this.accessGroupScopeLabel);
        this.accessGroupScopeBrowseButton = DialogUtil.createPushButton((WidgetFactoryContext)this.widgetFactoryContext, (Composite)accessGroupComposite, (String)Messages.VisibilityPart_AccessGroupBrowseButtonLabel, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessGroupSelectionDialog groupSelection = new AccessGroupSelectionDialog(parent.getShell(), VisibilityPart.this.repo);
                if (groupSelection.open() == 0) {
                    VisibilityPart.this.currentAccessGroup = groupSelection.getSelectedAccessGroup();
                    VisibilityPart.this.accessGroupScopeImage.setImage(VisibilityPart.this.standardLabelProvider.getImage((Object)VisibilityPart.this.currentAccessGroup));
                    VisibilityPart.this.accessGroupScopeLabel.setText(VisibilityPart.this.standardLabelProvider.getText((Object)VisibilityPart.this.currentAccessGroup));
                    VisibilityPart.this.selectedReadScope = (IReadScope)IReadScope.FACTORY.createAccessGroupScope(VisibilityPart.this.currentAccessGroup);
                    VisibilityPart.this.updateEnablement();
                    VisibilityPart.this.visibilityPartComposite.layout(true, true);
                }
            }
        });
        GridDataFactory.defaultsFor((Control)this.accessGroupScopeBrowseButton).align(0x1000008, 0x1000000).applyTo((Control)this.accessGroupScopeBrowseButton);
    }

    private void updateWidgetStates() {
        if (this.publicScopeRadioButton != null) {
            this.publicScopeRadioButton.setSelection(this.selectedReadScope == null || this.selectedReadScope instanceof IPublicScope);
        }
        if (this.privateScopeRadioButton != null) {
            this.privateScopeRadioButton.setSelection(this.selectedReadScope instanceof PrivateScope);
        }
        if (this.processAreaScopeRadioButton != null) {
            boolean isProtected = this.selectedReadScope instanceof IProcessAreaScope || this.selectedReadScope instanceof IContributorDeferringScope || this.selectedReadScope instanceof ITeamAreaPrivateScope;
            this.processAreaScopeRadioButton.setSelection(isProtected);
            if (this.projectAreasTableViewer != null) {
                this.setProjectAreaSelectionFilter();
            }
        }
        if (this.accessGroupScopeRadioButton != null) {
            this.accessGroupScopeRadioButton.setSelection(this.selectedReadScope instanceof IAccessGroupScope);
        }
    }

    private void updateSelection() {
        Object scope = null;
        if (this.publicScopeRadioButton != null && this.publicScopeRadioButton.getSelection()) {
            scope = IReadScope.FACTORY.createPublicScope();
        } else if (this.processAreaScopeRadioButton != null && this.processAreaScopeRadioButton.getSelection()) {
            if (this.projectAreasTableViewer != null) {
                IProjectAreaHandle projectArea = (IProjectAreaHandle)this.projectAreasTableViewer.getSelection().getFirstElement();
                scope = IReadScope.FACTORY.createContributorDeferringScope();
                IContributorDeferringScope cScope = (IContributorDeferringScope)scope;
                cScope.setScope((IAuditableHandle)projectArea);
            } else {
                int i = this.processAreaCombo.getSelectionIndex();
                if (this.processAreaOptions != null && this.processAreaOptions.length >= i) {
                    IProcessArea processArea = this.processAreaOptions[i];
                    scope = processArea instanceof ITeamArea ? IReadScope.FACTORY.createTeamAreaPrivateScope() : IReadScope.FACTORY.createProcessAreaScope((IProcessAreaHandle)this.owner);
                }
            }
        } else {
            scope = this.accessGroupScopeRadioButton != null && this.accessGroupScopeRadioButton.getSelection() ? (this.currentAccessGroup != null ? IReadScope.FACTORY.createAccessGroupScope(this.currentAccessGroup) : null) : IReadScope.FACTORY.createPrivateScope();
        }
        this.selectedReadScope = scope;
        this.updateEnablement();
    }

    private void updateEnablement() {
        if (this.accessGroupScopeRadioButton != null) {
            this.accessGroupScopeBrowseButton.setEnabled(this.accessGroupScopeRadioButton.getSelection());
        }
        if (this.projectAreasTableViewer != null) {
            TableItem item;
            this.projectAreasTableViewer.getTable().setEnabled(this.processAreaScopeRadioButton.getSelection());
            if (this.projectAreasTableViewer.getSelection().isEmpty() && this.projectAreasTableViewer.getTable().getItemCount() == 1 && (item = this.projectAreasTableViewer.getTable().getItem(0)).getData() instanceof IProjectAreaHandle) {
                this.projectAreasTableViewer.getTable().select(0);
            }
        } else if (this.processAreaCombo != null) {
            this.processAreaCombo.setEnabled(this.processAreaScopeRadioButton.getSelection() && this.processAreaOptions != null && this.processAreaOptions.length > 1);
        }
        boolean finished = this.selectedReadScope != null && (!(this.selectedReadScope instanceof IContributorDeferringScope) || !this.projectAreasTableViewer.getSelection().isEmpty());
        this.setPartComplete(finished);
    }

    public IReadScope getReadScope() {
        return this.selectedReadScope;
    }

    private void setCurrentAccessGroup(final IAccessGroupScope accessGroupScope) {
        final Display display = this.visibilityPartComposite.getDisplay();
        this.runner.enqueue(Messages.VisibilityPart_fetchingAccessGroup, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                IAccessGroupClientService accessGroupService = (IAccessGroupClientService)VisibilityPart.this.repo.getClientLibrary(IAccessGroupClientService.class);
                final IAccessGroup newAccessGroup = accessGroupService.getAccessGroupForGroupContextId(accessGroupScope.getAccessGroupId(), monitor);
                if (newAccessGroup != null) {
                    SWTUtil.greedyExec((Display)display, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (!VisibilityPart.this.visibilityPartComposite.isDisposed() && VisibilityPart.this.currentAccessGroup == null) {
                                VisibilityPart.this.currentAccessGroup = newAccessGroup;
                                VisibilityPart.this.accessGroupScopeImage.setImage(VisibilityPart.this.standardLabelProvider.getImage((Object)newAccessGroup));
                                VisibilityPart.this.accessGroupScopeLabel.setText(VisibilityPart.this.standardLabelProvider.getText((Object)newAccessGroup));
                                VisibilityPart.this.visibilityPartComposite.layout(true, true);
                                VisibilityPart.this.updateSelection();
                            }
                        }
                    });
                }
            }
        });
    }

    public void setInput(ITeamRepository newRepo, final IReadScope newReadScope, IProjectArea projectArea, ITeamArea teamArea) {
        boolean hasInputChanged = false;
        if (newRepo != null && (this.repo == null || this.repo != newRepo)) {
            this.repo = newRepo;
            if (this.projectAreasTableViewer != null) {
                this.projectAreasTableViewer.setInput((ISetWithListeners)new RepositoryQuery<IProjectArea>(this.repo, this.runner){

                    protected void attachListeners() {
                    }

                    protected void detachListeners() {
                    }

                    protected List<IProjectArea> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
                        ArrayList<IProjectArea> areas = new ArrayList<IProjectArea>();
                        List connectedAreas = fgRegistry.getConnectedProjectAreas(this.getRepository());
                        if (newReadScope != null && newReadScope instanceof IContributorDeferringScope) {
                            IProjectAreaHandle deferredTo = (IProjectAreaHandle)((IContributorDeferringScope)newReadScope).getScope();
                            boolean found = false;
                            for (IProjectAreaHandle handle : connectedAreas) {
                                if (!handle.sameItemId((IItemHandle)deferredTo)) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                connectedAreas.add(deferredTo);
                            }
                        }
                        List projects = this.getRepository().itemManager().fetchCompleteItems(connectedAreas, 0, monitor);
                        for (IProjectArea pa : projects) {
                            if (pa == null) continue;
                            areas.add(pa);
                        }
                        return areas;
                    }

                    public String getName() {
                        return "";
                    }
                });
            }
            hasInputChanged = true;
        }
        if (newReadScope != null && !ReadScopeUtils.equals((IReadScope)newReadScope, (IReadScope)this.inputReadScope)) {
            this.inputReadScope = newReadScope;
            this.selectedReadScope = newReadScope;
            if (this.selectedReadScope instanceof IAccessGroupScope) {
                this.setCurrentAccessGroup((IAccessGroupScope)this.selectedReadScope);
            }
            hasInputChanged = true;
        }
        if (projectArea != null && this.processAreaCombo != null) {
            if (teamArea != null) {
                this.processAreaOptions = new IProcessArea[2];
                this.processAreaOptions[1] = teamArea;
            } else {
                this.processAreaOptions = new IProcessArea[1];
            }
            this.processAreaOptions[0] = projectArea;
            String[] items = new String[this.processAreaOptions.length];
            int i = 0;
            while (i < this.processAreaOptions.length) {
                items[i] = this.processAreaOptions[i].getName();
                ++i;
            }
            this.processAreaCombo.setItems(items);
            this.selectProcessAreaInCombo(newReadScope);
            hasInputChanged = true;
        }
        if (hasInputChanged) {
            this.updateWidgetStates();
            this.updateEnablement();
        }
    }

    private void selectProcessAreaInCombo(IReadScope scope) {
        if (this.processAreaOptions != null && this.processAreaCombo != null && !this.processAreaCombo.isDisposed()) {
            IProcessArea selection = null;
            if (scope instanceof ITeamAreaPrivateScope) {
                if (this.processAreaOptions.length > 1) {
                    selection = this.processAreaOptions[1];
                }
            } else if (this.processAreaOptions.length > 0) {
                selection = this.processAreaOptions[0];
            }
            if (selection != null) {
                int i = 0;
                while (i < this.processAreaOptions.length) {
                    if (this.processAreaOptions[i].sameItemId((IItemHandle)selection)) {
                        this.processAreaCombo.select(i);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    protected abstract void setPartComplete(boolean var1);
}

